/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class GetTaskVariableCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String variableName;
    protected boolean isLocal;

    public GetTaskVariableCmd(String taskId, String variableName, boolean isLocal) {
        this.taskId = taskId;
        this.variableName = variableName;
        this.isLocal = isLocal;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("taskId", (Object)this.taskId);
        EnsureUtil.ensureNotNull("variableName", (Object)this.variableName);
        TaskEntity task = Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("task " + this.taskId + " doesn't exist", "task", (Object)task);
        Object value = this.isLocal ? task.getVariableLocal(this.variableName) : task.getVariable(this.variableName);
        return value;
    }
}

