/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.form.handler.TaskFormHandler;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class SubmitTaskFormCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected VariableMap properties;

    public SubmitTaskFormCmd(String taskId, Map<String, Object> properties) {
        this.taskId = taskId;
        this.properties = Variables.fromMap(properties);
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("taskId", (Object)this.taskId);
        TaskEntity task = Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("Cannot find task with id " + this.taskId, "task", (Object)task);
        TaskDefinition taskDefinition = task.getTaskDefinition();
        if (taskDefinition != null) {
            TaskFormHandler taskFormHandler = taskDefinition.getTaskFormHandler();
            taskFormHandler.submitFormVariables(this.properties, task);
        }
        if (DelegationState.PENDING.equals((Object)task.getDelegationState())) {
            task.resolve();
            task.createHistoricTaskDetails("Resolve");
        } else {
            task.complete();
            task.createHistoricTaskDetails("Complete");
        }
        return null;
    }
}

