/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.behavior;

import java.util.List;
import org.camunda.bpm.engine.exception.cmmn.CaseIllegalStateTransitionException;
import org.camunda.bpm.engine.impl.cmmn.CaseControlRule;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public abstract class PlanItemDefinitionActivityBehavior
implements CmmnActivityBehavior {
    @Override
    public void execute(CmmnActivityExecution execution) throws Exception {
    }

    protected boolean isAtLeastOneEntryCriteriaSatisfied(CmmnActivityExecution execution) {
        CmmnActivity activity = this.getActivity(execution);
        List<CmmnSentryDeclaration> entryCriteria = activity.getEntryCriteria();
        if (entryCriteria != null && !entryCriteria.isEmpty()) {
            return this.isSentrySatisified(entryCriteria, execution);
        }
        return true;
    }

    protected boolean isAtLeastOneExitCriteriaSatisfied(CmmnActivityExecution execution) {
        CmmnActivity activity = this.getActivity(execution);
        List<CmmnSentryDeclaration> exitCriteria = activity.getExitCriteria();
        if (exitCriteria != null && !exitCriteria.isEmpty()) {
            return this.isSentrySatisified(exitCriteria, execution);
        }
        return false;
    }

    protected boolean isSentrySatisified(List<CmmnSentryDeclaration> sentryDeclarations, CmmnActivityExecution execution) {
        String id = execution.getId();
        CmmnActivityExecution parent = execution.getParent();
        EnsureUtil.ensureNotNull(PvmException.class, "Case execution '" + id + "': has no parent.", "parent", (Object)parent);
        for (CmmnSentryDeclaration sentryDeclaration : sentryDeclarations) {
            String sentryId = sentryDeclaration.getId();
            if (!parent.isSentrySatisfied(sentryId)) continue;
            return true;
        }
        return false;
    }

    protected void evaluateRequiredRule(CmmnActivityExecution execution) {
        CmmnActivity activity = execution.getActivity();
        Object requiredRule = activity.getProperty("requiredRule");
        if (requiredRule != null) {
            CaseControlRule rule = (CaseControlRule)requiredRule;
            boolean required = rule.evaluate(execution);
            execution.setRequired(required);
        }
    }

    protected void evaluateRepetitionRule(CmmnActivityExecution execution) {
        CmmnActivity activity = execution.getActivity();
        Object repetitionRule = activity.getProperty("repetitionRule");
        if (repetitionRule != null) {
            CaseControlRule rule = (CaseControlRule)repetitionRule;
            rule.evaluate(execution);
        }
    }

    @Override
    public void onCreate(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.NEW, CaseExecutionState.AVAILABLE, "create");
        this.creating(execution);
    }

    protected void creating(CmmnActivityExecution execution) {
    }

    @Override
    public void started(CmmnActivityExecution execution) {
    }

    protected void completing(CmmnActivityExecution execution) {
    }

    protected void manualCompleting(CmmnActivityExecution execution) {
    }

    @Override
    public void onClose(CmmnActivityExecution execution) {
        String id = execution.getId();
        if (execution.isCaseInstanceExecution()) {
            if (execution.isClosed()) {
                String message = "Case instance'" + id + "' is already closed.";
                throw this.createIllegalStateTransitionException("close", message, execution);
            }
            if (execution.isActive()) {
                String message = "Case instance '" + id + "' must be {completed|terminated|suspended} to close it, but was 'active'.";
                throw this.createIllegalStateTransitionException("close", message, execution);
            }
        } else {
            String message = "It is not possible to close case execution '" + id + "' which is not a case instance.";
            throw this.createIllegalStateTransitionException("close", message, execution);
        }
    }

    protected void performTerminate(CmmnActivityExecution execution) {
        execution.performTerminate();
    }

    protected void performParentTerminate(CmmnActivityExecution execution) {
        execution.performParentTerminate();
    }

    protected void performExit(CmmnActivityExecution execution) {
        execution.performExit();
    }

    protected void performSuspension(CmmnActivityExecution execution) {
        execution.performSuspension();
    }

    protected void performParentSuspension(CmmnActivityExecution execution) {
        execution.performParentSuspension();
    }

    protected void resuming(CmmnActivityExecution execution) {
    }

    @Override
    public void resumed(CmmnActivityExecution execution) {
        if (execution.isAvailable()) {
            this.created(execution);
        }
    }

    @Override
    public void reactivated(CmmnActivityExecution execution) {
    }

    protected void ensureTransitionAllowed(CmmnActivityExecution execution, CaseExecutionState expected, CaseExecutionState target, String transition) {
        String id = execution.getId();
        CaseExecutionState currentState = execution.getCurrentState();
        if (execution.isTerminating() || execution.isSuspending()) {
            currentState = execution.getPreviousState();
        }
        if (target.equals(currentState)) {
            String message = "Case execution '" + id + "' is already " + target + ".";
            throw this.createIllegalStateTransitionException(transition, message, execution);
        }
        if (!expected.equals(currentState)) {
            String message = "Case execution '" + id + "' must be " + expected + " to " + transition + " it, but was " + currentState + ".";
            throw this.createIllegalStateTransitionException(transition, message, execution);
        }
    }

    protected void ensureNotCaseInstance(CmmnActivityExecution execution, String transition) {
        if (execution.isCaseInstanceExecution()) {
            String id = execution.getId();
            String message = "It is not possible to " + transition + " case instance '" + id + "'.";
            throw this.createIllegalStateTransitionException(transition, message, execution);
        }
    }

    protected CaseIllegalStateTransitionException createIllegalStateTransitionException(String transition, String message, CmmnActivityExecution execution) {
        String id = execution.getId();
        String errorMessage = String.format("Could not perform transition '%s' on case execution '%s': %s", transition, id, message);
        return new CaseIllegalStateTransitionException(errorMessage);
    }

    protected CmmnActivity getActivity(CmmnActivityExecution execution) {
        String id = execution.getId();
        CmmnActivity activity = execution.getActivity();
        EnsureUtil.ensureNotNull(PvmException.class, "Case execution '" + id + "': has no current activity.", "activity", (Object)activity);
        return activity;
    }
}

