/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.test;

import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.camunda.bpm.engine.impl.util.ClassNameUtil;
import org.camunda.bpm.engine.impl.util.LogUtil;

public class PvmTestCase
extends TestCase {
    protected static final String EMPTY_LINE = "                                                                                           ";
    protected static Logger log;
    protected static final LogUtil.ThreadLogMode DEFAULT_THREAD_LOG_MODE;
    protected LogUtil.ThreadLogMode threadRenderingMode;
    protected boolean isEmptyLinesEnabled = true;

    public PvmTestCase() {
        this(DEFAULT_THREAD_LOG_MODE);
    }

    public PvmTestCase(LogUtil.ThreadLogMode threadRenderingMode) {
        this.threadRenderingMode = threadRenderingMode;
    }

    public void assertTextPresent(String expected, String actual) {
        if (actual == null || actual.indexOf(expected) == -1) {
            throw new AssertionFailedError("expected presence of [" + expected + "], but was [" + actual + "]");
        }
    }

    public void assertTextPresentIgnoreCase(String expected, String actual) {
        this.assertTextPresent(expected.toLowerCase(), actual.toLowerCase());
    }

    protected void runTest() throws Throwable {
        LogUtil.resetThreadIndents();
        LogUtil.ThreadLogMode oldThreadRenderingMode = LogUtil.setThreadLogMode(this.threadRenderingMode);
        if (log.isLoggable(Level.FINE)) {
            if (this.isEmptyLinesEnabled) {
                log.fine(EMPTY_LINE);
            }
            log.fine("#### START " + ClassNameUtil.getClassNameWithoutPackage((Object)this) + "." + this.getName() + " ###########################################################");
        }
        try {
            super.runTest();
        }
        catch (AssertionFailedError e) {
            log.severe(EMPTY_LINE);
            log.log(Level.SEVERE, "ASSERTION FAILED: " + (Object)((Object)e), e);
            throw e;
        }
        catch (Throwable e) {
            log.severe(EMPTY_LINE);
            log.log(Level.SEVERE, "EXCEPTION: " + e, e);
            throw e;
        }
        finally {
            log.fine("#### END " + ClassNameUtil.getClassNameWithoutPackage((Object)this) + "." + this.getName() + " #############################################################");
            LogUtil.setThreadLogMode(oldThreadRenderingMode);
        }
    }

    static {
        LogUtil.readJavaUtilLoggingConfigFromClasspath();
        log = Logger.getLogger(PvmTestCase.class.getName());
        DEFAULT_THREAD_LOG_MODE = LogUtil.ThreadLogMode.INDENT;
    }
}

