/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable.serializer;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.variable.value.ObjectValueImpl;
import org.camunda.bpm.engine.impl.core.variable.value.UntypedValueImpl;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.impl.variable.serializer.AbstractTypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ByteArrayValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.DeserializedObjectsSession;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public abstract class AbstractObjectValueSerializer
extends AbstractTypedValueSerializer<ObjectValue> {
    protected String serializationDataFormat;

    public AbstractObjectValueSerializer(String serializationDataFormat) {
        super(ValueType.OBJECT);
        this.serializationDataFormat = serializationDataFormat;
    }

    @Override
    public String getSerializationDataformat() {
        return this.serializationDataFormat;
    }

    @Override
    public ObjectValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return (ObjectValue)Variables.objectValue(untypedValue.getValue()).create();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeValue(ObjectValue value, ValueFields valueFields) {
        objectValue = (ObjectValueImpl)value;
        objectTypeName = objectValue.getObjectTypeName();
        serializedStringValue = objectValue.getValueSerialized();
        serializedByteValue = null;
        if (objectValue.isDeserialized()) {
            objectToSerialize = objectValue.getValue();
            if (objectToSerialize != null) {
                if (objectTypeName == null) {
                    objectTypeName = this.getTypeNameForDeserialized(objectToSerialize);
                }
                try {
                    serializedByteValue = this.serializeToByteArray(objectToSerialize);
                    serializedStringValue = this.getSerializedStringValue(serializedByteValue);
                    if (valueFields.getByteArrayValue() != null || objectToSerialize == null) ** GOTO lbl23
                    this.dirtyCheckOnFlush(objectToSerialize, serializedByteValue, valueFields);
                }
                catch (Exception e) {
                    throw new ProcessEngineException("Cannot serialize object in variable '" + valueFields.getName() + "': " + e.getMessage(), e);
                }
            }
        } else if (serializedStringValue != null) {
            if (objectTypeName == null) {
                throw new ProcessEngineException("Cannot write serialized value for variable '" + valueFields.getName() + "': no 'objectTypeName' provided for non-null value.");
            }
            serializedByteValue = this.getSerializedBytesValue(serializedStringValue);
        }
lbl23:
        // 6 sources

        this.writeToValueFields(valueFields, objectTypeName, serializedByteValue);
        this.updateObjectValue(objectValue, objectTypeName, serializedStringValue);
    }

    @Override
    public ObjectValue readValue(ValueFields valueFields, boolean deserializeObjectValue) {
        byte[] serializedByteValue = this.readSerializedValueFromFields(valueFields);
        String serializedStringValue = this.getSerializedStringValue(serializedByteValue);
        String objectTypeName = this.readObjectNameFromFields(valueFields);
        if (deserializeObjectValue) {
            Object deserializedObject = null;
            if (serializedByteValue != null) {
                try {
                    deserializedObject = this.deserializeFromByteArray(serializedByteValue, objectTypeName);
                }
                catch (Exception e) {
                    throw new ProcessEngineException("Cannot deserialize object in variable '" + valueFields.getName() + "': " + e.getMessage(), e);
                }
            }
            ObjectValueImpl objectValue = new ObjectValueImpl(deserializedObject, serializedStringValue, this.serializationDataFormat, objectTypeName, true);
            if (deserializedObject != null) {
                this.dirtyCheckOnFlush(deserializedObject, serializedByteValue, valueFields);
            }
            return objectValue;
        }
        return new ObjectValueImpl(null, serializedStringValue, this.serializationDataFormat, objectTypeName, false);
    }

    protected void writeToValueFields(ValueFields valueFields, String objectTypeName, byte[] serializedValue) {
        ByteArrayValueSerializer.setBytes(valueFields, serializedValue);
        valueFields.setTextValue2(objectTypeName);
    }

    protected void updateObjectValue(ObjectValueImpl objectValue, String objectTypeName, String serializedValue) {
        objectValue.setSerializedValue(serializedValue);
        objectValue.setSerializationDataFormat(this.serializationDataFormat);
        objectValue.setObjectTypeName(objectTypeName);
    }

    protected String readObjectNameFromFields(ValueFields valueFields) {
        return valueFields.getTextValue2();
    }

    protected byte[] readSerializedValueFromFields(ValueFields valueFields) {
        return ByteArrayValueSerializer.getBytes(valueFields);
    }

    protected String getSerializedStringValue(byte[] serializedByteValue) {
        if (serializedByteValue != null) {
            if (!this.isSerializationTextBased()) {
                serializedByteValue = Base64.encodeBase64(serializedByteValue);
            }
            return StringUtil.fromBytes(serializedByteValue);
        }
        return null;
    }

    protected byte[] getSerializedBytesValue(String serializedStringValue) {
        if (serializedStringValue != null) {
            byte[] serializedByteValue = StringUtil.toByteArray(serializedStringValue);
            if (!this.isSerializationTextBased()) {
                serializedByteValue = Base64.decodeBase64(serializedByteValue);
            }
            return serializedByteValue;
        }
        return null;
    }

    @Override
    protected boolean canWriteValue(TypedValue typedValue) {
        boolean canSerialize;
        Object objectToSerialize = null;
        String requestedDataformat = null;
        if (typedValue instanceof UntypedValueImpl) {
            objectToSerialize = typedValue.getValue();
            requestedDataformat = null;
        } else if (typedValue instanceof ObjectValue) {
            ObjectValue objectValue = (ObjectValue)typedValue;
            String requestedDataFormat = objectValue.getSerializationDataFormat();
            if (!objectValue.isDeserialized()) {
                return this.serializationDataFormat.equals(requestedDataFormat);
            }
            objectToSerialize = typedValue.getValue();
            requestedDataformat = objectValue.getSerializationDataFormat();
        } else {
            return false;
        }
        boolean bl = canSerialize = objectToSerialize == null || this.canSerializeObject(objectToSerialize);
        if (requestedDataformat != null) {
            if (requestedDataformat.equals(this.serializationDataFormat)) {
                return canSerialize;
            }
            return false;
        }
        return canSerialize;
    }

    protected void dirtyCheckOnFlush(Object deserializedObject, byte[] serializedValue, ValueFields valueFields) {
        if (valueFields instanceof VariableInstanceEntity) {
            Context.getCommandContext().getSession(DeserializedObjectsSession.class).addDeserializedObject(this, deserializedObject, serializedValue, (VariableInstanceEntity)valueFields);
        }
    }

    protected abstract boolean canSerializeObject(Object var1);

    protected abstract String getTypeNameForDeserialized(Object var1);

    protected abstract byte[] serializeToByteArray(Object var1) throws Exception;

    protected abstract Object deserializeFromByteArray(byte[] var1, String var2) throws Exception;

    protected abstract boolean isSerializationTextBased();
}

