/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable.serializer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class DefaultVariableSerializers
implements Serializable,
VariableSerializers {
    private static final long serialVersionUID = 1L;
    protected List<TypedValueSerializer<?>> serializerList = new ArrayList();
    protected Map<String, TypedValueSerializer<?>> serializerMap = new HashMap();

    @Override
    public TypedValueSerializer<?> getSerializerByName(String serializerName) {
        return this.serializerMap.get(serializerName);
    }

    @Override
    public TypedValueSerializer<?> findSerializerForValue(TypedValue value) {
        String defaultSerializationFormat = Context.getProcessEngineConfiguration().getDefaultSerializationFormat();
        ArrayList matchedSerializers = new ArrayList();
        ValueType type = value.getType();
        for (TypedValueSerializer<?> typedValueSerializer : this.serializerList) {
            if (type != null && !typedValueSerializer.getType().equals(type) || !typedValueSerializer.canHandle(value)) continue;
            matchedSerializers.add(typedValueSerializer);
            if (!typedValueSerializer.getType().isPrimitiveValueType()) continue;
            break;
        }
        if (matchedSerializers.size() == 0) {
            throw new ProcessEngineException("Cannot find serializer for value '" + value + "'.");
        }
        if (matchedSerializers.size() == 1) {
            return (TypedValueSerializer)matchedSerializers.get(0);
        }
        if (defaultSerializationFormat != null) {
            for (TypedValueSerializer<Object> typedValueSerializer : matchedSerializers) {
                if (!defaultSerializationFormat.equals(typedValueSerializer.getSerializationDataformat())) continue;
                return typedValueSerializer;
            }
        }
        return (TypedValueSerializer)matchedSerializers.get(0);
    }

    @Override
    public DefaultVariableSerializers addSerializer(TypedValueSerializer<?> serializer) {
        return this.addSerializer((TypedValueSerializer)serializer, this.serializerList.size());
    }

    @Override
    public DefaultVariableSerializers addSerializer(TypedValueSerializer<?> serializer, int index) {
        this.serializerList.add(index, serializer);
        this.serializerMap.put(serializer.getName(), serializer);
        return this;
    }

    public void setSerializerList(List<TypedValueSerializer<?>> serializerList) {
        this.serializerList.clear();
        this.serializerList.addAll(serializerList);
        this.serializerMap.clear();
        for (TypedValueSerializer<?> serializer : serializerList) {
            this.serializerMap.put(serializer.getName(), serializer);
        }
    }

    @Override
    public int getSerializerIndex(TypedValueSerializer<?> serializer) {
        return this.serializerList.indexOf(serializer);
    }

    @Override
    public int getSerializerIndexByName(String serializerName) {
        TypedValueSerializer<?> serializer = this.serializerMap.get(serializerName);
        if (serializer != null) {
            return this.getSerializerIndex(serializer);
        }
        return -1;
    }

    @Override
    public VariableSerializers removeSerializer(TypedValueSerializer<?> serializer) {
        this.serializerList.remove(serializer);
        this.serializerMap.remove(serializer.getName());
        return this;
    }
}

