/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.camunda.bpm.engine.test.bpmn.event.timer;

import org.camunda.bpm.engine.impl.test.ResourceProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

/**
 * @author Frederik Heremans
 */
public class BoundaryTimerEventFullHistoryTest extends ResourceProcessEngineTestCase {
  
  public BoundaryTimerEventFullHistoryTest() {
    super("org/camunda/bpm/engine/test/standalone/history/fullhistory.camunda.cfg.xml");
  }
  
  @Override
  protected void closeDownProcessEngine() {
    processEngine.close();
    super.closeDownProcessEngine();
  }
  
  @Deployment
  public void testSetProcessVariablesFromTaskWhenTimerOnTask() {
    ProcessInstance processInstance = runtimeService.startProcessInstanceByKey("timerVariablesProcess");
    runtimeService.setVariable(processInstance.getId(), "myVar", 123456L);
  }

}
