/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.metadata;

import java.util.HashMap;
import java.util.Properties;
import junit.framework.TestCase;
import org.camunda.bpm.container.impl.metadata.PropertyHelper;
import org.camunda.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.junit.Assert;

public class PropertyHelperTest
extends TestCase {
    protected static final String JOB_EXECUTOR_DEPLOYMENT_AWARE_PROP = "jobExecutorDeploymentAware";
    protected static final String MAIL_SERVER_PORT_PROP = "mailServerPort";
    protected static final String JDBC_URL_PROP = "jdbcUrl";
    protected static final String DB_IDENTITY_USED_PROP = "dbIdentityUsed";

    public void testProcessEngineConfigurationProperties() {
        StandaloneProcessEngineConfiguration engineConfiguration = new StandaloneProcessEngineConfiguration();
        HashMap<String, String> propertiesToSet = new HashMap<String, String>();
        propertiesToSet.put(JOB_EXECUTOR_DEPLOYMENT_AWARE_PROP, "true");
        propertiesToSet.put(MAIL_SERVER_PORT_PROP, "42");
        propertiesToSet.put(JDBC_URL_PROP, "someUrl");
        PropertyHelper.applyProperties((Object)engineConfiguration, propertiesToSet);
        Assert.assertTrue((boolean)engineConfiguration.isJobExecutorDeploymentAware());
        Assert.assertEquals((long)42L, (long)engineConfiguration.getMailServerPort());
        Assert.assertEquals((Object)"someUrl", (Object)engineConfiguration.getJdbcUrl());
    }

    public void testConfigurationPropertiesWithMismatchingFieldAndSetter() {
        StandaloneProcessEngineConfiguration engineConfiguration = new StandaloneProcessEngineConfiguration();
        HashMap<String, String> propertiesToSet = new HashMap<String, String>();
        propertiesToSet.put(DB_IDENTITY_USED_PROP, "false");
        PropertyHelper.applyProperties((Object)engineConfiguration, propertiesToSet);
        Assert.assertFalse((boolean)engineConfiguration.isDbIdentityUsed());
        propertiesToSet.put(DB_IDENTITY_USED_PROP, "true");
        PropertyHelper.applyProperties((Object)engineConfiguration, propertiesToSet);
        Assert.assertTrue((boolean)engineConfiguration.isDbIdentityUsed());
    }

    public void testNonExistingPropertyForProcessEngineConfiguration() {
        StandaloneProcessEngineConfiguration engineConfiguration = new StandaloneProcessEngineConfiguration();
        HashMap<String, String> propertiesToSet = new HashMap<String, String>();
        propertiesToSet.put("aNonExistingProperty", "someValue");
        try {
            PropertyHelper.applyProperties((Object)engineConfiguration, propertiesToSet);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testResolvePropertyForExistingProperty() {
        Properties source = new Properties();
        source.put("camunda.test.someKey", "1234");
        String result = PropertyHelper.resolveProperty((Properties)source, (String)"${camunda.test.someKey}");
        Assert.assertEquals((Object)"1234", (Object)result);
    }

    public void testResolvePropertyWhitespaceAndMore() {
        Properties source = new Properties();
        source.put("camunda.test.someKey", "1234");
        String result = PropertyHelper.resolveProperty((Properties)source, (String)" -${ camunda.test.someKey }- ");
        Assert.assertEquals((Object)" -1234- ", (Object)result);
    }

    public void testResolvePropertyForMultiplePropertes() {
        Properties source = new Properties();
        source.put("camunda.test.oneKey", "1234");
        source.put("camunda.test.anotherKey", "5678");
        String result = PropertyHelper.resolveProperty((Properties)source, (String)"-${ camunda.test.oneKey }-${ camunda.test.anotherKey}-");
        Assert.assertEquals((Object)"-1234-5678-", (Object)result);
    }

    public void testResolvePropertyForMissingProperty() {
        Properties source = new Properties();
        String result = PropertyHelper.resolveProperty((Properties)source, (String)"${camunda.test.someKey}");
        Assert.assertEquals((Object)"", (Object)result);
    }

    public void testResolvePropertyNoTemplate() {
        Properties source = new Properties();
        source.put("camunda.test.someKey", "1234");
        String result = PropertyHelper.resolveProperty((Properties)source, (String)"camunda.test.someKey");
        Assert.assertEquals((Object)"camunda.test.someKey", (Object)result);
    }
}

