/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.filter;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class FilterPropertiesTest
extends PluggableProcessEngineTestCase {
    protected Filter filter;
    protected String nestedJsonObject = "{\"id\":\"nested\"}";
    protected String nestedJsonArray = "[\"a\",\"b\"]";

    public void setUp() {
        this.filter = this.filterService.newTaskFilter("name").setOwner("owner").setProperties(new HashMap());
    }

    public void testPropertiesFromNull() {
        this.filter.setProperties(null);
        FilterPropertiesTest.assertNull((Object)this.filter.getProperties());
        this.filter.setProperties((Map)null);
        FilterPropertiesTest.assertNull((Object)this.filter.getProperties());
    }

    public void testPropertiesFromMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("color", "#123456");
        properties.put("priority", 42);
        properties.put("userDefined", true);
        properties.put("object", this.nestedJsonObject);
        properties.put("array", this.nestedJsonArray);
        this.filter.setProperties(properties);
        this.assertTestProperties();
    }

    protected void assertTestProperties() {
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
        Map properties = this.filter.getProperties();
        FilterPropertiesTest.assertEquals((int)5, (int)properties.size());
        FilterPropertiesTest.assertEquals((Object)"#123456", properties.get("color"));
        FilterPropertiesTest.assertEquals((Object)42, properties.get("priority"));
        FilterPropertiesTest.assertEquals((Object)true, properties.get("userDefined"));
        FilterPropertiesTest.assertEquals((Object)this.nestedJsonObject, properties.get("object"));
        FilterPropertiesTest.assertEquals((Object)this.nestedJsonArray, properties.get("array"));
        this.filterService.deleteFilter(this.filter.getId());
    }
}

