/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.util.List;
import junit.framework.AssertionFailedError;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Event;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class TaskIdentityLinksTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/IdentityLinksProcess.bpmn20.xml"})
    public void testCandidateUserLink() {
        this.runtimeService.startProcessInstanceByKey("IdentityLinksProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addCandidateUser(taskId, "kermit");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        IdentityLink identityLink = (IdentityLink)identityLinks.get(0);
        TaskIdentityLinksTest.assertNull((Object)identityLink.getGroupId());
        TaskIdentityLinksTest.assertEquals((String)"kermit", (String)identityLink.getUserId());
        TaskIdentityLinksTest.assertEquals((String)"candidate", (String)identityLink.getType());
        TaskIdentityLinksTest.assertEquals((String)taskId, (String)identityLink.getTaskId());
        TaskIdentityLinksTest.assertEquals((int)1, (int)identityLinks.size());
        this.taskService.deleteCandidateUser(taskId, "kermit");
        TaskIdentityLinksTest.assertEquals((int)0, (int)this.taskService.getIdentityLinksForTask(taskId).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/IdentityLinksProcess.bpmn20.xml"})
    public void testCandidateGroupLink() {
        List taskEventMessageParts;
        Event taskEvent;
        List taskEvents;
        this.runtimeService.startProcessInstanceByKey("IdentityLinksProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addCandidateGroup(taskId, "muppets");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        IdentityLink identityLink = (IdentityLink)identityLinks.get(0);
        TaskIdentityLinksTest.assertEquals((String)"muppets", (String)identityLink.getGroupId());
        TaskIdentityLinksTest.assertNull((String)"kermit", (Object)identityLink.getUserId());
        TaskIdentityLinksTest.assertEquals((String)"candidate", (String)identityLink.getType());
        TaskIdentityLinksTest.assertEquals((String)taskId, (String)identityLink.getTaskId());
        TaskIdentityLinksTest.assertEquals((int)1, (int)identityLinks.size());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_FULL) {
            taskEvents = this.taskService.getTaskEvents(taskId);
            TaskIdentityLinksTest.assertEquals((int)1, (int)taskEvents.size());
            taskEvent = (Event)taskEvents.get(0);
            TaskIdentityLinksTest.assertEquals((String)"AddGroupLink", (String)taskEvent.getAction());
            taskEventMessageParts = taskEvent.getMessageParts();
            TaskIdentityLinksTest.assertEquals((String)"muppets", (String)((String)taskEventMessageParts.get(0)));
            TaskIdentityLinksTest.assertEquals((String)"candidate", (String)((String)taskEventMessageParts.get(1)));
            TaskIdentityLinksTest.assertEquals((int)2, (int)taskEventMessageParts.size());
        }
        this.taskService.deleteCandidateGroup(taskId, "muppets");
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_FULL) {
            taskEvents = this.taskService.getTaskEvents(taskId);
            taskEvent = this.findTaskEvent(taskEvents, "DeleteGroupLink");
            TaskIdentityLinksTest.assertEquals((String)"DeleteGroupLink", (String)taskEvent.getAction());
            taskEventMessageParts = taskEvent.getMessageParts();
            TaskIdentityLinksTest.assertEquals((String)"muppets", (String)((String)taskEventMessageParts.get(0)));
            TaskIdentityLinksTest.assertEquals((String)"candidate", (String)((String)taskEventMessageParts.get(1)));
            TaskIdentityLinksTest.assertEquals((int)2, (int)taskEventMessageParts.size());
            TaskIdentityLinksTest.assertEquals((int)2, (int)taskEvents.size());
        }
        TaskIdentityLinksTest.assertEquals((int)0, (int)this.taskService.getIdentityLinksForTask(taskId).size());
    }

    public void testAssigneeLink() {
        Task task = this.taskService.newTask("task");
        task.setAssignee("assignee");
        this.taskService.saveTask(task);
        List identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
        TaskIdentityLinksTest.assertNotNull((Object)identityLinks);
        TaskIdentityLinksTest.assertEquals((int)1, (int)identityLinks.size());
        IdentityLink identityLink = (IdentityLink)identityLinks.get(0);
        TaskIdentityLinksTest.assertEquals((String)"assignee", (String)identityLink.getType());
        TaskIdentityLinksTest.assertEquals((String)"assignee", (String)identityLink.getUserId());
        TaskIdentityLinksTest.assertEquals((String)"task", (String)identityLink.getTaskId());
        this.taskService.deleteTask(task.getId(), true);
    }

    public void testOwnerLink() {
        Task task = this.taskService.newTask("task");
        task.setOwner("owner");
        this.taskService.saveTask(task);
        List identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
        TaskIdentityLinksTest.assertNotNull((Object)identityLinks);
        TaskIdentityLinksTest.assertEquals((int)1, (int)identityLinks.size());
        IdentityLink identityLink = (IdentityLink)identityLinks.get(0);
        TaskIdentityLinksTest.assertEquals((String)"owner", (String)identityLink.getType());
        TaskIdentityLinksTest.assertEquals((String)"owner", (String)identityLink.getUserId());
        TaskIdentityLinksTest.assertEquals((String)"task", (String)identityLink.getTaskId());
        this.taskService.deleteTask(task.getId(), true);
    }

    private Event findTaskEvent(List<Event> taskEvents, String action) {
        for (Event event : taskEvents) {
            if (!action.equals(event.getAction())) continue;
            return event;
        }
        throw new AssertionFailedError("no task event found with action " + action);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/IdentityLinksProcess.bpmn20.xml"})
    public void testCustomTypeUserLink() {
        this.runtimeService.startProcessInstanceByKey("IdentityLinksProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addUserIdentityLink(taskId, "kermit", "interestee");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        IdentityLink identityLink = (IdentityLink)identityLinks.get(0);
        TaskIdentityLinksTest.assertNull((Object)identityLink.getGroupId());
        TaskIdentityLinksTest.assertEquals((String)"kermit", (String)identityLink.getUserId());
        TaskIdentityLinksTest.assertEquals((String)"interestee", (String)identityLink.getType());
        TaskIdentityLinksTest.assertEquals((String)taskId, (String)identityLink.getTaskId());
        TaskIdentityLinksTest.assertEquals((int)1, (int)identityLinks.size());
        this.taskService.deleteUserIdentityLink(taskId, "kermit", "interestee");
        TaskIdentityLinksTest.assertEquals((int)0, (int)this.taskService.getIdentityLinksForTask(taskId).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/IdentityLinksProcess.bpmn20.xml"})
    public void testCustomLinkGroupLink() {
        this.runtimeService.startProcessInstanceByKey("IdentityLinksProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addGroupIdentityLink(taskId, "muppets", "playing");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        IdentityLink identityLink = (IdentityLink)identityLinks.get(0);
        TaskIdentityLinksTest.assertEquals((String)"muppets", (String)identityLink.getGroupId());
        TaskIdentityLinksTest.assertNull((String)"kermit", (Object)identityLink.getUserId());
        TaskIdentityLinksTest.assertEquals((String)"playing", (String)identityLink.getType());
        TaskIdentityLinksTest.assertEquals((String)taskId, (String)identityLink.getTaskId());
        TaskIdentityLinksTest.assertEquals((int)1, (int)identityLinks.size());
        this.taskService.deleteGroupIdentityLink(taskId, "muppets", "playing");
        TaskIdentityLinksTest.assertEquals((int)0, (int)this.taskService.getIdentityLinksForTask(taskId).size());
    }

    public void testDeleteAssignee() {
        Task task = this.taskService.newTask();
        task.setAssignee("nonExistingUser");
        this.taskService.saveTask(task);
        this.taskService.deleteUserIdentityLink(task.getId(), "nonExistingUser", "assignee");
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        TaskIdentityLinksTest.assertNull((Object)task.getAssignee());
        TaskIdentityLinksTest.assertEquals((int)0, (int)this.taskService.getIdentityLinksForTask(task.getId()).size());
        this.taskService.deleteTask(task.getId(), true);
    }

    public void testDeleteOwner() {
        Task task = this.taskService.newTask();
        task.setOwner("nonExistingUser");
        this.taskService.saveTask(task);
        this.taskService.deleteUserIdentityLink(task.getId(), "nonExistingUser", "owner");
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        TaskIdentityLinksTest.assertNull((Object)task.getOwner());
        TaskIdentityLinksTest.assertEquals((int)0, (int)this.taskService.getIdentityLinksForTask(task.getId()).size());
        this.taskService.deleteTask(task.getId(), true);
    }
}

