/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.multiinstance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.error.ThrowErrorDelegate;
import org.camunda.bpm.engine.test.bpmn.multiinstance.RecordInvocationListener;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class MultiInstanceTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.sequentialUserTasks.bpmn20.xml"})
    public void testSequentialUserTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks", CollectionUtil.singletonMap((String)"nrOfLoops", (Object)3));
        String procId = processInstance.getId();
        ActivityInstance[] childInstances = this.runtimeService.getActivityInstance(processInstance.getId()).getChildActivityInstances();
        MultiInstanceTest.assertEquals((int)1, (int)childInstances.length);
        ActivityInstance firstActInstance = childInstances[0];
        MultiInstanceTest.assertEquals((String)processInstance.getId(), (String)firstActInstance.getParentActivityInstanceId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MultiInstanceTest.assertEquals((String)"My Task", (String)task.getName());
        MultiInstanceTest.assertEquals((String)"kermit_0", (String)task.getAssignee());
        this.taskService.complete(task.getId());
        childInstances = this.runtimeService.getActivityInstance(processInstance.getId()).getChildActivityInstances();
        MultiInstanceTest.assertEquals((int)1, (int)childInstances.length);
        MultiInstanceTest.assertFalse((boolean)childInstances[0].getId().equals(firstActInstance.getId()));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        MultiInstanceTest.assertEquals((String)"My Task", (String)task.getName());
        MultiInstanceTest.assertEquals((String)"kermit_1", (String)task.getAssignee());
        this.taskService.complete(task.getId());
        childInstances = this.runtimeService.getActivityInstance(processInstance.getId()).getChildActivityInstances();
        MultiInstanceTest.assertEquals((int)1, (int)childInstances.length);
        MultiInstanceTest.assertFalse((boolean)childInstances[0].getId().equals(firstActInstance.getId()));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        MultiInstanceTest.assertEquals((String)"My Task", (String)task.getName());
        MultiInstanceTest.assertEquals((String)"kermit_2", (String)task.getAssignee());
        this.taskService.complete(task.getId());
        MultiInstanceTest.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.sequentialUserTasks.bpmn20.xml"})
    public void testSequentialUserTasksHistory() {
        this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks", CollectionUtil.singletonMap((String)"nrOfLoops", (Object)4)).getId();
        for (int i = 0; i < 4; ++i) {
            this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("userTask").list();
            MultiInstanceTest.assertEquals((int)4, (int)historicActivityInstances.size());
            for (HistoricActivityInstance hai : historicActivityInstances) {
                MultiInstanceTest.assertNotNull((Object)hai.getActivityId());
                MultiInstanceTest.assertNotNull((Object)hai.getActivityName());
                MultiInstanceTest.assertNotNull((Object)hai.getStartTime());
                MultiInstanceTest.assertNotNull((Object)hai.getEndTime());
                MultiInstanceTest.assertNotNull((Object)hai.getAssignee());
            }
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            List historicTaskInstances = this.historyService.createHistoricTaskInstanceQuery().list();
            MultiInstanceTest.assertEquals((int)4, (int)historicTaskInstances.size());
            for (HistoricTaskInstance ht : historicTaskInstances) {
                MultiInstanceTest.assertNotNull((Object)ht.getAssignee());
                MultiInstanceTest.assertNotNull((Object)ht.getStartTime());
                MultiInstanceTest.assertNotNull((Object)ht.getEndTime());
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.sequentialUserTasks.bpmn20.xml"})
    public void testSequentialUserTasksWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks", CollectionUtil.singletonMap((String)"nrOfLoops", (Object)3)).getId();
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        MultiInstanceTest.assertEquals((String)"taskAfterTimer", (String)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.sequentialUserTasks.bpmn20.xml"})
    public void testSequentialUserTasksCompletionCondition() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks", CollectionUtil.singletonMap((String)"nrOfLoops", (Object)10)).getId();
        for (int i = 0; i < 5; ++i) {
            Task task = (Task)this.taskService.createTaskQuery().singleResult();
            this.taskService.complete(task.getId());
        }
        MultiInstanceTest.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void FAILING_testSequentialMITasksExecutionListener() {
        RecordInvocationListener.reset();
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("nrOfLoops", 2);
        this.runtimeService.startProcessInstanceByKey("miSequentialListener", vars);
        MultiInstanceTest.assertEquals((int)1, (int)RecordInvocationListener.INVOCATIONS.get("start"));
        MultiInstanceTest.assertNull((Object)RecordInvocationListener.INVOCATIONS.get("end"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        MultiInstanceTest.assertEquals((int)2, (int)RecordInvocationListener.INVOCATIONS.get("start"));
        MultiInstanceTest.assertEquals((int)1, (int)RecordInvocationListener.INVOCATIONS.get("end"));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        MultiInstanceTest.assertEquals((int)2, (int)RecordInvocationListener.INVOCATIONS.get("start"));
        MultiInstanceTest.assertEquals((int)2, (int)RecordInvocationListener.INVOCATIONS.get("end"));
    }

    @Deployment
    public void FAILING_testParallelMITasksExecutionListener() {
        RecordInvocationListener.reset();
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("nrOfLoops", 5);
        this.runtimeService.startProcessInstanceByKey("miSequentialListener", vars);
        MultiInstanceTest.assertEquals((int)5, (int)RecordInvocationListener.INVOCATIONS.get("start"));
        MultiInstanceTest.assertNull((Object)RecordInvocationListener.INVOCATIONS.get("end"));
        List tasks = this.taskService.createTaskQuery().list();
        this.taskService.complete(((Task)tasks.get(0)).getId());
        MultiInstanceTest.assertEquals((int)5, (int)RecordInvocationListener.INVOCATIONS.get("start"));
        MultiInstanceTest.assertEquals((int)1, (int)RecordInvocationListener.INVOCATIONS.get("end"));
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.taskService.complete(((Task)tasks.get(2)).getId());
        this.taskService.complete(((Task)tasks.get(3)).getId());
        this.taskService.complete(((Task)tasks.get(4)).getId());
        MultiInstanceTest.assertEquals((int)5, (int)RecordInvocationListener.INVOCATIONS.get("start"));
        MultiInstanceTest.assertEquals((int)5, (int)RecordInvocationListener.INVOCATIONS.get("end"));
    }

    @Deployment
    public void testNestedSequentialUserTasks() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedSequentialUserTasks").getId();
        for (int i = 0; i < 3; ++i) {
            Task task = (Task)this.taskService.createTaskQuery().taskAssignee("kermit").singleResult();
            MultiInstanceTest.assertEquals((String)"My Task", (String)task.getName());
            ActivityInstance processInstance = this.runtimeService.getActivityInstance(procId);
            List instancesForActivitiyId = this.getInstancesForActivitiyId(processInstance, "miTasks");
            MultiInstanceTest.assertEquals((int)1, (int)instancesForActivitiyId.size());
            ActivityInstance userTaskActInst = (ActivityInstance)instancesForActivitiyId.get(0);
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testParallelUserTasks() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("miParallelUserTasks");
        String procId = procInst.getId();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        MultiInstanceTest.assertEquals((int)3, (int)tasks.size());
        MultiInstanceTest.assertEquals((String)"My Task 0", (String)((Task)tasks.get(0)).getName());
        MultiInstanceTest.assertEquals((String)"My Task 1", (String)((Task)tasks.get(1)).getName());
        MultiInstanceTest.assertEquals((String)"My Task 2", (String)((Task)tasks.get(2)).getName());
        ActivityInstance processInstance = this.runtimeService.getActivityInstance(procId);
        MultiInstanceTest.assertEquals((int)3, (int)processInstance.getChildActivityInstances().length);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        processInstance = this.runtimeService.getActivityInstance(procId);
        MultiInstanceTest.assertEquals((int)2, (int)processInstance.getChildActivityInstances().length);
        this.taskService.complete(((Task)tasks.get(1)).getId());
        processInstance = this.runtimeService.getActivityInstance(procId);
        MultiInstanceTest.assertEquals((int)1, (int)processInstance.getChildActivityInstances().length);
        this.taskService.complete(((Task)tasks.get(2)).getId());
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelUserTasks.bpmn20.xml"})
    public void testParallelUserTasksHistory() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("miParallelUserTasks");
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(task.getId());
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskAssignee().asc()).list();
            for (int i = 0; i < historicTaskInstances.size(); ++i) {
                HistoricTaskInstance hi = (HistoricTaskInstance)historicTaskInstances.get(i);
                MultiInstanceTest.assertNotNull((Object)hi.getStartTime());
                MultiInstanceTest.assertNotNull((Object)hi.getEndTime());
                MultiInstanceTest.assertEquals((String)("kermit_" + i), (String)hi.getAssignee());
            }
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("userTask").list();
            MultiInstanceTest.assertEquals((int)3, (int)historicActivityInstances.size());
            for (HistoricActivityInstance hai : historicActivityInstances) {
                MultiInstanceTest.assertNotNull((Object)hai.getStartTime());
                MultiInstanceTest.assertNotNull((Object)hai.getEndTime());
                MultiInstanceTest.assertNotNull((Object)hai.getAssignee());
                MultiInstanceTest.assertEquals((String)"userTask", (String)hai.getActivityType());
                MultiInstanceTest.assertEquals((String)pi.getId(), (String)hai.getParentActivityInstanceId());
                MultiInstanceTest.assertNotNull((Object)hai.getTaskId());
            }
        }
    }

    @Deployment
    public void testParallelUserTasksWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelUserTasksWithTimer").getId();
        List tasks = this.taskService.createTaskQuery().list();
        this.taskService.complete(((Task)tasks.get(0)).getId());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        MultiInstanceTest.assertEquals((String)"taskAfterTimer", (String)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testParallelUserTasksCompletionCondition() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelUserTasksCompletionCondition").getId();
        List tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)5, (int)tasks.size());
        for (int i = 0; i < 3; ++i) {
            MultiInstanceTest.assertEquals((long)(5 - i), (long)this.taskService.createTaskQuery().count());
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testParallelUserTasksBasedOnCollection() {
        List<String> assigneeList = Arrays.asList("kermit", "gonzo", "mispiggy", "fozzie", "bubba");
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelUserTasksBasedOnCollection", CollectionUtil.singletonMap((String)"assigneeList", assigneeList)).getId();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskAssignee().asc()).list();
        MultiInstanceTest.assertEquals((int)5, (int)tasks.size());
        MultiInstanceTest.assertEquals((String)"bubba", (String)((Task)tasks.get(0)).getAssignee());
        MultiInstanceTest.assertEquals((String)"fozzie", (String)((Task)tasks.get(1)).getAssignee());
        MultiInstanceTest.assertEquals((String)"gonzo", (String)((Task)tasks.get(2)).getAssignee());
        MultiInstanceTest.assertEquals((String)"kermit", (String)((Task)tasks.get(3)).getAssignee());
        MultiInstanceTest.assertEquals((String)"mispiggy", (String)((Task)tasks.get(4)).getAssignee());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.taskService.complete(((Task)tasks.get(2)).getId());
        MultiInstanceTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelUserTasksBasedOnCollection.bpmn20.xml"})
    public void testEmptyCollectionInMI() {
        ArrayList assigneeList = new ArrayList();
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelUserTasksBasedOnCollection", CollectionUtil.singletonMap((String)"assigneeList", assigneeList)).getId();
        MultiInstanceTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        this.assertProcessEnded(procId);
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List activities = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(procId).orderByActivityId().asc()).list();
            MultiInstanceTest.assertEquals((int)3, (int)activities.size());
            MultiInstanceTest.assertEquals((String)"miTasks", (String)((HistoricActivityInstance)activities.get(0)).getActivityId());
            MultiInstanceTest.assertEquals((String)"theEnd", (String)((HistoricActivityInstance)activities.get(1)).getActivityId());
            MultiInstanceTest.assertEquals((String)"theStart", (String)((HistoricActivityInstance)activities.get(2)).getActivityId());
        }
    }

    @Deployment
    public void testParallelUserTasksCustomExtensions() {
        HashMap<String, List<String>> vars = new HashMap<String, List<String>>();
        List<String> assigneeList = Arrays.asList("kermit", "gonzo", "fozzie");
        vars.put("assigneeList", assigneeList);
        this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks", vars);
        for (String assignee : assigneeList) {
            Task task = (Task)this.taskService.createTaskQuery().singleResult();
            MultiInstanceTest.assertEquals((String)assignee, (String)task.getAssignee());
            this.taskService.complete(task.getId());
        }
    }

    @Deployment
    public void testParallelUserTasksExecutionAndTaskListeners() {
        this.runtimeService.startProcessInstanceByKey("miParallelUserTasks");
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        Execution waitState = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        MultiInstanceTest.assertEquals((Object)3, (Object)this.runtimeService.getVariable(waitState.getId(), "taskListenerCounter"));
        MultiInstanceTest.assertEquals((Object)3, (Object)this.runtimeService.getVariable(waitState.getId(), "executionListenerCounter"));
    }

    @Deployment
    public void testNestedParallelUserTasks() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedParallelUserTasks").getId();
        List tasks = this.taskService.createTaskQuery().taskAssignee("kermit").list();
        for (Task task : tasks) {
            MultiInstanceTest.assertEquals((String)"My Task", (String)task.getName());
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testSequentialScriptTasks() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("sum", 0);
        vars.put("nrOfLoops", 5);
        this.runtimeService.startProcessInstanceByKey("miSequentialScriptTask", vars);
        Execution waitStateExecution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        int sum = (Integer)this.runtimeService.getVariable(waitStateExecution.getId(), "sum");
        MultiInstanceTest.assertEquals((int)10, (int)sum);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testSequentialScriptTasks.bpmn20.xml"})
    public void testSequentialScriptTasksHistory() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("sum", 0);
        vars.put("nrOfLoops", 7);
        this.runtimeService.startProcessInstanceByKey("miSequentialScriptTask", vars);
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List historicInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().activityType("scriptTask").orderByActivityId().asc()).list();
            MultiInstanceTest.assertEquals((int)7, (int)historicInstances.size());
            for (int i = 0; i < 7; ++i) {
                HistoricActivityInstance hai = (HistoricActivityInstance)historicInstances.get(i);
                MultiInstanceTest.assertEquals((String)"scriptTask", (String)hai.getActivityType());
                MultiInstanceTest.assertNotNull((Object)hai.getStartTime());
                MultiInstanceTest.assertNotNull((Object)hai.getEndTime());
            }
        }
    }

    @Deployment
    public void testSequentialScriptTasksCompletionCondition() {
        this.runtimeService.startProcessInstanceByKey("miSequentialScriptTaskCompletionCondition").getId();
        Execution waitStateExecution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        int sum = (Integer)this.runtimeService.getVariable(waitStateExecution.getId(), "sum");
        MultiInstanceTest.assertEquals((int)5, (int)sum);
    }

    @Deployment
    public void testParallelScriptTasks() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("sum", 0);
        vars.put("nrOfLoops", 10);
        this.runtimeService.startProcessInstanceByKey("miParallelScriptTask", vars);
        Execution waitStateExecution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        int sum = (Integer)this.runtimeService.getVariable(waitStateExecution.getId(), "sum");
        MultiInstanceTest.assertEquals((int)45, (int)sum);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelScriptTasks.bpmn20.xml"})
    public void testParallelScriptTasksHistory() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("sum", 0);
        vars.put("nrOfLoops", 4);
        this.runtimeService.startProcessInstanceByKey("miParallelScriptTask", vars);
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("scriptTask").list();
            MultiInstanceTest.assertEquals((int)4, (int)historicActivityInstances.size());
            for (HistoricActivityInstance hai : historicActivityInstances) {
                MultiInstanceTest.assertNotNull((Object)hai.getStartTime());
                MultiInstanceTest.assertNotNull((Object)hai.getStartTime());
            }
        }
    }

    @Deployment
    public void testParallelScriptTasksCompletionCondition() {
        this.runtimeService.startProcessInstanceByKey("miParallelScriptTaskCompletionCondition");
        Execution waitStateExecution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        int sum = (Integer)this.runtimeService.getVariable(waitStateExecution.getId(), "sum");
        MultiInstanceTest.assertEquals((int)2, (int)sum);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelScriptTasksCompletionCondition.bpmn20.xml"})
    public void testParallelScriptTasksCompletionConditionHistory() {
        this.runtimeService.startProcessInstanceByKey("miParallelScriptTaskCompletionCondition");
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("scriptTask").list();
            MultiInstanceTest.assertEquals((int)2, (int)historicActivityInstances.size());
        }
    }

    @Deployment
    public void testSequentialSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess").getId();
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc();
        for (int i = 0; i < 4; ++i) {
            List tasks = query.list();
            MultiInstanceTest.assertEquals((int)2, (int)tasks.size());
            MultiInstanceTest.assertEquals((String)"task one", (String)((Task)tasks.get(0)).getName());
            MultiInstanceTest.assertEquals((String)"task two", (String)((Task)tasks.get(1)).getName());
            this.taskService.complete(((Task)tasks.get(0)).getId());
            this.taskService.complete(((Task)tasks.get(1)).getId());
            if (i == 3) continue;
            List activities = this.runtimeService.getActiveActivityIds(procId);
            MultiInstanceTest.assertNotNull((Object)activities);
            MultiInstanceTest.assertEquals((int)2, (int)activities.size());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testSequentialSubProcessEndEvent() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess").getId();
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc();
        for (int i = 0; i < 4; ++i) {
            List tasks = query.list();
            MultiInstanceTest.assertEquals((int)1, (int)tasks.size());
            MultiInstanceTest.assertEquals((String)"task one", (String)((Task)tasks.get(0)).getName());
            this.taskService.complete(((Task)tasks.get(0)).getId());
            if (i == 3) continue;
            List activities = this.runtimeService.getActiveActivityIds(procId);
            MultiInstanceTest.assertNotNull((Object)activities);
            MultiInstanceTest.assertEquals((int)1, (int)activities.size());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testSequentialSubProcess.bpmn20.xml"})
    public void testSequentialSubProcessHistory() {
        this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess");
        for (int i = 0; i < 4; ++i) {
            List tasks = this.taskService.createTaskQuery().list();
            this.taskService.complete(((Task)tasks.get(0)).getId());
            this.taskService.complete(((Task)tasks.get(1)).getId());
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List onlySubProcessInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("subProcess").list();
            MultiInstanceTest.assertEquals((int)4, (int)onlySubProcessInstances.size());
            List historicInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("subProcess").list();
            MultiInstanceTest.assertEquals((int)4, (int)historicInstances.size());
            for (HistoricActivityInstance hai : historicInstances) {
                MultiInstanceTest.assertNotNull((Object)hai.getStartTime());
                MultiInstanceTest.assertNotNull((Object)hai.getEndTime());
            }
            historicInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("userTask").list();
            MultiInstanceTest.assertEquals((int)8, (int)historicInstances.size());
            for (HistoricActivityInstance hai : historicInstances) {
                MultiInstanceTest.assertNotNull((Object)hai.getStartTime());
                MultiInstanceTest.assertNotNull((Object)hai.getEndTime());
            }
        }
    }

    @Deployment
    public void testSequentialSubProcessWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocessWithTimer").getId();
        List tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)2, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)2, (int)tasks.size());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        MultiInstanceTest.assertEquals((String)"taskAfterTimer", (String)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testSequentialSubProcessCompletionCondition() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocessCompletionCondition").getId();
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc();
        for (int i = 0; i < 3; ++i) {
            List tasks = query.list();
            MultiInstanceTest.assertEquals((int)2, (int)tasks.size());
            MultiInstanceTest.assertEquals((String)"task one", (String)((Task)tasks.get(0)).getName());
            MultiInstanceTest.assertEquals((String)"task two", (String)((Task)tasks.get(1)).getName());
            this.taskService.complete(((Task)tasks.get(0)).getId());
            this.taskService.complete(((Task)tasks.get(1)).getId());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testNestedSequentialSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedSequentialSubProcess").getId();
        for (int i = 0; i < 3; ++i) {
            List tasks = this.taskService.createTaskQuery().taskAssignee("kermit").list();
            this.taskService.complete(((Task)tasks.get(0)).getId());
            this.taskService.complete(((Task)tasks.get(1)).getId());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testNestedSequentialSubProcessWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedSequentialSubProcessWithTimer").getId();
        for (int i = 0; i < 2; ++i) {
            List tasks = this.taskService.createTaskQuery().taskAssignee("kermit").list();
            this.taskService.complete(((Task)tasks.get(0)).getId());
            this.taskService.complete(((Task)tasks.get(1)).getId());
        }
        List tasks = this.taskService.createTaskQuery().taskAssignee("kermit").list();
        this.taskService.complete(((Task)tasks.get(0)).getId());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        MultiInstanceTest.assertEquals((String)"taskAfterTimer", (String)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testParallelSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelSubprocess").getId();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        MultiInstanceTest.assertEquals((int)4, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelSubProcess.bpmn20.xml"})
    public void testParallelSubProcessHistory() {
        List historicActivityInstances;
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("miParallelSubprocess");
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityId("miSubProcess").list();
            MultiInstanceTest.assertEquals((int)2, (int)historicActivityInstances.size());
            for (HistoricActivityInstance hai : historicActivityInstances) {
                MultiInstanceTest.assertNotNull((Object)hai.getStartTime());
                MultiInstanceTest.assertNull((Object)hai.getEndTime());
                MultiInstanceTest.assertNotNull((String)pi.getId(), (Object)hai.getParentActivityInstanceId());
            }
        }
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(task.getId());
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityId("miSubProcess").list();
            MultiInstanceTest.assertEquals((int)2, (int)historicActivityInstances.size());
            for (HistoricActivityInstance hai : historicActivityInstances) {
                MultiInstanceTest.assertNotNull((Object)hai.getStartTime());
                MultiInstanceTest.assertNotNull((Object)hai.getEndTime());
                MultiInstanceTest.assertNotNull((String)pi.getId(), (Object)hai.getParentActivityInstanceId());
            }
        }
    }

    @Deployment
    public void testParallelSubProcessWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelSubprocessWithTimer").getId();
        List tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)6, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        MultiInstanceTest.assertEquals((String)"taskAfterTimer", (String)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testParallelSubProcessCompletionCondition() {
        ActivityInstance[] taskActivities;
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelSubprocessCompletionCondition").getId();
        List tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)4, (int)tasks.size());
        for (ActivityInstance taskActivity : taskActivities = this.runtimeService.getActivityInstance(procId).getChildActivityInstances()[0].getChildActivityInstances()) {
            Task task = (Task)this.taskService.createTaskQuery().activityInstanceIdIn(new String[]{taskActivity.getId()}).singleResult();
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testParallelSubProcessAllAutomatic() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelSubprocessAllAutomatics", CollectionUtil.singletonMap((String)"nrOfLoops", (Object)5)).getId();
        Execution waitState = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        MultiInstanceTest.assertEquals((Object)10, (Object)this.runtimeService.getVariable(waitState.getId(), "sum"));
        this.runtimeService.signal(waitState.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelSubProcessAllAutomatic.bpmn20.xml"})
    public void testParallelSubProcessAllAutomaticCompletionCondition() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelSubprocessAllAutomatics", CollectionUtil.singletonMap((String)"nrOfLoops", (Object)10)).getId();
        Execution waitState = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        MultiInstanceTest.assertEquals((Object)12, (Object)this.runtimeService.getVariable(waitState.getId(), "sum"));
        this.runtimeService.signal(waitState.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testNestedParallelSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedParallelSubProcess").getId();
        List tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)8, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testNestedParallelSubProcessWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedParallelSubProcess").getId();
        List tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)12, (int)tasks.size());
        for (int i = 0; i < 3; ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        MultiInstanceTest.assertEquals((String)"taskAfterTimer", (String)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testSequentialCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    public void testSequentialCallActivity() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialCallActivity").getId();
        for (int i = 0; i < 3; ++i) {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
            MultiInstanceTest.assertEquals((int)2, (int)tasks.size());
            MultiInstanceTest.assertEquals((String)"task one", (String)((Task)tasks.get(0)).getName());
            MultiInstanceTest.assertEquals((String)"task two", (String)((Task)tasks.get(1)).getName());
            this.taskService.complete(((Task)tasks.get(0)).getId());
            this.taskService.complete(((Task)tasks.get(1)).getId());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testSequentialCallActivityWithList.bpmn20.xml"})
    public void testSequentialCallActivityWithList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        HashMap<String, ArrayList<String>> variables = new HashMap<String, ArrayList<String>>();
        variables.put("list", list);
        String procId = this.runtimeService.startProcessInstanceByKey("parentProcess", variables).getId();
        Task task1 = (Task)this.taskService.createTaskQuery().processVariableValueEquals("element", (Object)"one").singleResult();
        Task task2 = (Task)this.taskService.createTaskQuery().processVariableValueEquals("element", (Object)"two").singleResult();
        MultiInstanceTest.assertNotNull((Object)task1);
        MultiInstanceTest.assertNotNull((Object)task2);
        HashMap<String, String> subVariables = new HashMap<String, String>();
        subVariables.put("x", "y");
        this.taskService.complete(task1.getId(), subVariables);
        this.taskService.complete(task2.getId(), subVariables);
        Task task3 = (Task)this.taskService.createTaskQuery().processDefinitionKey("midProcess").singleResult();
        MultiInstanceTest.assertNotNull((Object)task3);
        this.taskService.complete(task3.getId());
        Task task4 = (Task)this.taskService.createTaskQuery().processDefinitionKey("parentProcess").singleResult();
        MultiInstanceTest.assertNotNull((Object)task4);
        this.taskService.complete(task4.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testSequentialCallActivityWithTimer.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    public void testSequentialCallActivityWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miSequentialCallActivityWithTimer").getId();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        MultiInstanceTest.assertEquals((int)2, (int)tasks.size());
        MultiInstanceTest.assertEquals((String)"task one", (String)((Task)tasks.get(0)).getName());
        MultiInstanceTest.assertEquals((String)"task two", (String)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        MultiInstanceTest.assertEquals((String)"taskAfterTimer", (String)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    public void testParallelCallActivity() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelCallActivity").getId();
        List tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)12, (int)tasks.size());
        for (int i = 0; i < tasks.size(); ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    public void testParallelCallActivityHistory() {
        this.runtimeService.startProcessInstanceByKey("miParallelCallActivity");
        List tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)12, (int)tasks.size());
        for (int i = 0; i < tasks.size(); ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
            MultiInstanceTest.assertEquals((int)7, (int)historicProcessInstances.size());
            for (HistoricProcessInstance hpi : historicProcessInstances) {
                MultiInstanceTest.assertNotNull((Object)hpi.getStartTime());
                MultiInstanceTest.assertNotNull((Object)hpi.getEndTime());
            }
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityType("callActivity").list();
            MultiInstanceTest.assertEquals((int)6, (int)historicActivityInstances.size());
            for (HistoricActivityInstance hai : historicActivityInstances) {
                MultiInstanceTest.assertNotNull((Object)hai.getStartTime());
                MultiInstanceTest.assertNotNull((Object)hai.getEndTime());
            }
        }
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            List historicTaskInstances = this.historyService.createHistoricTaskInstanceQuery().list();
            MultiInstanceTest.assertEquals((int)12, (int)historicTaskInstances.size());
            for (HistoricTaskInstance hti : historicTaskInstances) {
                MultiInstanceTest.assertNotNull((Object)hti.getStartTime());
                MultiInstanceTest.assertNotNull((Object)hti.getEndTime());
                MultiInstanceTest.assertNotNull((Object)hti.getAssignee());
                MultiInstanceTest.assertEquals((String)"completed", (String)hti.getDeleteReason());
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelCallActivityWithTimer.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    public void testParallelCallActivityWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miParallelCallActivity").getId();
        List tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)6, (int)tasks.size());
        for (int i = 0; i < 2; ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        MultiInstanceTest.assertEquals((String)"taskAfterTimer", (String)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testNestedSequentialCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    public void testNestedSequentialCallActivity() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedSequentialCallActivity").getId();
        for (int i = 0; i < 4; ++i) {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
            MultiInstanceTest.assertEquals((int)2, (int)tasks.size());
            MultiInstanceTest.assertEquals((String)"task one", (String)((Task)tasks.get(0)).getName());
            MultiInstanceTest.assertEquals((String)"task two", (String)((Task)tasks.get(1)).getName());
            this.taskService.complete(((Task)tasks.get(0)).getId());
            this.taskService.complete(((Task)tasks.get(1)).getId());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testNestedSequentialCallActivityWithTimer.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    public void testNestedSequentialCallActivityWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedSequentialCallActivityWithTimer").getId();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        MultiInstanceTest.assertEquals((int)2, (int)tasks.size());
        MultiInstanceTest.assertEquals((String)"task one", (String)((Task)tasks.get(0)).getName());
        MultiInstanceTest.assertEquals((String)"task two", (String)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)2, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        MultiInstanceTest.assertEquals((String)"taskAfterTimer", (String)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testNestedParallelCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    public void testNestedParallelCallActivity() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedParallelCallActivity").getId();
        List tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)14, (int)tasks.size());
        for (int i = 0; i < 14; ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testNestedParallelCallActivityWithTimer.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    public void testNestedParallelCallActivityWithTimer() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedParallelCallActivityWithTimer").getId();
        List tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)4, (int)tasks.size());
        for (int i = 0; i < 3; ++i) {
            this.taskService.complete(((Task)tasks.get(i)).getId());
        }
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().singleResult();
        MultiInstanceTest.assertEquals((String)"taskAfterTimer", (String)taskAfterTimer.getTaskDefinitionKey());
        this.taskService.complete(taskAfterTimer.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testNestedParallelCallActivityCompletionCondition.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.externalSubProcess.bpmn20.xml"})
    public void testNestedParallelCallActivityCompletionCondition() {
        String procId = this.runtimeService.startProcessInstanceByKey("miNestedParallelCallActivityCompletionCondition").getId();
        MultiInstanceTest.assertEquals((long)8L, (long)this.taskService.createTaskQuery().count());
        for (int i = 0; i < 2; ++i) {
            ProcessInstance nextSubProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("externalSubProcess").listPage(0, 1).get(0);
            List tasks = this.taskService.createTaskQuery().processInstanceId(nextSubProcessInstance.getId()).list();
            MultiInstanceTest.assertEquals((int)2, (int)tasks.size());
            for (Task task : tasks) {
                this.taskService.complete(task.getId());
            }
        }
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testSequentialServiceTaskWithClass() {
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("multiInstanceServiceTask", CollectionUtil.singletonMap((String)"result", (Object)5));
        Integer result = (Integer)this.runtimeService.getVariable(procInst.getId(), "result");
        MultiInstanceTest.assertEquals((int)160, (int)result);
        this.runtimeService.signal(procInst.getId());
        this.assertProcessEnded(procInst.getId());
    }

    @Deployment
    public void testSequentialServiceTaskWithClassAndCollection() {
        List<Integer> items = Arrays.asList(1, 2, 3, 4, 5, 6);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("result", 1);
        vars.put("items", items);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("multiInstanceServiceTask", vars);
        Integer result = (Integer)this.runtimeService.getVariable(procInst.getId(), "result");
        MultiInstanceTest.assertEquals((int)720, (int)result);
        this.runtimeService.signal(procInst.getId());
        this.assertProcessEnded(procInst.getId());
    }

    @Deployment
    public void testAct901() {
        Date startTime = ClockUtil.getCurrentTime();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("multiInstanceSubProcess");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc()).list();
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 61000L));
        List timers = this.managementService.createJobQuery().list();
        MultiInstanceTest.assertEquals((int)5, (int)timers.size());
        for (Job timer : timers) {
            this.managementService.executeJob(timer.getId());
        }
        tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc()).list();
        MultiInstanceTest.assertEquals((int)0, (int)tasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.callActivityWithBoundaryErrorEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.throwingErrorEventSubProcess.bpmn20.xml"})
    public void testMultiInstanceCallActivityWithErrorBoundaryEvent() {
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        variableMap.put("assignees", Arrays.asList("kermit", "gonzo"));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variableMap);
        List tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)2, (int)tasks.size());
        variableMap = new HashMap();
        variableMap.put("done", false);
        this.taskService.complete(((Task)tasks.get(0)).getId(), variableMap);
        tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)1, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        List processInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").list();
        MultiInstanceTest.assertEquals((int)0, (int)processInstances.size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.callActivityWithBoundaryErrorEventSequential.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.throwingErrorEventSubProcess.bpmn20.xml"})
    public void testSequentialMultiInstanceCallActivityWithErrorBoundaryEvent() {
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        variableMap.put("assignees", Arrays.asList("kermit", "gonzo"));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", variableMap);
        List tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)1, (int)tasks.size());
        variableMap = new HashMap();
        variableMap.put("done", false);
        this.taskService.complete(((Task)tasks.get(0)).getId(), variableMap);
        tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)1, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        List processInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").list();
        MultiInstanceTest.assertEquals((int)0, (int)processInstances.size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testNestedMultiInstanceTasks.bpmn20.xml"})
    public void testNestedMultiInstanceTasks() {
        List<String> processes = Arrays.asList("process A", "process B");
        List<String> assignees = Arrays.asList("kermit", "gonzo");
        HashMap<String, List<String>> variableMap = new HashMap<String, List<String>>();
        variableMap.put("subProcesses", processes);
        variableMap.put("assignees", assignees);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miNestedMultiInstanceTasks", variableMap);
        List tasks = this.taskService.createTaskQuery().list();
        MultiInstanceTest.assertEquals((int)(processes.size() * assignees.size()), (int)tasks.size());
        for (Task t : tasks) {
            this.taskService.complete(t.getId());
        }
        List processInstances = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("miNestedMultiInstanceTasks").list();
        MultiInstanceTest.assertEquals((int)0, (int)processInstances.size());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testParallelUserTasks.bpmn20.xml"})
    public void testActiveExecutionsInParallelTasks() {
        this.runtimeService.startProcessInstanceByKey("miParallelUserTasks").getId();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        List executions = this.runtimeService.createExecutionQuery().list();
        MultiInstanceTest.assertEquals((int)5, (int)executions.size());
        for (Execution execution : executions) {
            ExecutionEntity entity = (ExecutionEntity)execution;
            if (!entity.getId().equals(instance.getId()) && !entity.getParentId().equals(instance.getId())) {
                MultiInstanceTest.assertTrue((boolean)entity.isActive());
                continue;
            }
            MultiInstanceTest.assertFalse((boolean)entity.isActive());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchExceptionThrownByExecuteOfSequentialAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwException()).getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchErrorThrownByExecuteOfSequentialAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwError()).getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchExceptionThrownBySignalOfSequentialAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        MultiInstanceTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchErrorThrownBySignalOfSequentialAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        MultiInstanceTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchExceptionThrownByExecuteOfParallelAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwException()).getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchErrorThrownByExecuteOfParallelAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", ThrowErrorDelegate.throwError()).getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchExceptionThrownBySignalOfParallelAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").list().get(3);
        MultiInstanceTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelAbstractBpmnActivityBehavior.bpmn20.xml"})
    public void testCatchErrorThrownBySignalOfParallelAbstractBpmnActivityBehavior() {
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess").getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").list().get(3);
        MultiInstanceTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialDelegateExpression.bpmn20.xml"})
    public void testCatchExceptionThrownByExecuteOfSequentialDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwException());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialDelegateExpression.bpmn20.xml"})
    public void testCatchErrorThrownByExecuteOfSequentialDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwError());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialDelegateExpression.bpmn20.xml"})
    public void testCatchExceptionThrownBySignalOfSequentialDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        MultiInstanceTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownBySequentialDelegateExpression.bpmn20.xml"})
    public void testCatchErrorThrownBySignalOfSequentialDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.leaveExecution());
        this.runtimeService.signal(((Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult()).getId());
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").singleResult();
        MultiInstanceTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelDelegateExpression.bpmn20.xml"})
    public void testCatchExceptionThrownByExecuteOfParallelDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwException());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelDelegateExpression.bpmn20.xml"})
    public void testCatchErrorThrownByExecuteOfParallelDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        variables.putAll(ThrowErrorDelegate.throwError());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelDelegateExpression.bpmn20.xml"})
    public void testCatchExceptionThrownBySignalOfParallelDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").list().get(3);
        MultiInstanceTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwException());
        this.runtimeService.signal(serviceTask.getId());
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskException", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/multiinstance/MultiInstanceTest.testCatchErrorThrownByParallelDelegateExpression.bpmn20.xml"})
    public void testCatchErrorThrownBySignalOfParallelDelegateExpression() {
        VariableMap variables = Variables.createVariables().putValue("myDelegate", (Object)new ThrowErrorDelegate());
        String pi = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables).getId();
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertNull((Object)this.runtimeService.getVariable(pi, "signaled"));
        Execution serviceTask = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi).activityId("serviceTask").list().get(3);
        MultiInstanceTest.assertNotNull((Object)serviceTask);
        this.runtimeService.setVariables(pi, ThrowErrorDelegate.throwError());
        this.runtimeService.signal(serviceTask.getId());
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "executed")));
        MultiInstanceTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi, "signaled")));
        Task userTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi).singleResult();
        MultiInstanceTest.assertNotNull((Object)userTask);
        MultiInstanceTest.assertEquals((String)"userTaskError", (String)userTask.getTaskDefinitionKey());
        this.taskService.complete(userTask.getId());
    }
}

