/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.servicetask;

import java.util.Collection;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.bpmn.servicetask.ModelExecutionContextServiceTask;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.Event;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.bpmn.instance.Task;
import org.camunda.bpm.model.xml.Model;

public class ServiceTaskBpmnModelExecutionContextTest
extends PluggableProcessEngineTestCase {
    private static final String PROCESS_ID = "process";
    private String deploymentId;

    public void testJavaDelegateModelExecutionContext() {
        this.deploy();
        this.runtimeService.startProcessInstanceByKey(PROCESS_ID);
        BpmnModelInstance modelInstance = ModelExecutionContextServiceTask.modelInstance;
        ServiceTaskBpmnModelExecutionContextTest.assertNotNull((Object)modelInstance);
        Model model = modelInstance.getModel();
        Collection events = modelInstance.getModelElementsByType(model.getType(Event.class));
        ServiceTaskBpmnModelExecutionContextTest.assertEquals((int)2, (int)events.size());
        Collection tasks = modelInstance.getModelElementsByType(model.getType(Task.class));
        ServiceTaskBpmnModelExecutionContextTest.assertEquals((int)1, (int)tasks.size());
        Process process = (Process)modelInstance.getDefinitions().getRootElements().iterator().next();
        ServiceTaskBpmnModelExecutionContextTest.assertEquals((String)PROCESS_ID, (String)process.getId());
        ServiceTaskBpmnModelExecutionContextTest.assertTrue((boolean)process.isExecutable());
        ServiceTask serviceTask = ModelExecutionContextServiceTask.serviceTask;
        ServiceTaskBpmnModelExecutionContextTest.assertNotNull((Object)serviceTask);
        ServiceTaskBpmnModelExecutionContextTest.assertEquals((String)ModelExecutionContextServiceTask.class.getName(), (String)serviceTask.getCamundaClass());
    }

    private void deploy() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask().camundaClass(ModelExecutionContextServiceTask.class.getName())).endEvent().done();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy().getId();
    }

    public void tearDown() {
        ModelExecutionContextServiceTask.clear();
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }
}

