/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cache;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.test.PvmTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;

public class ProcessDefinitionCacheTest
extends PvmTestCase {
    public void testStartProcessInstanceByIdAfterReboot() {
        ProcessEngines.destroy();
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        processEngineConfiguration.setProcessEngineName("reboot-test-schema");
        processEngineConfiguration.setJdbcUrl("jdbc:h2:mem:activiti-reboot-test;DB_CLOSE_DELAY=1000");
        ProcessEngine schemaProcessEngine = processEngineConfiguration.buildProcessEngine();
        ProcessEngine processEngine = new StandaloneProcessEngineConfiguration().setProcessEngineName("reboot-test").setDatabaseSchemaUpdate("false").setJdbcUrl("jdbc:h2:mem:activiti-reboot-test;DB_CLOSE_DELAY=1000").setJobExecutorActivate(false).buildProcessEngine();
        processEngine.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/cache/originalProcess.bpmn20.xml").deploy();
        List processDefinitions = processEngine.getRepositoryService().createProcessDefinitionQuery().list();
        ProcessDefinitionCacheTest.assertEquals((int)1, (int)processDefinitions.size());
        ProcessInstance processInstance = processEngine.getRuntimeService().startProcessInstanceById(((ProcessDefinition)processDefinitions.get(0)).getId());
        String processInstanceId = processInstance.getId();
        ProcessDefinitionCacheTest.assertNotNull((Object)processInstance);
        processEngine.close();
        ProcessDefinitionCacheTest.assertNotNull((Object)processEngine.getRuntimeService());
        processEngine = new StandaloneProcessEngineConfiguration().setProcessEngineName("reboot-test").setDatabaseSchemaUpdate("false").setJdbcUrl("jdbc:h2:mem:activiti-reboot-test;DB_CLOSE_DELAY=1000").setJobExecutorActivate(false).buildProcessEngine();
        processInstance = (ProcessInstance)processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ProcessDefinitionCacheTest.assertNotNull((Object)processInstance);
        TaskService taskService = processEngine.getTaskService();
        Task task = (Task)taskService.createTaskQuery().list().get(0);
        taskService.complete(task.getId());
        processInstance = (ProcessInstance)processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ProcessDefinitionCacheTest.assertNull((Object)processInstance);
        processInstance = processEngine.getRuntimeService().startProcessInstanceById(((ProcessDefinition)processDefinitions.get(0)).getId());
        ProcessDefinitionCacheTest.assertNotNull((Object)processInstance);
        processEngine.close();
        schemaProcessEngine.close();
    }

    public void testDeployRevisedProcessAfterDeleteOnOtherProcessEngine() {
        ProcessEngine processEngine1 = new StandaloneProcessEngineConfiguration().setProcessEngineName("reboot-test-schema").setDatabaseSchemaUpdate("true").setJdbcUrl("jdbc:h2:mem:activiti-process-cache-test;DB_CLOSE_DELAY=1000").setJobExecutorActivate(false).buildProcessEngine();
        RepositoryService repositoryService1 = processEngine1.getRepositoryService();
        ProcessEngine processEngine2 = new StandaloneProcessEngineConfiguration().setProcessEngineName("reboot-test").setDatabaseSchemaUpdate("false").setJdbcUrl("jdbc:h2:mem:activiti-process-cache-test;DB_CLOSE_DELAY=1000").setJobExecutorActivate(false).buildProcessEngine();
        RepositoryService repositoryService2 = processEngine2.getRepositoryService();
        RuntimeService runtimeService2 = processEngine2.getRuntimeService();
        TaskService taskService2 = processEngine2.getTaskService();
        String deploymentId = repositoryService1.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/cache/originalProcess.bpmn20.xml").deploy().getId();
        String processDefinitionId = ((ProcessDefinition)repositoryService2.createProcessDefinitionQuery().singleResult()).getId();
        runtimeService2.startProcessInstanceById(processDefinitionId);
        Task task = (Task)taskService2.createTaskQuery().singleResult();
        ProcessDefinitionCacheTest.assertEquals((String)"original task", (String)task.getName());
        repositoryService2.deleteDeployment(deploymentId, true);
        ProcessDefinitionCacheTest.assertEquals((long)0L, (long)repositoryService2.createDeploymentQuery().count());
        ProcessDefinitionCacheTest.assertEquals((long)0L, (long)runtimeService2.createProcessInstanceQuery().count());
        deploymentId = repositoryService1.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/cache/revisedProcess.bpmn20.xml").deploy().getId();
        processDefinitionId = ((ProcessDefinition)repositoryService2.createProcessDefinitionQuery().singleResult()).getId();
        runtimeService2.startProcessInstanceByKey("oneTaskProcess");
        task = (Task)taskService2.createTaskQuery().singleResult();
        ProcessDefinitionCacheTest.assertEquals((String)"revised task", (String)task.getName());
        repositoryService1.deleteDeployment(deploymentId, true);
        processEngine1.close();
        processEngine2.close();
    }
}

