/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.sentry;

import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseSentryPartQueryImpl;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnSentryPart;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.test.Deployment;

public class SentryEntryCriteriaTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testSequenceEnableTask.cmmn"})
    public void testSequenceEnableTask() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        this.manualStart(firstHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        SentryEntryCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "enable"));
        this.complete(firstHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        Object enableVariable = this.caseService.getVariable(caseInstanceId, "enable");
        SentryEntryCriteriaTest.assertNotNull((Object)enableVariable);
        SentryEntryCriteriaTest.assertTrue((boolean)((Boolean)enableVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testSequenceAutoStartTask.cmmn"})
    public void testSequenceAutoStartTask() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        this.manualStart(firstHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        SentryEntryCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "enable"));
        SentryEntryCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "start"));
        this.complete(firstHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isActive());
        SentryEntryCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "enable"));
        Object startVariable = this.caseService.getVariable(caseInstanceId, "start");
        SentryEntryCriteriaTest.assertNotNull((Object)startVariable);
        SentryEntryCriteriaTest.assertTrue((boolean)((Boolean)startVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testSequenceEnableStage.cmmn"})
    public void testSequenceEnableStage() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        String stageId = stage.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)stage.isAvailable());
        this.manualStart(firstHumanTaskId);
        stage = this.queryCaseExecutionById(stageId);
        SentryEntryCriteriaTest.assertTrue((boolean)stage.isAvailable());
        SentryEntryCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "enable"));
        this.complete(firstHumanTaskId);
        stage = this.queryCaseExecutionById(stageId);
        SentryEntryCriteriaTest.assertTrue((boolean)stage.isEnabled());
        Object enableVariable = this.caseService.getVariable(caseInstanceId, "enable");
        SentryEntryCriteriaTest.assertNotNull((Object)enableVariable);
        SentryEntryCriteriaTest.assertTrue((boolean)((Boolean)enableVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testSequenceAutoStartStage.cmmn"})
    public void testSequenceAutoStartStage() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        String stageId = stage.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)stage.isAvailable());
        this.manualStart(firstHumanTaskId);
        stage = this.queryCaseExecutionById(stageId);
        SentryEntryCriteriaTest.assertTrue((boolean)stage.isAvailable());
        SentryEntryCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "enable"));
        SentryEntryCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "start"));
        this.complete(firstHumanTaskId);
        stage = this.queryCaseExecutionById(stageId);
        SentryEntryCriteriaTest.assertTrue((boolean)stage.isActive());
        SentryEntryCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "enable"));
        Object startVariable = this.caseService.getVariable(caseInstanceId, "start");
        SentryEntryCriteriaTest.assertNotNull((Object)startVariable);
        SentryEntryCriteriaTest.assertTrue((boolean)((Boolean)startVariable));
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().enabled();
        SentryEntryCriteriaTest.assertEquals((long)2L, (long)query.count());
        for (CaseExecution child : query.list()) {
            SentryEntryCriteriaTest.assertEquals((String)stageId, (String)child.getParentId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testSequenceOccurMilestone.cmmn"})
    public void testSequenceOccurMilestone() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution milestone = this.queryCaseExecutionByActivityId("PI_Milestone_1");
        String milestoneId = milestone.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)milestone.isAvailable());
        this.manualStart(firstHumanTaskId);
        milestone = this.queryCaseExecutionById(milestoneId);
        SentryEntryCriteriaTest.assertTrue((boolean)milestone.isAvailable());
        SentryEntryCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "occur"));
        this.complete(firstHumanTaskId);
        milestone = this.queryCaseExecutionById(milestoneId);
        SentryEntryCriteriaTest.assertNull((Object)milestone);
        Object occurVariable = this.caseService.getVariable(caseInstanceId, "occur");
        SentryEntryCriteriaTest.assertNotNull((Object)occurVariable);
        SentryEntryCriteriaTest.assertTrue((boolean)((Boolean)occurVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testSequence.cmmn"})
    public void testSequence() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isAvailable());
        this.manualStart(firstHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isAvailable());
        SentryEntryCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "enable"));
        this.complete(firstHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isAvailable());
        Object enableVariable = this.caseService.getVariable(caseInstanceId, "enable");
        SentryEntryCriteriaTest.assertNotNull((Object)enableVariable);
        SentryEntryCriteriaTest.assertTrue((boolean)((Boolean)enableVariable));
        this.caseService.withCaseExecution(caseInstanceId).removeVariable("enable").execute();
        this.manualStart(secondHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isAvailable());
        SentryEntryCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "enable"));
        this.complete(secondHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
        enableVariable = this.caseService.getVariable(caseInstanceId, "enable");
        SentryEntryCriteriaTest.assertNotNull((Object)enableVariable);
        SentryEntryCriteriaTest.assertTrue((boolean)((Boolean)enableVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testSequenceWithIfPart.cmmn"})
    public void testSequenceWithIfPartNotSatisfied() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        this.manualStart(firstHumanTaskId);
        this.caseService.withCaseExecution(firstHumanTaskId).setVariable("value", (Object)99).complete();
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryEntryCriteriaTest.assertNull((Object)firstHumanTask);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testSequenceWithIfPart.cmmn"})
    public void testSequenceWithIfPartSatisfied() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        this.manualStart(firstHumanTaskId);
        this.caseService.withCaseExecution(firstHumanTaskId).setVariable("value", (Object)100).complete();
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryEntryCriteriaTest.assertNull((Object)firstHumanTask);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testAndFork.cmmn"})
    public void testAndFork() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isAvailable());
        CaseSentryPartQueryImpl query = this.createCaseSentryPartQuery();
        CmmnSentryPart part = (CmmnSentryPart)query.singleResult();
        SentryEntryCriteriaTest.assertFalse((boolean)part.isSatisfied());
        this.manualStart(firstHumanTaskId);
        this.complete(firstHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
        part = (CmmnSentryPart)query.satisfied().singleResult();
        SentryEntryCriteriaTest.assertNotNull((Object)part);
        SentryEntryCriteriaTest.assertTrue((boolean)part.isSatisfied());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testAndJoin.cmmn"})
    public void testAndJoin() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isAvailable());
        this.manualStart(firstHumanTaskId);
        this.complete(firstHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isAvailable());
        SentryEntryCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "enable"));
        this.manualStart(secondHumanTaskId);
        this.complete(secondHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
        Object enableVariable = this.caseService.getVariable(caseInstanceId, "enable");
        SentryEntryCriteriaTest.assertNotNull((Object)enableVariable);
        SentryEntryCriteriaTest.assertTrue((boolean)((Boolean)enableVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testSequenceCombinedWithAndJoin.cmmn"})
    public void testSequenceCombinedWithAndJoin() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isAvailable());
        this.manualStart(firstHumanTaskId);
        this.complete(firstHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isAvailable());
        this.manualStart(secondHumanTaskId);
        this.complete(secondHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testOrFork.cmmn"})
    public void testOrFork() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isAvailable());
        this.manualStart(firstHumanTaskId);
        this.caseService.withCaseExecution(firstHumanTaskId).setVariable("value", (Object)80).complete();
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testOrJoin.cmmn"})
    public void testOrJoin() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isAvailable());
        this.manualStart(firstHumanTaskId);
        this.complete(firstHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
        Object enableVariable = this.caseService.getVariable(caseInstanceId, "enable");
        SentryEntryCriteriaTest.assertNotNull((Object)enableVariable);
        SentryEntryCriteriaTest.assertTrue((boolean)((Boolean)enableVariable));
        this.manualStart(secondHumanTaskId);
        this.complete(secondHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testCycle.cmmn"})
    public void testCycle() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isAvailable());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)thirdHumanTask.isAvailable());
        try {
            this.manualStart(firstHumanTaskId);
            SentryEntryCriteriaTest.fail((String)"It should not be possible to start the first human task manually.");
        }
        catch (NotAllowedException e) {
            // empty catch block
        }
        try {
            this.manualStart(secondHumanTaskId);
            SentryEntryCriteriaTest.fail((String)"It should not be possible to start the second human task manually.");
        }
        catch (NotAllowedException e) {
            // empty catch block
        }
        try {
            this.manualStart(thirdHumanTaskId);
            SentryEntryCriteriaTest.fail((String)"It should not be possible to third the second human task manually.");
        }
        catch (NotAllowedException e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testEnableByInstanceCreation.cmmn"})
    public void testEnableByInstanceCreation() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testEnableOnParentSuspendInsideStage.cmmn"})
    public void FAILING_testEnableOnParentSuspendInsideStage() {
        this.createCaseInstance();
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        String stageId = stage.getId();
        this.manualStart(stageId);
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        this.suspend(stageId);
        stage = this.queryCaseExecutionById(stageId);
        SentryEntryCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)stage).isSuspended());
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)firstHumanTask).isSuspended());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)secondHumanTask).isSuspended());
        SentryEntryCriteriaTest.assertEquals((Object)CaseExecutionState.ENABLED, (Object)((CaseExecutionEntity)secondHumanTask).getPreviousState());
        this.resume(stageId);
        stage = this.queryCaseExecutionById(stageId);
        SentryEntryCriteriaTest.assertTrue((boolean)stage.isActive());
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testEnableOnParentResumeInsideStage.cmmn"})
    public void FAILING_testEnableOnParentResumeInsideStage() {
        this.createCaseInstance();
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        String stageId = stage.getId();
        this.manualStart(stageId);
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        this.suspend(stageId);
        stage = this.queryCaseExecutionById(stageId);
        SentryEntryCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)stage).isSuspended());
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)firstHumanTask).isSuspended());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)secondHumanTask).isSuspended());
        SentryEntryCriteriaTest.assertEquals((Object)CaseExecutionState.AVAILABLE, (Object)((CaseExecutionEntity)secondHumanTask).getPreviousState());
        this.resume(stageId);
        stage = this.queryCaseExecutionById(stageId);
        SentryEntryCriteriaTest.assertTrue((boolean)stage.isActive());
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testResume.cmmn"})
    public void testResume() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution milestone = this.queryCaseExecutionByActivityId("PI_Milestone_1");
        String milestoneId = milestone.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)milestone.isAvailable());
        this.suspend(milestoneId);
        this.manualStart(firstHumanTaskId);
        this.complete(firstHumanTaskId);
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryEntryCriteriaTest.assertNull((Object)firstHumanTask);
        milestone = this.queryCaseExecutionById(milestoneId);
        SentryEntryCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)milestone).isSuspended());
        this.resume(milestoneId);
        milestone = this.queryCaseExecutionById(milestoneId);
        SentryEntryCriteriaTest.assertNull((Object)milestone);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryEntryCriteriaTest.testFireAlsoNotAffectedSentries.cmmn"})
    public void testFireAlsoNotAffectedSentries() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        CaseExecution milestone = this.queryCaseExecutionByActivityId("PI_Milestone_1");
        String milestoneId = milestone.getId();
        SentryEntryCriteriaTest.assertTrue((boolean)milestone.isAvailable());
        this.suspend(milestoneId);
        this.caseService.withCaseExecution(caseInstanceId).setVariable("value", (Object)99).execute();
        this.manualStart(firstHumanTaskId);
        this.complete(firstHumanTaskId);
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryEntryCriteriaTest.assertNull((Object)firstHumanTask);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        milestone = this.queryCaseExecutionById(milestoneId);
        SentryEntryCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)milestone).isSuspended());
        this.caseService.withCaseExecution(caseInstanceId).setVariable("value", (Object)101).execute();
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        milestone = this.queryCaseExecutionById(milestoneId);
        SentryEntryCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)milestone).isSuspended());
        this.resume(milestoneId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryEntryCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        milestone = this.queryCaseExecutionById(milestoneId);
        SentryEntryCriteriaTest.assertNull((Object)milestone);
    }
}

