/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import junit.framework.TestCase;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public abstract class ConcurrencyTestCase
extends PluggableProcessEngineTestCase {
    protected ThreadControl executeControllableCommand(final ControllableCommand<?> command) {
        Thread thread;
        final Thread controlThread = Thread.currentThread();
        command.monitor.executingThread = thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ConcurrencyTestCase.this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)command);
                }
                catch (RuntimeException e) {
                    controlThread.interrupt();
                    throw e;
                }
            }
        });
        thread.start();
        return command.monitor;
    }

    static class ThreadControl {
        protected boolean syncAvailable = false;
        protected Thread executingThread;

        ThreadControl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForSync() {
            ThreadControl threadControl = this;
            synchronized (threadControl) {
                if (Thread.interrupted()) {
                    TestCase.fail();
                }
                if (!this.syncAvailable) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        TestCase.fail();
                    }
                }
                this.syncAvailable = false;
            }
        }

        public void waitUntilDone() {
            this.makeContinue();
            try {
                this.executingThread.join();
            }
            catch (InterruptedException e) {
                TestCase.fail();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sync() {
            ThreadControl threadControl = this;
            synchronized (threadControl) {
                this.syncAvailable = true;
                try {
                    this.notifyAll();
                    this.wait();
                }
                catch (InterruptedException e) {
                    TestCase.fail();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void makeContinue() {
            ThreadControl threadControl = this;
            synchronized (threadControl) {
                if (Thread.interrupted()) {
                    TestCase.fail();
                }
                this.notifyAll();
            }
        }
    }

    static abstract class ControllableCommand<T>
    implements Command<T> {
        protected final ThreadControl monitor = new ThreadControl();
    }
}

