/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.el;

import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.el.CommandContextFunctionMapper;
import org.camunda.bpm.engine.impl.el.DateTimeFunctionMapper;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.javax.el.FunctionMapper;
import org.camunda.bpm.engine.test.el.CustomExpressionManager;
import org.junit.Assert;
import org.junit.Test;

public class CustomExpressionManagerTest {
    @Test
    public void testBuiltinFunctionMapperRegistration() {
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration();
        CustomExpressionManager customExpressionManager = new CustomExpressionManager();
        Assert.assertTrue((boolean)customExpressionManager.getFunctionMappers().isEmpty());
        config.setExpressionManager((ExpressionManager)customExpressionManager);
        config.buildProcessEngine();
        Assert.assertSame((Object)((Object)customExpressionManager), (Object)config.getExpressionManager());
        Assert.assertEquals((long)2L, (long)customExpressionManager.getFunctionMappers().size());
        boolean commandContextMapperFound = false;
        boolean dateTimeMapperFound = false;
        for (FunctionMapper functionMapper : customExpressionManager.getFunctionMappers()) {
            if (functionMapper instanceof CommandContextFunctionMapper) {
                commandContextMapperFound = true;
            }
            if (!(functionMapper instanceof DateTimeFunctionMapper)) continue;
            dateTimeMapperFound = true;
        }
        Assert.assertTrue((commandContextMapperFound && dateTimeMapperFound ? 1 : 0) != 0);
    }
}

