/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.bpmn.gateway;

import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;

public class ParallelGatewayTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testForkJoin() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("forkJoin");
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc();
        List tasks = query.list();
        ParallelGatewayTest.assertEquals((int)2, (int)tasks.size());
        Task task1 = (Task)tasks.get(0);
        ParallelGatewayTest.assertEquals((String)"Receive Payment", (String)task1.getName());
        Task task2 = (Task)tasks.get(1);
        ParallelGatewayTest.assertEquals((String)"Ship Order", (String)task2.getName());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = query.list();
        ParallelGatewayTest.assertEquals((int)1, (int)tasks.size());
        ParallelGatewayTest.assertEquals((String)"Archive Order", (String)((Task)tasks.get(0)).getName());
    }

    @Deployment
    public void testUnbalancedForkJoin() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("UnbalancedForkJoin");
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc();
        List tasks = query.list();
        ParallelGatewayTest.assertEquals((int)3, (int)tasks.size());
        Task task1 = (Task)tasks.get(0);
        ParallelGatewayTest.assertEquals((String)"Task 1", (String)task1.getName());
        Task task2 = (Task)tasks.get(1);
        ParallelGatewayTest.assertEquals((String)"Task 2", (String)task2.getName());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        tasks = query.list();
        Task task3 = (Task)tasks.get(0);
        ParallelGatewayTest.assertEquals((int)2, (int)tasks.size());
        ParallelGatewayTest.assertEquals((String)"Task 3", (String)task3.getName());
        Task task4 = (Task)tasks.get(1);
        ParallelGatewayTest.assertEquals((String)"Task 4", (String)task4.getName());
        this.taskService.complete(task3.getId());
        this.taskService.complete(task4.getId());
        this.assertProcessEnded(pi.getId());
    }
}

