/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class OperationLogQueryTest
extends PluggableProcessEngineTestCase {
    private ProcessInstance process;
    private Task userTask;
    private Execution execution;
    private String processTaskId;
    private Date today = new Date(ClockUtil.getCurrentTime().getTime() / 1000L * 1000L);
    private Date tomorrow = new Date((ClockUtil.getCurrentTime().getTime() + 86400000L) / 1000L * 1000L);
    private Date yesterday = new Date((ClockUtil.getCurrentTime().getTime() - 86400000L) / 1000L * 1000L);

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQuery() {
        int i;
        int i2;
        this.createLogEntries();
        OperationLogQueryTest.assertEquals((long)17L, (long)this.query().count());
        OperationLogQueryTest.assertEquals((long)11L, (long)this.query().entityType("Task").count());
        OperationLogQueryTest.assertEquals((long)4L, (long)this.query().entityType("IdentityLink").count());
        OperationLogQueryTest.assertEquals((long)2L, (long)this.query().entityType("Attachment").count());
        OperationLogQueryTest.assertEquals((long)0L, (long)this.query().entityType("unknown entity type").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("Create").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("SetPriority").count());
        OperationLogQueryTest.assertEquals((long)4L, (long)this.query().operationType("Update").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("AddUserLink").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("DeleteUserLink").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("AddGroupLink").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("DeleteGroupLink").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("AddAttachment").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("DeleteAttachment").count());
        OperationLogQueryTest.assertEquals((long)11L, (long)this.query().processDefinitionId(this.process.getProcessDefinitionId()).count());
        OperationLogQueryTest.assertEquals((long)11L, (long)this.query().processInstanceId(this.process.getId()).count());
        OperationLogQueryTest.assertEquals((long)11L, (long)this.query().executionId(this.execution.getId()).count());
        OperationLogQueryTest.assertEquals((long)11L, (long)this.query().taskId(this.processTaskId).count());
        OperationLogQueryTest.assertEquals((long)6L, (long)this.query().taskId(this.userTask.getId()).count());
        OperationLogQueryTest.assertEquals((long)11L, (long)this.query().userId("icke").count());
        OperationLogQueryTest.assertEquals((long)6L, (long)this.query().userId("er").count());
        UserOperationLogQuery updates = this.query().operationType("Update");
        String updateOperationId = ((UserOperationLogEntry)updates.list().get(0)).getOperationId();
        OperationLogQueryTest.assertEquals((long)updates.count(), (long)this.query().operationId(updateOperationId).count());
        OperationLogQueryTest.assertEquals((long)3L, (long)this.query().property("assignee").count());
        OperationLogQueryTest.assertEquals((long)2L, (long)this.query().property("owner").count());
        List ascLog = ((UserOperationLogQuery)this.query().orderByTimestamp().asc()).list();
        for (i2 = 0; i2 < 4; ++i2) {
            OperationLogQueryTest.assertTrue((this.yesterday.getTime() <= ((UserOperationLogEntry)ascLog.get(i2)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i2 = 4; i2 < 12; ++i2) {
            OperationLogQueryTest.assertTrue((this.today.getTime() <= ((UserOperationLogEntry)ascLog.get(i2)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i2 = 12; i2 < 16; ++i2) {
            OperationLogQueryTest.assertTrue((this.tomorrow.getTime() <= ((UserOperationLogEntry)ascLog.get(i2)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        List descLog = ((UserOperationLogQuery)this.query().orderByTimestamp().desc()).list();
        for (i = 0; i < 4; ++i) {
            OperationLogQueryTest.assertTrue((this.tomorrow.getTime() <= ((UserOperationLogEntry)descLog.get(i)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i = 4; i < 11; ++i) {
            OperationLogQueryTest.assertTrue((this.today.getTime() <= ((UserOperationLogEntry)descLog.get(i)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i = 11; i < 15; ++i) {
            OperationLogQueryTest.assertTrue((this.yesterday.getTime() <= ((UserOperationLogEntry)descLog.get(i)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        OperationLogQueryTest.assertEquals((long)4L, (long)this.query().beforeTimestamp(this.today).count());
        OperationLogQueryTest.assertEquals((long)12L, (long)this.query().beforeTimestamp(this.tomorrow).count());
        OperationLogQueryTest.assertEquals((long)13L, (long)this.query().afterTimestamp(this.yesterday).count());
        OperationLogQueryTest.assertEquals((long)5L, (long)this.query().afterTimestamp(this.today).count());
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstanceById(OperationLogQueryTest.this.userTask.getId());
                return null;
            }
        });
    }

    private UserOperationLogQuery query() {
        return this.historyService.createUserOperationLogQuery();
    }

    private void createLogEntries() {
        ClockUtil.setCurrentTime((Date)this.yesterday);
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.execution = (Execution)this.processEngine.getRuntimeService().createExecutionQuery().processInstanceId(this.process.getId()).singleResult();
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("icke");
        this.taskService.addCandidateUser(this.processTaskId, "er");
        this.taskService.deleteCandidateUser(this.processTaskId, "er");
        this.taskService.addCandidateGroup(this.processTaskId, "wir");
        this.taskService.deleteCandidateGroup(this.processTaskId, "wir");
        ClockUtil.setCurrentTime((Date)this.today);
        this.taskService.setOwner(this.processTaskId, "icke");
        this.taskService.claim(this.processTaskId, "icke");
        this.taskService.setAssignee(this.processTaskId, "er");
        this.taskService.setPriority(this.processTaskId, 10);
        Attachment attachment = this.taskService.createAttachment("image/ico", this.processTaskId, this.process.getId(), "favicon.ico", "favicon", "http://camunda.com/favicon.ico");
        this.taskService.deleteAttachment(attachment.getId());
        this.taskService.complete(this.processTaskId);
        this.assertProcessEnded(this.process.getId());
        this.identityService.setAuthenticatedUserId("er");
        this.userTask = this.taskService.newTask();
        this.userTask.setName("to do");
        this.taskService.saveTask(this.userTask);
        ClockUtil.setCurrentTime((Date)this.tomorrow);
        this.userTask.setDescription("desc");
        this.userTask.setOwner("icke");
        this.userTask.setAssignee("er");
        this.userTask.setDueDate(new Date());
        this.taskService.saveTask(this.userTask);
        this.taskService.complete(this.userTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessInstanceOperationsById() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.suspendProcessInstanceById(this.process.getId());
        this.runtimeService.activateProcessInstanceById(this.process.getId());
        this.runtimeService.deleteProcessInstance(this.process.getId(), "a delete reason");
        OperationLogQueryTest.assertEquals((long)3L, (long)this.query().entityType("ProcessInstance").count());
        UserOperationLogEntry deleteEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processInstanceId(this.process.getId()).operationType("Delete").singleResult();
        OperationLogQueryTest.assertNotNull((Object)deleteEntry);
        OperationLogQueryTest.assertEquals((String)this.process.getId(), (String)deleteEntry.getProcessInstanceId());
        OperationLogQueryTest.assertNull((Object)deleteEntry.getProcessDefinitionId());
        OperationLogQueryTest.assertNull((Object)deleteEntry.getProcessDefinitionKey());
        UserOperationLogEntry suspendEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processInstanceId(this.process.getId()).operationType("Suspend").singleResult();
        OperationLogQueryTest.assertNotNull((Object)suspendEntry);
        OperationLogQueryTest.assertEquals((String)this.process.getId(), (String)suspendEntry.getProcessInstanceId());
        OperationLogQueryTest.assertNull((Object)suspendEntry.getProcessDefinitionId());
        OperationLogQueryTest.assertNull((Object)suspendEntry.getProcessDefinitionKey());
        OperationLogQueryTest.assertEquals((String)"suspensionState", (String)suspendEntry.getProperty());
        OperationLogQueryTest.assertEquals((String)"suspended", (String)suspendEntry.getNewValue());
        OperationLogQueryTest.assertNull((Object)suspendEntry.getOrgValue());
        UserOperationLogEntry activateEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processInstanceId(this.process.getId()).operationType("Activate").singleResult();
        OperationLogQueryTest.assertNotNull((Object)activateEntry);
        OperationLogQueryTest.assertEquals((String)this.process.getId(), (String)activateEntry.getProcessInstanceId());
        OperationLogQueryTest.assertNull((Object)activateEntry.getProcessDefinitionId());
        OperationLogQueryTest.assertNull((Object)activateEntry.getProcessDefinitionKey());
        OperationLogQueryTest.assertEquals((String)"suspensionState", (String)activateEntry.getProperty());
        OperationLogQueryTest.assertEquals((String)"active", (String)activateEntry.getNewValue());
        OperationLogQueryTest.assertNull((Object)activateEntry.getOrgValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessInstanceOperationsByProcessDefinitionId() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(this.process.getProcessDefinitionId());
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(this.process.getProcessDefinitionId());
        OperationLogQueryTest.assertEquals((long)2L, (long)this.query().entityType("ProcessInstance").count());
        UserOperationLogEntry suspendEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionId(this.process.getProcessDefinitionId()).operationType("Suspend").singleResult();
        OperationLogQueryTest.assertNotNull((Object)suspendEntry);
        OperationLogQueryTest.assertEquals((String)this.process.getProcessDefinitionId(), (String)suspendEntry.getProcessDefinitionId());
        OperationLogQueryTest.assertNull((Object)suspendEntry.getProcessInstanceId());
        OperationLogQueryTest.assertNull((Object)suspendEntry.getProcessDefinitionKey());
        OperationLogQueryTest.assertEquals((String)"suspensionState", (String)suspendEntry.getProperty());
        OperationLogQueryTest.assertEquals((String)"suspended", (String)suspendEntry.getNewValue());
        OperationLogQueryTest.assertNull((Object)suspendEntry.getOrgValue());
        UserOperationLogEntry activateEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionId(this.process.getProcessDefinitionId()).operationType("Activate").singleResult();
        OperationLogQueryTest.assertNotNull((Object)activateEntry);
        OperationLogQueryTest.assertNull((Object)activateEntry.getProcessInstanceId());
        OperationLogQueryTest.assertNull((Object)activateEntry.getProcessDefinitionKey());
        OperationLogQueryTest.assertEquals((String)this.process.getProcessDefinitionId(), (String)activateEntry.getProcessDefinitionId());
        OperationLogQueryTest.assertEquals((String)"suspensionState", (String)activateEntry.getProperty());
        OperationLogQueryTest.assertEquals((String)"active", (String)activateEntry.getNewValue());
        OperationLogQueryTest.assertNull((Object)activateEntry.getOrgValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessInstanceOperationsByProcessDefinitionKey() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey("oneTaskProcess");
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey("oneTaskProcess");
        OperationLogQueryTest.assertEquals((long)2L, (long)this.query().entityType("ProcessInstance").count());
        UserOperationLogEntry suspendEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionKey("oneTaskProcess").operationType("Suspend").singleResult();
        OperationLogQueryTest.assertNotNull((Object)suspendEntry);
        OperationLogQueryTest.assertNull((Object)suspendEntry.getProcessInstanceId());
        OperationLogQueryTest.assertNull((Object)suspendEntry.getProcessDefinitionId());
        OperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)suspendEntry.getProcessDefinitionKey());
        OperationLogQueryTest.assertEquals((String)"suspensionState", (String)suspendEntry.getProperty());
        OperationLogQueryTest.assertEquals((String)"suspended", (String)suspendEntry.getNewValue());
        OperationLogQueryTest.assertNull((Object)suspendEntry.getOrgValue());
        UserOperationLogEntry activateEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionKey("oneTaskProcess").operationType("Activate").singleResult();
        OperationLogQueryTest.assertNotNull((Object)activateEntry);
        OperationLogQueryTest.assertNull((Object)activateEntry.getProcessInstanceId());
        OperationLogQueryTest.assertNull((Object)activateEntry.getProcessDefinitionId());
        OperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)activateEntry.getProcessDefinitionKey());
        OperationLogQueryTest.assertEquals((String)"suspensionState", (String)activateEntry.getProperty());
        OperationLogQueryTest.assertEquals((String)"active", (String)activateEntry.getNewValue());
        OperationLogQueryTest.assertNull((Object)activateEntry.getOrgValue());
        this.historyService.deleteUserOperationLogEntry(suspendEntry.getId());
        this.historyService.deleteUserOperationLogEntry(activateEntry.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessDefinitionOperationsById() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        this.repositoryService.activateProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        OperationLogQueryTest.assertEquals((long)2L, (long)this.query().entityType("ProcessInstance").count());
        UserOperationLogEntry suspendEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionId(this.process.getProcessDefinitionId()).operationType("Suspend").singleResult();
        OperationLogQueryTest.assertNotNull((Object)suspendEntry);
        OperationLogQueryTest.assertNull((Object)suspendEntry.getProcessInstanceId());
        OperationLogQueryTest.assertEquals((String)this.process.getProcessDefinitionId(), (String)suspendEntry.getProcessDefinitionId());
        OperationLogQueryTest.assertNull((Object)suspendEntry.getProcessDefinitionKey());
        OperationLogQueryTest.assertEquals((String)"suspensionState", (String)suspendEntry.getProperty());
        OperationLogQueryTest.assertEquals((String)"suspended", (String)suspendEntry.getNewValue());
        OperationLogQueryTest.assertNull((Object)suspendEntry.getOrgValue());
        UserOperationLogEntry activateEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionId(this.process.getProcessDefinitionId()).operationType("Activate").singleResult();
        OperationLogQueryTest.assertNotNull((Object)activateEntry);
        OperationLogQueryTest.assertNull((Object)activateEntry.getProcessInstanceId());
        OperationLogQueryTest.assertEquals((String)this.process.getProcessDefinitionId(), (String)activateEntry.getProcessDefinitionId());
        OperationLogQueryTest.assertNull((Object)activateEntry.getProcessDefinitionKey());
        OperationLogQueryTest.assertEquals((String)"suspensionState", (String)activateEntry.getProperty());
        OperationLogQueryTest.assertEquals((String)"active", (String)activateEntry.getNewValue());
        OperationLogQueryTest.assertNull((Object)activateEntry.getOrgValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessDefinitionOperationsByKey() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionByKey("oneTaskProcess", true, null);
        this.repositoryService.activateProcessDefinitionByKey("oneTaskProcess", true, null);
        OperationLogQueryTest.assertEquals((long)2L, (long)this.query().entityType("ProcessInstance").count());
        UserOperationLogEntry suspendEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionKey("oneTaskProcess").operationType("Suspend").singleResult();
        OperationLogQueryTest.assertNotNull((Object)suspendEntry);
        OperationLogQueryTest.assertNull((Object)suspendEntry.getProcessInstanceId());
        OperationLogQueryTest.assertNull((Object)suspendEntry.getProcessDefinitionId());
        OperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)suspendEntry.getProcessDefinitionKey());
        OperationLogQueryTest.assertEquals((String)"suspensionState", (String)suspendEntry.getProperty());
        OperationLogQueryTest.assertEquals((String)"suspended", (String)suspendEntry.getNewValue());
        OperationLogQueryTest.assertNull((Object)suspendEntry.getOrgValue());
        UserOperationLogEntry activateEntry = (UserOperationLogEntry)this.query().entityType("ProcessInstance").processDefinitionKey("oneTaskProcess").operationType("Activate").singleResult();
        OperationLogQueryTest.assertNotNull((Object)activateEntry);
        OperationLogQueryTest.assertNull((Object)activateEntry.getProcessInstanceId());
        OperationLogQueryTest.assertNull((Object)activateEntry.getProcessDefinitionId());
        OperationLogQueryTest.assertEquals((String)"oneTaskProcess", (String)activateEntry.getProcessDefinitionKey());
        OperationLogQueryTest.assertEquals((String)"suspensionState", (String)activateEntry.getProperty());
        OperationLogQueryTest.assertEquals((String)"active", (String)activateEntry.getNewValue());
        OperationLogQueryTest.assertNull((Object)activateEntry.getOrgValue());
        this.historyService.deleteUserOperationLogEntry(suspendEntry.getId());
        this.historyService.deleteUserOperationLogEntry(activateEntry.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        OperationLogQueryTest.assertNotNull((Object)task);
        this.taskService.setAssignee(task.getId(), "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().caseDefinitionId(caseDefinitionId);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        OperationLogQueryTest.assertNotNull((Object)task);
        this.taskService.setAssignee(task.getId(), "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().caseInstanceId(caseInstanceId);
        this.verifyQueryResults(query, 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseExecutionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        OperationLogQueryTest.assertNotNull((Object)task);
        this.taskService.setAssignee(task.getId(), "demo");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().caseExecutionId(caseExecutionId);
        this.verifyQueryResults(query, 1);
    }

    private void verifyQueryResults(UserOperationLogQuery query, int countExpected) {
        OperationLogQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        OperationLogQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            OperationLogQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            OperationLogQueryTest.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(UserOperationLogQuery query) {
        try {
            query.singleResult();
            OperationLogQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }
}

