/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class DefaultUserPermissionNameForTaskCfgTest {
    @Test
    public void updateIsDefaultTaskPermission() {
        Assert.assertEquals((Object)"UPDATE", (Object)new StandaloneInMemProcessEngineConfiguration().getDefaultUserPermissionNameForTask());
    }

    @Test
    public void shouldInitUpdatePermission() {
        TestProcessEngineCfg testProcessEngineCfg = new TestProcessEngineCfg();
        testProcessEngineCfg.setDefaultUserPermissionNameForTask("UPDATE");
        testProcessEngineCfg.initDefaultUserPermissionForTask();
        Assert.assertEquals((Object)Permissions.UPDATE, (Object)testProcessEngineCfg.getDefaultUserPermissionForTask());
    }

    @Test
    public void shouldInitTaskWorkPermission() {
        TestProcessEngineCfg testProcessEngineCfg = new TestProcessEngineCfg();
        testProcessEngineCfg.setDefaultUserPermissionNameForTask("TASK_WORK");
        testProcessEngineCfg.initDefaultUserPermissionForTask();
        Assert.assertEquals((Object)Permissions.TASK_WORK, (Object)testProcessEngineCfg.getDefaultUserPermissionForTask());
    }

    @Test
    public void shouldThrowExceptionOnUnsupportedPermission() {
        TestProcessEngineCfg testProcessEngineCfg = new TestProcessEngineCfg();
        testProcessEngineCfg.setDefaultUserPermissionNameForTask("UNSUPPORTED");
        try {
            testProcessEngineCfg.initDefaultUserPermissionForTask();
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            String expectedExceptionMessage = String.format("Invalid value '%s' for configuration property 'defaultUserPermissionNameForTask'.", "UNSUPPORTED");
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{expectedExceptionMessage});
        }
    }

    @Test
    public void shouldThrowExceptionOnNullPermissionName() {
        TestProcessEngineCfg testProcessEngineCfg = new TestProcessEngineCfg();
        testProcessEngineCfg.setDefaultUserPermissionNameForTask(null);
        try {
            testProcessEngineCfg.initDefaultUserPermissionForTask();
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            String expectedExceptionMessage = "Invalid value 'null' for configuration property 'defaultUserPermissionNameForTask'.";
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{expectedExceptionMessage});
        }
    }

    @Test
    public void shouldNotInitIfAlreadySet() {
        TestProcessEngineCfg testProcessEngineCfg = new TestProcessEngineCfg();
        testProcessEngineCfg.setDefaultUserPermissionForTask((Permission)Permissions.ALL);
        testProcessEngineCfg.initDefaultUserPermissionForTask();
        Assert.assertEquals((Object)Permissions.ALL, (Object)testProcessEngineCfg.getDefaultUserPermissionForTask());
    }

    @Test
    public void shouldInitTaskPermission() {
        try (ProcessEngine engine = null;){
            TestProcessEngineCfg testProcessEngineCfg = new TestProcessEngineCfg();
            engine = testProcessEngineCfg.setProcessEngineName("DefaultTaskPermissionsCfgTest-engine").setJdbcUrl(String.format("jdbc:h2:mem:%s", "DefaultTaskPermissionsCfgTest-engine-db")).setMetricsEnabled(false).setJobExecutorActivate(false).buildProcessEngine();
            Assert.assertTrue((boolean)testProcessEngineCfg.initMethodCalled);
        }
    }

    static class TestProcessEngineCfg
    extends StandaloneInMemProcessEngineConfiguration {
        boolean initMethodCalled = false;

        TestProcessEngineCfg() {
        }

        public void initDefaultUserPermissionForTask() {
            super.initDefaultUserPermissionForTask();
            this.initMethodCalled = true;
        }
    }
}

