/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.test.api.authorization.service.ExecuteCommandDelegate;
import org.camunda.bpm.engine.test.api.authorization.service.ExecuteCommandListener;
import org.camunda.bpm.engine.test.api.authorization.service.ExecuteCommandTaskListener;
import org.camunda.bpm.engine.test.api.authorization.service.ExecuteQueryDelegate;
import org.camunda.bpm.engine.test.api.authorization.service.ExecuteQueryListener;
import org.camunda.bpm.engine.test.api.authorization.service.ExecuteQueryTaskListener;
import org.camunda.bpm.engine.test.api.authorization.service.MyDelegationService;
import org.camunda.bpm.engine.test.api.authorization.service.MyFormFieldValidator;
import org.camunda.bpm.engine.test.api.authorization.service.MyServiceTaskActivityBehaviorExecuteCommand;
import org.camunda.bpm.engine.test.api.authorization.service.MyServiceTaskActivityBehaviorExecuteQuery;
import org.camunda.bpm.engine.test.api.authorization.service.MyTaskService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DelegationAuthorizationTest
extends AuthorizationTest {
    public static final String DEFAULT_PROCESS_KEY = "process";

    @Override
    @Before
    public void setUp() throws Exception {
        MyDelegationService.clearProperties();
        this.processEngineConfiguration.setAuthorizationEnabledForCustomCode(false);
        super.setUp();
    }

    @Deployment
    @Test
    public void testJavaDelegateExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testJavaDelegateExecutesCommandAfterUserCompletesTask() {
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testJavaDelegateExecutesQueryAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myDelegate", new ExecuteQueryDelegate());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testJavaDelegateExecutesCommandAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myDelegate", new ExecuteCommandDelegate());
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testJavaDelegateExecutesQueryAfterUserCompletesTaskAsExpression() {
        this.processEngineConfiguration.getBeans().put("myDelegate", new ExecuteQueryDelegate());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testJavaDelegateExecutesCommandAfterUserCompletesTaskAsExpression() {
        this.processEngineConfiguration.getBeans().put("myDelegate", new ExecuteCommandDelegate());
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testCustomActivityBehaviorExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testCustomActivityBehaviorExecutesCommandAfterUserCompletesTask() {
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testCustomActivityBehaviorExecutesQueryAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myBehavior", new MyServiceTaskActivityBehaviorExecuteQuery());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testCustomActivityBehaviorExecutesCommandAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myBehavior", new MyServiceTaskActivityBehaviorExecuteCommand());
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testSignallableActivityBehaviorAsClass() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 4);
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signal(processInstanceId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testSignallableActivityBehaviorAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("activityBehavior", new MyServiceTaskActivityBehaviorExecuteQuery());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 4);
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signal(processInstanceId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testExecutionListenerExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testExecutionListenerExecutesCommandAfterUserCompletesTask() {
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testExecutionListenerExecutesQueryAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteQueryListener());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testExecutionListenerExecutesCommandAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteCommandListener());
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testExecutionListenerExecutesQueryAfterUserCompletesTaskAsExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteQueryListener());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testExecutionListenerExecutesCommandAfterUserCompletesTaskAsExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteCommandListener());
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testTaskListenerExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testTaskListenerExecutesCommandAfterUserCompletesTask() {
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testTaskListenerExecutesQueryAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteQueryTaskListener());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testTaskListenerExecutesCommandAfterUserCompletesTaskAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteCommandTaskListener());
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testTaskListenerExecutesQueryAfterUserCompletesTaskAsExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteQueryTaskListener());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testTaskListenerExecutesCommandAfterUserCompletesTaskAsExpression() {
        this.processEngineConfiguration.getBeans().put("myListener", new ExecuteCommandTaskListener());
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testTaskAssigneeExpression() {
        this.processEngineConfiguration.getBeans().put("myTaskService", new MyTaskService());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testScriptTaskExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        Task task = this.selectAnyTask();
        String taskId = task.getId();
        String processInstanceId = task.getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId});
        VariableInstance variableUser = (VariableInstance)query.variableName("userId").singleResult();
        Assert.assertNotNull((Object)variableUser);
        Assert.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        VariableInstance variableCount = (VariableInstance)query.variableName("count").singleResult();
        Assert.assertNotNull((Object)variableCount);
        Assert.assertEquals((Object)5L, (Object)variableCount.getValue());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testScriptTaskExecutesCommandAfterUserCompletesTask() {
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstance variableUser = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("userId").singleResult();
        Assert.assertNotNull((Object)variableUser);
        Assert.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testScriptExecutionListenerExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        Task task = this.selectAnyTask();
        String taskId = task.getId();
        String processInstanceId = task.getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId});
        VariableInstance variableUser = (VariableInstance)query.variableName("userId").singleResult();
        Assert.assertNotNull((Object)variableUser);
        Assert.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        VariableInstance variableCount = (VariableInstance)query.variableName("count").singleResult();
        Assert.assertNotNull((Object)variableCount);
        Assert.assertEquals((Object)5L, (Object)variableCount.getValue());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testScriptExecutionListenerExecutesCommandAfterUserCompletesTask() {
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstance variableUser = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("userId").singleResult();
        Assert.assertNotNull((Object)variableUser);
        Assert.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testScriptTaskListenerExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        Task task = this.selectAnyTask();
        String taskId = task.getId();
        String processInstanceId = task.getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId});
        VariableInstance variableUser = (VariableInstance)query.variableName("userId").singleResult();
        Assert.assertNotNull((Object)variableUser);
        Assert.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        VariableInstance variableCount = (VariableInstance)query.variableName("count").singleResult();
        Assert.assertNotNull((Object)variableCount);
        Assert.assertEquals((Object)5L, (Object)variableCount.getValue());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testScriptTaskListenerExecutesCommandAfterUserCompletesTask() {
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstance variableUser = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("userId").singleResult();
        Assert.assertNotNull((Object)variableUser);
        Assert.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testScriptConditionExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        Task task = this.selectAnyTask();
        String taskId = task.getId();
        String processInstanceId = task.getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId});
        VariableInstance variableUser = (VariableInstance)query.variableName("userId").singleResult();
        Assert.assertNotNull((Object)variableUser);
        Assert.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        VariableInstance variableCount = (VariableInstance)query.variableName("count").singleResult();
        Assert.assertNotNull((Object)variableCount);
        Assert.assertEquals((Object)5L, (Object)variableCount.getValue());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testScriptConditionExecutesCommandAfterUserCompletesTask() {
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstance variableUser = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("userId").singleResult();
        Assert.assertNotNull((Object)variableUser);
        Assert.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testScriptIoMappingExecutesQueryAfterUserCompletesTask() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        Task task = this.selectAnyTask();
        String taskId = task.getId();
        String processInstanceId = task.getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId});
        VariableInstance variableUser = (VariableInstance)query.variableName("userId").singleResult();
        Assert.assertNotNull((Object)variableUser);
        Assert.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        VariableInstance variableCount = (VariableInstance)query.variableName("count").singleResult();
        Assert.assertNotNull((Object)variableCount);
        Assert.assertEquals((Object)5L, (Object)variableCount.getValue());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testScriptIoMappingExecutesCommandAfterUserCompletesTask() {
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId});
        VariableInstance variableUser = (VariableInstance)query.variableName("userId").singleResult();
        Assert.assertNotNull((Object)variableUser);
        Assert.assertEquals((Object)this.userId, (Object)variableUser.getValue());
        VariableInstance variableCount = (VariableInstance)query.variableName("count").singleResult();
        Assert.assertNotNull((Object)variableCount);
        Assert.assertEquals((Object)1L, (Object)variableCount.getValue());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testCustomStartFormHandlerExecutesQuery() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String processDefinitionId = this.selectProcessDefinitionByKey(DEFAULT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, DEFAULT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        StartFormData startFormData = this.formService.getStartFormData(processDefinitionId);
        Assert.assertNotNull((Object)startFormData);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testCustomTaskFormHandlerExecutesQuery() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        Assert.assertNotNull((Object)taskFormData);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/DelegationAuthorizationTest.testCustomStartFormHandlerExecutesQuery.bpmn20.xml"})
    @Test
    public void testSubmitCustomStartFormHandlerExecutesQuery() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String processDefinitionId = this.selectProcessDefinitionByKey(DEFAULT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, DEFAULT_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.formService.submitStartForm(processDefinitionId, null);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/DelegationAuthorizationTest.testCustomTaskFormHandlerExecutesQuery.bpmn20.xml"})
    @Test
    public void testSubmitCustomTaskFormHandlerExecutesQuery() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.formService.submitTaskForm(taskId, null);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testCustomFormFieldValidator() {
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.formService.submitTaskForm(taskId, null);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment
    @Test
    public void testCustomFormFieldValidatorAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myValidator", new MyFormFieldValidator());
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.formService.submitTaskForm(taskId, null);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)5L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/DelegationAuthorizationTest.testJavaDelegateExecutesQueryAfterUserCompletesTask.bpmn20.xml"})
    @Test
    public void testPerformAuthorizationCheckByExecutingQuery() {
        this.processEngineConfiguration.setAuthorizationEnabledForCustomCode(true);
        this.startProcessInstancesByKey(DEFAULT_PROCESS_KEY, 5);
        String taskId = this.selectAnyTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        Assert.assertEquals((Object)0L, (Object)MyDelegationService.INSTANCES_COUNT);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/DelegationAuthorizationTest.testJavaDelegateExecutesCommandAfterUserCompletesTask.bpmn20.xml"})
    @Test
    public void testPerformAuthorizationCheckByExecutingCommand() {
        this.processEngineConfiguration.setAuthorizationEnabledForCustomCode(true);
        this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.taskService.complete(taskId);
            Assert.fail((String)"Exception expected: It should not be possible to execute the command inside JavaDelegate");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)MyDelegationService.CURRENT_AUTHENTICATION);
        Assert.assertEquals((Object)this.userId, (Object)MyDelegationService.CURRENT_AUTHENTICATION.getUserId());
        this.disableAuthorization();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.enableAuthorization();
    }

    @Deployment
    @Test
    public void testTaskListenerOnCreateAssignsTask() {
        String processInstanceId = this.startProcessInstanceByKey(DEFAULT_PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    protected void startProcessInstancesByKey(String key, int count) {
        for (int i = 0; i < count; ++i) {
            this.startProcessInstanceByKey(key);
        }
    }

    protected Task selectAnyTask() {
        this.disableAuthorization();
        Task task = (Task)this.taskService.createTaskQuery().listPage(0, 1).get(0);
        this.enableAuthorization();
        return task;
    }
}

