/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.SystemPermissions;
import org.camunda.bpm.engine.authorization.TaskPermissions;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.management.TableMetaData;
import org.camunda.bpm.engine.management.TablePage;
import org.camunda.bpm.engine.telemetry.TelemetryData;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ManagementAuthorizationTest
extends AuthorizationTest {
    protected static final String REQUIRED_ADMIN_AUTH_EXCEPTION = "ENGINE-03029 Required admin authenticated group or user.";
    protected static final String DUMMY_PROPERTY = "dummy-property";
    protected static final String DUMMY_VALUE = "aPropertyValue";
    protected static final String DUMMY_METRIC = "dummyMetric";

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.managementService.deleteProperty(DUMMY_PROPERTY);
        this.managementService.deleteLicenseKey();
    }

    @Test
    public void shouldGetTableCountAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        Map tableCount = this.managementService.getTableCount();
        Assertions.assertThat((Map)tableCount).isNotEmpty();
    }

    @Test
    public void shouldGetTableCountWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        Map tableCount = this.managementService.getTableCount();
        Assertions.assertThat((Map)tableCount).isNotEmpty();
    }

    @Test
    public void shouldGetTableCountWithAdminAndPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        Map tableCount = this.managementService.getTableCount();
        Assertions.assertThat((Map)tableCount).isNotEmpty();
    }

    @Test
    public void shouldNotGetTableCountWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.getTableCount()).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.READ));
    }

    @Test
    public void shouldGetTableNameAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        String tableName = this.managementService.getTableName(ProcessDefinitionEntity.class);
        Assertions.assertThat((String)(tablePrefix + "ACT_RE_PROCDEF")).isEqualTo((Object)tableName);
    }

    @Test
    public void shouldGetTableNameWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        String tableName = this.managementService.getTableName(ProcessDefinitionEntity.class);
        Assertions.assertThat((String)(tablePrefix + "ACT_RE_PROCDEF")).isEqualTo((Object)tableName);
    }

    @Test
    public void shouldGetTableNameAdminAndWithPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        String tableName = this.managementService.getTableName(ProcessDefinitionEntity.class);
        Assertions.assertThat((String)(tablePrefix + "ACT_RE_PROCDEF")).isEqualTo((Object)tableName);
    }

    @Test
    public void shouldNotGetTableNameWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.getTableName(ProcessDefinitionEntity.class)).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.READ));
    }

    @Test
    public void shouldGetTableMetaDataAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        TableMetaData tableMetaData = this.managementService.getTableMetaData("ACT_RE_PROCDEF");
        Assertions.assertThat((Object)tableMetaData).isNotNull();
    }

    @Test
    public void shouldGetTableMetaDataWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        TableMetaData tableMetaData = this.managementService.getTableMetaData("ACT_RE_PROCDEF");
        Assertions.assertThat((Object)tableMetaData).isNotNull();
    }

    @Test
    public void shouldGetTableMetaDataWithAdminAndPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        TableMetaData tableMetaData = this.managementService.getTableMetaData("ACT_RE_PROCDEF");
        Assertions.assertThat((Object)tableMetaData).isNotNull();
    }

    @Test
    public void shouldNotGetTableMetaDataWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.getTableMetaData("ACT_RE_PROCDEF")).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.READ));
    }

    @Test
    public void shouldNotPerformTablePageQueryWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.createTablePageQuery().tableName("ACT_RE_PROCDEF").listPage(0, Integer.MAX_VALUE)).hasMessage(REQUIRED_ADMIN_AUTH_EXCEPTION);
    }

    @Test
    public void shouldPerformTablePageQueryAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        TablePage page = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RE_PROCDEF").listPage(0, Integer.MAX_VALUE);
        Assertions.assertThat((Object)page).isNotNull();
    }

    @Test
    public void shouldGetHistoryLevelAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        int historyLevel = this.managementService.getHistoryLevel();
        Assert.assertEquals((long)this.processEngineConfiguration.getHistoryLevel().getId(), (long)historyLevel);
    }

    @Test
    public void shouldGetHistoryLevelWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        int historyLevel = this.managementService.getHistoryLevel();
        Assert.assertEquals((long)this.processEngineConfiguration.getHistoryLevel().getId(), (long)historyLevel);
    }

    @Test
    public void shouldGetHistoryLevelAdminAndWithPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        int historyLevel = this.managementService.getHistoryLevel();
        Assert.assertEquals((long)this.processEngineConfiguration.getHistoryLevel().getId(), (long)historyLevel);
    }

    @Test
    public void shouldNotGetHistoryLevelWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.getHistoryLevel()).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.READ));
    }

    @Test
    public void shouldNotPerformDataSchemaUpgradeWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.databaseSchemaUpgrade(null, null, null)).hasMessage(REQUIRED_ADMIN_AUTH_EXCEPTION);
    }

    @Test
    public void shouldGetPropertiesAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        Map properties = this.managementService.getProperties();
        Assertions.assertThat((Map)properties).isNotEmpty();
    }

    @Test
    public void shouldGetPropertiesWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        Map properties = this.managementService.getProperties();
        Assertions.assertThat((Map)properties).isNotEmpty();
    }

    @Test
    public void shouldGetPropertiesWithAdminAndPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        Map properties = this.managementService.getProperties();
        Assertions.assertThat((Map)properties).isNotEmpty();
    }

    @Test
    public void shouldNotGetPropertiesWithWrongPermission() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{TaskPermissions.DELETE});
        Assertions.assertThatThrownBy(() -> this.managementService.getProperties()).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.READ));
    }

    @Test
    public void shouldNotGetPropertiesWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.getProperties()).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.READ));
    }

    @Test
    public void shouldSetPropertyAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.managementService.setProperty(DUMMY_PROPERTY, DUMMY_VALUE);
        this.disableAuthorization();
        Assertions.assertThat((String)((String)this.managementService.getProperties().get(DUMMY_PROPERTY))).isEqualTo((Object)DUMMY_VALUE);
    }

    @Test
    public void shouldSetPropertyWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.SET});
        this.managementService.setProperty(DUMMY_PROPERTY, DUMMY_VALUE);
        this.disableAuthorization();
        Assertions.assertThat((String)((String)this.managementService.getProperties().get(DUMMY_PROPERTY))).isEqualTo((Object)DUMMY_VALUE);
    }

    @Test
    public void shouldSetPropertyWithAdminAndPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.SET});
        this.managementService.setProperty(DUMMY_PROPERTY, DUMMY_VALUE);
        this.disableAuthorization();
        Assertions.assertThat((String)((String)this.managementService.getProperties().get(DUMMY_PROPERTY))).isEqualTo((Object)DUMMY_VALUE);
    }

    @Test
    public void shouldNotSetPropertyWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.setProperty(DUMMY_PROPERTY, DUMMY_VALUE)).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.SET));
    }

    @Test
    public void shouldDeletePropertyAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.managementService.setProperty(DUMMY_VALUE, DUMMY_PROPERTY);
        this.managementService.deleteProperty(DUMMY_PROPERTY);
        this.disableAuthorization();
        Assertions.assertThat((String)((String)this.managementService.getProperties().get(DUMMY_PROPERTY))).isNull();
    }

    @Test
    public void shouldDeletePropertyWithPermission() {
        this.disableAuthorization();
        this.managementService.setProperty(DUMMY_VALUE, DUMMY_PROPERTY);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.DELETE});
        this.managementService.deleteProperty(DUMMY_PROPERTY);
        this.disableAuthorization();
        Assertions.assertThat((String)((String)this.managementService.getProperties().get(DUMMY_PROPERTY))).isNull();
        this.enableAuthorization();
    }

    @Test
    public void shouldDeletePropertyWithAdminAndPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.DELETE});
        this.managementService.setProperty(DUMMY_VALUE, DUMMY_PROPERTY);
        this.managementService.deleteProperty(DUMMY_PROPERTY);
        Assertions.assertThat((String)((String)this.managementService.getProperties().get(DUMMY_PROPERTY))).isNull();
    }

    @Test
    public void shouldNotDeletePropertyWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.deleteProperty(DUMMY_PROPERTY)).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.DELETE));
    }

    @Test
    public void shouldNotToggleTelemetryEnabledWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.toggleTelemetry(false)).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.SET));
    }

    @Test
    public void shouldToggleTelemetryEnabledAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.managementService.toggleTelemetry(true);
        this.managementService.toggleTelemetry(false);
        Assertions.assertThat((Boolean)this.managementService.isTelemetryEnabled()).isFalse();
    }

    @Test
    public void shouldToggleTelemetryEnabledWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ, SystemPermissions.SET});
        this.managementService.toggleTelemetry(true);
        this.managementService.toggleTelemetry(false);
        Assertions.assertThat((Boolean)this.managementService.isTelemetryEnabled()).isFalse();
    }

    @Test
    public void shouldToggleTelemetryEnabledWithAdminAndPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ, SystemPermissions.SET});
        this.managementService.toggleTelemetry(true);
        this.managementService.toggleTelemetry(false);
        Assertions.assertThat((Boolean)this.managementService.isTelemetryEnabled()).isFalse();
    }

    @Test
    public void shouldGetTelemetryDataAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((Object)telemetryData).isNotNull();
    }

    @Test
    public void shouldGetTelemetryDataWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((Object)telemetryData).isNotNull();
    }

    @Test
    public void shouldGetTelemetryDataWithAdminAndPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((Object)telemetryData).isNotNull();
    }

    @Test
    public void shouldNotGetTelemetryDataWithoutAdminAndPermission() {
        Assertions.assertThatThrownBy(() -> this.managementService.getTelemetryData()).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.READ));
    }

    @Test
    public void shouldGetLicenseKeyAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.managementService.setLicenseKey("testLicenseKey");
        String licenseKey = this.managementService.getLicenseKey();
        Assertions.assertThat((String)licenseKey).isNotNull();
    }

    @Test
    public void shouldGetLicenseKeyWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        this.disableAuthorization();
        this.managementService.setLicenseKey("testLicenseKey");
        this.enableAuthorization();
        String licenseKey = this.managementService.getLicenseKey();
        Assertions.assertThat((String)licenseKey).isNotNull();
    }

    @Test
    public void shouldGetLicenseKeyWithAdminAndPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        this.managementService.setLicenseKey("testLicenseKey");
        String licenseKey = this.managementService.getLicenseKey();
        Assertions.assertThat((String)licenseKey).isEqualTo((Object)"testLicenseKey");
    }

    @Test
    public void shouldNotGetLicenseKeyWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.getLicenseKey()).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.READ));
    }

    @Test
    public void shouldSetLicenseKeyAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.managementService.setLicenseKey("testLicenseKey");
        Assertions.assertThat((String)this.managementService.getLicenseKey()).isNotNull();
    }

    @Test
    public void shouldSetLicenseKeyWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.SET});
        this.managementService.setLicenseKey("testLicenseKey");
        this.disableAuthorization();
        Assertions.assertThat((String)this.managementService.getLicenseKey()).isNotNull();
        this.enableAuthorization();
    }

    @Test
    public void shouldSetLicenseKeyWithAdminAndPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.SET});
        this.managementService.setLicenseKey("testLicenseKey");
        Assertions.assertThat((String)this.managementService.getLicenseKey()).isEqualTo((Object)"testLicenseKey");
    }

    @Test
    public void shouldNotSetLicenseKeyWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.setLicenseKey("testLicenseKey")).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.SET));
    }

    @Test
    public void shouldDeleteLicenseKeyAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.managementService.setLicenseKey("testLicenseKey");
        this.managementService.deleteLicenseKey();
        Assertions.assertThat((String)this.managementService.getLicenseKey()).isNull();
    }

    @Test
    public void shouldDeleteLicenseKeyWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.DELETE});
        this.disableAuthorization();
        this.managementService.setLicenseKey("testLicenseKey");
        this.enableAuthorization();
        this.managementService.deleteLicenseKey();
        this.disableAuthorization();
        Assertions.assertThat((String)this.managementService.getLicenseKey()).isNull();
        this.enableAuthorization();
    }

    @Test
    public void shouldDeleteLicenseKeyWithAdminAndPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.DELETE});
        this.managementService.setLicenseKey("testLicenseKey");
        this.managementService.deleteLicenseKey();
        Assertions.assertThat((String)this.managementService.getLicenseKey()).isNull();
    }

    @Test
    public void shouldNotDeleteLicenseKeyWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.deleteLicenseKey()).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.DELETE));
    }

    @Test
    public void shouldDeleteMetricsAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.processEngineConfiguration.getDbMetricsReporter().reportValueAtOnce(DUMMY_METRIC, 15L);
        this.managementService.deleteMetrics(null);
        Assertions.assertThat((long)this.managementService.createMetricsQuery().name(DUMMY_METRIC).sum()).isZero();
    }

    @Test
    public void shouldDeleteMetricsWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.DELETE});
        this.processEngineConfiguration.getDbMetricsReporter().reportValueAtOnce(DUMMY_METRIC, 15L);
        this.managementService.deleteMetrics(null);
        Assertions.assertThat((long)this.managementService.createMetricsQuery().name(DUMMY_METRIC).sum()).isZero();
    }

    @Test
    public void shouldDeleteMetricsWithAdminAndPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.DELETE});
        this.processEngineConfiguration.getDbMetricsReporter().reportValueAtOnce(DUMMY_METRIC, 15L);
        this.managementService.deleteMetrics(null);
        Assertions.assertThat((long)this.managementService.createMetricsQuery().name(DUMMY_METRIC).sum()).isZero();
    }

    @Test
    public void shouldNotDeleteMetricsWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.deleteMetrics(null)).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.DELETE));
    }

    @Test
    public void shouldDeleteTaskMetricsAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.managementService.deleteTaskMetrics(null);
        Assertions.assertThat((long)this.managementService.createMetricsQuery().name("unique-task-workers").sum()).isZero();
    }

    @Test
    public void shouldDeleteTaskMetricsWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.DELETE});
        this.managementService.deleteTaskMetrics(null);
        Assertions.assertThat((long)this.managementService.createMetricsQuery().name("unique-task-workers").sum()).isZero();
    }

    @Test
    public void shouldDeleteTaskMetricsWithAdminAndPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.DELETE});
        this.managementService.deleteTaskMetrics(null);
        Assertions.assertThat((long)this.managementService.createMetricsQuery().name("unique-task-workers").sum()).isZero();
    }

    @Test
    public void shouldNotDeleteTaskMetricsWithoutAuthorization() {
        Assertions.assertThatThrownBy(() -> this.managementService.deleteTaskMetrics(null)).hasMessageContaining(this.permissionException((Resource)Resources.SYSTEM, (Permission)SystemPermissions.DELETE));
    }

    @Test
    public void shouldExecuteSchemaLogListAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        List schemaLog = this.managementService.createSchemaLogQuery().list();
        Assertions.assertThat((List)schemaLog).isNotEmpty();
    }

    @Test
    public void shouldExecuteSchemaLogListWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        List schemaLog = this.managementService.createSchemaLogQuery().list();
        Assertions.assertThat((List)schemaLog).isNotEmpty();
    }

    @Test
    public void shouldExecuteSchemaLogListWithAdminAndPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        List schemaLog = this.managementService.createSchemaLogQuery().list();
        Assertions.assertThat((List)schemaLog).isNotEmpty();
    }

    @Test
    public void shouldNotExecuteSchemaLogListWithoutAuthorization() {
        List schemaLog = this.managementService.createSchemaLogQuery().list();
        Assertions.assertThat((List)schemaLog).isEmpty();
    }

    @Test
    public void shouldExecuteSchemaLogCountAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        long schemaLog = this.managementService.createSchemaLogQuery().count();
        Assertions.assertThat((long)schemaLog).isGreaterThan(0L);
    }

    @Test
    public void shouldExecuteSchemaLogCountWithPermission() {
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        long schemaLog = this.managementService.createSchemaLogQuery().count();
        Assertions.assertThat((long)schemaLog).isGreaterThan(0L);
    }

    @Test
    public void shouldExecuteSchemaLogCountWithAdminAndPermission() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.createGrantAuthorization((Resource)Resources.SYSTEM, "*", this.userId, new Permission[]{SystemPermissions.READ});
        long schemaLog = this.managementService.createSchemaLogQuery().count();
        Assertions.assertThat((long)schemaLog).isGreaterThan(0L);
    }

    @Test
    public void shouldNotExecuteSchemaLogCountWithoutAuthorization() {
        long schemaLog = this.managementService.createSchemaLogQuery().count();
        Assertions.assertThat((long)schemaLog).isZero();
    }
}

