/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.suspensionstate;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.multitenancy.StaticTenantIdTestProvider;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyProcessDefinitionSuspensionStateTenantIdProviderTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final BpmnModelInstance PROCESS = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().camundaAsyncBefore()).endEvent().done();
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        StaticTenantIdTestProvider tenantIdProvider = new StaticTenantIdTestProvider(TENANT_ONE);
        configuration.setTenantIdProvider((TenantIdProvider)tenantIdProvider);
    });
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() throws Exception {
        this.testRule.deploy(PROCESS);
    }

    @Test
    public void suspendProcessDefinitionByIdIncludeInstancesFromAllTenants() {
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
        ProcessDefinition processDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().withoutTenantId().singleResult();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionId(processDefinition.getId());
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinition.getId()).includeProcessInstances(true).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void activateProcessDefinitionByIdIncludeInstancesFromAllTenants() {
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeProcessInstances(true).suspend();
        ProcessDefinition processDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().withoutTenantId().singleResult();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionId(processDefinition.getId());
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinition.getId()).includeProcessInstances(true).activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }
}

