/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.io.InputStream;
import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyDecisionRequirementsDefinitionCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String DRG_DMN = "org/camunda/bpm/engine/test/api/multitenancy/DecisionRequirementsGraph.dmn";
    protected static final String DRD_DMN = "org/camunda/bpm/engine/test/api/multitenancy/DecisionRequirementsGraph.png";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected String decisionRequirementsDefinitionId;
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected ProcessEngineConfiguration processEngineConfiguration;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.testRule.deployForTenant(TENANT_ONE, DRG_DMN, DRD_DMN);
        this.decisionRequirementsDefinitionId = ((DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult()).getId();
    }

    @Test
    public void failToGetDecisionRequirementsDefinitionNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getDecisionRequirementsDefinition(this.decisionRequirementsDefinitionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the decision requirements definition");
    }

    @Test
    public void getDecisionRequirementsDefinitionWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DecisionRequirementsDefinition definition = this.repositoryService.getDecisionRequirementsDefinition(this.decisionRequirementsDefinitionId);
        Assertions.assertThat((String)definition.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void getDecisionRequirementsDefinitionDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        DecisionRequirementsDefinition definition = this.repositoryService.getDecisionRequirementsDefinition(this.decisionRequirementsDefinitionId);
        Assertions.assertThat((String)definition.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void failToGetDecisionRequirementsModelNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getDecisionRequirementsModel(this.decisionRequirementsDefinitionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the decision requirements definition");
    }

    @Test
    public void getDecisionRequirementsModelWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getDecisionRequirementsModel(this.decisionRequirementsDefinitionId);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
    }

    @Test
    public void getDecisionRequirementsModelDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getDecisionRequirementsModel(this.decisionRequirementsDefinitionId);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
    }

    @Test
    public void failToGetDecisionRequirementsDiagramNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.getDecisionRequirementsDiagram(this.decisionRequirementsDefinitionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the decision requirements definition");
    }

    @Test
    public void getDecisionDiagramWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getDecisionRequirementsDiagram(this.decisionRequirementsDefinitionId);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
    }

    @Test
    public void getDecisionDiagramDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getDecisionRequirementsDiagram(this.decisionRequirementsDefinitionId);
        Assertions.assertThat((InputStream)inputStream).isNotNull();
    }
}

