/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanValidationException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationIntermediateConditionalEventTest {
    public static final BpmnModelInstance ONE_CONDITION_PROCESS = ((ConditionalEventDefinitionBuilder)ProcessModels.newModel().startEvent().intermediateCatchEvent("conditionCatch").conditionalEventDefinition("test").condition("${variable == 1}")).conditionalEventDefinitionDone().userTask("userTask").endEvent().done();
    protected static final String VAR_NAME = "variable";
    protected static final String NEW_CONDITION_ID = "newCondition";
    protected static final String NEW_VAR_CONDITION = "${variable == 2}";
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testMigrateEventSubscription() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ONE_CONDITION_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ONE_CONDITION_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("conditionCatch", "conditionCatch").updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("conditionCatch", "conditionCatch", null);
        this.testHelper.setVariable(processInstance.getId(), VAR_NAME, "1");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testMigrateConditionalEventWithoutUpdateTrigger() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ONE_CONDITION_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ONE_CONDITION_PROCESS);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("conditionCatch", "conditionCatch").build()).isInstanceOf(MigrationPlanValidationException.class)).hasMessageContaining("Conditional event has to migrate with update event trigger.");
    }

    @Test
    public void testMigrateEventSubscriptionChangeCondition() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ONE_CONDITION_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((ConditionalEventDefinitionBuilder)Bpmn.createExecutableProcess().startEvent().intermediateCatchEvent(NEW_CONDITION_ID).conditionalEventDefinition().condition(NEW_VAR_CONDITION)).conditionalEventDefinitionDone().userTask("userTask").done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("conditionCatch", NEW_CONDITION_ID).updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("conditionCatch", NEW_CONDITION_ID, null);
        this.testHelper.setVariable(processInstance.getId(), VAR_NAME, "1");
        Assert.assertNull((Object)this.rule.getTaskService().createTaskQuery().singleResult());
        this.testHelper.setVariable(processInstance.getId(), VAR_NAME, "2");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }
}

