/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration.batch;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.bpmn.multiinstance.DelegateEvent;
import org.camunda.bpm.engine.test.bpmn.multiinstance.DelegateExecutionListener;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BatchMigrationTest {
    protected static final Date TEST_DATE = new Date(1457326800000L);
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected ProcessEngineConfigurationImpl configuration;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected int defaultBatchJobsPerSeed;
    protected int defaultInvocationsPerBatchJob;
    protected boolean defaultEnsureJobDueDateSet;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule).around((TestRule)this.testRule);
    @Parameterized.Parameter(value=0)
    public boolean ensureJobDueDateSet;
    @Parameterized.Parameter(value=1)
    public Date currentTime;

    @Parameterized.Parameters(name="Job DueDate is set: {0}")
    public static Collection<Object[]> scenarios() throws ParseException {
        return Arrays.asList({false, null}, {true, TEST_DATE});
    }

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Before
    public void storeEngineSettings() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.defaultBatchJobsPerSeed = this.configuration.getBatchJobsPerSeed();
        this.defaultInvocationsPerBatchJob = this.configuration.getInvocationsPerBatchJob();
        this.defaultEnsureJobDueDateSet = this.configuration.isEnsureJobDueDateNotNull();
        this.configuration.setEnsureJobDueDateNotNull(this.ensureJobDueDateSet);
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @After
    public void restoreEngineSettings() {
        this.configuration.setBatchJobsPerSeed(this.defaultBatchJobsPerSeed);
        this.configuration.setInvocationsPerBatchJob(this.defaultInvocationsPerBatchJob);
        this.configuration.setEnsureJobDueDateNotNull(this.defaultEnsureJobDueDateSet);
    }

    @Test
    public void testNullMigrationPlan() {
        try {
            this.runtimeService.newMigration(null).processInstanceIds(Collections.singletonList("process")).executeAsync();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"migration plan is null"});
        }
    }

    @Test
    public void testNullProcessInstanceIdsList() {
        ProcessDefinition testProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds((List)null).executeAsync();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"process instance ids is empty"});
        }
    }

    @Test
    public void testProcessInstanceIdsListWithNullValue() {
        ProcessDefinition testProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(Arrays.asList("foo", null, "bar")).executeAsync();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"process instance ids contains null value"});
        }
    }

    @Test
    public void testEmptyProcessInstanceIdsList() {
        ProcessDefinition testProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(Collections.emptyList()).executeAsync();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"process instance ids is empty"});
        }
    }

    @Test
    public void testNullProcessInstanceIdsArray() {
        ProcessDefinition testProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds((String[])null).executeAsync();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"process instance ids is empty"});
        }
    }

    @Test
    public void testProcessInstanceIdsArrayWithNullValue() {
        ProcessDefinition testProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceIds(new String[]{"foo", null, "bar"}).executeAsync();
            Assert.fail((String)"Should not be able to migrate");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"process instance ids contains null value"});
        }
    }

    @Test
    public void testNullProcessInstanceQuery() {
        ProcessDefinition testProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceQuery(null).executeAsync();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"process instance ids is empty"});
        }
    }

    @Test
    public void testEmptyProcessInstanceQuery() {
        ProcessDefinition testProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(testProcessDefinition.getId(), testProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstanceQuery emptyProcessInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        Assert.assertEquals((long)0L, (long)emptyProcessInstanceQuery.count());
        try {
            this.runtimeService.newMigration(migrationPlan).processInstanceQuery(emptyProcessInstanceQuery).executeAsync();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"process instance ids is empty"});
        }
    }

    @Test
    public void testBatchCreation() {
        Batch batch = this.helper.migrateProcessInstancesAsync(15);
        this.assertBatchCreated(batch, 15);
    }

    @Test
    public void testSeedJobCreation() {
        ClockUtil.setCurrentTime((Date)TEST_DATE);
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        Assert.assertNotNull((Object)seedJobDefinition);
        Assert.assertEquals((Object)batch.getId(), (Object)seedJobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)"batch-seed-job", (Object)seedJobDefinition.getJobType());
        Assert.assertEquals((Object)this.helper.sourceProcessDefinition.getDeploymentId(), (Object)seedJobDefinition.getDeploymentId());
        JobDefinition migrationJobDefinition = this.helper.getExecutionJobDefinition(batch);
        Assert.assertNotNull((Object)migrationJobDefinition);
        Assert.assertEquals((Object)"instance-migration", (Object)migrationJobDefinition.getJobType());
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertNotNull((Object)seedJob);
        Assert.assertEquals((Object)seedJobDefinition.getId(), (Object)seedJob.getJobDefinitionId());
        Assert.assertEquals((Object)this.currentTime, (Object)seedJob.getDuedate());
        Assert.assertEquals((Object)seedJobDefinition.getDeploymentId(), (Object)seedJob.getDeploymentId());
        Assert.assertNull((Object)seedJob.getProcessDefinitionId());
        Assert.assertNull((Object)seedJob.getProcessDefinitionKey());
        Assert.assertNull((Object)seedJob.getProcessInstanceId());
        Assert.assertNull((Object)seedJob.getExecutionId());
        List<Job> migrationJobs = this.helper.getExecutionJobs(batch);
        Assert.assertEquals((long)0L, (long)migrationJobs.size());
    }

    @Test
    public void testMigrationJobsCreation() {
        ClockUtil.setCurrentTime((Date)TEST_DATE);
        this.engineRule.getProcessEngineConfiguration().setBatchJobsPerSeed(10);
        Batch batch = this.helper.migrateProcessInstancesAsync(20);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        JobDefinition migrationJobDefinition = this.helper.getExecutionJobDefinition(batch);
        String sourceDeploymentId = this.helper.getSourceProcessDefinition().getDeploymentId();
        this.helper.executeSeedJob(batch);
        List<Job> migrationJobs = this.helper.getJobsForDefinition(migrationJobDefinition);
        Assert.assertEquals((long)10L, (long)migrationJobs.size());
        for (Job migrationJob : migrationJobs) {
            Assert.assertEquals((Object)migrationJobDefinition.getId(), (Object)migrationJob.getJobDefinitionId());
            Assert.assertEquals((Object)this.currentTime, (Object)migrationJob.getDuedate());
            Assert.assertEquals((Object)sourceDeploymentId, (Object)migrationJob.getDeploymentId());
            Assert.assertNull((Object)migrationJob.getProcessDefinitionId());
            Assert.assertNull((Object)migrationJob.getProcessDefinitionKey());
            Assert.assertNull((Object)migrationJob.getProcessInstanceId());
            Assert.assertNull((Object)migrationJob.getExecutionId());
        }
        Job seedJob = this.helper.getJobForDefinition(seedJobDefinition);
        Assert.assertNotNull((Object)seedJob);
    }

    @Test
    public void testMonitorJobCreation() {
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        this.helper.completeSeedJobs(batch);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        Assert.assertNotNull((Object)seedJobDefinition);
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertNull((Object)seedJob);
        JobDefinition monitorJobDefinition = this.helper.getMonitorJobDefinition(batch);
        Assert.assertNotNull((Object)monitorJobDefinition);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertNotNull((Object)monitorJob);
    }

    @Test
    public void testMigrationJobsExecution() {
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        this.helper.completeSeedJobs(batch);
        List<Job> migrationJobs = this.helper.getExecutionJobs(batch);
        for (Job migrationJob : migrationJobs) {
            this.helper.executeJob(migrationJob);
        }
        Assert.assertEquals((long)0L, (long)this.helper.countSourceProcessInstances());
        Assert.assertEquals((long)10L, (long)this.helper.countTargetProcessInstances());
        Assert.assertEquals((long)0L, (long)this.helper.getExecutionJobs(batch).size());
        Assert.assertNotNull((Object)this.helper.getMonitorJob(batch));
    }

    @Test
    @RequiredDatabase(excludes={"cockroachdb"})
    public void testMigrationJobsExecutionByJobExecutorWithAuthorizationEnabledAndTenant() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        processEngineConfiguration.setAuthorizationEnabled(true);
        try {
            Batch batch = this.helper.migrateProcessInstancesAsyncForTenant(10, "someTenantId");
            this.helper.completeSeedJobs(batch);
            this.testRule.waitForJobExecutorToProcessAllJobs();
            Assert.assertEquals((long)0L, (long)this.helper.countSourceProcessInstances());
            Assert.assertEquals((long)10L, (long)this.helper.countTargetProcessInstances());
        }
        finally {
            processEngineConfiguration.setAuthorizationEnabled(false);
        }
    }

    @Test
    @RequiredDatabase(includes={"cockroachdb"})
    public void testMigrationJobsExecutionByJobExecutorWithAuthorizationEnabledAndTenantUsesCockroachDB() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        processEngineConfiguration.setAuthorizationEnabled(true);
        try {
            Batch batch = this.helper.migrateProcessInstancesAsyncForTenant(10, "someTenantId");
            this.helper.completeSeedJobs(batch);
            this.testRule.waitForJobExecutorToProcessAllJobs(30000L);
            Assert.assertEquals((long)0L, (long)this.helper.countSourceProcessInstances());
            Assert.assertEquals((long)10L, (long)this.helper.countTargetProcessInstances());
        }
        finally {
            processEngineConfiguration.setAuthorizationEnabled(false);
        }
    }

    @Test
    public void testNumberOfJobsCreatedBySeedJobPerInvocation() {
        int batchJobsPerSeed = 10;
        this.engineRule.getProcessEngineConfiguration().setBatchJobsPerSeed(10);
        Batch batch = this.helper.migrateProcessInstancesAsync(batchJobsPerSeed * 2 + 4);
        this.helper.executeSeedJob(batch);
        Assert.assertEquals((long)batch.getBatchJobsPerSeed(), (long)this.helper.getExecutionJobs(batch).size());
        this.helper.executeSeedJob(batch);
        Assert.assertEquals((long)(2 * batch.getBatchJobsPerSeed()), (long)this.helper.getExecutionJobs(batch).size());
        this.helper.executeSeedJob(batch);
        Assert.assertEquals((long)(2 * batch.getBatchJobsPerSeed() + 4), (long)this.helper.getExecutionJobs(batch).size());
        Assert.assertNull((Object)this.helper.getSeedJob(batch));
    }

    @Test
    public void testDefaultBatchConfiguration() {
        ProcessEngineConfigurationImpl configuration = this.engineRule.getProcessEngineConfiguration();
        Assert.assertEquals((long)100L, (long)configuration.getBatchJobsPerSeed());
        Assert.assertEquals((long)1L, (long)configuration.getInvocationsPerBatchJob());
        Assert.assertEquals((long)30L, (long)configuration.getBatchPollTime());
    }

    @Test
    public void testCustomNumberOfJobsCreateBySeedJob() {
        ProcessEngineConfigurationImpl configuration = this.engineRule.getProcessEngineConfiguration();
        configuration.setBatchJobsPerSeed(2);
        configuration.setInvocationsPerBatchJob(5);
        Batch batch = this.helper.migrateProcessInstancesAsync(20);
        Assert.assertEquals((long)2L, (long)batch.getBatchJobsPerSeed());
        Assert.assertEquals((long)5L, (long)batch.getInvocationsPerBatchJob());
        Assert.assertEquals((long)4L, (long)batch.getTotalJobs());
        this.helper.executeSeedJob(batch);
        Assert.assertEquals((long)2L, (long)this.helper.getExecutionJobs(batch).size());
        this.helper.executeSeedJob(batch);
        Assert.assertEquals((long)4L, (long)this.helper.getExecutionJobs(batch).size());
        Assert.assertNull((Object)this.helper.getSeedJob(batch));
    }

    @Test
    public void testMonitorJobPollingForCompletion() {
        ClockUtil.setCurrentTime((Date)TEST_DATE);
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        Date createDate = TEST_DATE;
        this.helper.completeSeedJobs(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertNotNull((Object)monitorJob);
        Assert.assertEquals((Object)this.currentTime, (Object)monitorJob.getDuedate());
        this.helper.executeMonitorJob(batch);
        monitorJob = this.helper.getMonitorJob(batch);
        Date dueDate = this.helper.addSeconds(createDate, 30);
        Assert.assertEquals((Object)dueDate, (Object)monitorJob.getDuedate());
    }

    @Test
    public void testMonitorJobRemovesBatchAfterCompletion() {
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        this.helper.executeMonitorJob(batch);
        Assert.assertEquals((long)0L, (long)this.managementService.createBatchQuery().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Test
    public void testBatchDeletionWithCascade() {
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        this.helper.completeSeedJobs(batch);
        this.managementService.deleteBatch(batch.getId(), true);
        Assert.assertEquals((long)0L, (long)this.managementService.createBatchQuery().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Test
    public void testBatchDeletionWithoutCascade() {
        Batch batch = this.helper.migrateProcessInstancesAsync(10);
        this.helper.completeSeedJobs(batch);
        this.managementService.deleteBatch(batch.getId(), false);
        Assert.assertEquals((long)0L, (long)this.managementService.createBatchQuery().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Test
    public void testBatchWithFailedSeedJobDeletionWithCascade() {
        Batch batch = this.helper.migrateProcessInstancesAsync(2);
        Job seedJob = this.helper.getSeedJob(batch);
        this.managementService.setJobRetries(seedJob.getId(), 0);
        this.managementService.deleteBatch(batch.getId(), true);
        long historicIncidents = this.historyService.createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    @Test
    public void testBatchWithFailedMigrationJobDeletionWithCascade() {
        Batch batch = this.helper.migrateProcessInstancesAsync(2);
        this.helper.completeSeedJobs(batch);
        List<Job> migrationJobs = this.helper.getExecutionJobs(batch);
        for (Job migrationJob : migrationJobs) {
            this.managementService.setJobRetries(migrationJob.getId(), 0);
        }
        this.managementService.deleteBatch(batch.getId(), true);
        long historicIncidents = this.historyService.createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    @Test
    public void testBatchWithFailedMonitorJobDeletionWithCascade() {
        Batch batch = this.helper.migrateProcessInstancesAsync(2);
        this.helper.completeSeedJobs(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        this.managementService.setJobRetries(monitorJob.getId(), 0);
        this.managementService.deleteBatch(batch.getId(), true);
        long historicIncidents = this.historyService.createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    @Test
    public void testBatchExecutionFailureWithMissingProcessInstance() {
        Batch batch = this.helper.migrateProcessInstancesAsync(2);
        this.helper.completeSeedJobs(batch);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        String deletedProcessInstanceId = ((ProcessInstance)processInstances.get(0)).getId();
        this.runtimeService.deleteProcessInstance(deletedProcessInstanceId, "test");
        this.helper.executeJobs(batch);
        Assert.assertEquals((long)0L, (long)this.helper.countSourceProcessInstances());
        Assert.assertEquals((long)1L, (long)this.helper.countTargetProcessInstances());
        List<Job> migrationJobs = this.helper.getExecutionJobs(batch);
        Assert.assertEquals((long)1L, (long)migrationJobs.size());
        Job failedJob = migrationJobs.get(0);
        Assert.assertEquals((long)2L, (long)failedJob.getRetries());
        Assertions.assertThat((String)failedJob.getExceptionMessage()).startsWith((CharSequence)"ENGINE-23003");
        Assertions.assertThat((String)failedJob.getExceptionMessage()).contains(new CharSequence[]{"Process instance '" + deletedProcessInstanceId + "' cannot be migrated"});
    }

    @Test
    public void testBatchCreationWithProcessInstanceQuery() {
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        int processInstanceCount = 15;
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        for (int i = 0; i < processInstanceCount; ++i) {
            runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        }
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstanceQuery sourceProcessInstanceQuery = runtimeService.createProcessInstanceQuery().processDefinitionId(sourceProcessDefinition.getId());
        Assert.assertEquals((long)processInstanceCount, (long)sourceProcessInstanceQuery.count());
        Batch batch = runtimeService.newMigration(migrationPlan).processInstanceQuery(sourceProcessInstanceQuery).executeAsync();
        this.assertBatchCreated(batch, processInstanceCount);
    }

    @Test
    public void testBatchCreationWithOverlappingProcessInstanceIdsAndQuery() {
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        int processInstanceCount = 15;
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < processInstanceCount; ++i) {
            processInstanceIds.add(runtimeService.startProcessInstanceById(sourceProcessDefinition.getId()).getId());
        }
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstanceQuery sourceProcessInstanceQuery = runtimeService.createProcessInstanceQuery().processDefinitionId(sourceProcessDefinition.getId());
        Assert.assertEquals((long)processInstanceCount, (long)sourceProcessInstanceQuery.count());
        Batch batch = runtimeService.newMigration(migrationPlan).processInstanceIds(processInstanceIds).processInstanceQuery(sourceProcessInstanceQuery).executeAsync();
        this.assertBatchCreated(batch, processInstanceCount);
    }

    @Test
    public void testListenerInvocationForNewlyCreatedScope() {
        DelegateEvent.clearEvents();
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").camundaExecutionListenerClass("start", DelegateExecutionListener.class.getName()).done());
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Batch batch = this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        List<DelegateEvent> recordedEvents = DelegateEvent.getEvents();
        Assert.assertEquals((long)1L, (long)recordedEvents.size());
        DelegateEvent event = recordedEvents.get(0);
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)event.getProcessDefinitionId());
        Assert.assertEquals((Object)"subProcess", (Object)event.getCurrentActivityId());
        DelegateEvent.clearEvents();
    }

    @Test
    public void testSkipListenerInvocationForNewlyCreatedScope() {
        DelegateEvent.clearEvents();
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").camundaExecutionListenerClass("start", DelegateExecutionListener.class.getName()).done());
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Batch batch = this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).skipCustomListeners().executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        Assert.assertEquals((long)0L, (long)DelegateEvent.getEvents().size());
    }

    @Test
    public void testIoMappingInvocationForNewlyCreatedScope() {
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").camundaInputParameter("foo", "bar").done());
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Batch batch = this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        VariableInstance inputVariable = (VariableInstance)this.engineRule.getRuntimeService().createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)inputVariable);
        Assert.assertEquals((Object)"foo", (Object)inputVariable.getName());
        Assert.assertEquals((Object)"bar", (Object)inputVariable.getValue());
        ActivityInstance activityInstance = this.engineRule.getRuntimeService().getActivityInstance(processInstance.getId());
        Assert.assertEquals((Object)activityInstance.getActivityInstances("subProcess")[0].getId(), (Object)inputVariable.getActivityInstanceId());
    }

    @Test
    public void testSkipIoMappingInvocationForNewlyCreatedScope() {
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").camundaInputParameter("foo", "bar").done());
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Batch batch = this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).skipIoMappings().executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        Assert.assertEquals((long)0L, (long)this.engineRule.getRuntimeService().createVariableInstanceQuery().count());
    }

    @Test
    public void testUpdateEventTrigger() {
        String newMessageName = "newMessage";
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_RECEIVE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_RECEIVE_TASK_PROCESS).renameMessage("Message", newMessageName));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().updateEventTriggers().build();
        Batch batch = this.runtimeService.newMigration(migrationPlan).processInstanceIds(Collections.singletonList(processInstance.getId())).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertEquals((Object)newMessageName, (Object)eventSubscription.getEventName());
    }

    @Test
    public void testDeleteBatchJobManually() {
        Batch batch = this.helper.createMigrationBatchWithSize(1);
        this.helper.completeSeedJobs(batch);
        JobEntity migrationJob = (JobEntity)this.helper.getExecutionJobs(batch).get(0);
        String byteArrayId = migrationJob.getJobHandlerConfigurationRaw();
        ByteArrayEntity byteArrayEntity = (ByteArrayEntity)this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(byteArrayId));
        Assert.assertNotNull((Object)byteArrayEntity);
        this.managementService.deleteJob(migrationJob.getId());
        byteArrayEntity = (ByteArrayEntity)this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(byteArrayId));
        Assert.assertNull((Object)byteArrayEntity);
    }

    @Test
    public void testMigrateWithVarargsArray() {
        ProcessDefinition sourceDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.migrationRule.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceById(sourceDefinition.getId());
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceById(sourceDefinition.getId());
        Batch batch = this.runtimeService.newMigration(migrationPlan).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        this.helper.executeMonitorJob(batch);
        Assert.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionId(targetDefinition.getId()).count());
    }

    @Test
    public void shouldSetInvocationsPerBatchType() {
        this.configuration.getInvocationsPerBatchJobByBatchType().put("instance-migration", 42);
        Batch batch = this.helper.migrateProcessInstancesAsync(15);
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.configuration.setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldSetExecutionStartTimeInBatchAndHistory() {
        ClockUtil.setCurrentTime((Date)TEST_DATE);
        Batch batch = this.helper.migrateProcessInstancesAsync(15);
        this.helper.executeSeedJob(batch);
        List<Job> executionJobs = this.helper.getExecutionJobs(batch);
        this.helper.executeJob(executionJobs.get(0));
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        batch = (Batch)this.managementService.createBatchQuery().singleResult();
        Assertions.assertThat((Date)batch.getExecutionStartTime()).isEqualToIgnoringMillis(TEST_DATE);
        Assertions.assertThat((Date)historicBatch.getExecutionStartTime()).isEqualToIgnoringMillis(TEST_DATE);
    }

    protected void assertBatchCreated(Batch batch, int processInstanceCount) {
        Assert.assertNotNull((Object)batch);
        Assert.assertNotNull((Object)batch.getId());
        Assert.assertEquals((Object)"instance-migration", (Object)batch.getType());
        Assert.assertEquals((long)processInstanceCount, (long)batch.getTotalJobs());
        Assert.assertEquals((long)this.defaultBatchJobsPerSeed, (long)batch.getBatchJobsPerSeed());
        Assert.assertEquals((long)this.defaultInvocationsPerBatchJob, (long)batch.getInvocationsPerBatchJob());
    }

    public class GetByteArrayCommand
    implements Command<ByteArrayEntity> {
        protected String byteArrayId;

        public GetByteArrayCommand(String byteArrayId) {
            this.byteArrayId = byteArrayId;
        }

        public ByteArrayEntity execute(CommandContext commandContext) {
            return (ByteArrayEntity)commandContext.getDbEntityManager().selectOne("selectByteArray", (Object)this.byteArrayId);
        }
    }
}

