/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH
 * under one or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership. Camunda licenses this file to you under the Apache License,
 * Version 2.0; you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.engine.impl.batch;

import java.util.Date;
import java.util.List;

public class SetJobRetriesBatchConfiguration extends SetRetriesBatchConfiguration {

  protected Date dueDate;
  protected boolean isDueDateSet;

  public SetJobRetriesBatchConfiguration(List<String> ids, int retries, Date dueDate, boolean isDueDateSet) {
    this(ids, null, retries, dueDate, isDueDateSet);
  }

  public SetJobRetriesBatchConfiguration(List<String> ids, DeploymentMappings mappings, int retries, Date dueDate, boolean isDueDateSet) {
    super(ids, mappings, retries);
    this.dueDate = dueDate;
    this.isDueDateSet = isDueDateSet;
  }

  public Date getDueDate() {
    return dueDate;
  }

  public void setDueDate(Date dueDate) {
    isDueDateSet = true;
    this.dueDate = dueDate;
  }

  public boolean isDueDateSet() {
    return isDueDateSet;
  }

}
