/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.externaltask;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.ibatis.jdbc.RuntimeSqlException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryBuilder;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricExternalTaskLogQuery;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.externaltask.ExternalTaskCustomValue;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.AssertUtil;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExternalTaskServiceTest
extends PluggableProcessEngineTest {
    protected static final String WORKER_ID = "aWorkerId";
    protected static final long LOCK_TIME = 10000L;
    protected static final String TOPIC_NAME = "externalTaskTopic";
    protected static final String ERROR_MESSAGE = "error message";
    protected static final String ERROR_DETAILS = "error details";
    protected SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy - HH:mm:ss");

    @Before
    public void setUp() throws Exception {
        Date now = this.formatter.parse(this.formatter.format(new Date()));
        ClockUtil.setCurrentTime((Date)now);
    }

    @After
    public void tearDown() throws Exception {
        ClockUtil.reset();
    }

    @Test
    public void testFailOnMalformedpriorityInput() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/externaltask/externalTaskInvalidPriority.bpmn20.xml").deploy();
            Assert.fail((String)"deploying a process with malformed priority should not succeed");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresentIgnoreCase("value 'NOTaNumber' for attribute 'taskPriority' is not a valid number", e.getMessage());
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"externalTaskWithPrio");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetch() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        Assert.assertNotNull((Object)task.getId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)task.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)task.getProcessDefinitionId());
        Assert.assertEquals((Object)"externalTask", (Object)task.getActivityId());
        Assert.assertEquals((Object)"oneExternalTaskProcess", (Object)task.getProcessDefinitionKey());
        Assert.assertEquals((Object)TOPIC_NAME, (Object)task.getTopicName());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId()).getActivityInstances("externalTask")[0];
        Assert.assertEquals((Object)activityInstance.getId(), (Object)task.getActivityInstanceId());
        Assert.assertEquals((Object)activityInstance.getExecutionIds()[0], (Object)task.getExecutionId());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), task.getLockExpirationTime());
        Assert.assertEquals((Object)WORKER_ID, (Object)task.getWorkerId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskWithPriorityProcess.bpmn20.xml"})
    @Test
    public void testFetchWithPriority() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        Assert.assertNotNull((Object)task.getId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)task.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)task.getProcessDefinitionId());
        Assert.assertEquals((Object)"externalTaskWithPrio", (Object)task.getActivityId());
        Assert.assertEquals((Object)"twoExternalTaskWithPriorityProcess", (Object)task.getProcessDefinitionKey());
        Assert.assertEquals((Object)TOPIC_NAME, (Object)task.getTopicName());
        Assert.assertEquals((long)7L, (long)task.getPriority());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId()).getActivityInstances("externalTaskWithPrio")[0];
        Assert.assertEquals((Object)activityInstance.getId(), (Object)task.getActivityInstanceId());
        Assert.assertEquals((Object)activityInstance.getExecutionIds()[0], (Object)task.getExecutionId());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), task.getLockExpirationTime());
        Assert.assertEquals((Object)WORKER_ID, (Object)task.getWorkerId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityProcess.bpmn20.xml"})
    @Test
    public void testFetchProcessWithPriority() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(2, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)2L, (long)externalTasks.size());
        Assert.assertEquals((long)9L, (long)((LockedExternalTask)externalTasks.get(0)).getPriority());
        Assert.assertEquals((long)7L, (long)((LockedExternalTask)externalTasks.get(1)).getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpressionProcess.bpmn20.xml"})
    @Test
    public void testFetchProcessWithPriorityExpression() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", (Map)Variables.createVariables().putValue("priority", (Object)18));
        List externalTasks = this.externalTaskService.fetchAndLock(2, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)2L, (long)externalTasks.size());
        Assert.assertEquals((long)18L, (long)((LockedExternalTask)externalTasks.get(0)).getPriority());
        Assert.assertEquals((long)7L, (long)((LockedExternalTask)externalTasks.get(1)).getPriority());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml"})
    @Test
    public void testFetchWithPriorityExpression() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", (Map)Variables.createVariables().putValue("priority", (Object)18));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        Assert.assertNotNull((Object)task.getId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)task.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)task.getProcessDefinitionId());
        Assert.assertEquals((Object)"externalTaskWithPrio", (Object)task.getActivityId());
        Assert.assertEquals((Object)"twoExternalTaskWithPriorityProcess", (Object)task.getProcessDefinitionKey());
        Assert.assertEquals((Object)TOPIC_NAME, (Object)task.getTopicName());
        Assert.assertEquals((long)18L, (long)task.getPriority());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId()).getActivityInstances("externalTaskWithPrio")[0];
        Assert.assertEquals((Object)activityInstance.getId(), (Object)task.getActivityInstanceId());
        Assert.assertEquals((Object)activityInstance.getExecutionIds()[0], (Object)task.getExecutionId());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), task.getLockExpirationTime());
        Assert.assertEquals((Object)WORKER_ID, (Object)task.getWorkerId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskWithPriorityProcess.bpmn20.xml"})
    @Test
    public void testFetchWithPriorityOrdering() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(2, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)2L, (long)externalTasks.size());
        Assert.assertTrue((((LockedExternalTask)externalTasks.get(0)).getPriority() > ((LockedExternalTask)externalTasks.get(1)).getPriority() ? 1 : 0) != 0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskWithPriorityProcess.bpmn20.xml"})
    @Test
    public void testFetchNextWithPriority() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        long firstPrio = task.getPriority();
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), task.getLockExpirationTime());
        externalTasks = this.externalTaskService.fetchAndLock(1, "anotherWorkerId", true).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        Assert.assertTrue((firstPrio >= ((LockedExternalTask)externalTasks.get(0)).getPriority() ? 1 : 0) != 0);
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        Assert.assertEquals((long)firstPrio, (long)((LockedExternalTask)externalTasks.get(0)).getPriority());
    }

    @Deployment
    @Test
    public void testFetchTopicSelection() {
        this.runtimeService.startProcessInstanceByKey("twoTopicsProcess");
        List topic1Tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).execute();
        List topic2Tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic2", 10000L).execute();
        Assert.assertEquals((long)1L, (long)topic1Tasks.size());
        Assert.assertEquals((Object)"topic1", (Object)((LockedExternalTask)topic1Tasks.get(0)).getTopicName());
        Assert.assertEquals((long)1L, (long)topic2Tasks.size());
        Assert.assertEquals((Object)"topic2", (Object)((LockedExternalTask)topic2Tasks.get(0)).getTopicName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchWithoutTopicName() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(null, 10000L).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("topicName is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchNullWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(1, null).topic(TOPIC_NAME, 10000L).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("workerId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchNegativeNumberOfTasks() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(-1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("maxResults is not greater than or equal to 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchLessTasksThanExist() {
        for (int i = 0; i < 10; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        }
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)5L, (long)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchNegativeLockTime() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, -1L).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("lockTime is not greater than 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchZeroLockTime() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        try {
            this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 0L).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("lockTime is not greater than 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchNoTopics() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).execute();
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Deployment
    @Test
    public void testFetchVariables() {
        this.runtimeService.startProcessInstanceByKey("subProcessExternalTask", (Map)Variables.createVariables().putValue("processVar1", (Object)42).putValue("processVar2", (Object)43));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).variables(new String[]{"processVar1", "subProcessVar", "taskVar"}).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        VariableMap variables = task.getVariables();
        Assert.assertEquals((long)3L, (long)variables.size());
        Assert.assertEquals((Object)42, (Object)variables.get((Object)"processVar1"));
        Assert.assertEquals((Object)44L, (Object)variables.get((Object)"subProcessVar"));
        Assert.assertEquals((Object)45L, (Object)variables.get((Object)"taskVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchVariables.bpmn20.xml"})
    @Test
    public void testShouldNotFetchSerializedVariables() {
        ExternalTaskCustomValue customValue = new ExternalTaskCustomValue();
        customValue.setTestValue("value1");
        this.runtimeService.startProcessInstanceByKey("subProcessExternalTask", (Map)Variables.createVariables().putValue("processVar1", (Object)customValue));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).variables(new String[]{"processVar1"}).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        VariableMap variables = task.getVariables();
        Assert.assertEquals((long)1L, (long)variables.size());
        try {
            variables.get((Object)"processVar1");
            Assert.fail((String)"did not receive an exception although variable was serialized");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"Object is not deserialized.", (Object)e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchVariables.bpmn20.xml"})
    @Test
    public void testFetchSerializedVariables() {
        ExternalTaskCustomValue customValue = new ExternalTaskCustomValue();
        customValue.setTestValue("value1");
        this.runtimeService.startProcessInstanceByKey("subProcessExternalTask", (Map)Variables.createVariables().putValue("processVar1", (Object)customValue));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).variables(new String[]{"processVar1"}).enableCustomObjectDeserialization().execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        VariableMap variables = task.getVariables();
        Assert.assertEquals((long)1L, (long)variables.size());
        ExternalTaskCustomValue receivedCustomValue = (ExternalTaskCustomValue)variables.get((Object)"processVar1");
        Assert.assertNotNull((Object)receivedCustomValue);
        Assert.assertNotNull((Object)receivedCustomValue.getTestValue());
        Assert.assertEquals((Object)"value1", (Object)receivedCustomValue.getTestValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskVariablesTest.testExternalTaskVariablesLocal.bpmn20.xml"})
    @Test
    public void testFetchOnlyLocalVariables() {
        VariableMap globalVars = Variables.putValue((String)"globalVar", (Object)"globalVal");
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", (Map)globalVars);
        String workerId = "workerId";
        String topicName = "testTopic";
        List lockedExternalTasks = this.externalTaskService.fetchAndLock(10, "workerId").topic("testTopic", 60000L).execute();
        Assert.assertEquals((long)1L, (long)lockedExternalTasks.size());
        LockedExternalTask lockedExternalTask = (LockedExternalTask)lockedExternalTasks.get(0);
        VariableMap variables = lockedExternalTask.getVariables();
        Assert.assertEquals((long)2L, (long)variables.size());
        Assert.assertEquals((Object)"globalVal", (Object)variables.getValue("globalVar", String.class));
        Assert.assertEquals((Object)"localVal", (Object)variables.getValue("localVar", String.class));
        this.externalTaskService.unlock(lockedExternalTask.getId());
        lockedExternalTasks = this.externalTaskService.fetchAndLock(10, "workerId").topic("testTopic", 60000L).variables(new String[]{"globalVar", "localVar"}).localVariables().execute();
        Assert.assertEquals((long)1L, (long)lockedExternalTasks.size());
        lockedExternalTask = (LockedExternalTask)lockedExternalTasks.get(0);
        variables = lockedExternalTask.getVariables();
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"localVal", (Object)variables.getValue("localVar", String.class));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskVariablesTest.testExternalTaskVariablesLocal.bpmn20.xml"})
    @Test
    public void testFetchNonExistingLocalVariables() {
        VariableMap globalVars = Variables.putValue((String)"globalVar", (Object)"globalVal");
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", (Map)globalVars);
        String workerId = "workerId";
        String topicName = "testTopic";
        List lockedExternalTasks = this.externalTaskService.fetchAndLock(10, "workerId").topic("testTopic", 60000L).variables(new String[]{"globalVar", "nonExistingLocalVar"}).localVariables().execute();
        Assert.assertEquals((long)1L, (long)lockedExternalTasks.size());
        LockedExternalTask lockedExternalTask = (LockedExternalTask)lockedExternalTasks.get(0);
        VariableMap variables = lockedExternalTask.getVariables();
        Assert.assertEquals((long)0L, (long)variables.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchVariables.bpmn20.xml"})
    @Test
    public void testFetchAllVariables() {
        this.runtimeService.startProcessInstanceByKey("subProcessExternalTask", (Map)Variables.createVariables().putValue("processVar1", (Object)42).putValue("processVar2", (Object)43));
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.verifyVariables(task);
        this.runtimeService.startProcessInstanceByKey("subProcessExternalTask", (Map)Variables.createVariables().putValue("processVar1", (Object)42).putValue("processVar2", (Object)43));
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).variables((String[])null).execute();
        task = (LockedExternalTask)externalTasks.get(0);
        this.verifyVariables(task);
        this.runtimeService.startProcessInstanceByKey("subProcessExternalTask", (Map)Variables.createVariables().putValue("processVar1", (Object)42).putValue("processVar2", (Object)43));
        List list = null;
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).variables(list).execute();
        task = (LockedExternalTask)externalTasks.get(0);
        this.verifyVariables(task);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchNonExistingVariable() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).variables(new String[]{"nonExistingVariable"}).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        Assert.assertTrue((boolean)task.getVariables().isEmpty());
    }

    @Deployment
    @Test
    public void testFetchMultipleTopics() {
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).topic("topic2", 20000L).execute();
        Assert.assertEquals((long)2L, (long)tasks.size());
        LockedExternalTask topic1Task = "topic1".equals(((LockedExternalTask)tasks.get(0)).getTopicName()) ? (LockedExternalTask)tasks.get(0) : (LockedExternalTask)tasks.get(1);
        LockedExternalTask topic2Task = "topic2".equals(((LockedExternalTask)tasks.get(0)).getTopicName()) ? (LockedExternalTask)tasks.get(0) : (LockedExternalTask)tasks.get(1);
        Assert.assertEquals((Object)"topic1", (Object)topic1Task.getTopicName());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), topic1Task.getLockExpirationTime());
        Assert.assertEquals((Object)"topic2", (Object)topic2Task.getTopicName());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(20000L), topic2Task.getLockExpirationTime());
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).topic("topic2", 20000L).topic("topic3", 30000L).execute();
        Assert.assertEquals((long)1L, (long)tasks.size());
        LockedExternalTask topic3Task = (LockedExternalTask)tasks.get(0);
        Assert.assertEquals((Object)"topic3", (Object)topic3Task.getTopicName());
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(30000L), topic3Task.getLockExpirationTime());
    }

    @Deployment
    @Test
    public void testFetchMultipleTopicsWithVariables() {
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", (Map)Variables.createVariables().putValue("var1", (Object)0).putValue("var2", (Object)0));
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).variables(new String[]{"var1", "var2"}).topic("topic2", 10000L).variables(new String[]{"var1"}).execute();
        LockedExternalTask topic1Task = "topic1".equals(((LockedExternalTask)tasks.get(0)).getTopicName()) ? (LockedExternalTask)tasks.get(0) : (LockedExternalTask)tasks.get(1);
        LockedExternalTask topic2Task = "topic2".equals(((LockedExternalTask)tasks.get(0)).getTopicName()) ? (LockedExternalTask)tasks.get(0) : (LockedExternalTask)tasks.get(1);
        Assert.assertEquals((Object)"topic1", (Object)topic1Task.getTopicName());
        Assert.assertEquals((Object)"topic2", (Object)topic2Task.getTopicName());
        VariableMap topic1Variables = topic1Task.getVariables();
        Assert.assertEquals((long)2L, (long)topic1Variables.size());
        Assert.assertEquals((Object)1L, (Object)topic1Variables.get((Object)"var1"));
        Assert.assertEquals((Object)1L, (Object)topic1Variables.get((Object)"var2"));
        VariableMap topic2Variables = topic2Task.getVariables();
        Assert.assertEquals((long)1L, (long)topic2Variables.size());
        Assert.assertEquals((Object)2L, (Object)topic2Variables.get((Object)"var1"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchMultipleTopics.bpmn20.xml"})
    @Test
    public void testFetchMultipleTopicsMaxTasks() {
        for (int i = 0; i < 10; ++i) {
            this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess");
        }
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("topic1", 10000L).topic("topic2", 10000L).topic("topic3", 10000L).execute();
        Assert.assertEquals((long)5L, (long)tasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchSuspendedTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchAndLockWithInitialBuilder() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTaskQueryBuilder initialBuilder = this.externalTaskService.fetchAndLock(1, WORKER_ID);
        initialBuilder.topic(TOPIC_NAME, 10000L);
        List tasks = initialBuilder.execute();
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityProcess.bpmn20.xml"})
    @Test
    public void testFetchByProcessDefinitionId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess");
        String processDefinitionId2 = processInstance2.getProcessDefinitionId();
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).processDefinitionId(processDefinitionId2).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        Assert.assertEquals((Object)processDefinitionId2, (Object)((LockedExternalTask)externalTasks.get(0)).getProcessDefinitionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchByProcessDefinitionIdCombination() {
        String topicName1 = "topic1";
        String topicName2 = "topic2";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        Long lockDuration = 60000L;
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey1);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey2);
        String processDefinitionId2 = processInstance2.getProcessDefinitionId();
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).topic(topicName2, lockDuration.longValue()).processDefinitionId(processDefinitionId2).execute();
        Assert.assertEquals((long)3L, (long)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
            if (externalTask.getTopicName().equals(topicName1)) {
                Assert.assertEquals((Object)pi.getProcessDefinitionId(), (Object)externalTask.getProcessDefinitionId());
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                Assert.assertEquals((Object)processDefinitionId2, (Object)pi.getProcessDefinitionId());
                Assert.assertEquals((Object)processDefinitionId2, (Object)externalTask.getProcessDefinitionId());
                continue;
            }
            Assert.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchByProcessDefinitionIdIn() {
        String topicName1 = "topic1";
        String topicName2 = "topic2";
        String topicName3 = "topic3";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        String businessKey3 = "testBusinessKey3";
        Long lockDuration = 60000L;
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey1);
        String processDefinitionId1 = processInstance1.getProcessDefinitionId();
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey2);
        String processDefinitionId2 = processInstance2.getProcessDefinitionId();
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey3);
        String processDefinitionId3 = processInstance3.getProcessDefinitionId();
        List topicTasks = this.externalTaskService.fetchAndLock(2, "externalWorkerId").topic(topicName1, lockDuration.longValue()).processDefinitionIdIn(new String[]{processDefinitionId1}).processDefinitionKey("parallelExternalTaskProcess").topic(topicName2, lockDuration.longValue()).processDefinitionId(processDefinitionId2).businessKey(businessKey2).topic(topicName3, lockDuration.longValue()).processDefinitionId(processDefinitionId3).processDefinitionKeyIn(new String[]{"unexisting"}).execute();
        Assert.assertEquals((long)2L, (long)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
            if (externalTask.getTopicName().equals(topicName1)) {
                Assert.assertEquals((Object)processDefinitionId1, (Object)pi.getProcessDefinitionId());
                Assert.assertEquals((Object)processDefinitionId1, (Object)externalTask.getProcessDefinitionId());
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                Assert.assertEquals((Object)processDefinitionId2, (Object)pi.getProcessDefinitionId());
                Assert.assertEquals((Object)processDefinitionId2, (Object)externalTask.getProcessDefinitionId());
                continue;
            }
            Assert.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityProcess.bpmn20.xml"})
    @Test
    public void testFetchByProcessDefinitionIds() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        String processDefinitionId1 = processInstance1.getProcessDefinitionId();
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess");
        String processDefinitionId2 = processInstance2.getProcessDefinitionId();
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).processDefinitionId(processDefinitionId2).processDefinitionIdIn(new String[]{processDefinitionId1}).execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityProcess.bpmn20.xml"})
    @Test
    public void testFetchByProcessDefinitionKey() {
        String processDefinitionKey1 = "oneExternalTaskProcess";
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey1);
        String processDefinitionKey2 = "twoExternalTaskWithPriorityProcess";
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey2);
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).processDefinitionKey(processDefinitionKey2).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        Assert.assertEquals((Object)processDefinitionKey2, (Object)((LockedExternalTask)externalTasks.get(0)).getProcessDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityProcess.bpmn20.xml"})
    @Test
    public void testFetchByProcessDefinitionKeyIn() {
        String processDefinitionKey1 = "oneExternalTaskProcess";
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey1);
        String processDefinitionKey2 = "twoExternalTaskWithPriorityProcess";
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey2);
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).processDefinitionKeyIn(new String[]{processDefinitionKey2}).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        Assert.assertEquals((Object)processDefinitionKey2, (Object)((LockedExternalTask)externalTasks.get(0)).getProcessDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityProcess.bpmn20.xml"})
    @Test
    public void testFetchByProcessDefinitionKeys() {
        String processDefinitionKey1 = "oneExternalTaskProcess";
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey1);
        String processDefinitionKey2 = "twoExternalTaskWithPriorityProcess";
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey2);
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).processDefinitionKey(processDefinitionKey1).processDefinitionKeyIn(new String[]{processDefinitionKey2}).execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchByProcessDefinitionIdAndKey() {
        String topicName1 = "topic1";
        String topicName2 = "topic2";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        String businessKey3 = "testBusinessKey3";
        Long lockDuration = 60000L;
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey1);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey2);
        String processDefinitionId2 = processInstance2.getProcessDefinitionId();
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey3);
        String processDefinitionId3 = processInstance3.getProcessDefinitionId();
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).topic(topicName2, lockDuration.longValue()).processDefinitionIdIn(new String[]{processDefinitionId2, processDefinitionId3}).topic("topic3", lockDuration.longValue()).processDefinitionIdIn(new String[]{"unexisting"}).execute();
        Assert.assertEquals((long)3L, (long)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
            if (externalTask.getTopicName().equals(topicName1)) {
                Assert.assertEquals((Object)pi.getProcessDefinitionId(), (Object)externalTask.getProcessDefinitionId());
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                Assert.assertEquals((Object)processDefinitionId2, (Object)pi.getProcessDefinitionId());
                Assert.assertEquals((Object)processDefinitionId2, (Object)externalTask.getProcessDefinitionId());
                continue;
            }
            Assert.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchWithoutTenant() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).withoutTenantId().execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void shouldLockExternalTask() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().notLocked().singleResult();
        this.externalTaskService.lock(externalTask.getId(), WORKER_ID, 10000L);
        List lockedExternalTasks = this.externalTaskService.createExternalTaskQuery().locked().list();
        Assertions.assertThat((List)lockedExternalTasks).hasSize(1);
        Date lockExpirationTime = new DateTime((Object)ClockUtil.getCurrentTime()).plus(10000L).toDate();
        ExternalTask lockedExternalTask = (ExternalTask)lockedExternalTasks.get(0);
        Assertions.assertThat((String)lockedExternalTask.getWorkerId()).isEqualToIgnoringCase((CharSequence)WORKER_ID);
        Assertions.assertThat((Date)lockedExternalTask.getLockExpirationTime()).isEqualTo((Object)lockExpirationTime);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void shouldLockExternalTaskWithExpiredLock() throws java.text.ParseException {
        String aSecondWorkerId = "aSecondWorkerId";
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().notLocked().singleResult();
        this.externalTaskService.lock(externalTask.getId(), WORKER_ID, 10000L);
        Date lockExpiredTime = this.formatter.parse(this.formatter.format(DateUtils.addMilliseconds((Date)ClockUtil.getCurrentTime(), (int)11000)));
        ClockUtil.setCurrentTime((Date)lockExpiredTime);
        this.externalTaskService.lock(externalTask.getId(), aSecondWorkerId, 10000L);
        List lockedExternalTasks = this.externalTaskService.createExternalTaskQuery().locked().list();
        Assertions.assertThat((List)lockedExternalTasks).hasSize(1);
        Date lockExpirationTime = new DateTime((Object)ClockUtil.getCurrentTime()).plus(10000L).toDate();
        ExternalTask lockedExternalTask = (ExternalTask)lockedExternalTasks.get(0);
        Assertions.assertThat((String)lockedExternalTask.getWorkerId()).isEqualToIgnoringCase((CharSequence)aSecondWorkerId);
        Assertions.assertThat((Date)lockedExternalTask.getLockExpirationTime()).isEqualTo((Object)lockExpirationTime);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void shouldLockAlreadyLockedExternalTaskWithSameWorker() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().notLocked().singleResult();
        this.externalTaskService.lock(externalTask.getId(), WORKER_ID, 10000L);
        ExternalTask externalTaskFirstLock = (ExternalTask)this.externalTaskService.createExternalTaskQuery().locked().singleResult();
        Date firstLockExpirationTime = externalTaskFirstLock.getLockExpirationTime();
        this.externalTaskService.lock(externalTaskFirstLock.getId(), WORKER_ID, 100000L);
        ExternalTask externalTaskSecondLock = (ExternalTask)this.externalTaskService.createExternalTaskQuery().locked().singleResult();
        Date secondLockExpirationTime = externalTaskSecondLock.getLockExpirationTime();
        Assertions.assertThat((Date)firstLockExpirationTime).isBefore(secondLockExpirationTime);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void shouldFailToLockAlreadyLockedExternalTask() {
        String aSecondWorkerId = "aSecondWorkerId";
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().notLocked().singleResult();
        this.externalTaskService.lock(externalTask.getId(), WORKER_ID, 10000L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.externalTaskService.lock(externalTask.getId(), aSecondWorkerId, 10000L)).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("External Task " + externalTask.getId() + " cannot be locked by worker '" + aSecondWorkerId + "'. It is locked by worker '" + WORKER_ID + "'.");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void shouldReportMissingWorkerIdOnLockExternalTask() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().notLocked().singleResult();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.externalTaskService.lock(externalTask.getId(), null, 10000L)).isInstanceOf(NullValueException.class)).hasMessageContaining("workerId is null");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void shouldReportMissingExternalTaskIdOnLockExternalTask() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.externalTaskService.lock(null, WORKER_ID, 10000L)).isInstanceOf(NotFoundException.class)).hasMessageContaining("Cannot find external task with id null: externalTask is null");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void shouldReportNonexistentExternalTaskIdOnLockExternalTask() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.externalTaskService.lock("fakeExternalTaskId", WORKER_ID, 10000L)).isInstanceOf(NotFoundException.class)).hasMessageContaining("Cannot find external task with id fakeExternalTaskId: externalTask is null");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void shouldFailToLockExternalTaskWithNullLockDuration() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.externalTaskService.lock("fakeExternalTaskId", WORKER_ID, 0L)).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("lockDuration is not greater than 0");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void shouldFailToLockExternalTaskWithNegativeLockDuration() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.externalTaskService.lock("fakeExternalTaskId", WORKER_ID, -1L)).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("lockDuration is not greater than 0");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testComplete() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterExternalTask").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testCompleteWithVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, (Map)Variables.createVariables().putValue("var", (Object)42));
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterExternalTask").done());
        Assert.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstance.getId(), "var"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testCompleteWithWrongWorkerId() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), "someCrazyWorkerId");
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent("cannot be completed by worker 'someCrazyWorkerId'. It is locked by worker 'aWorkerId'.", e.getMessage());
        }
    }

    @Test
    public void testCompleteNonExistingTask() {
        try {
            this.externalTaskService.complete("nonExistingTaskId", WORKER_ID);
            Assert.fail((String)"exception expected");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresent("Cannot find external task with id nonExistingTaskId", e.getMessage());
        }
    }

    @Test
    public void testCompleteNullTaskId() {
        try {
            this.externalTaskService.complete(null, WORKER_ID);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot find external task with id " + null, e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testCompleteNullWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        try {
            this.externalTaskService.complete(task.getId(), null);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("workerId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testCompleteSuspendedTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.externalTaskService.complete(task.getId(), WORKER_ID);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("ExternalTask with id '" + task.getId() + "' is suspended", e.getMessage());
        }
        this.testRule.assertProcessNotEnded(processInstance.getId());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        this.externalTaskService.complete(task.getId(), WORKER_ID);
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinition.bpmn20.xml"})
    public void shouldEvaluateNestedErrorEventDefinitionsOnComplete() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.externalTaskService.complete(task.getId(), WORKER_ID);
        List list = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)list).hasSize(1);
        Assertions.assertThat((String)((Task)list.get(0)).getName()).isEqualTo((Object)"userTask");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionVariableExpression.bpmn20.xml"})
    public void shouldEvaluateNestedErrorEventDefinitionsOnCompleteWithVariables() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "bar");
        this.externalTaskService.complete(task.getId(), WORKER_ID, vars);
        List list = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)list).hasSize(1);
        Assertions.assertThat((String)((Task)list.get(0)).getName()).isEqualTo((Object)"userTask");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionVariableExpression.bpmn20.xml"})
    public void shouldEvaluateNestedErrorEventDefinitionsOnCompleteWithLocalVariables() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "bar");
        this.externalTaskService.complete(task.getId(), WORKER_ID, null, vars);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getName()).isEqualTo((Object)"userTask");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionVariableExpression.bpmn20.xml"})
    public void shouldFailNestedErrorEventDefinitionsWhenVariableWasNotProvidedByClientOnComplete() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.externalTaskService.complete(task.getId(), WORKER_ID)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Unknown property used in expression");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionVariableExpression.bpmn20.xml"})
    public void shouldKeepVariablesAfterEvaluateNestedErrorEventDefinitionsOnCompleteWithVariables() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "bar");
        this.externalTaskService.complete(task.getId(), WORKER_ID, vars);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getName()).isEqualTo((Object)"userTask");
        List variables = this.runtimeService.createVariableInstanceQuery().variableName("foo").list();
        Assertions.assertThat((List)variables).hasSize(1);
        Assertions.assertThat((Object)((VariableInstance)variables.get(0)).getValue()).isEqualTo((Object)"bar");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionVariableExpression.bpmn20.xml"})
    public void shouldNotKeepVariablesAfterEvaluateNestedErrorEventDefinitionsOnCompleteWithLocalVariables() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "bar");
        this.externalTaskService.complete(task.getId(), WORKER_ID, null, vars);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getName()).isEqualTo((Object)"userTask");
        List list = this.runtimeService.createVariableInstanceQuery().variableName("foo").list();
        Assertions.assertThat((List)list).hasSize(0);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionTrueAndOutputMapping.bpmn20.xml"})
    public void shouldNotFailOutputMappingAfterNestedErrorEventDefinitionsOnComplete() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "bar");
        this.externalTaskService.complete(task.getId(), WORKER_ID, vars);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getName()).isEqualTo((Object)"userTask");
        List variables = this.runtimeService.createVariableInstanceQuery().variableName("foo").list();
        Assertions.assertThat((List)variables).hasSize(1);
        Assertions.assertThat((Object)((VariableInstance)variables.get(0)).getValue()).isEqualTo((Object)"bar");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionTrueAndOutputMapping.bpmn20.xml"})
    public void shouldFailOutputMappingAfterNestedErrorEventDefinitionsWhenVariableWasNotProvidedByClientOnComplete() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.externalTaskService.complete(task.getId(), WORKER_ID)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Propagation of bpmn error errorCode failed.");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinition.bpmn20.xml"})
    public void shouldEvaluateNestedErrorEventDefinitionsOnFailure() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, 0, 3000L);
        List list = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)list).hasSize(1);
        Assertions.assertThat((String)((Task)list.get(0)).getName()).isEqualTo((Object)"userTask");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionVariableExpression.bpmn20.xml"})
    public void shouldEvaluateNestedErrorEventDefinitionsOnFailWithVariables() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "bar");
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, ERROR_DETAILS, 0, 3000L, vars, null);
        List list = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)list).hasSize(1);
        Assertions.assertThat((String)((Task)list.get(0)).getName()).isEqualTo((Object)"userTask");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionVariableExpression.bpmn20.xml"})
    public void shouldEvaluateNestedErrorEventDefinitionsOnFailWithLocalVariables() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "bar");
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, ERROR_DETAILS, 0, 3000L, null, vars);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getName()).isEqualTo((Object)"userTask");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionVariableExpression.bpmn20.xml"})
    public void shouldNotFailNestedErrorEventDefinitionsWhenVariableWasNotProvidedByClientOnFail() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, ERROR_DETAILS, 0, 3000L, null, null);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_FULL.getId()) {
            HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
            Assert.assertNotNull((Object)historicIncident);
            Assert.assertEquals((Object)incident.getId(), (Object)historicIncident.getId());
            Assert.assertTrue((boolean)historicIncident.isOpen());
        }
        Assert.assertNotNull((Object)incident);
        Assert.assertNotNull((Object)incident.getId());
        Assert.assertEquals((Object)ERROR_MESSAGE, (Object)incident.getIncidentMessage());
        Assert.assertEquals((Object)task.getExecutionId(), (Object)incident.getExecutionId());
        Assert.assertEquals((Object)"externalTask", (Object)incident.getActivityId());
        Assert.assertEquals((Object)incident.getId(), (Object)incident.getCauseIncidentId());
        Assert.assertEquals((Object)"failedExternalTask", (Object)incident.getIncidentType());
        Assert.assertEquals((Object)task.getProcessDefinitionId(), (Object)incident.getProcessDefinitionId());
        Assert.assertEquals((Object)task.getProcessInstanceId(), (Object)incident.getProcessInstanceId());
        Assert.assertEquals((Object)incident.getId(), (Object)incident.getRootCauseIncidentId());
        Assert.assertEquals((Object)task.getId(), (Object)incident.getConfiguration());
        Assert.assertNull((Object)incident.getJobDefinitionId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionVariableExpression.bpmn20.xml"})
    public void shouldKeepVariablesAfterEvaluateNestedErrorEventDefinitionsOnFailWithVariables() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "bar");
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, ERROR_DETAILS, 0, 3000L, vars, null);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getName()).isEqualTo((Object)"userTask");
        List variables = this.runtimeService.createVariableInstanceQuery().variableName("foo").list();
        Assertions.assertThat((List)variables).hasSize(1);
        Assertions.assertThat((Object)((VariableInstance)variables.get(0)).getValue()).isEqualTo((Object)"bar");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionVariableExpression.bpmn20.xml"})
    public void shouldNotKeepVariablesAfterEvaluateNestedErrorEventDefinitionsOnFailWithLocalVariables() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "bar");
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, ERROR_DETAILS, 0, 3000L, null, vars);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getName()).isEqualTo((Object)"userTask");
        List list = this.runtimeService.createVariableInstanceQuery().variableName("foo").list();
        Assertions.assertThat((List)list).hasSize(0);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionTrueAndOutputMapping.bpmn20.xml"})
    public void shouldNotFailOutputMappingAfterNestedErrorEventDefinitionsOnFail() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "bar");
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, ERROR_DETAILS, 0, 3000L, vars, null);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getName()).isEqualTo((Object)"userTask");
        List variables = this.runtimeService.createVariableInstanceQuery().variableName("foo").list();
        Assertions.assertThat((List)variables).hasSize(1);
        Assertions.assertThat((Object)((VariableInstance)variables.get(0)).getValue()).isEqualTo((Object)"bar");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionTrueAndOutputMapping.bpmn20.xml"})
    public void shouldFailOutputMappingAfterNestedErrorEventDefinitionsWhenVariableWasNotProvidedByClientOnFail() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, 0, 3000L)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Propagation of bpmn error errorCode failed.");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionExpressionIncludesErrorMessage.bpmn20.xml"})
    public void shouldResolveExpressionWithErrorMessageInNestedErrorEventDefinitionOnFailure() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assertions.assertThat((List)externalTasks).hasSize(1);
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, "myErrorMessage", "myErrorDetails", 0, 3000L);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getName()).isEqualTo((Object)"userTask");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionExpressionIncludesNullErrorMessage.bpmn20.xml"})
    public void shouldResolveExpressionWithErrorMessageInNestedErrorEventDefinitionOnComplete() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assertions.assertThat((List)externalTasks).hasSize(1);
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.externalTaskService.complete(task.getId(), WORKER_ID);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getName()).isEqualTo((Object)"userTask");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionExpressionIncludesNullErrorMessage.bpmn20.xml"})
    public void shouldResolveExpressionWithErrorMessageInNestedErrorEventDefinitionOnCompleteWithMultipleActivities() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List lockedExternalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assertions.assertThat((List)lockedExternalTasks).hasSize(1);
        LockedExternalTask task = (LockedExternalTask)lockedExternalTasks.get(0);
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List externalTasks = this.externalTaskService.createExternalTaskQuery().activityId(task.getActivityId()).list();
        Assertions.assertThat((List)externalTasks).hasSize(2);
        this.externalTaskService.complete(task.getId(), WORKER_ID);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getName()).isEqualTo((Object)"userTask");
        Assertions.assertThat((String)((Task)tasks.get(0)).getProcessInstanceId()).isEqualTo((Object)task.getProcessInstanceId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithTwoNestedErrorEventDefinitionExpressions.bpmn20.xml"})
    public void shouldResolveFirstOfTwoExpressionsInNestedErrorEventDefinitionOnComplete() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List lockedExternalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assertions.assertThat((List)lockedExternalTasks).hasSize(1);
        LockedExternalTask task = (LockedExternalTask)lockedExternalTasks.get(0);
        HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
        vars.put("a", true);
        vars.put("b", false);
        this.externalTaskService.complete(task.getId(), WORKER_ID, vars);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getName()).isEqualTo((Object)"userTask A");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithTwoNestedErrorEventDefinitionExpressions.bpmn20.xml"})
    public void shouldResolveSecondOfTwoExpressionsInNestedErrorEventDefinitionOnComplete() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List lockedExternalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assertions.assertThat((List)lockedExternalTasks).hasSize(1);
        LockedExternalTask task = (LockedExternalTask)lockedExternalTasks.get(0);
        HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
        vars.put("a", false);
        vars.put("b", true);
        this.externalTaskService.complete(task.getId(), WORKER_ID, vars);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getName()).isEqualTo((Object)"userTask B");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithTwoNestedErrorEventDefinitionExpressions.bpmn20.xml"})
    public void shouldResolveBothOfTwoExpressionsInNestedErrorEventDefinitionOnComplete() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List lockedExternalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assertions.assertThat((List)lockedExternalTasks).hasSize(1);
        LockedExternalTask task = (LockedExternalTask)lockedExternalTasks.get(0);
        HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
        vars.put("a", true);
        vars.put("b", true);
        this.externalTaskService.complete(task.getId(), WORKER_ID, vars);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(1);
        Assertions.assertThat((String)((Task)tasks.get(0)).getName()).isEqualTo((Object)"userTask A");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionEmptyExpression.bpmn20.xml"})
    public void shouldIgnoreEmptyExpressionInNestedErrorEventDefinitionOnComplete() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List lockedExternalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assertions.assertThat((List)lockedExternalTasks).hasSize(1);
        LockedExternalTask task = (LockedExternalTask)lockedExternalTasks.get(0);
        this.externalTaskService.complete(task.getId(), WORKER_ID);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(0);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.externalTaskWithNestedErrorEventDefinitionEmptyExpression.bpmn20.xml"})
    public void shouldIgnoreNullExpressionInNestedErrorEventDefinitionOnComplete() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithNestedErrorEventDefinition");
        List lockedExternalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assertions.assertThat((List)lockedExternalTasks).hasSize(1);
        LockedExternalTask task = (LockedExternalTask)lockedExternalTasks.get(0);
        this.externalTaskService.complete(task.getId(), WORKER_ID);
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(0);
    }

    @Test
    @Deployment
    public void shouldThrowProcessEngineExceptionWhenOtherResourceIsNotFound() {
        this.runtimeService.startProcessInstanceByKey("oneExternalAndScriptTask");
        List lockedExternalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assertions.assertThat((List)lockedExternalTasks).hasSize(1);
        LockedExternalTask task = (LockedExternalTask)lockedExternalTasks.get(0);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.externalTaskService.complete(task.getId(), WORKER_ID)).isExactlyInstanceOf(ProcessEngineException.class)).isNotInstanceOf(NotFoundException.class)).hasMessageContaining("Unable to find resource at path foo");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testLocking() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        AssertUtil.assertEqualsSecondPrecision(this.nowPlus(10000L), task.getLockExpirationTime());
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testCompleteLockExpiredTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testCompleteReclaimedLockExpiredTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        List reclaimedTasks = this.externalTaskService.fetchAndLock(1, "anotherWorkerId").topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.complete(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("cannot be completed by worker 'aWorkerId'. It is locked by worker 'anotherWorkerId'.", e.getMessage());
        }
        this.externalTaskService.complete(((LockedExternalTask)reclaimedTasks.get(0)).getId(), "anotherWorkerId");
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        Assert.assertEquals((long)0L, (long)this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute().size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testExternalTaskExecutionTreeExpansion() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("boundaryExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask externalTask = (LockedExternalTask)tasks.get(0);
        this.runtimeService.correlateMessage("Message");
        this.externalTaskService.complete(externalTask.getId(), WORKER_ID);
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("afterBoundaryTask").done());
        Task afterBoundaryTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(afterBoundaryTask.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testExternalTaskExecutionTreeCompaction() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("concurrentExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask externalTask = (LockedExternalTask)tasks.get(0);
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(userTask.getId());
        this.externalTaskService.complete(externalTask.getId(), WORKER_ID);
        tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)tasks.size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testUnlock() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.externalTaskService.unlock(task.getId());
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        LockedExternalTask reAcquiredTask = (LockedExternalTask)externalTasks.get(0);
        Assert.assertEquals((Object)task.getId(), (Object)reAcquiredTask.getId());
    }

    @Test
    public void testUnlockNullTaskId() {
        try {
            this.externalTaskService.unlock(null);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"externalTaskId is null"));
        }
    }

    @Test
    public void testUnlockNonExistingTask() {
        try {
            this.externalTaskService.unlock("nonExistingId");
            Assert.fail((String)"expected exception");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresent("Cannot find external task with id nonExistingId", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleFailure() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        ClockUtil.setCurrentTime((Date)this.nowPlus(3000L));
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, 5, 3000L);
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)tasks.size());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createIncidentQuery().count());
        ClockUtil.setCurrentTime((Date)this.nowPlus(4000L));
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)tasks.size());
        task = (LockedExternalTask)tasks.get(0);
        Assert.assertEquals((Object)ERROR_MESSAGE, (Object)task.getErrorMessage());
        Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleFailureWithErrorDetails() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        ClockUtil.setCurrentTime((Date)this.nowPlus(3000L));
        try {
            RuntimeSqlException cause = new RuntimeSqlException("test cause");
            for (int i = 0; i < 10; ++i) {
                cause = new RuntimeSqlException((Throwable)cause);
            }
            throw cause;
        }
        catch (RuntimeException e) {
            String exceptionStackTrace = ExceptionUtils.getStackTrace((Throwable)e);
            String errorMessage = e.getMessage();
            while (errorMessage.length() < 1000) {
                errorMessage = errorMessage + ":" + e.getMessage();
            }
            Assert.assertThat((Object)exceptionStackTrace, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)exceptionStackTrace.length(), (Matcher)Is.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(4000))));
            this.externalTaskService.handleFailure(task.getId(), WORKER_ID, errorMessage, exceptionStackTrace, 5, 3000L);
            ClockUtil.setCurrentTime((Date)this.nowPlus(4000L));
            tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
            Assert.assertThat((Object)tasks.size(), (Matcher)Is.is((Object)1));
            task = (LockedExternalTask)tasks.get(0);
            Assert.assertThat((Object)task.getErrorMessage(), (Matcher)Is.is((Object)errorMessage.substring(0, 666)));
            Assert.assertThat((Object)task.getRetries(), (Matcher)Is.is((Object)5));
            Assert.assertThat((Object)this.externalTaskService.getExternalTaskErrorDetails(task.getId()), (Matcher)Is.is((Object)exceptionStackTrace));
            Assert.assertThat((Object)task.getErrorDetails(), (Matcher)Is.is((Object)exceptionStackTrace));
            return;
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleFailureZeroRetries() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        ClockUtil.setCurrentTime((Date)this.nowPlus(3000L));
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, 0, 3000L);
        ClockUtil.setCurrentTime((Date)this.nowPlus(4000L));
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)tasks.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_FULL.getId()) {
            HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
            Assert.assertNotNull((Object)historicIncident);
            Assert.assertEquals((Object)incident.getId(), (Object)historicIncident.getId());
            Assert.assertTrue((boolean)historicIncident.isOpen());
            Assert.assertEquals((Object)this.getHistoricTaskLogOrdered(incident.getConfiguration()).get(0).getId(), (Object)historicIncident.getHistoryConfiguration());
        }
        Assert.assertNotNull((Object)incident);
        Assert.assertNotNull((Object)incident.getId());
        Assert.assertEquals((Object)ERROR_MESSAGE, (Object)incident.getIncidentMessage());
        Assert.assertEquals((Object)task.getExecutionId(), (Object)incident.getExecutionId());
        Assert.assertEquals((Object)"externalTask", (Object)incident.getActivityId());
        Assert.assertEquals((Object)incident.getId(), (Object)incident.getCauseIncidentId());
        Assert.assertEquals((Object)"failedExternalTask", (Object)incident.getIncidentType());
        Assert.assertEquals((Object)task.getProcessDefinitionId(), (Object)incident.getProcessDefinitionId());
        Assert.assertEquals((Object)task.getProcessInstanceId(), (Object)incident.getProcessInstanceId());
        Assert.assertEquals((Object)incident.getId(), (Object)incident.getRootCauseIncidentId());
        AssertUtil.assertEqualsSecondPrecision(this.nowMinus(4000L), incident.getIncidentTimestamp());
        Assert.assertEquals((Object)task.getId(), (Object)incident.getConfiguration());
        Assert.assertNull((Object)incident.getJobDefinitionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleFailureZeroRetriesAfterIncidentsAreResolved() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, 0, 3000L);
        this.externalTaskService.setRetries(task.getId(), 5);
        ClockUtil.setCurrentTime((Date)this.nowPlus(3000L));
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)this.nowPlus(4000L));
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, 1, 3000L);
        ClockUtil.setCurrentTime((Date)this.nowPlus(5000L));
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, 0, 3000L);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertNotNull((Object)incident.getId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_FULL.getId()) {
            List historicIncidents = ((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().configuration(task.getId()).orderByCreateTime().asc()).list();
            Assert.assertEquals((long)2L, (long)historicIncidents.size());
            List<HistoricExternalTaskLog> logs = this.getHistoricTaskLogOrdered(task.getId());
            Assert.assertEquals((long)3L, (long)logs.size());
            Assert.assertTrue((boolean)((HistoricIncident)historicIncidents.get(0)).isResolved());
            Assert.assertEquals((Object)logs.get(2).getId(), (Object)((HistoricIncident)historicIncidents.get(0)).getHistoryConfiguration());
            Assert.assertTrue((boolean)((HistoricIncident)historicIncidents.get(1)).isOpen());
            Assert.assertEquals((Object)logs.get(0).getId(), (Object)((HistoricIncident)historicIncidents.get(1)).getHistoryConfiguration());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleFailureAndDeleteProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, 0, 10000L);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleFailureThenComplete() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, 0, 10000L);
        this.externalTaskService.complete(task.getId(), WORKER_ID);
        Task followingTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)followingTask);
        Assert.assertEquals((Object)"afterExternalTask", (Object)followingTask.getTaskDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleFailureWithWrongWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), "someCrazyWorkerId", ERROR_MESSAGE, 5, 10000L);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            this.testRule.assertTextPresent("Failure of External Task " + ((LockedExternalTask)externalTasks.get(0)).getId() + " cannot be reported by worker 'someCrazyWorkerId'. It is locked by worker '" + WORKER_ID + "'.", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleFailureNonExistingTask() {
        try {
            this.externalTaskService.handleFailure("nonExistingTaskId", WORKER_ID, ERROR_MESSAGE, 5, 10000L);
            Assert.fail((String)"exception expected");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresent("Cannot find external task with id nonExistingTaskId", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleFailureNullTaskId() {
        try {
            this.externalTaskService.handleFailure(null, WORKER_ID, ERROR_MESSAGE, 5, 10000L);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot find external task with id " + null, e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleFailureNullWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), null, ERROR_MESSAGE, 5, 10000L);
            Assert.fail((String)"exception expected");
        }
        catch (NullValueException e) {
            this.testRule.assertTextPresent("workerId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleFailureNegativeLockDuration() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, ERROR_MESSAGE, 5, -10000L);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("retryDuration is not greater than or equal to 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleFailureNegativeRetries() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, ERROR_MESSAGE, -5, 10000L);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("retries is not greater than or equal to 0", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleFailureNullErrorMessage() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, null, 5, 10000L);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        Assert.assertNull((Object)task.getErrorMessage());
        Assert.assertNull((Object)this.externalTaskService.getExternalTaskErrorDetails(task.getId()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleFailureSuspendedTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, ERROR_MESSAGE, 5, 10000L);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("ExternalTask with id '" + task.getId() + "' is suspended", e.getMessage());
        }
        this.testRule.assertProcessNotEnded(processInstance.getId());
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        this.externalTaskService.handleFailure(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, ERROR_MESSAGE, 5, 10000L);
        ExternalTask updatedTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Assert.assertEquals((long)5L, (long)updatedTask.getRetries().intValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testSetRetries() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        this.externalTaskService.setRetries(((LockedExternalTask)externalTasks.get(0)).getId(), 5);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testSetRetriesResolvesFailureIncident() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask lockedTask = (LockedExternalTask)externalTasks.get(0);
        this.externalTaskService.handleFailure(lockedTask.getId(), WORKER_ID, ERROR_MESSAGE, 0, 10000L);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.externalTaskService.setRetries(lockedTask.getId(), 5);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createIncidentQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_FULL.getId()) {
            HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
            Assert.assertNotNull((Object)historicIncident);
            Assert.assertEquals((Object)incident.getId(), (Object)historicIncident.getId());
            Assert.assertTrue((boolean)historicIncident.isResolved());
        }
        ClockUtil.setCurrentTime((Date)this.nowPlus(13000L));
        externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        Assert.assertEquals((Object)lockedTask.getId(), (Object)((LockedExternalTask)externalTasks.get(0)).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testSetRetriesToZero() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask lockedTask = (LockedExternalTask)externalTasks.get(0);
        this.externalTaskService.setRetries(lockedTask.getId(), 0);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertEquals((Object)lockedTask.getId(), (Object)incident.getConfiguration());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_FULL.getId()) {
            HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
            Assert.assertNotNull((Object)historicIncident);
            Assert.assertEquals((Object)incident.getId(), (Object)historicIncident.getId());
            Assert.assertTrue((boolean)historicIncident.isOpen());
            Assert.assertNull((Object)historicIncident.getHistoryConfiguration());
        }
        this.externalTaskService.setRetries(lockedTask.getId(), 5);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createIncidentQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testSetRetriesToZeroAfterFailureWithRetriesLeft() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, 2, 3000L);
        ClockUtil.setCurrentTime((Date)this.nowPlus(3000L));
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)this.nowPlus(5000L));
        this.externalTaskService.handleFailure(task.getId(), WORKER_ID, ERROR_MESSAGE, 1, 3000L);
        tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)this.nowPlus(7000L));
        this.externalTaskService.setRetries(task.getId(), 0);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertNotNull((Object)incident.getId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_FULL.getId()) {
            HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().configuration(task.getId()).singleResult();
            Assert.assertNotNull((Object)historicIncident);
            List<HistoricExternalTaskLog> logs = this.getHistoricTaskLogOrdered(task.getId());
            Assert.assertEquals((long)2L, (long)logs.size());
            HistoricExternalTaskLog log = logs.get(0);
            Assert.assertTrue((boolean)historicIncident.isOpen());
            Assert.assertEquals((Object)log.getId(), (Object)historicIncident.getHistoryConfiguration());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testSetRetriesNegative() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        try {
            this.externalTaskService.setRetries(((LockedExternalTask)externalTasks.get(0)).getId(), -5);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("retries is not greater than or equal to 0", e.getMessage());
        }
    }

    @Test
    public void testSetRetriesNonExistingTask() {
        try {
            this.externalTaskService.setRetries("someExternalTaskId", 5);
            Assert.fail((String)"expected exception");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresent("externalTask is null", e.getMessage());
        }
    }

    @Test
    public void testSetRetriesNullTaskId() {
        try {
            this.externalTaskService.setRetries((String)null, 5);
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"externalTaskId is null"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testSetPriority() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        this.externalTaskService.setPriority(((LockedExternalTask)externalTasks.get(0)).getId(), 5L);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Assert.assertEquals((long)5L, (long)((int)task.getPriority()));
    }

    @Test
    public void testSetPriorityNonExistingTask() {
        try {
            this.externalTaskService.setPriority("someExternalTaskId", 5L);
            Assert.fail((String)"expected exception");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresent("externalTask is null", e.getMessage());
        }
    }

    @Test
    public void testSetPriorityNullTaskId() {
        try {
            this.externalTaskService.setPriority(null, 5L);
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"externalTaskId is null"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskWithPriorityProcess.bpmn20.xml"})
    @Test
    public void testAfterSetPriorityFetchHigherTask() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(2, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)2L, (long)externalTasks.size());
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(1);
        Assert.assertEquals((long)0L, (long)task.getPriority());
        this.externalTaskService.setPriority(task.getId(), 9L);
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        externalTasks = this.externalTaskService.fetchAndLock(1, "anotherWorkerId", true).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)((LockedExternalTask)externalTasks.get(0)).getPriority(), (long)9L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testSetPriorityLockExpiredTask() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        this.externalTaskService.setPriority(((LockedExternalTask)externalTasks.get(0)).getId(), 9L);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID, true).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)1L, (long)externalTasks.size());
        Assert.assertEquals((long)((LockedExternalTask)externalTasks.get(0)).getPriority(), (long)9L);
    }

    @Deployment
    @Test
    public void testCancelExternalTaskWithBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("boundaryExternalTaskProcess");
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().count());
        this.runtimeService.correlateMessage("Message");
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBoundaryTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)afterBoundaryTask);
        Assert.assertEquals((Object)"afterBoundaryTask", (Object)afterBoundaryTask.getTaskDefinitionKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleBpmnError() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List<LockedExternalTask> externalTasks = this.helperHandleBpmnError(1, WORKER_ID, TOPIC_NAME, 10000L, "ERROR-OCCURED");
        Assert.assertEquals((long)0L, (long)externalTasks.size());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBpmnError = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)afterBpmnError);
        Assert.assertEquals((Object)afterBpmnError.getTaskDefinitionKey(), (Object)"afterBpmnError");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleBpmnErrorWithoutDefinedBoundary() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List<LockedExternalTask> externalTasks = this.helperHandleBpmnError(1, WORKER_ID, TOPIC_NAME, 10000L, "ERROR-OCCURED");
        Assert.assertEquals((long)0L, (long)externalTasks.size());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBpmnError = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNull((Object)afterBpmnError);
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    public List<LockedExternalTask> helperHandleBpmnError(int taskCount, String workerID, String topicName, long lockTime, String errorCode) {
        List externalTasks = this.externalTaskService.fetchAndLock(taskCount, workerID).topic(topicName, lockTime).execute();
        this.externalTaskService.handleBpmnError(((LockedExternalTask)externalTasks.get(0)).getId(), workerID, errorCode);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        return externalTasks;
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleBpmnErrorLockExpiredTask() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        this.externalTaskService.handleBpmnError(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "ERROR-OCCURED");
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBpmnError = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)afterBpmnError);
        Assert.assertEquals((Object)afterBpmnError.getTaskDefinitionKey(), (Object)"afterBpmnError");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleBpmnErrorReclaimedLockExpiredTaskWithoutDefinedBoundary() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        this.handleBpmnErrorReclaimedLockExpiredTask(false);
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleBpmnErrorReclaimedLockExpiredTaskWithBoundary() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.handleBpmnErrorReclaimedLockExpiredTask(false);
    }

    public void handleBpmnErrorReclaimedLockExpiredTask(boolean includeVariables) {
        List reclaimedTasks;
        List externalTasks;
        block2: {
            externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
            ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
            reclaimedTasks = this.externalTaskService.fetchAndLock(1, "anotherWorkerId").topic(TOPIC_NAME, 10000L).execute();
            try {
                this.externalTaskService.handleBpmnError(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "ERROR-OCCURED");
                Assert.fail((String)"exception expected");
            }
            catch (ProcessEngineException e) {
                this.testRule.assertTextPresent("Bpmn error of External Task " + ((LockedExternalTask)externalTasks.get(0)).getId() + " cannot be reported by worker '" + WORKER_ID + "'. It is locked by worker 'anotherWorkerId'.", e.getMessage());
                if (!includeVariables) break block2;
                List list = this.runtimeService.createVariableInstanceQuery().list();
                Assert.assertEquals((long)0L, (long)list.size());
            }
        }
        this.externalTaskService.complete(((LockedExternalTask)reclaimedTasks.get(0)).getId(), "anotherWorkerId");
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
    }

    @Test
    public void testHandleBpmnErrorNonExistingTask() {
        try {
            this.externalTaskService.handleBpmnError("nonExistingTaskId", WORKER_ID, "ERROR-OCCURED");
            Assert.fail((String)"exception expected");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresent("Cannot find external task with id nonExistingTaskId", e.getMessage());
        }
    }

    @Test
    public void testHandleBpmnNullTaskId() {
        try {
            this.externalTaskService.handleBpmnError(null, WORKER_ID, "ERROR-OCCURED");
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot find external task with id " + null, e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleBpmnNullErrorCode() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        try {
            this.externalTaskService.handleBpmnError(task.getId(), WORKER_ID, null);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("errorCode is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleBpmnErrorNullWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        try {
            this.externalTaskService.handleBpmnError(task.getId(), null, "ERROR-OCCURED");
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("workerId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleBpmnErrorSuspendedTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        LockedExternalTask task = (LockedExternalTask)externalTasks.get(0);
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        try {
            this.externalTaskService.handleBpmnError(task.getId(), WORKER_ID, "ERROR-OCCURED");
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("ExternalTask with id '" + task.getId() + "' is suspended", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleBpmnErrorPassVariablesBoundryEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        variables.put("transientVar", (String)Variables.integerValue((Integer)1, (boolean)true));
        this.externalTaskService.handleBpmnError(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "ERROR-OCCURED", null, variables);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBpmnError = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)afterBpmnError);
        Assert.assertEquals((Object)afterBpmnError.getTaskDefinitionKey(), (Object)"afterBpmnError");
        List list = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{pi.getId()}).list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"foo", (Object)((VariableInstance)list.get(0)).getName());
    }

    @Test
    public void testHandleBpmnErrorPassVariablesEventSubProcess() {
        BpmnModelInstance process = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").serviceTask("externalTask").camundaType("external")).camundaTopic(TOPIC_NAME)).endEvent("endEvent").done();
        BpmnModelInstance subProcess = ((StartEventBuilder)((SubProcessBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(process).addSubProcessTo("process").id("eventSubProcess")).triggerByEvent()).embeddedSubProcess().startEvent("eventSubProcessStart").error("ERROR-SPEC-10")).userTask("afterBpmnError").endEvent().subProcessDone().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(subProcess);
        String deploymentId = this.testRule.deploy(targetProcess).getId();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        variables.put("transientVar", (String)Variables.integerValue((Integer)1, (boolean)true));
        this.externalTaskService.handleBpmnError(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "ERROR-SPEC-10", null, variables);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBpmnError = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)afterBpmnError);
        Assert.assertEquals((Object)afterBpmnError.getTaskDefinitionKey(), (Object)"afterBpmnError");
        List list = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{pi.getId()}).list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"foo", (Object)((VariableInstance)list.get(0)).getName());
    }

    @Deployment
    @Test
    public void testHandleBpmnErrorPassMessageEventSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        ClockUtil.setCurrentTime((Date)new DateTime((Object)ClockUtil.getCurrentTime()).plus(20000L).toDate());
        String anErrorMessage = "Some meaningful message";
        this.externalTaskService.handleBpmnError(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "ERROR-SPEC-10", anErrorMessage);
        externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assert.assertEquals((long)0L, (long)externalTasks.size());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().count());
        Task afterBpmnError = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)afterBpmnError);
        Assert.assertEquals((Object)afterBpmnError.getTaskDefinitionKey(), (Object)"afterBpmnError");
        List list = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{pi.getId()}).list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"errorMessageVariable", (Object)((VariableInstance)list.get(0)).getName());
        Assert.assertEquals((Object)anErrorMessage, (Object)((VariableInstance)list.get(0)).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testHandleBpmnErrorReclaimedLockExpiredTaskWithBoundaryAndPassVariables() {
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskProcess");
        this.handleBpmnErrorReclaimedLockExpiredTask(true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testUpdateRetriesByExternalTaskIds() {
        this.startProcessInstance("oneExternalTaskProcess", 5);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        List<String> externalTaskIds = Arrays.asList(((ExternalTask)tasks.get(0)).getId(), ((ExternalTask)tasks.get(1)).getId(), ((ExternalTask)tasks.get(2)).getId(), ((ExternalTask)tasks.get(3)).getId(), ((ExternalTask)tasks.get(4)).getId());
        this.externalTaskService.updateRetries().externalTaskIds(externalTaskIds).set(5);
        tasks = this.externalTaskService.createExternalTaskQuery().list();
        Assert.assertEquals((long)5L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testUpdateRetriesByExternalTaskIdArray() {
        this.startProcessInstance("oneExternalTaskProcess", 5);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        List<String> externalTaskIds = Arrays.asList(((ExternalTask)tasks.get(0)).getId(), ((ExternalTask)tasks.get(1)).getId(), ((ExternalTask)tasks.get(2)).getId(), ((ExternalTask)tasks.get(3)).getId(), ((ExternalTask)tasks.get(4)).getId());
        this.externalTaskService.updateRetries().externalTaskIds(externalTaskIds.toArray(new String[externalTaskIds.size()])).set(5);
        tasks = this.externalTaskService.createExternalTaskQuery().list();
        Assert.assertEquals((long)5L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testUpdateRetriesByProcessInstanceIds() {
        List<String> processInstances = this.startProcessInstance("oneExternalTaskProcess", 5);
        this.externalTaskService.updateRetries().processInstanceIds(processInstances).set(5);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        Assert.assertEquals((long)5L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testUpdateRetriesByProcessInstanceIdArray() {
        List<String> processInstances = this.startProcessInstance("oneExternalTaskProcess", 5);
        this.externalTaskService.updateRetries().processInstanceIds(processInstances.toArray(new String[processInstances.size()])).set(5);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        Assert.assertEquals((long)5L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testUpdateRetriesByExternalTaskQuery() {
        this.startProcessInstance("oneExternalTaskProcess", 5);
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.externalTaskService.updateRetries().externalTaskQuery(query).set(5);
        List tasks = query.list();
        Assert.assertEquals((long)5L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testUpdateRetriesByProcessInstanceQuery() {
        this.startProcessInstance("oneExternalTaskProcess", 5);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneExternalTaskProcess");
        this.externalTaskService.updateRetries().processInstanceQuery(processInstanceQuery).set(5);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        Assert.assertEquals((long)5L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @RequiredHistoryLevel(value="audit")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testUpdateRetriesByHistoricProcessInstanceQuery() {
        this.startProcessInstance("oneExternalTaskProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("oneExternalTaskProcess");
        this.externalTaskService.updateRetries().historicProcessInstanceQuery(query).set(5);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        Assert.assertEquals((long)5L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @RequiredHistoryLevel(value="audit")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testUpdateRetriesByAllParameters() {
        List<String> ids = this.startProcessInstance("oneExternalTaskProcess", 5);
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(ids.get(0)).singleResult();
        ExternalTaskQuery externalTaskQuery = this.externalTaskService.createExternalTaskQuery().processInstanceId(ids.get(1));
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(ids.get(2));
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(ids.get(3));
        this.externalTaskService.updateRetries().externalTaskIds(new String[]{externalTask.getId()}).externalTaskQuery(externalTaskQuery).processInstanceQuery(processInstanceQuery).historicProcessInstanceQuery(historicProcessInstanceQuery).processInstanceIds(new String[]{ids.get(4)}).set(5);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        Assert.assertEquals((long)5L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((Object)5, (Object)task.getRetries());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testExtendLockTime() {
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        try {
            this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
            ClockUtil.setCurrentTime((Date)this.nowMinus(1000L));
            List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
            Date extendLockTime = new Date();
            ClockUtil.setCurrentTime((Date)extendLockTime);
            this.externalTaskService.extendLock(((LockedExternalTask)lockedTasks.get(0)).getId(), WORKER_ID, 10000L);
            ExternalTask taskWithExtendedLock = (ExternalTask)this.externalTaskService.createExternalTaskQuery().locked().singleResult();
            Assert.assertNotNull((Object)taskWithExtendedLock);
            AssertUtil.assertEqualsSecondPrecision(new Date(extendLockTime.getTime() + 10000L), taskWithExtendedLock.getLockExpirationTime());
        }
        finally {
            ClockUtil.setCurrentTime((Date)oldCurrentTime);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testExtendLockTimeThatExpired() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 1L).execute();
        Assert.assertNotNull((Object)lockedTasks);
        Assert.assertEquals((long)1L, (long)lockedTasks.size());
        ClockUtil.setCurrentTime((Date)this.nowPlus(2L));
        try {
            this.externalTaskService.extendLock(((LockedExternalTask)lockedTasks.get(0)).getId(), WORKER_ID, 100L);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot extend a lock that expired"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testExtendLockTimeWithoutLock() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        try {
            this.externalTaskService.extendLock(externalTask.getId(), WORKER_ID, 100L);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("The lock of the External Task " + externalTask.getId() + " cannot be extended by worker '" + WORKER_ID));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testExtendLockTimeWithNullLockTime() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 1L).execute();
        Assert.assertNotNull((Object)lockedTasks);
        Assert.assertEquals((long)1L, (long)lockedTasks.size());
        try {
            this.externalTaskService.extendLock(((LockedExternalTask)lockedTasks.get(0)).getId(), WORKER_ID, 0L);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("lockTime is not greater than 0"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testExtendLockTimeWithNegativeLockTime() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 1L).execute();
        Assert.assertNotNull((Object)lockedTasks);
        Assert.assertEquals((long)1L, (long)lockedTasks.size());
        try {
            this.externalTaskService.extendLock(((LockedExternalTask)lockedTasks.get(0)).getId(), WORKER_ID, -1L);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("lockTime is not greater than 0"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testExtendLockTimeWithNullWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 1L).execute();
        Assert.assertNotNull((Object)lockedTasks);
        Assert.assertEquals((long)1L, (long)lockedTasks.size());
        try {
            this.externalTaskService.extendLock(((LockedExternalTask)lockedTasks.get(0)).getId(), null, 100L);
            Assert.fail((String)"Exception expected");
        }
        catch (NullValueException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("workerId is null"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testExtendLockTimeWithDifferentWorkerId() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 1L).execute();
        Assert.assertNotNull((Object)lockedTasks);
        Assert.assertEquals((long)1L, (long)lockedTasks.size());
        LockedExternalTask task = (LockedExternalTask)lockedTasks.get(0);
        try {
            this.externalTaskService.extendLock(task.getId(), "anAnotherWorkerId", 100L);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("The lock of the External Task " + task.getId() + " cannot be extended by worker 'anAnotherWorkerId'"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testExtendLockTimeWithNullExternalTask() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 1L).execute();
        Assert.assertNotNull((Object)lockedTasks);
        Assert.assertEquals((long)1L, (long)lockedTasks.size());
        try {
            this.externalTaskService.extendLock(null, WORKER_ID, 100L);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot find external task with id null"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testExtendLockTimeForUnexistingExternalTask() {
        try {
            this.externalTaskService.extendLock("unexisting", WORKER_ID, 100L);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot find external task with id unexisting"));
        }
    }

    @Test
    public void testCompleteWithLocalVariables() {
        BpmnModelInstance instance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().serviceTask("externalTask").camundaType("external")).camundaTopic("foo")).camundaTaskPriority("100")).camundaExecutionListenerClass("end", ReadLocalVariableListenerImpl.class)).userTask("user").endEvent().done();
        this.testRule.deploy(instance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic("foo", 1L).execute();
        this.externalTaskService.complete(((LockedExternalTask)lockedTasks.get(0)).getId(), WORKER_ID, null, (Map)Variables.createVariables().putValue("abc", (Object)"bar"));
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).singleResult();
        Assert.assertNull((Object)variableInstance);
        if (this.processEngineConfiguration.getHistoryLevel() == HistoryLevel.HISTORY_LEVEL_AUDIT || this.processEngineConfiguration.getHistoryLevel() == HistoryLevel.HISTORY_LEVEL_FULL) {
            HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().activityInstanceIdIn(new String[]{((LockedExternalTask)lockedTasks.get(0)).getActivityInstanceId()}).singleResult();
            Assert.assertNotNull((Object)historicVariableInstance);
            Assert.assertEquals((Object)"abc", (Object)historicVariableInstance.getName());
            Assert.assertEquals((Object)"bar", (Object)historicVariableInstance.getValue());
        }
    }

    @Test
    public void testCompleteWithNonLocalVariables() {
        BpmnModelInstance instance = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().serviceTask("externalTask").camundaType("external")).camundaTopic("foo")).camundaTaskPriority("100")).camundaExecutionListenerClass("end", ReadLocalVariableListenerImpl.class)).userTask("user").endEvent().done();
        this.testRule.deploy(instance);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        List lockedTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic("foo", 1L).execute();
        this.externalTaskService.complete(((LockedExternalTask)lockedTasks.get(0)).getId(), WORKER_ID, (Map)Variables.createVariables().putValue("abc", (Object)"bar"), null);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstance.getId()}).singleResult();
        Assert.assertNotNull((Object)variableInstance);
        Assert.assertEquals((Object)"bar", (Object)variableInstance.getValue());
        Assert.assertEquals((Object)"abc", (Object)variableInstance.getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testFetchWithEmptyListOfVariables() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic(TOPIC_NAME, 10000L).variables(new String[0]).execute();
        Assert.assertEquals((long)1L, (long)tasks.size());
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        Assert.assertNotNull((Object)task.getId());
        Assert.assertEquals((long)0L, (long)task.getVariables().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByBusinessKey() {
        String topicName1 = "topic1";
        String topicName2 = "topic2";
        String topicName3 = "topic3";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        Long lockDuration = 60000L;
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey1);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey2);
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).businessKey(businessKey1).topic(topicName2, lockDuration.longValue()).businessKey(businessKey2).topic(topicName3, lockDuration.longValue()).businessKey("fakeBusinessKey").execute();
        Assert.assertEquals((long)2L, (long)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
            if (externalTask.getTopicName().equals(topicName1)) {
                Assert.assertEquals((Object)businessKey1, (Object)pi.getBusinessKey());
                Assert.assertEquals((Object)businessKey1, (Object)externalTask.getBusinessKey());
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                Assert.assertEquals((Object)businessKey2, (Object)pi.getBusinessKey());
                Assert.assertEquals((Object)businessKey2, (Object)externalTask.getBusinessKey());
                continue;
            }
            Assert.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByBusinessKeyCombination1() {
        String topicName1 = "topic1";
        String topicName2 = "topic2";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        Long lockDuration = 60000L;
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey1);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey2);
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).businessKey(businessKey1).topic(topicName2, lockDuration.longValue()).execute();
        Assert.assertEquals((long)3L, (long)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
            if (externalTask.getTopicName().equals(topicName1)) {
                Assert.assertEquals((Object)businessKey1, (Object)pi.getBusinessKey());
                Assert.assertEquals((Object)businessKey1, (Object)externalTask.getBusinessKey());
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                Assert.assertEquals((Object)pi.getBusinessKey(), (Object)externalTask.getBusinessKey());
                continue;
            }
            Assert.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByBusinessKeyCombination2() {
        String topicName1 = "topic1";
        String topicName2 = "topic2";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        Long lockDuration = 60000L;
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey1);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey2);
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).topic(topicName2, lockDuration.longValue()).businessKey(businessKey2).execute();
        Assert.assertEquals((long)3L, (long)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
            if (externalTask.getTopicName().equals(topicName1)) {
                Assert.assertEquals((Object)pi.getBusinessKey(), (Object)externalTask.getBusinessKey());
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                Assert.assertEquals((Object)businessKey2, (Object)pi.getBusinessKey());
                Assert.assertEquals((Object)businessKey2, (Object)externalTask.getBusinessKey());
                continue;
            }
            Assert.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByBusinessKeyLocking() {
        String topicName1 = "topic1";
        String topicName2 = "topic2";
        String topicName3 = "topic3";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        Long lockDuration = 60000L;
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey1);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess", businessKey2);
        List lockedTopicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).businessKey(businessKey1).topic(topicName2, lockDuration.longValue()).businessKey(businessKey2).topic(topicName3, lockDuration.longValue()).businessKey("fakeBusinessKey").execute();
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).businessKey(businessKey1).topic(topicName2, 2L * lockDuration).businessKey(businessKey2).topic(topicName3, 2L * lockDuration).businessKey(businessKey1).execute();
        Assert.assertEquals((long)2L, (long)lockedTopicTasks.size());
        Assert.assertEquals((long)1L, (long)topicTasks.size());
        LockedExternalTask externalTask = (LockedExternalTask)topicTasks.get(0);
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
        Assert.assertEquals((Object)businessKey1, (Object)pi.getBusinessKey());
        Assert.assertEquals((Object)businessKey1, (Object)externalTask.getBusinessKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testVariableValueTopicQuery.bpmn20.xml"})
    @Test
    public void testTopicQueryByVariableValue() {
        String topicName1 = "testTopic1";
        String topicName2 = "testTopic2";
        String variableName = "testVariable";
        String variableValue1 = "testValue1";
        String variableValue2 = "testValue2";
        HashMap<String, String> variables = new HashMap<String, String>();
        Long lockDuration = 60000L;
        variables.put(variableName, variableValue1);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", variables);
        variables.put(variableName, variableValue2);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", variables);
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).processInstanceVariableEquals(variableName, (Object)variableValue1).topic(topicName2, lockDuration.longValue()).processInstanceVariableEquals(variableName, (Object)variableValue2).execute();
        Assert.assertEquals((long)2L, (long)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            if (externalTask.getTopicName().equals(topicName1)) {
                Assert.assertEquals((Object)variableValue1, (Object)externalTask.getVariables().get((Object)variableName));
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                Assert.assertEquals((Object)variableValue2, (Object)externalTask.getVariables().get((Object)variableName));
                continue;
            }
            Assert.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testVariableValueTopicQuery.bpmn20.xml"})
    @Test
    public void testTopicQueryByVariableValueLocking() {
        String topicName1 = "testTopic1";
        String topicName2 = "testTopic2";
        String topicName3 = "testTopic3";
        String variableName = "testVariable";
        String variableValue1 = "testValue1";
        String variableValue2 = "testValue2";
        HashMap<String, String> variables = new HashMap<String, String>();
        Long lockDuration = 60000L;
        variables.put(variableName, variableValue1);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", variables);
        variables.put(variableName, variableValue2);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", variables);
        List lockedTopicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).processInstanceVariableEquals(variableName, (Object)variableValue1).topic(topicName2, lockDuration.longValue()).processInstanceVariableEquals(variableName, (Object)variableValue2).execute();
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, 2L * lockDuration).processInstanceVariableEquals(variableName, (Object)variableValue1).topic(topicName2, 2L * lockDuration).processInstanceVariableEquals(variableName, (Object)variableValue2).topic(topicName3, lockDuration.longValue()).processInstanceVariableEquals(variableName, (Object)variableValue2).execute();
        Assert.assertEquals((long)2L, (long)lockedTopicTasks.size());
        Assert.assertEquals((long)1L, (long)topicTasks.size());
        LockedExternalTask externalTask = (LockedExternalTask)topicTasks.get(0);
        Assert.assertEquals((Object)topicName3, (Object)externalTask.getTopicName());
        Assert.assertEquals((Object)variableValue2, (Object)externalTask.getVariables().get((Object)variableName));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testVariableValueTopicQuery.bpmn20.xml"})
    @Test
    public void testTopicQueryByVariableValues() {
        String topicName1 = "testTopic1";
        String topicName2 = "testTopic2";
        String topicName3 = "testTopic3";
        String variableName1 = "testVariable1";
        String variableName2 = "testVariable2";
        String variableName3 = "testVariable3";
        String variableValue1 = "testValue1";
        String variableValue2 = "testValue2";
        String variableValue3 = "testValue3";
        String variableValue4 = "testValue4";
        String variableValue5 = "testValue5";
        String variableValue6 = "testValue6";
        HashMap<String, String> variables = new HashMap<String, String>();
        Long lockDuration = 60000L;
        variables.put(variableName1, variableValue1);
        variables.put(variableName2, variableValue2);
        variables.put(variableName3, variableValue3);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", variables);
        variables.put(variableName1, variableValue4);
        variables.put(variableName2, variableValue5);
        variables.put(variableName3, variableValue6);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", variables);
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).processInstanceVariableEquals(variableName1, (Object)variableValue1).processInstanceVariableEquals(variableName2, (Object)variableValue2).topic(topicName2, lockDuration.longValue()).processInstanceVariableEquals(variableName2, (Object)variableValue5).processInstanceVariableEquals(variableName3, (Object)variableValue6).topic(topicName3, lockDuration.longValue()).processInstanceVariableEquals(variableName1, (Object)"fakeVariableValue").execute();
        Assert.assertEquals((long)2L, (long)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            if (externalTask.getTopicName().equals(topicName1)) {
                Assert.assertEquals((Object)variableValue1, (Object)externalTask.getVariables().get((Object)variableName1));
                Assert.assertEquals((Object)variableValue2, (Object)externalTask.getVariables().get((Object)variableName2));
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                Assert.assertEquals((Object)variableValue5, (Object)externalTask.getVariables().get((Object)variableName2));
                Assert.assertEquals((Object)variableValue6, (Object)externalTask.getVariables().get((Object)variableName3));
                continue;
            }
            Assert.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testVariableValueTopicQuery.bpmn20.xml"})
    @Test
    public void testTopicQueryByBusinessKeyAndVariableValue() {
        String topicName1 = "testTopic1";
        String topicName2 = "testTopic2";
        String topicName3 = "testTopic3";
        String businessKey1 = "testBusinessKey1";
        String businessKey2 = "testBusinessKey2";
        String variableName = "testVariable1";
        String variableValue1 = "testValue1";
        String variableValue2 = "testValue2";
        HashMap<String, String> variables = new HashMap<String, String>();
        Long lockDuration = 60000L;
        variables.put(variableName, variableValue1);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", businessKey1, variables);
        variables.put(variableName, variableValue2);
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcessTopicQueryVariableValues", businessKey2, variables);
        List topicTasks = this.externalTaskService.fetchAndLock(3, "externalWorkerId").topic(topicName1, lockDuration.longValue()).businessKey(businessKey1).processInstanceVariableEquals(variableName, (Object)variableValue1).topic(topicName2, lockDuration.longValue()).businessKey(businessKey2).processInstanceVariableEquals(variableName, (Object)variableValue2).topic(topicName3, lockDuration.longValue()).businessKey("fakeBusinessKey").execute();
        Assert.assertEquals((long)2L, (long)topicTasks.size());
        for (LockedExternalTask externalTask : topicTasks) {
            ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(externalTask.getProcessInstanceId()).singleResult();
            if (externalTask.getTopicName().equals(topicName1)) {
                Assert.assertEquals((Object)businessKey1, (Object)pi.getBusinessKey());
                Assert.assertEquals((Object)variableValue1, (Object)externalTask.getVariables().get((Object)variableName));
                continue;
            }
            if (externalTask.getTopicName().equals(topicName2)) {
                Assert.assertEquals((Object)businessKey2, (Object)pi.getBusinessKey());
                Assert.assertEquals((Object)variableValue2, (Object)externalTask.getVariables().get((Object)variableName));
                continue;
            }
            Assert.fail((String)"No other topic name values should be available!");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchAndLockByProcessDefinitionVersionTag.bpmn20.xml"})
    @Test
    public void testFetchAndLockByProcessDefinitionVersionTag() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        this.runtimeService.startProcessInstanceByKey("testFetchAndLockByProcessDefinitionVersionTag");
        Long totalExternalTasks = this.externalTaskService.createExternalTaskQuery().count();
        List fetchedExternalTasks = this.externalTaskService.fetchAndLock(1, "workerID").topic(TOPIC_NAME, 1000L).processDefinitionVersionTag("version X.Y").execute();
        Assertions.assertThat((Long)totalExternalTasks).isEqualTo(2L);
        Assertions.assertThat((int)fetchedExternalTasks.size()).isEqualTo(1);
        Assertions.assertThat((String)((LockedExternalTask)fetchedExternalTasks.get(0)).getProcessDefinitionKey()).isEqualTo((Object)"testFetchAndLockByProcessDefinitionVersionTag");
        Assertions.assertThat((String)((LockedExternalTask)fetchedExternalTasks.get(0)).getProcessDefinitionVersionTag()).isEqualTo((Object)"version X.Y");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchMultipleTopics.bpmn20.xml"})
    @Test
    public void testGetTopicNamesWithLockedTasks() {
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess");
        this.externalTaskService.fetchAndLock(1, WORKER_ID).topic("topic1", 10000L).execute();
        List result = this.externalTaskService.getTopicNames(true, false, false);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"topic1"});
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchMultipleTopics.bpmn20.xml"})
    @Test
    public void testGetTopicNamesWithUnlockedTasks() {
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess");
        this.externalTaskService.fetchAndLock(1, WORKER_ID).topic("topic1", 10000L).execute();
        List result = this.externalTaskService.getTopicNames(false, true, false);
        Assertions.assertThat((List)result).containsExactlyInAnyOrder((Object[])new String[]{"topic2", "topic3"});
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchMultipleTopics.bpmn20.xml"})
    @Test
    public void testGetTopicNamesWithRetries() {
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess");
        ExternalTask topic1Task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().topicName("topic1").singleResult();
        ExternalTask topic2Task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().topicName("topic2").singleResult();
        ExternalTask topic3Task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().topicName("topic3").singleResult();
        this.externalTaskService.setRetries(topic1Task.getId(), 3);
        this.externalTaskService.setRetries(topic2Task.getId(), 0);
        this.externalTaskService.setRetries(topic3Task.getId(), 0);
        List result = this.externalTaskService.getTopicNames(false, false, true);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"topic1"});
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchMultipleTopics.bpmn20.xml"})
    @Test
    public void testGetTopicNamesisDistinct() {
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess");
        this.runtimeService.startProcessInstanceByKey("parallelExternalTaskProcess");
        List result = this.externalTaskService.getTopicNames();
        Assertions.assertThat((List)result).containsExactlyInAnyOrder((Object[])new String[]{"topic1", "topic2", "topic3"});
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchAndLockWithExtensionProperties.bpmn20.xml"})
    @Test
    public void testFetchAndLockWithExtensionProperties_shouldReturnProperties() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithCustomProperties");
        List lockedExternalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).includeExtensionProperties().execute();
        Assertions.assertThat((List)lockedExternalTasks).hasSize(1);
        Assertions.assertThat((Map)((LockedExternalTask)lockedExternalTasks.get(0)).getExtensionProperties()).containsOnly(new Map.Entry[]{Assertions.entry((Object)"property1", (Object)"value1"), Assertions.entry((Object)"property2", (Object)"value2"), Assertions.entry((Object)"property3", (Object)"value3")});
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchAndLockWithoutExtensionProperties.bpmn20.xml"})
    @Test
    public void testFetchAndLockWithExtensionProperties_shouldReturnEmptyMap() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithoutCustomProperties");
        List lockedExternalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).includeExtensionProperties().execute();
        Assertions.assertThat((List)lockedExternalTasks).hasSize(1);
        Assertions.assertThat((Map)((LockedExternalTask)lockedExternalTasks.get(0)).getExtensionProperties()).isEmpty();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/ExternalTaskServiceTest.testFetchAndLockWithExtensionProperties.bpmn20.xml"})
    @Test
    public void testFetchAndLockWithoutExtensionProperties_shouldReturnEmptyMap() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithCustomProperties");
        List lockedExternalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assertions.assertThat((List)lockedExternalTasks).hasSize(1);
        Assertions.assertThat((Map)((LockedExternalTask)lockedExternalTasks.get(0)).getExtensionProperties()).isEmpty();
    }

    protected Date nowPlus(long millis) {
        return new Date(ClockUtil.getCurrentTime().getTime() + millis);
    }

    protected Date nowMinus(long millis) {
        return new Date(ClockUtil.getCurrentTime().getTime() - millis);
    }

    protected List<String> startProcessInstance(String key, int instances) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < instances; ++i) {
            ids.add(this.runtimeService.startProcessInstanceByKey(key, String.valueOf(i)).getId());
        }
        return ids;
    }

    protected void verifyVariables(LockedExternalTask task) {
        VariableMap variables = task.getVariables();
        Assert.assertEquals((long)4L, (long)variables.size());
        Assert.assertEquals((Object)42, (Object)variables.get((Object)"processVar1"));
        Assert.assertEquals((Object)43, (Object)variables.get((Object)"processVar2"));
        Assert.assertEquals((Object)44L, (Object)variables.get((Object)"subProcessVar"));
        Assert.assertEquals((Object)45L, (Object)variables.get((Object)"taskVar"));
    }

    protected List<HistoricExternalTaskLog> getHistoricTaskLogOrdered(String taskId) {
        return ((HistoricExternalTaskLogQuery)this.historyService.createHistoricExternalTaskLogQuery().failureLog().externalTaskId(taskId).orderByTimestamp().desc()).list();
    }

    public static class ReadLocalVariableListenerImpl
    implements ExecutionListener {
        public void notify(DelegateExecution execution) throws Exception {
            String value = (String)execution.getVariable("abc");
            Assert.assertEquals((Object)"bar", (Object)value);
        }
    }
}

