/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.MethodInvocation;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.test.util.TriConsumer;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MultiTenancySetTaskPropertyTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    protected static final BpmnModelInstance ONE_TASK_PROCESS = Bpmn.createExecutableProcess((String)"oneTaskProcess").startEvent().userTask().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected final String operationName;
    protected final TriConsumer<TaskService, String, Object> operation;
    protected final Object value;
    protected final String taskQueryBuilderMethodName;
    protected TaskService taskService;
    protected IdentityService identityService;
    protected String taskId;
    protected Task task;

    public MultiTenancySetTaskPropertyTest(String operationName, TriConsumer<TaskService, String, Object> operation, Object value, String taskQueryBuilderMethodName) {
        this.operationName = operationName;
        this.operation = operation;
        this.value = value;
        this.taskQueryBuilderMethodName = taskQueryBuilderMethodName;
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> data() {
        TriConsumer<TaskService, String, Object> setPriority = (taskService, taskId, value) -> taskService.setPriority(taskId, ((Integer)value).intValue());
        TriConsumer<TaskService, String, Object> setName = (taskService, taskId, value) -> taskService.setName(taskId, (String)value);
        TriConsumer<TaskService, String, Object> setDescription = (taskService, taskId, value) -> taskService.setDescription(taskId, (String)value);
        TriConsumer<TaskService, String, Object> setDueDate = (taskService, taskId, value) -> taskService.setDueDate(taskId, (Date)value);
        TriConsumer<TaskService, String, Object> setFollowUpDate = (taskService, taskId, value) -> taskService.setFollowUpDate(taskId, (Date)value);
        return Arrays.asList({"setPriority", setPriority, 1, "taskPriority"}, {"setName", setName, "name", "taskName"}, {"setDescription", setDescription, "description", "taskDescription"}, {"setDueDate", setDueDate, DateTime.now().toDate(), "dueDate"}, {"setFollowUpDate", setFollowUpDate, DateTime.now().toDate(), "followUpDate"});
    }

    @Before
    public void init() {
        this.testRule.deployForTenant(TENANT_ONE, ONE_TASK_PROCESS);
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        this.task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        this.taskId = this.task.getId();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    public void shouldSetOperationForTaskWithAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null, Collections.singletonList(TENANT_ONE));
        this.operation.accept(this.taskService, this.taskId, this.value);
        this.assertCorrespondingTaskQueryHasCount(1L);
    }

    @Test
    public void shouldSetOperationForTaskWithNoAuthenticatedTenant() {
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.operation.accept(this.taskService, this.taskId, this.value)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot assign the task '" + this.task.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void shouldSetOperationForTaskWithDisabledTenantCheck() {
        this.identityService.setAuthentication("aUserId", null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.operation.accept(this.taskService, this.taskId, this.value);
        this.assertCorrespondingTaskQueryHasCount(1L);
    }

    private void assertCorrespondingTaskQueryHasCount(long count) {
        TaskQuery query = this.taskService.createTaskQuery().taskId(this.taskId);
        query = this.withTaskCriteria(query, this.taskQueryBuilderMethodName, this.value);
        Assertions.assertThat((long)query.count()).isEqualTo(count);
    }

    private TaskQuery withTaskCriteria(TaskQuery taskQuery, String methodName, Object propertyValue) {
        return (TaskQuery)MethodInvocation.of(taskQuery, methodName, new Object[]{propertyValue}).invoke();
    }
}

