/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.compensate;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompensationEventParseInvalidProcessTest {
    private static final String PROCESS_DEFINITION_DIRECTORY = "org/camunda/bpm/engine/test/bpmn/event/compensate/";
    @Parameterized.Parameter(value=0)
    public String processDefinitionResource;
    @Parameterized.Parameter(value=1)
    public String expectedErrorMessage;
    @Parameterized.Parameter(value=2)
    public String[] bpmnElementIds;
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected RepositoryService repositoryService;

    @Parameterized.Parameters(name="{index}: process definition = {0}, expected error message = {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"CompensationEventParseInvalidProcessTest.illegalCompensateActivityRefParentScope.bpmn20.xml", "Invalid attribute value for 'activityRef': no activity with id 'someServiceInMainProcess' in scope 'subProcess'", new String[]{"throwCompensate"}}, {"CompensationEventParseInvalidProcessTest.illegalCompensateActivityRefNestedScope.bpmn20.xml", "Invalid attribute value for 'activityRef': no activity with id 'someServiceInNestedScope' in scope 'subProcess'", new String[]{"throwCompensate"}}, {"CompensationEventParseInvalidProcessTest.invalidActivityRefFails.bpmn20.xml", "Invalid attribute value for 'activityRef':", new String[]{"throwCompensate"}}, {"CompensationEventParseInvalidProcessTest.multipleCompensationCatchEventsCompensationAttributeMissingFails.bpmn20.xml", "compensation boundary catch must be connected to element with isForCompensation=true", new String[]{"compensateBookHotelEvt", "undoBookHotel", "Association"}}, {"CompensationEventParseInvalidProcessTest.multipleCompensationCatchEventsFails.bpmn20.xml", "multiple boundary events with compensateEventDefinition not supported on same activity", new String[]{"compensateBookHotelEvt2"}}, {"CompensationEventParseInvalidProcessTest.multipleCompensationEventSubProcesses.bpmn20.xml", "multiple event subprocesses with compensation start event are not supported on the same scope", new String[]{"startInCompensationScope2"}}, {"CompensationEventParseInvalidProcessTest.compensationEventSubProcessesAtProcessLevel.bpmn20.xml", "event subprocess with compensation start event is only supported for embedded subprocess", new String[]{"startInCompensationScope"}}, {"CompensationEventParseInvalidProcessTest.compensationEventSubprocessAndBoundaryEvent.bpmn20.xml", "compensation boundary event and event subprocess with compensation start event are not supported on the same scope", new String[]{"subprocess", "compensateSubProcess"}}, {"CompensationEventParseInvalidProcessTest.invalidOutgoingSequenceflow.bpmn20.xml", "Invalid outgoing sequence flow of compensation activity 'undoTask'. A compensation activity should not have an incoming or outgoing sequence flow.", new String[]{"undoTask"}}, {"CompensationEventParseInvalidProcessTest.invalidIncomingSequenceflow.bpmn20.xml", "Invalid incoming sequence flow of compensation activity 'task'. A compensation activity should not have an incoming or outgoing sequence flow.", new String[]{"task"}});
    }

    @Before
    public void initServices() {
        this.repositoryService = this.rule.getRepositoryService();
    }

    @Test
    public void testParseInvalidProcessDefinition() {
        block2: {
            try {
                this.repositoryService.createDeployment().addClasspathResource(PROCESS_DEFINITION_DIRECTORY + this.processDefinitionResource).deploy();
                Assert.fail((String)("exception expected: " + this.expectedErrorMessage));
            }
            catch (ParseException e) {
                this.assertExceptionMessageContainsText((Exception)((Object)e), this.expectedErrorMessage);
                List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
                Assertions.assertThat((int)errors.size()).isEqualTo(1);
                Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)this.bpmnElementIds[0]);
                if (this.bpmnElementIds.length != 2) break block2;
                Assertions.assertThat((List)((Problem)errors.get(0)).getElementIds()).containsExactlyInAnyOrder((Object[])this.bpmnElementIds);
            }
        }
    }

    public void assertExceptionMessageContainsText(Exception e, String expectedMessage) {
        String actualMessage = e.getMessage();
        if (actualMessage == null || !actualMessage.contains(expectedMessage)) {
            throw new AssertionFailedError("expected presence of [" + expectedMessage + "], but was [" + actualMessage + "]");
        }
    }
}

