/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.executionlistener;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.bpmn.executionlistener.ThrowingHistoryEventProducer;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="audit")
public class ThrowingHistoryExecutionListenerTest {
    protected static final String PROCESS_KEY = "Process";
    protected static final String INTERNAL_ERROR_CODE = "208";
    protected static final ThrowingHistoryEventProducer HISTORY_PRODUCER = new ThrowingHistoryEventProducer();
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(config -> config.setHistoryEventProducer((HistoryEventProducer)HISTORY_PRODUCER));
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.processEngineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.processEngineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected RepositoryService repositoryService;

    @Before
    public void initServices() {
        this.runtimeService = this.processEngineRule.getRuntimeService();
        this.taskService = this.processEngineRule.getTaskService();
        this.historyService = this.processEngineRule.getHistoryService();
        this.managementService = this.processEngineRule.getManagementService();
        this.repositoryService = this.processEngineRule.getRepositoryService();
    }

    @After
    public void reset() {
        HISTORY_PRODUCER.reset();
    }

    @Test
    public void shouldFailForExceptionInHistoryListenerAfterBpmnErrorInEndListenerWithErrorBoundary() {
        HISTORY_PRODUCER.failsWithException().failsAtActivity("throw");
        BpmnModelInstance model = this.createModelWithCatchInServiceTaskAndListener("end");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(RuntimeException.class)).hasMessage("Intended exception from history producer");
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
    }

    @Test
    public void shouldFailForExceptionInHistoryListenerAfterBpmnErrorInEndListenerWithErrorBoundaryOnSubprocess() {
        HISTORY_PRODUCER.failsWithException().failsAtActivity("throw");
        BpmnModelInstance model = this.createModelWithCatchInSubprocessAndListener("end");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(RuntimeException.class)).hasMessage("Intended exception from history producer");
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
    }

    @Test
    public void shouldFailForExceptionInHistoryListenerAfterBpmnErrorInEndListenerWithErrorStartInEventSubprocess() {
        HISTORY_PRODUCER.failsWithException().failsAtActivity("throw");
        BpmnModelInstance model = this.createModelWithCatchInEventSubprocessAndListener("end");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(RuntimeException.class)).hasMessage("Intended exception from history producer");
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
    }

    @Test
    public void shouldFailForExceptionInHistoryListenerAfterBpmnErrorInStartListenerWithErrorBoundary() {
        HISTORY_PRODUCER.failsWithException().failsAtActivity("throw");
        BpmnModelInstance model = this.createModelWithCatchInServiceTaskAndListener("start");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(RuntimeException.class)).hasMessage("Intended exception from history producer");
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
    }

    @Test
    public void shouldFailForExceptionInHistoryListenerAfterBpmnErrorInStartListenerWithErrorBoundaryOnSubprocess() {
        HISTORY_PRODUCER.failsWithException().failsAtActivity("throw");
        BpmnModelInstance model = this.createModelWithCatchInSubprocessAndListener("start");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(RuntimeException.class)).hasMessage("Intended exception from history producer");
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
    }

    @Test
    public void shouldFailForExceptionInHistoryListenerAfterBpmnErrorInStartListenerWithErrorStartInEventSubprocess() {
        HISTORY_PRODUCER.failsWithException().failsAtActivity("throw");
        BpmnModelInstance model = this.createModelWithCatchInEventSubprocessAndListener("start");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(RuntimeException.class)).hasMessage("Intended exception from history producer");
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
    }

    @Test
    public void shouldCatchBpmnErrorFromHistoryListenerAfterBpmnErrorInEndListenerWithErrorBoundary() {
        HISTORY_PRODUCER.failsAtActivity("throw");
        BpmnModelInstance model = this.createModelWithCatchInServiceTaskAndListener("end");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyHistoryListenerErrorGotCaught();
        this.verifyActivityRunning("throw");
    }

    @Test
    public void shouldCatchBpmnErrorFromHistoryListenerAfterBpmnErrorInEndListenerWithErrorBoundaryOnSubprocess() {
        HISTORY_PRODUCER.failsAtActivity("throw");
        BpmnModelInstance model = this.createModelWithCatchInSubprocessAndListener("end");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyHistoryListenerErrorGotCaught();
        this.verifyActivityRunning("throw");
    }

    @Test
    public void shouldCatchBpmnErrorFromHistoryListenerAfterBpmnErrorInEndListenerWithErrorStartInEventSubprocess() {
        HISTORY_PRODUCER.failsAtActivity("throw");
        BpmnModelInstance model = this.createModelWithCatchInEventSubprocessAndListener("end");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.complete(task.getId());
        this.verifyHistoryListenerErrorGotCaught();
        this.verifyActivityRunning("throw");
    }

    @Test
    public void shouldFailForBpmnErrorInHistoryListenerAfterBpmnErrorInStartListenerWithErrorBoundary() {
        HISTORY_PRODUCER.failsAtActivity("throw");
        BpmnModelInstance model = this.createModelWithCatchInServiceTaskAndListener("start");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(BpmnError.class);
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
    }

    @Test
    public void shouldFailForBpmnErrorInHistoryListenerAfterBpmnErrorInStartListenerWithErrorBoundaryOnSubprocess() {
        HISTORY_PRODUCER.failsAtActivity("throw");
        BpmnModelInstance model = this.createModelWithCatchInSubprocessAndListener("start");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(BpmnError.class);
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
    }

    @Test
    public void shouldFailForBpmnErrorInHistoryListenerAfterBpmnErrorInStartListenerWithErrorStartInEventSubprocess() {
        HISTORY_PRODUCER.failsAtActivity("throw");
        BpmnModelInstance model = this.createModelWithCatchInEventSubprocessAndListener("start");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        Assertions.assertThatThrownBy(() -> this.taskService.complete(task.getId())).isInstanceOf(BpmnError.class);
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
    }

    protected BpmnModelInstance createModelWithCatchInServiceTaskAndListener(String eventName) {
        return ((BoundaryEventBuilder)((BoundaryEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("userTask1").serviceTask("throw").camundaExecutionListenerClass(eventName, ThrowBPMNErrorDelegate.class)).camundaExpression("${true}")).boundaryEvent("errorEvent").error(INTERNAL_ERROR_CODE)).userTask("afterCatchInternal").endEvent("endEventInternal").moveToActivity("throw").boundaryEvent("errorEventHistory").error("508")).userTask("afterCatchHistory").endEvent("endEventHistory").moveToActivity("throw").userTask("afterService").endEvent().done();
    }

    protected BpmnModelInstance createModelWithCatchInSubprocessAndListener(String eventName) {
        return ((BoundaryEventBuilder)((BoundaryEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask("userTask1").subProcess("sub").embeddedSubProcess().startEvent("inSub").serviceTask("throw").camundaExecutionListenerClass(eventName, ThrowBPMNErrorDelegate.class)).camundaExpression("${true}")).userTask("afterService").endEvent().subProcessDone().boundaryEvent("errorEvent").error(INTERNAL_ERROR_CODE)).userTask("afterCatch").endEvent("endEvent").moveToActivity("sub").boundaryEvent("errorEventHistory").error("508")).userTask("afterCatchHistory").endEvent("endEventHistory").moveToActivity("sub").userTask("afterSub").endEvent().done();
    }

    protected BpmnModelInstance createModelWithCatchInEventSubprocessAndListener(String eventName) {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_KEY);
        BpmnModelInstance model = ((ServiceTaskBuilder)((ServiceTaskBuilder)processBuilder.startEvent().userTask("userTask1").serviceTask("throw").camundaExecutionListenerClass(eventName, ThrowBPMNErrorDelegate.class)).camundaExpression("${true}")).userTask("afterService").endEvent().done();
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent("errorEvent").error(INTERNAL_ERROR_CODE)).userTask("afterCatch").endEvent();
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent("errorEventHistory").error("508")).userTask("afterCatchHistory").endEvent();
        return model;
    }

    protected void verifyHistoryListenerErrorGotCaught() {
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().list().size());
        Assert.assertEquals((Object)"afterCatchHistory", (Object)((Task)this.taskService.createTaskQuery().singleResult()).getName());
    }

    protected void verifyActivityRunning(String activityName) {
        Assertions.assertThat((long)this.historyService.createHistoricActivityInstanceQuery().activityName(activityName).unfinished().count()).isEqualTo(1L);
    }

    public static class ThrowBPMNErrorDelegate
    implements ExecutionListener {
        public void notify(DelegateExecution execution) throws Exception {
            throw new BpmnError("508", "business error");
        }
    }
}

