/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.scripttask;

import java.util.Date;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.bpmn.scripttask.AbstractScriptTaskTest;
import org.camunda.bpm.engine.test.bpmn.scripttask.MySerializable;
import org.junit.Assert;
import org.junit.Test;

public class ScriptTaskNashornTest
extends AbstractScriptTaskTest {
    private static final String NASHORN = "nashorn";

    @Test
    public void testJavascriptProcessVarVisibility() {
        this.deployProcess(NASHORN, "execution.setVariable('foo', 'a');if (typeof foo !== 'undefined') {   throw 'Variable foo should be defined as script variable.';}var foo = 'b';if(execution.getVariable('foo') != 'a') {  throw 'Execution should contain variable foo';}if(foo != 'b') {  throw 'Script variable must override the visibiltity of the execution variable.';}");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
        Assert.assertEquals((Object)"a", (Object)variableValue);
    }

    @Test
    public void testJavascriptFunctionInvocation() {
        this.deployProcess(NASHORN, "function sum(a,b){  return a+b;};var result = sum(1,2);execution.setVariable('foo', result);");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variable = this.runtimeService.getVariable(pi.getId(), "foo");
        Assertions.assertThat((Object)variable).isIn(new Object[]{3, 3.0});
    }

    @Test
    public void testJsVariable() {
        String scriptText = "var foo = 1;";
        this.deployProcess(NASHORN, scriptText);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
        Assert.assertNull((Object)variableValue);
    }

    @Test
    public void testJavascriptVariableSerialization() {
        this.deployProcess(NASHORN, "execution.setVariable('date', new java.util.Date(0));");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Date date = (Date)this.runtimeService.getVariable(pi.getId(), "date");
        Assert.assertEquals((long)0L, (long)date.getTime());
        this.deployProcess(NASHORN, "execution.setVariable('myVar', new org.camunda.bpm.engine.test.bpmn.scripttask.MySerializable('test'));");
        pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        MySerializable myVar = (MySerializable)this.runtimeService.getVariable(pi.getId(), "myVar");
        Assert.assertEquals((Object)"test", (Object)myVar.getName());
    }

    @Test
    public void shouldLoadExternalScript() {
        this.deployProcess(NASHORN, "load(\"" + this.getNormalizedResourcePath("/org/camunda/bpm/engine/test/bpmn/scripttask/sum.js") + "\");execution.setVariable('foo', sum(3, 4));");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        Object variableValue = this.runtimeService.getVariable(pi.getId(), "foo");
        Assertions.assertThat((Object)variableValue).isInstanceOf(Number.class);
        Assertions.assertThat((int)((Number)variableValue).intValue()).isEqualTo(7);
    }
}

