/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.history.handler.CompositeDbHistoryEventHandler;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.history.AbstractCompositeHistoryEventHandlerTest;
import org.junit.Test;

public class CompositeDbHistoryEventHandlerTest
extends AbstractCompositeHistoryEventHandlerTest {
    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseCompositeDbHistoryEventHandlerNonArgumentConstructor() {
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)new CompositeDbHistoryEventHandler());
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isZero();
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isEqualTo(2L);
    }

    @Test
    public void shouldUseCompositeDbHistoryEventHandlerNonArgumentConstructorAddNullEvent() {
        CompositeDbHistoryEventHandler compositeDbHistoryEventHandler = new CompositeDbHistoryEventHandler();
        try {
            compositeDbHistoryEventHandler.add(null);
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"History event handler is null");
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseCompositeDbHistoryEventHandlerNonArgumentConstructorAddNotNullEvent() {
        CompositeDbHistoryEventHandler compositeDbHistoryEventHandler = new CompositeDbHistoryEventHandler();
        compositeDbHistoryEventHandler.add((HistoryEventHandler)new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeDbHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isEqualTo(2);
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isEqualTo(2L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseCompositeDbHistoryEventHandlerNonArgumentConstructorAddTwoNotNullEvents() {
        CompositeDbHistoryEventHandler compositeDbHistoryEventHandler = new CompositeDbHistoryEventHandler();
        compositeDbHistoryEventHandler.add((HistoryEventHandler)new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        compositeDbHistoryEventHandler.add((HistoryEventHandler)new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeDbHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isEqualTo(4);
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isEqualTo(2L);
    }

    @Test
    public void shouldUseCompositeDbHistoryEventHandlerArgumentConstructorWithNullVarargs() {
        Object historyEventHandler = null;
        try {
            new CompositeDbHistoryEventHandler(new HistoryEventHandler[]{historyEventHandler});
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"History event handler is null");
        }
    }

    @Test
    public void shouldUseCompositeDbHistoryEventHandlerArgumentConstructorWithNullTwoVarargs() {
        try {
            new CompositeDbHistoryEventHandler(new HistoryEventHandler[]{null, null});
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"History event handler is null");
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseCompositeDbHistoryEventHandlerArgumentConstructorWithNotNullVarargsOneEvent() {
        CompositeDbHistoryEventHandler compositeDbHistoryEventHandler = new CompositeDbHistoryEventHandler(new HistoryEventHandler[]{new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler()});
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeDbHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isEqualTo(2);
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isEqualTo(2L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseCompositeDbHistoryEventHandlerArgumentConstructorWithNotNullVarargsTwoEvents() {
        CompositeDbHistoryEventHandler compositeDbHistoryEventHandler = new CompositeDbHistoryEventHandler(new HistoryEventHandler[]{new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler(), new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler()});
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeDbHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isEqualTo(4);
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isEqualTo(2L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseCompositeDbHistoryEventHandlerArgumentConstructorWithEmptyList() {
        CompositeDbHistoryEventHandler compositeDbHistoryEventHandler = new CompositeDbHistoryEventHandler(new ArrayList());
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeDbHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isZero();
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isEqualTo(2L);
    }

    @Test
    public void shouldUseCompositeDbHistoryEventHandlerArgumentConstructorWithNotEmptyListNullTwoEvents() {
        ArrayList<Object> historyEventHandlers = new ArrayList<Object>();
        historyEventHandlers.add(null);
        historyEventHandlers.add(null);
        try {
            new CompositeDbHistoryEventHandler(historyEventHandlers);
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"History event handler is null");
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoryLevelTest.bpmn20.xml"})
    public void shouldUseCompositeDbHistoryEventHandlerArgumentConstructorWithNotEmptyListNotNullTwoEvents() {
        ArrayList<AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler> historyEventHandlers = new ArrayList<AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler>();
        historyEventHandlers.add(new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        historyEventHandlers.add(new AbstractCompositeHistoryEventHandlerTest.CustomDbHistoryEventHandler());
        CompositeDbHistoryEventHandler compositeDbHistoryEventHandler = new CompositeDbHistoryEventHandler(historyEventHandlers);
        this.processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeDbHistoryEventHandler);
        this.startProcessAndCompleteUserTask();
        Assertions.assertThat((int)this.countCustomHistoryEventHandler).isEqualTo(4);
        Assertions.assertThat((long)this.historyService.createHistoricDetailQuery().count()).isEqualTo(2L);
    }
}

