/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import java.util.Arrays;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.oplog.UserOperationLogContext;
import org.camunda.bpm.engine.impl.oplog.UserOperationLogContextEntry;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class CustomUserOperationLogTest {
    public static final String USER_ID = "demo";
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/camunda/bpm/engine/test/history/useroperationlog/enable.legacy.user.operation.log.camunda.cfg.xml");
    private static final String TASK_ID = UUID.randomUUID().toString();
    private CommandExecutor commandExecutor;
    private HistoryService historyService;

    @Before
    public void setUp() throws Exception {
        this.commandExecutor = ((ProcessEngineConfigurationImpl)bootstrapRule.getProcessEngine().getProcessEngineConfiguration()).getCommandExecutorTxRequired();
        this.historyService = bootstrapRule.getProcessEngine().getHistoryService();
    }

    @Test
    public void testDoNotOverwriteUserId() throws Exception {
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                UserOperationLogContext userOperationLogContext = new UserOperationLogContext();
                userOperationLogContext.setUserId("kermit");
                UserOperationLogContextEntry entry = new UserOperationLogContextEntry("foo", "bar");
                entry.setPropertyChanges(Arrays.asList(new PropertyChange(null, null, null)));
                entry.setTaskId(TASK_ID);
                userOperationLogContext.addEntry(entry);
                commandContext.getOperationLogManager().logUserOperations(userOperationLogContext);
                return null;
            }
        });
        Assertions.assertThat((String)((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().taskId(TASK_ID).singleResult()).getUserId()).isEqualTo((Object)"kermit");
    }
}

