/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.jobexecutor.AbstractJobExecutorAcquireJobsTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class HistoryCleanupJobPriorityRangeTest
extends AbstractJobExecutorAcquireJobsTest {
    protected HistoryService historyService;
    protected long defaultHistoryCleanupJobPriority;
    protected boolean defaultIsJobExecutorAcquireByPriority;

    @Before
    public void setup() {
        this.historyService = this.rule.getHistoryService();
        this.defaultHistoryCleanupJobPriority = this.configuration.getHistoryCleanupJobPriority();
        this.defaultIsJobExecutorAcquireByPriority = this.configuration.isJobExecutorAcquireByPriority();
    }

    @After
    public void tearDown() {
        this.configuration.setHistoryCleanupJobPriority(this.defaultHistoryCleanupJobPriority);
        this.configuration.setJobExecutorAcquireByPriority(this.defaultIsJobExecutorAcquireByPriority);
        this.resetDatabase();
    }

    private void resetDatabase() {
        this.configuration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = HistoryCleanupJobPriorityRangeTest.this.historyService.findHistoryCleanupJobs();
                for (Job job : jobs) {
                    commandContext.getJobManager().deleteJob((JobEntity)job);
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
                }
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
    }

    @Test
    public void shouldSetConfiguredPriorityOnHistoryCleanupJob() {
        this.configuration.setHistoryCleanupJobPriority(10L);
        this.historyService.cleanUpHistoryAsync(true);
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        Assertions.assertThat((List)historyCleanupJobs).hasSize(1);
        Assertions.assertThat((long)((Job)historyCleanupJobs.get(0)).getPriority()).isEqualTo(10L);
    }

    @Test
    public void shouldAcquireHistoryCleanupJobInPriorityRange() {
        this.configuration.setJobExecutorPriorityRangeMin(5L);
        this.configuration.setJobExecutorPriorityRangeMax(15L);
        this.configuration.setHistoryCleanupJobPriority(10L);
        this.historyService.cleanUpHistoryAsync(true);
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).hasSize(1);
        Assertions.assertThat((long)this.findJobById(acquirableJobs.get(0).getId()).getPriority()).isEqualTo(10L);
    }

    @Test
    public void shouldNotAcquireHistoryCleanupJobOutsidePriorityRange() {
        this.configuration.setJobExecutorAcquireByPriority(true);
        this.configuration.setJobExecutorPriorityRangeMin(5L);
        this.configuration.setJobExecutorPriorityRangeMax(15L);
        this.configuration.setHistoryCleanupJobPriority(20L);
        this.historyService.cleanUpHistoryAsync(true);
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).hasSize(0);
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        Assertions.assertThat((List)historyCleanupJobs).hasSize(1);
        Assertions.assertThat((long)((Job)historyCleanupJobs.get(0)).getPriority()).isEqualTo(20L);
    }
}

