/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.runtime.FailingDelegate;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.standalone.history.CustomHistoryLevelIncident;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CustomHistoryLevelIncidentTest {
    @Parameterized.Parameter(value=0)
    public static List<HistoryEventTypes> eventTypes;
    static CustomHistoryLevelIncident customHistoryLevelIncident;
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule;
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper migrationHelper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.migrationRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected RepositoryService repositoryService;
    protected TaskService taskService;
    protected ProcessEngineConfigurationImpl configuration;
    DeploymentWithDefinitions deployment;
    public static String PROCESS_DEFINITION_KEY;
    public static BpmnModelInstance FAILING_SERVICE_TASK_MODEL;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({Arrays.asList(HistoryEventTypes.INCIDENT_CREATE)}, {Arrays.asList(HistoryEventTypes.INCIDENT_CREATE, HistoryEventTypes.INCIDENT_RESOLVE)}, {Arrays.asList(HistoryEventTypes.INCIDENT_DELETE, HistoryEventTypes.INCIDENT_CREATE, HistoryEventTypes.INCIDENT_MIGRATE, HistoryEventTypes.INCIDENT_RESOLVE)});
    }

    @Before
    public void setUp() throws Exception {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.taskService = this.engineRule.getTaskService();
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        customHistoryLevelIncident.setEventTypes(eventTypes);
        this.configuration.setHistoryCleanupStrategy("endTimeBased");
    }

    @After
    public void tearDown() throws Exception {
        customHistoryLevelIncident.setEventTypes(null);
        if (this.deployment != null) {
            this.repositoryService.deleteDeployment(this.deployment.getId(), true);
        }
        this.migrationHelper.removeAllRunningAndHistoricBatches();
        this.configuration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = CustomHistoryLevelIncidentTest.this.managementService.createJobQuery().list();
                for (Job job : jobs) {
                    commandContext.getJobManager().deleteJob((JobEntity)job);
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
                }
                List historicIncidents = CustomHistoryLevelIncidentTest.this.historyService.createHistoricIncidentQuery().list();
                for (HistoricIncident historicIncident : historicIncidents) {
                    commandContext.getDbEntityManager().delete((DbEntity)((HistoricIncidentEntity)historicIncident));
                }
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
    }

    @Test
    public void testDeleteHistoricIncidentByProcDefId() {
        this.deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", FAILING_SERVICE_TASK_MODEL).deployWithResult();
        String processDefinitionId = ((ProcessDefinition)this.deployment.getDeployedProcessDefinitions().get(0)).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        this.executeAvailableJobs();
        if (eventTypes != null) {
            HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
            Assert.assertNotNull((Object)historicIncident);
        }
        this.repositoryService.deleteProcessDefinitions().byKey(PROCESS_DEFINITION_KEY).cascade().delete();
        List incidents = this.historyService.createHistoricIncidentQuery().list();
        Assert.assertEquals((long)0L, (long)incidents.size());
    }

    @Test
    public void testDeleteHistoricIncidentByBatchId() {
        this.initBatchOperationHistoryTimeToLive();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)-11));
        BatchEntity batch = (BatchEntity)this.createFailingMigrationBatch();
        this.migrationHelper.completeSeedJobs((Batch)batch);
        List list = this.managementService.createJobQuery().list();
        for (Job job : list) {
            if (!((JobEntity)job).getJobHandlerType().equals("instance-migration")) continue;
            this.managementService.setJobRetries(job.getId(), 1);
        }
        this.migrationHelper.executeJobs((Batch)batch);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)-10));
        this.managementService.deleteBatch(batch.getId(), false);
        ClockUtil.setCurrentTime((Date)new Date());
        if (eventTypes != null) {
            HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
            Assert.assertNotNull((Object)historicIncident);
        }
        this.historyService.cleanUpHistoryAsync(true);
        for (Job job : this.historyService.findHistoryCleanupJobs()) {
            this.managementService.executeJob(job.getId());
        }
        List incidents = this.historyService.createHistoricIncidentQuery().list();
        Assert.assertEquals((long)0L, (long)incidents.size());
    }

    @Test
    public void testDeleteHistoricIncidentByJobDefinitionId() {
        BatchEntity batch = (BatchEntity)this.createFailingMigrationBatch();
        this.migrationHelper.completeSeedJobs((Batch)batch);
        List list = this.managementService.createJobQuery().list();
        for (Job job : list) {
            if (!((JobEntity)job).getJobHandlerType().equals("instance-migration")) continue;
            this.managementService.setJobRetries(job.getId(), 1);
        }
        this.migrationHelper.executeJobs((Batch)batch);
        if (eventTypes != null) {
            HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
            Assert.assertNotNull((Object)historicIncident);
        }
        this.managementService.deleteBatch(batch.getId(), true);
        List incidents = this.historyService.createHistoricIncidentQuery().list();
        Assert.assertEquals((long)0L, (long)incidents.size());
    }

    protected void executeAvailableJobs() {
        List jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        if (jobs.isEmpty()) {
            return;
        }
        for (Job job : jobs) {
            try {
                this.managementService.executeJob(job.getId());
            }
            catch (Exception exception) {}
        }
        this.executeAvailableJobs();
    }

    protected void initBatchOperationHistoryTimeToLive() {
        this.configuration.setBatchOperationHistoryTimeToLive("P0D");
        this.configuration.initHistoryCleanup();
    }

    protected Batch createFailingMigrationBatch() {
        BpmnModelInstance instance = this.createModelInstance();
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(instance);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(instance);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        Batch batch = this.runtimeService.newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId(), "unknownId")).executeAsync();
        return batch;
    }

    protected BpmnModelInstance createModelInstance() {
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)"process").startEvent("start").userTask("userTask1").endEvent("end").done();
        return instance;
    }

    static {
        customHistoryLevelIncident = new CustomHistoryLevelIncident(eventTypes);
        bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
            configuration.setJdbcUrl("jdbc:h2:mem:" + CustomHistoryLevelIncident.class.getSimpleName());
            ArrayList<CustomHistoryLevelIncident> levels = new ArrayList<CustomHistoryLevelIncident>();
            levels.add(customHistoryLevelIncident);
            configuration.setCustomHistoryLevels(levels);
            configuration.setHistory("aCustomHistoryLevelIncident");
            configuration.setDatabaseSchemaUpdate("create-drop");
        });
        PROCESS_DEFINITION_KEY = "oneFailingServiceTaskProcess";
        FAILING_SERVICE_TASK_MODEL = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent("start").serviceTask("task").camundaAsyncBefore()).camundaClass(FailingDelegate.class.getName())).endEvent("end").done();
    }
}

