/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.Removable;
import org.camunda.bpm.engine.test.util.RemoveAfter;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRemoveRule
extends TestWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(EntityRemoveRule.class);
    private final Removable removable;

    private EntityRemoveRule(ProcessEngineTestRule engineTestRule) {
        this.removable = Removable.of(engineTestRule);
    }

    public static EntityRemoveRule of(ProcessEngineTestRule rule) {
        return new EntityRemoveRule(rule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement apply(final Statement base, Description description) {
        final RemoveAfter removeAfterAnnotation = this.getAnnotation(description, RemoveAfter.class);
        final boolean methodHasRemoveAfterAnnotation = removeAfterAnnotation != null;
        try {
            Statement statement = new Statement(){

                public void evaluate() throws Throwable {
                    base.evaluate();
                    if (!methodHasRemoveAfterAnnotation) {
                        return;
                    }
                    if (EntityRemoveRule.this.hasZeroArguments(removeAfterAnnotation)) {
                        EntityRemoveRule.this.removable.removeAll();
                        return;
                    }
                    EntityRemoveRule.this.removable.remove(removeAfterAnnotation.value());
                }
            };
            return statement;
        }
        finally {
            LOG.debug("deleteTasks: {}", (Object)methodHasRemoveAfterAnnotation);
        }
    }

    private boolean hasZeroArguments(RemoveAfter annotation) {
        return annotation.value() == null || annotation.value().length == 0;
    }

    private <T extends Annotation> T getAnnotation(Description description, Class<T> annotation) {
        String methodName = description.getMethodName();
        try {
            Class testClass = description.getTestClass();
            String methodWithoutParamsName = methodName.split("\\[")[0];
            Method method = testClass.getMethod(methodWithoutParamsName, new Class[0]);
            return method.getAnnotation(annotation);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to fetch annotation | annotationName: " + annotation.getName() + ", methodName: " + methodName, e);
        }
    }
}

