/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.util.EntityRemoveException;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Removable {
    private static final Logger LOG = LoggerFactory.getLogger(Removable.class);
    private final ProcessEngine engine;
    private final Map<Class<?>, ThrowingRunnable> mappings;

    private Removable(ProcessEngine engine) {
        HashMap mappings = new HashMap();
        mappings.put(Task.class, this::removeAllTasks);
        mappings.put(ProcessInstance.class, this::removeAllProcessInstances);
        mappings.put(Deployment.class, this::removeAllDeployments);
        mappings.put(Incident.class, this::removeAllIncidents);
        mappings.put(HistoricIncident.class, this::removeAllHistoricIncidents);
        mappings.put(HistoricProcessInstance.class, this::removeAllHistoricProcessInstances);
        mappings.put(HistoricDecisionInstance.class, this::removeAllHistoricDecisionInstances);
        mappings.put(HistoricCaseInstance.class, this::removeAllHistoricCaseInstances);
        mappings.put(HistoryCleanupJobDeclaration.class, this::removeHistoryCleanupJobRelatedEntries);
        this.engine = engine;
        this.mappings = mappings;
    }

    public static Removable of(ProcessEngineTestRule rule) {
        Objects.requireNonNull(rule);
        Objects.requireNonNull(rule.processEngineRule);
        return Removable.of(rule.processEngineRule.getProcessEngine());
    }

    public static Removable of(ProcessEngine engine) {
        Objects.requireNonNull(engine);
        return new Removable(engine);
    }

    public void remove(Class<?> clazz) throws EntityRemoveException {
        Objects.requireNonNull(clazz, "remove does not accept null arguments");
        ThrowingRunnable runnable = this.mappings.get(clazz);
        if (runnable == null) {
            throw new UnsupportedOperationException("class " + clazz.getName() + " is not supported yet for Removal");
        }
        try {
            runnable.execute();
        }
        catch (Exception e) {
            throw new EntityRemoveException(e);
        }
    }

    public void remove(Class<?>[] classes) throws EntityRemoveException {
        Objects.requireNonNull(classes, "remove does not accept null arguments");
        for (Class<?> clazz : classes) {
            this.remove(clazz);
        }
    }

    public void removeAll() throws EntityRemoveException {
        try {
            for (Map.Entry<Class<?>, ThrowingRunnable> entry : this.mappings.entrySet()) {
                ThrowingRunnable runnable = entry.getValue();
                runnable.execute();
            }
        }
        catch (Exception e) {
            throw new EntityRemoveException(e);
        }
    }

    private void removeHistoryCleanupJobRelatedEntries() {
        HistoryService historyService = this.engine.getHistoryService();
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)this.engine.getProcessEngineConfiguration();
        config.getCommandExecutorTxRequired().execute(context -> {
            List jobs = historyService.findHistoryCleanupJobs();
            for (Object job : jobs) {
                context.getJobManager().deleteJob((JobEntity)job);
                context.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
            }
            List list = historyService.createHistoricJobLogQuery().list();
            for (HistoricJobLog jobLog : list) {
                context.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobLog.getJobId());
            }
            List historicIncidents = historyService.createHistoricIncidentQuery().list();
            for (HistoricIncident historicIncident : historicIncidents) {
                context.getDbEntityManager().delete((DbEntity)((HistoricIncidentEntity)historicIncident));
            }
            context.getMeterLogManager().deleteAll();
            return null;
        });
    }

    private void removeAllHistoricProcessInstances() {
        HistoryService historyService = this.engine.getHistoryService();
        List historicProcessInstances = historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
        }
    }

    private void removeAllHistoricDecisionInstances() {
        HistoryService historyService = this.engine.getHistoryService();
        List historicDecisionInstances = historyService.createHistoricDecisionInstanceQuery().list();
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
        }
    }

    private void removeAllHistoricCaseInstances() {
        HistoryService historyService = this.engine.getHistoryService();
        List historicCaseInstances = historyService.createHistoricCaseInstanceQuery().list();
        for (HistoricCaseInstance historicCaseInstance : historicCaseInstances) {
            historyService.deleteHistoricCaseInstance(historicCaseInstance.getId());
        }
    }

    private void removeAllTasks() {
        try {
            TaskService taskService = this.engine.getTaskService();
            List tasks = taskService.createTaskQuery().list();
            for (Task task : tasks) {
                LOG.debug("deleteTask with taskId: {}", (Object)task.getId());
                taskService.deleteTask(task.getId(), true);
            }
        }
        catch (Exception e) {
            throw new EntityRemoveException(e);
        }
    }

    private void removeAllDeployments() {
        RepositoryService repositoryService = this.engine.getRepositoryService();
        for (Deployment deployment : this.engine.getRepositoryService().createDeploymentQuery().list()) {
            repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    private void removeAllProcessInstances() {
        try {
            RuntimeService runtimeService = this.engine.getRuntimeService();
            for (ProcessInstance processInstance : runtimeService.createProcessInstanceQuery().list()) {
                runtimeService.deleteProcessInstance(processInstance.getId(), "test ended", true);
            }
        }
        catch (Exception e) {
            throw new EntityRemoveException(e);
        }
    }

    private void removeAllHistoricIncidents() {
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)this.engine.getProcessEngineConfiguration();
        CommandExecutor commandExecutor = engineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute(commandContext -> {
            HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
            if (historyLevel.equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                List incidents = Context.getProcessEngineConfiguration().getHistoryService().createHistoricIncidentQuery().list();
                for (HistoricIncident incident : incidents) {
                    commandContext.getHistoricIncidentManager().delete((DbEntity)((HistoricIncidentEntity)incident));
                }
            }
            return null;
        });
    }

    private void removeAllIncidents() {
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)this.engine.getProcessEngineConfiguration();
        CommandExecutor commandExecutor = engineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute(commandContext -> {
            HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
            if (historyLevel.equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-processdefinition");
                List incidents = Context.getProcessEngineConfiguration().getRuntimeService().createIncidentQuery().list();
                for (Incident incident : incidents) {
                    commandContext.getIncidentManager().delete((DbEntity)((IncidentEntity)incident));
                }
            }
            return null;
        });
    }
}

