/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.externaltask;

import java.util.List;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.authorization.externaltask.HandleExternalTaskAuthorizationTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnlockExternalTaskAuthorizationTest
extends HandleExternalTaskAuthorizationTest {
    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSetJobPriority() {
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("oneExternalTaskProcess");
        List tasks = this.engineRule.getExternalTaskService().fetchAndLock(5, "workerId").topic("externalTaskTopic", 5000L).execute();
        LockedExternalTask task = (LockedExternalTask)tasks.get(0);
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstanceId", processInstance.getId()).bindResource("processDefinitionKey", "oneExternalTaskProcess").start();
        this.engineRule.getExternalTaskService().unlock(task.getId());
        if (this.authRule.assertScenario(this.scenario)) {
            ExternalTask externalTask = (ExternalTask)this.engineRule.getExternalTaskService().createExternalTaskQuery().singleResult();
            Assert.assertNull((Object)externalTask.getLockExpirationTime());
        }
    }
}

