/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyUserOperationLogTenantCheckTest {
    protected static final String USER_ONE = "aUserId";
    protected static final String USER_TWO = "user_two";
    protected static final String USER_WITHOUT_TENANT = "aUserId1";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_NAME = "process";
    protected static final String AN_ANNOTATION = "anAnnotation";
    protected static final BpmnModelInstance MODEL = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("aTaskId").done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected TaskService taskService;
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected IdentityService identityService;

    @Before
    public void init() {
        this.taskService = this.engineRule.getTaskService();
        this.historyService = this.engineRule.getHistoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    public void shouldSetAnnotationWithoutTenant() {
        this.testRule.deploy(MODEL);
        this.identityService.setAuthentication(USER_ONE, null);
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.historyService.setAnnotationForOperationLogById(singleResult.getOperationId(), AN_ANNOTATION);
        singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        Assertions.assertThat((String)singleResult.getTenantId()).isEqualTo(null);
    }

    @Test
    public void shouldSetAnnotationWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.historyService.setAnnotationForOperationLogById(singleResult.getOperationId(), AN_ANNOTATION);
        singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        Assertions.assertThat((String)singleResult.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void shouldThrowExceptionWhenSetAnnotationWithDifferentTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.identityService.setAuthentication(USER_TWO, null, Arrays.asList(TENANT_TWO));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.setAnnotationForOperationLogById(singleResult.getOperationId(), AN_ANNOTATION)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the user operation log entry '" + singleResult.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void shouldThrowExceptionWhenSetAnnotationWithNoAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.identityService.setAuthentication(USER_WITHOUT_TENANT, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.setAnnotationForOperationLogById(singleResult.getOperationId(), AN_ANNOTATION)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the user operation log entry '" + singleResult.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void shouldClearAnnotationWithoutTenant() {
        this.testRule.deploy(MODEL);
        this.identityService.setAuthentication(USER_ONE, null);
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.historyService.setAnnotationForOperationLogById(singleResult.getOperationId(), AN_ANNOTATION);
        this.historyService.clearAnnotationForOperationLogById(singleResult.getOperationId());
        singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        Assertions.assertThat((String)singleResult.getTenantId()).isEqualTo(null);
    }

    @Test
    public void shouldClearAnnotationWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.historyService.setAnnotationForOperationLogById(singleResult.getOperationId(), AN_ANNOTATION);
        this.historyService.clearAnnotationForOperationLogById(singleResult.getOperationId());
        singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        Assertions.assertThat((String)singleResult.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void shouldThrowExceptionWhenClearAnnotationWithDifferentTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.historyService.setAnnotationForOperationLogById(singleResult.getOperationId(), AN_ANNOTATION);
        this.identityService.setAuthentication(USER_TWO, null, Arrays.asList(TENANT_TWO));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.clearAnnotationForOperationLogById(singleResult.getOperationId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the user operation log entry '" + singleResult.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void shouldThrowExceptionWhenClearAnnotationWithNoAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.historyService.setAnnotationForOperationLogById(singleResult.getOperationId(), AN_ANNOTATION);
        this.identityService.setAuthentication(USER_WITHOUT_TENANT, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.clearAnnotationForOperationLogById(singleResult.getOperationId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the user operation log entry '" + singleResult.getId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void shouldDeleteWithoutTenant() {
        this.testRule.deploy(MODEL);
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("paul");
        this.taskService.complete(taskId);
        String entryId = ((UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult()).getId();
        this.historyService.deleteUserOperationLogEntry(entryId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        Assert.assertNull((Object)singleResult);
    }

    @Test
    public void shouldDeleteWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        String entryId = singleResult.getId();
        this.historyService.deleteUserOperationLogEntry(entryId);
        singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        Assert.assertNull((Object)singleResult);
    }

    @Test
    public void shouldThrownExceptionWhenDeleteWithDifferentTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        String entryId = singleResult.getId();
        this.identityService.setAuthentication(USER_TWO, null, Arrays.asList(TENANT_TWO));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.deleteUserOperationLogEntry(entryId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot delete the user operation log entry '" + entryId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void shouldThrownExceptionWhenDeleteWithNoAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        String entryId = singleResult.getId();
        this.identityService.setAuthentication(USER_WITHOUT_TENANT, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.deleteUserOperationLogEntry(entryId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot delete the user operation log entry '" + entryId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void shouldDeleteWhenTenantCheckDisabled() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ONE, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        Assertions.assertThat((Object)singleResult).isNotNull();
        String entryId = singleResult.getId();
        this.identityService.setAuthentication(USER_WITHOUT_TENANT, null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.historyService.deleteUserOperationLogEntry(entryId);
        singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        Assert.assertNull((Object)singleResult);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(true);
    }
}

