/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import camundajar.impl.com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.cfg.BatchWindowConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandlerConfiguration;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.ExceptionUtil;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.bpm.engine.impl.util.ParseUtil;
import org.camunda.bpm.engine.management.MetricIntervalValue;
import org.camunda.bpm.engine.management.MetricsQuery;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.test.util.Removable;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoryCleanupTest {
    private static final int PROCESS_INSTANCES_COUNT = 3;
    private static final int DECISIONS_IN_PROCESS_INSTANCES = 3;
    private static final int DECISION_INSTANCES_COUNT = 10;
    private static final int CASE_INSTANCES_COUNT = 4;
    private static final int HISTORY_TIME_TO_LIVE = 5;
    private static final int DAYS_IN_THE_PAST = -6;
    protected static final String ONE_TASK_PROCESS = "oneTaskProcess";
    protected static final String DECISION = "decision";
    protected static final String ONE_TASK_CASE = "case";
    private static final int NUMBER_OF_THREADS = 3;
    private static final String USER_ID = "demo";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected String defaultStartTime;
    protected String defaultEndTime;
    protected int defaultBatchSize;
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        configuration.setHistoryCleanupBatchSize(20);
        configuration.setHistoryCleanupBatchThreshold(10);
        configuration.setDefaultNumberOfRetries(5);
        configuration.setHistoryCleanupDegreeOfParallelism(3);
    });
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected Removable removable;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    private final Random random = new Random();
    private HistoryService historyService;
    private RuntimeService runtimeService;
    private ManagementService managementService;
    private CaseService caseService;
    private RepositoryService repositoryService;
    private IdentityService identityService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.caseService = this.engineRule.getCaseService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.testRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/dmn/Example.dmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithHistoryTimeToLive.cmmn");
        this.defaultStartTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowStartTime();
        this.defaultEndTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowEndTime();
        this.defaultBatchSize = this.processEngineConfiguration.getHistoryCleanupBatchSize();
        this.processEngineConfiguration.setHistoryCleanupStrategy("endTimeBased");
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.removable = Removable.of(this.testRule);
    }

    @After
    public void clearDatabase() {
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(this.defaultStartTime);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(this.defaultEndTime);
        this.processEngineConfiguration.setHistoryCleanupBatchSize(this.defaultBatchSize);
        this.processEngineConfiguration.setHistoryCleanupStrategy("removalTimeBased");
        this.processEngineConfiguration.setHistoryCleanupEnabled(true);
        this.processEngineConfiguration.setHistoryCleanupDefaultNumberOfRetries(Integer.valueOf(3));
        this.removable.removeAll();
        this.clearMetrics();
        this.identityService.clearAuthentication();
    }

    protected void clearMetrics() {
        Collection meters = this.processEngineConfiguration.getMetricsRegistry().getDbMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
        this.managementService.deleteMetrics(null);
    }

    @Test
    public void testHistoryCleanupManualRun() {
        this.prepareData(15);
        ClockUtil.setCurrentTime((Date)new Date());
        this.runHistoryCleanup(true);
        this.assertResult(0L);
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().operationType("CreateHistoryCleanupJobs").list();
        Assert.assertEquals((long)1L, (long)userOperationLogEntries.size());
        UserOperationLogEntry entry = (UserOperationLogEntry)userOperationLogEntries.get(0);
        Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
    }

    @Test
    public void shouldThrowExceptionWhenCleanupDisabled_1() {
        this.processEngineConfiguration.setHistoryCleanupEnabled(false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.cleanUpHistoryAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("History cleanup is disabled for this engine");
    }

    @Test
    public void shouldThrowExceptionWhenCleanupDisabled_2() {
        this.processEngineConfiguration.setHistoryCleanupEnabled(false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.cleanUpHistoryAsync(true)).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("History cleanup is disabled for this engine");
    }

    @Test
    public void testDataSplitBetweenThreads() {
        this.prepareData(15);
        ClockUtil.setCurrentTime((Date)new Date());
        this.historyService.cleanUpHistoryAsync(true).getId();
        for (Job job : this.historyService.findHistoryCleanupJobs()) {
            Object historicProcessInstance2;
            this.managementService.executeJob(job.getId());
            HistoryCleanupJobHandlerConfiguration jobHandlerConfiguration = this.getHistoryCleanupJobHandlerConfiguration(job);
            int minuteFrom = jobHandlerConfiguration.getMinuteFrom();
            int minuteTo = jobHandlerConfiguration.getMinuteTo();
            List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
            for (Object historicProcessInstance2 : historicProcessInstances) {
                if (historicProcessInstance2.getEndTime() == null) continue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(historicProcessInstance2.getEndTime());
                Assert.assertTrue((minuteFrom > calendar.get(12) || calendar.get(12) > minuteTo ? 1 : 0) != 0);
            }
            List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
            historicProcessInstance2 = historicDecisionInstances.iterator();
            while (historicProcessInstance2.hasNext()) {
                HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)historicProcessInstance2.next();
                if (historicDecisionInstance.getEvaluationTime() == null) continue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(historicDecisionInstance.getEvaluationTime());
                Assert.assertTrue((minuteFrom > calendar.get(12) || calendar.get(12) > minuteTo ? 1 : 0) != 0);
            }
            List historicCaseInstances = this.historyService.createHistoricCaseInstanceQuery().list();
            for (HistoricCaseInstance historicCaseInstance : historicCaseInstances) {
                if (historicCaseInstance.getCloseTime() == null) continue;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(historicCaseInstance.getCloseTime());
                Assert.assertTrue((minuteFrom > calendar.get(12) || calendar.get(12) > minuteTo ? 1 : 0) != 0);
            }
        }
        this.assertResult(0L);
    }

    private HistoryCleanupJobHandlerConfiguration getHistoryCleanupJobHandlerConfiguration(Job job) {
        return HistoryCleanupJobHandlerConfiguration.fromJson((JsonObject)JsonUtil.asObject((String)((JobEntity)job).getJobHandlerConfigurationRaw()));
    }

    private void runHistoryCleanup() {
        this.runHistoryCleanup(false);
    }

    private void runHistoryCleanup(boolean manualRun) {
        this.historyService.cleanUpHistoryAsync(manualRun);
        for (Job job : this.historyService.findHistoryCleanupJobs()) {
            this.managementService.executeJob(job.getId());
        }
    }

    @Test
    public void testHistoryCleanupMetrics() {
        this.processEngineConfiguration.setHistoryCleanupMetricsEnabled(true);
        this.prepareData(15);
        ClockUtil.setCurrentTime((Date)new Date());
        this.runHistoryCleanup(true);
        long removedProcessInstances = this.managementService.createMetricsQuery().name("history-cleanup-removed-process-instances").sum();
        long removedDecisionInstances = this.managementService.createMetricsQuery().name("history-cleanup-removed-decision-instances").sum();
        long removedCaseInstances = this.managementService.createMetricsQuery().name("history-cleanup-removed-case-instances").sum();
        Assert.assertTrue((removedProcessInstances > 0L ? 1 : 0) != 0);
        Assert.assertTrue((removedDecisionInstances > 0L ? 1 : 0) != 0);
        Assert.assertTrue((removedCaseInstances > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)15L, (long)(removedProcessInstances + removedCaseInstances + removedDecisionInstances));
    }

    @Test
    public void testHistoryCleanupMetricsExtend() {
        Date currentDate = new Date();
        this.processEngineConfiguration.setHistoryCleanupMetricsEnabled(true);
        this.prepareData(15);
        ClockUtil.setCurrentTime((Date)currentDate);
        this.runHistoryCleanup(true);
        this.assertResult(0L);
        MetricsQuery processMetricsQuery = this.managementService.createMetricsQuery().name("history-cleanup-removed-process-instances");
        long removedProcessInstances = processMetricsQuery.startDate(DateUtils.addDays((Date)currentDate, (int)-6)).endDate(DateUtils.addHours((Date)currentDate, (int)1)).sum();
        Assert.assertEquals((long)5L, (long)removedProcessInstances);
        MetricsQuery decisionMetricsQuery = this.managementService.createMetricsQuery().name("history-cleanup-removed-decision-instances");
        long removedDecisionInstances = decisionMetricsQuery.startDate(DateUtils.addDays((Date)currentDate, (int)-6)).endDate(DateUtils.addHours((Date)currentDate, (int)1)).sum();
        Assert.assertEquals((long)5L, (long)removedDecisionInstances);
        MetricsQuery caseMetricsQuery = this.managementService.createMetricsQuery().name("history-cleanup-removed-case-instances");
        long removedCaseInstances = caseMetricsQuery.startDate(DateUtils.addDays((Date)currentDate, (int)-6)).endDate(DateUtils.addHours((Date)currentDate, (int)1)).sum();
        Assert.assertEquals((long)5L, (long)removedCaseInstances);
        long noneProcessInstances = processMetricsQuery.startDate(DateUtils.addHours((Date)currentDate, (int)1)).limit(1).sum();
        Assert.assertEquals((long)0L, (long)noneProcessInstances);
        long noneDecisionInstances = decisionMetricsQuery.startDate(DateUtils.addHours((Date)currentDate, (int)1)).limit(1).sum();
        Assert.assertEquals((long)0L, (long)noneDecisionInstances);
        long noneCaseInstances = caseMetricsQuery.startDate(DateUtils.addHours((Date)currentDate, (int)1)).limit(1).sum();
        Assert.assertEquals((long)0L, (long)noneCaseInstances);
        List piList = processMetricsQuery.startDate(currentDate).interval(900L);
        Assert.assertEquals((long)1L, (long)piList.size());
        Assert.assertEquals((long)5L, (long)((MetricIntervalValue)piList.get(0)).getValue());
        List diList = decisionMetricsQuery.startDate(DateUtils.addDays((Date)currentDate, (int)-6)).interval(900L);
        Assert.assertEquals((long)1L, (long)diList.size());
        Assert.assertEquals((long)5L, (long)((MetricIntervalValue)diList.get(0)).getValue());
        List ciList = caseMetricsQuery.startDate(DateUtils.addDays((Date)currentDate, (int)-6)).interval(900L);
        Assert.assertEquals((long)1L, (long)ciList.size());
        Assert.assertEquals((long)5L, (long)((MetricIntervalValue)ciList.get(0)).getValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupOnlyDecisionInstancesRemoved() {
        this.prepareInstances(null, 5, null);
        ClockUtil.setCurrentTime((Date)new Date());
        this.runHistoryCleanup(true);
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupOnlyProcessInstancesRemoved() {
        this.prepareInstances(5, null, null);
        ClockUtil.setCurrentTime((Date)new Date());
        this.runHistoryCleanup(true);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)13L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupOnlyCaseInstancesRemoved() {
        this.prepareInstances(null, null, 5);
        ClockUtil.setCurrentTime((Date)new Date());
        this.runHistoryCleanup(true);
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)13L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupOnlyDecisionInstancesNotRemoved() {
        this.prepareInstances(5, null, 5);
        ClockUtil.setCurrentTime((Date)new Date());
        this.runHistoryCleanup(true);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)13L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupOnlyProcessInstancesNotRemoved() {
        this.prepareInstances(null, 5, 5);
        ClockUtil.setCurrentTime((Date)new Date());
        this.runHistoryCleanup(true);
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupOnlyCaseInstancesNotRemoved() {
        this.prepareInstances(5, 5, null);
        ClockUtil.setCurrentTime((Date)new Date());
        this.runHistoryCleanup(true);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupEverythingRemoved() {
        this.prepareInstances(5, 5, 5);
        ClockUtil.setCurrentTime((Date)new Date());
        this.runHistoryCleanup(true);
        this.assertResult(0L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn"})
    public void testHistoryCleanupNothingRemoved() {
        this.prepareInstances(null, null, null);
        ClockUtil.setCurrentTime((Date)new Date());
        this.runHistoryCleanup(true);
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        Assert.assertEquals((long)13L, (long)this.historyService.createHistoricDecisionInstanceQuery().count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricCaseInstanceQuery().count());
    }

    private void prepareInstances(Integer processInstanceTimeToLive, Integer decisionTimeToLive, Integer caseTimeToLive) {
        int i;
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("testProcess").list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(((ProcessDefinition)processDefinitions.get(0)).getId(), processInstanceTimeToLive);
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey("testDecision").list();
        Assert.assertEquals((long)1L, (long)decisionDefinitions.size());
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(((DecisionDefinition)decisionDefinitions.get(0)).getId(), decisionTimeToLive);
        List caseDefinitions = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").list();
        Assert.assertEquals((long)1L, (long)caseDefinitions.size());
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(((CaseDefinition)caseDefinitions.get(0)).getId(), caseTimeToLive);
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)-6));
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        VariableMap variables = Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37));
        for (i = 0; i < 3; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
            processInstanceIds.add(processInstance.getId());
        }
        this.runtimeService.deleteProcessInstances(processInstanceIds, null, true, true);
        for (i = 0; i < 10; ++i) {
            this.engineRule.getDecisionService().evaluateDecisionByKey("testDecision").variables((Map)variables).evaluate();
        }
        for (i = 0; i < 4; ++i) {
            CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37 + (double)i)));
            this.caseService.terminateCaseExecution(caseInstance.getId());
            this.caseService.closeCaseInstance(caseInstance.getId());
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    @Test
    public void testHistoryCleanupWithinBatchWindow() {
        this.prepareData(15);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(now));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)now, (int)5)));
        this.processEngineConfiguration.initHistoryCleanup();
        this.runHistoryCleanup();
        this.assertResult(0L);
    }

    @Test
    public void testHistoryCleanupJobNullTTL() {
        this.removeHistoryTimeToLive();
        this.prepareData(15);
        ClockUtil.setCurrentTime((Date)new Date());
        this.runHistoryCleanup(true);
        this.assertResult(15L);
    }

    private void removeHistoryTimeToLive() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(ONE_TASK_PROCESS).list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(((ProcessDefinition)processDefinitions.get(0)).getId(), null);
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION).list();
        Assert.assertEquals((long)1L, (long)decisionDefinitions.size());
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(((DecisionDefinition)decisionDefinitions.get(0)).getId(), null);
        List caseDefinitions = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(ONE_TASK_CASE).list();
        Assert.assertEquals((long)1L, (long)caseDefinitions.size());
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(((CaseDefinition)caseDefinitions.get(0)).getId(), null);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testHistoryCleanupJobDefaultTTL() {
        this.prepareBPMNData(15, "twoTasksProcess");
        ClockUtil.setCurrentTime((Date)new Date());
        this.runHistoryCleanup(true);
        this.assertResult(15L);
    }

    @Test
    public void testFindHistoryCleanupJob() {
        this.historyService.cleanUpHistoryAsync(true).getId();
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        Assert.assertEquals((long)3L, (long)historyCleanupJobs.size());
    }

    @Test
    public void testRescheduleForNever() {
        this.historyService.cleanUpHistoryAsync(true);
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        Assert.assertFalse((boolean)historyCleanupJobs.isEmpty());
        for (Job job : historyCleanupJobs) {
            Assert.assertNotNull((Object)job.getDuedate());
        }
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(null);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(null);
        this.processEngineConfiguration.initHistoryCleanup();
        ClockUtil.setCurrentTime((Date)new Date());
        this.historyService.cleanUpHistoryAsync(false);
        historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        for (Job job : historyCleanupJobs) {
            Assert.assertTrue((boolean)job.isSuspended());
            Assert.assertNull((Object)job.getDuedate());
        }
    }

    @Test
    public void shouldResolveIncidentAndApplyHistoryCleanupDefaultRetriesConfig() {
        this.processEngineConfiguration.setHistoryCleanupDefaultNumberOfRetries(Integer.valueOf(10));
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.imitateFailedJob(jobId);
        jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        JobEntity jobEntity = this.getJobEntity(jobId);
        Assertions.assertThat((String)jobEntity.getExceptionByteArrayId()).isNull();
        Assertions.assertThat((String)jobEntity.getExceptionMessage()).isNull();
        Assertions.assertThat((int)jobEntity.getRetries()).isEqualTo(10);
    }

    @Test
    public void shouldResolveIncidentAndApplyDefaultRetriesConfig() {
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.imitateFailedJob(jobId);
        jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        JobEntity jobEntity = this.getJobEntity(jobId);
        Assertions.assertThat((String)jobEntity.getExceptionByteArrayId()).isNull();
        Assertions.assertThat((String)jobEntity.getExceptionMessage()).isNull();
        Assertions.assertThat((int)jobEntity.getRetries()).isEqualTo(5);
    }

    private void imitateFailedJob(final String jobId) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobEntity jobEntity = HistoryCleanupTest.this.getJobEntity(jobId);
                jobEntity.setRetries(0);
                jobEntity.setExceptionMessage("Something bad happened");
                jobEntity.setExceptionStacktrace(ExceptionUtil.getExceptionStacktrace((Throwable)new RuntimeException("Something bad happened")));
                return null;
            }
        });
    }

    @Test
    public void testLessThanThresholdManualRun() {
        this.prepareData(5);
        ClockUtil.setCurrentTime((Date)new Date());
        this.runHistoryCleanup(true);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        for (Job job : this.historyService.findHistoryCleanupJobs()) {
            Assert.assertTrue((boolean)job.isSuspended());
        }
    }

    @Test
    public void testNotEnoughTimeToDeleteEverything() {
        this.prepareData(80);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(now));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)now, (int)5)));
        this.processEngineConfiguration.initHistoryCleanup();
        this.runHistoryCleanup();
        ClockUtil.setCurrentTime((Date)DateUtils.addHours((Date)now, (int)6));
        for (Job job : this.historyService.findHistoryCleanupJobs()) {
            this.managementService.executeJob(job.getId());
        }
        this.assertResultNotLess(20L);
    }

    @Test
    public void testManualRunDoesNotRespectBatchWindow() {
        int processInstanceCount = 40;
        this.prepareData(processInstanceCount);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)now, (int)1)));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)now, (int)5)));
        this.processEngineConfiguration.initHistoryCleanup();
        this.runHistoryCleanup(true);
        ClockUtil.setCurrentTime((Date)DateUtils.addHours((Date)now, (int)6));
        for (Job job : this.historyService.findHistoryCleanupJobs()) {
            this.managementService.executeJob(job.getId());
        }
        this.assertResult(0L);
    }

    @Test
    public void testLessThanThresholdWithinBatchWindow() {
        this.prepareData(5);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(now));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)now, (int)5)));
        this.processEngineConfiguration.initHistoryCleanup();
        this.runHistoryCleanup();
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        for (Job job : historyCleanupJobs) {
            JobEntity jobEntity = (JobEntity)job;
            HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
            Date nextRun = this.getNextRunWithDelay(ClockUtil.getCurrentTime(), 0);
            Assert.assertTrue((jobEntity.getDuedate().equals(nextRun) || jobEntity.getDuedate().after(nextRun) ? 1 : 0) != 0);
            Date nextRunMax = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)3600);
            Assert.assertTrue((boolean)jobEntity.getDuedate().before(nextRunMax));
            Assert.assertEquals((long)1L, (long)configuration.getCountEmptyRuns());
        }
        this.assertResult(0L);
    }

    private Date getNextRunWithDelay(Date date, int countEmptyRuns) {
        return DateUtils.setMilliseconds((Date)DateUtils.addSeconds((Date)date, (int)Math.min((int)(Math.pow(2.0, countEmptyRuns) * 10.0), 3600)), (int)0);
    }

    private JobEntity getJobEntity(String jobId) {
        return (JobEntity)this.managementService.createJobQuery().jobId(jobId).list().get(0);
    }

    @Test
    public void testLessThanThresholdWithinBatchWindowAgain() {
        this.prepareData(5);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(now));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)now, (int)1)));
        this.processEngineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync();
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        for (int i = 1; i <= 6; ++i) {
            for (Job job : historyCleanupJobs) {
                this.managementService.executeJob(job.getId());
            }
        }
        historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        for (Job job : historyCleanupJobs) {
            JobEntity jobEntity = (JobEntity)job;
            HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
            Date nextRun = this.getNextRunWithDelay(ClockUtil.getCurrentTime(), 5);
            Assert.assertTrue((jobEntity.getDuedate().equals(nextRun) || jobEntity.getDuedate().after(nextRun) ? 1 : 0) != 0);
            Date nextRunMax = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)3600);
            Assert.assertTrue((boolean)jobEntity.getDuedate().before(nextRunMax));
            Assert.assertEquals((long)6L, (long)configuration.getCountEmptyRuns());
        }
        this.assertResult(0L);
    }

    @Test
    public void testLessThanThresholdWithinBatchWindowMaxDelayReached() {
        this.prepareData(5);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(now));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)now, (int)2)));
        this.processEngineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync();
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        for (int i = 1; i <= 11; ++i) {
            for (Job job : historyCleanupJobs) {
                this.managementService.executeJob(job.getId());
            }
        }
        historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        for (Job job : historyCleanupJobs) {
            JobEntity jobEntity = (JobEntity)job;
            HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
            Date nextRun = this.getNextRunWithDelay(ClockUtil.getCurrentTime(), 10);
            Assert.assertTrue((jobEntity.getDuedate().equals(nextRun) || jobEntity.getDuedate().after(nextRun) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)jobEntity.getDuedate().before(this.getNextRunWithinBatchWindow(now)));
            Assert.assertEquals((long)11L, (long)configuration.getCountEmptyRuns());
        }
        this.assertResult(0L);
    }

    @Test
    public void testLessThanThresholdCloseToBatchWindowEndTime() {
        this.prepareData(5);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(now));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addMinutes((Date)now, (int)30)));
        this.processEngineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync();
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        for (int i = 1; i <= 9; ++i) {
            for (Job job : historyCleanupJobs) {
                this.managementService.executeJob(job.getId());
            }
        }
        historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        for (Job job : historyCleanupJobs) {
            JobEntity jobEntity = (JobEntity)job;
            HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
            Date nextRun = this.getNextRunWithinBatchWindow(ClockUtil.getCurrentTime());
            Assert.assertTrue((boolean)jobEntity.getDuedate().equals(nextRun));
            Assert.assertEquals((long)0L, (long)configuration.getCountEmptyRuns());
        }
        this.assertResult(0L);
    }

    @Test
    public void testLessThanThresholdOutsideBatchWindow() {
        this.prepareData(5);
        Date twoHoursAgo = new Date();
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(new SimpleDateFormat("HH:mm").format(twoHoursAgo));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(new SimpleDateFormat("HH:mm").format(DateUtils.addHours((Date)twoHoursAgo, (int)1)));
        this.processEngineConfiguration.initHistoryCleanup();
        ClockUtil.setCurrentTime((Date)DateUtils.addHours((Date)twoHoursAgo, (int)2));
        for (int i = 1; i <= 3; ++i) {
            this.runHistoryCleanup();
        }
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        for (Job job : historyCleanupJobs) {
            JobEntity jobEntity = (JobEntity)job;
            HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
            Date nextRun = this.getNextRunWithinBatchWindow(ClockUtil.getCurrentTime());
            Assert.assertTrue((boolean)jobEntity.getDuedate().equals(nextRun));
            Assert.assertEquals((long)0L, (long)configuration.getCountEmptyRuns());
        }
        this.assertResult(5L);
    }

    @Test
    public void testLessThanThresholdOutsideBatchWindowAfterMidnight() throws ParseException {
        this.prepareData(5);
        Date date = HistoryCleanupTest.addDays(new Date(), 1);
        ClockUtil.setCurrentTime((Date)DateUtils.setMinutes((Date)DateUtils.setHours((Date)date, (int)1), (int)10));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:00");
        this.processEngineConfiguration.initHistoryCleanup();
        String jobId = this.historyService.cleanUpHistoryAsync().getId();
        this.managementService.executeJob(jobId);
        JobEntity jobEntity = this.getJobEntity(jobId);
        HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
        Date nextRun = this.getNextRunWithinBatchWindow(ClockUtil.getCurrentTime());
        Assert.assertTrue((boolean)jobEntity.getDuedate().equals(nextRun));
        Assert.assertTrue((boolean)nextRun.after(ClockUtil.getCurrentTime()));
        Assert.assertEquals((long)0L, (long)configuration.getCountEmptyRuns());
        this.assertResult(5L);
    }

    @Test
    public void testLessThanThresholdOutsideBatchWindowBeforeMidnight() {
        this.prepareData(5);
        Date date = new Date();
        ClockUtil.setCurrentTime((Date)DateUtils.setMinutes((Date)DateUtils.setHours((Date)date, (int)22), (int)10));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:00");
        this.processEngineConfiguration.initHistoryCleanup();
        String jobId = this.historyService.cleanUpHistoryAsync().getId();
        this.managementService.executeJob(jobId);
        JobEntity jobEntity = this.getJobEntity(jobId);
        HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
        Date nextRun = this.getNextRunWithinBatchWindow(ClockUtil.getCurrentTime());
        Assert.assertTrue((boolean)jobEntity.getDuedate().equals(nextRun));
        Assert.assertTrue((boolean)nextRun.after(ClockUtil.getCurrentTime()));
        Assert.assertEquals((long)0L, (long)configuration.getCountEmptyRuns());
        this.assertResult(5L);
    }

    @Test
    public void testLessThanThresholdWithinBatchWindowBeforeMidnight() {
        this.prepareData(5);
        Date date = new Date();
        ClockUtil.setCurrentTime((Date)DateUtils.setMinutes((Date)DateUtils.setHours((Date)date, (int)23), (int)10));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:00");
        this.processEngineConfiguration.initHistoryCleanup();
        this.runHistoryCleanup();
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        for (Job job : historyCleanupJobs) {
            JobEntity jobEntity = (JobEntity)job;
            HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
            Date nextRun = this.getNextRunWithDelay(ClockUtil.getCurrentTime(), 0);
            Assert.assertTrue((jobEntity.getDuedate().equals(nextRun) || jobEntity.getDuedate().after(nextRun) ? 1 : 0) != 0);
            Date nextRunMax = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)3600);
            Assert.assertTrue((boolean)jobEntity.getDuedate().before(nextRunMax));
            Assert.assertEquals((long)1L, (long)configuration.getCountEmptyRuns());
        }
        this.assertResult(0L);
    }

    @Test
    public void testLessThanThresholdWithinBatchWindowAfterMidnight() throws ParseException {
        this.prepareData(5);
        Date date = HistoryCleanupTest.addDays(new Date(), 1);
        ClockUtil.setCurrentTime((Date)DateUtils.setMinutes((Date)DateUtils.setHours((Date)date, (int)0), (int)10));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:00");
        this.processEngineConfiguration.initHistoryCleanup();
        this.runHistoryCleanup(false);
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        for (Job job : historyCleanupJobs) {
            JobEntity jobEntity = (JobEntity)job;
            HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
            Date nextRun = this.getNextRunWithDelay(ClockUtil.getCurrentTime(), 0);
            Assert.assertTrue((jobEntity.getDuedate().equals(nextRun) || jobEntity.getDuedate().after(nextRun) ? 1 : 0) != 0);
            Date nextRunMax = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)3600);
            Assert.assertTrue((boolean)jobEntity.getDuedate().before(nextRunMax));
            Assert.assertEquals((long)1L, (long)configuration.getCountEmptyRuns());
        }
        this.assertResult(0L);
    }

    @Test
    @Ignore(value="CAM-10055")
    public void testLessThanThresholdOutsideBatchWindowAfterMidnightDaylightSaving() throws ParseException {
        this.prepareData(5);
        ClockUtil.setCurrentTime((Date)sdf.parse("2019-05-28T01:10:00"));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00CET");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:00CET");
        this.processEngineConfiguration.initHistoryCleanup();
        String jobId = this.historyService.cleanUpHistoryAsync().getId();
        this.managementService.executeJob(jobId);
        JobEntity jobEntity = this.getJobEntity(jobId);
        HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
        Date nextRun = this.getNextRunWithinBatchWindow(ClockUtil.getCurrentTime());
        Assert.assertTrue((boolean)jobEntity.getDuedate().equals(nextRun));
        Assert.assertTrue((boolean)nextRun.after(ClockUtil.getCurrentTime()));
        Assert.assertEquals((long)0L, (long)configuration.getCountEmptyRuns());
        this.assertResult(5L);
    }

    @Test
    @Ignore(value="CAM-10055")
    public void testLessThanThresholdWithinBatchWindowAfterMidnightDaylightSaving() throws ParseException {
        this.prepareData(5);
        ClockUtil.setCurrentTime((Date)sdf.parse("2018-05-14T00:10:00"));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00CET");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:00CET");
        this.processEngineConfiguration.initHistoryCleanup();
        this.runHistoryCleanup(false);
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        for (Job job : historyCleanupJobs) {
            JobEntity jobEntity = (JobEntity)job;
            HistoryCleanupJobHandlerConfiguration configuration = this.getConfiguration(jobEntity);
            Date nextRun = this.getNextRunWithDelay(ClockUtil.getCurrentTime(), 0);
            Assert.assertTrue((jobEntity.getDuedate().equals(nextRun) || jobEntity.getDuedate().after(nextRun) ? 1 : 0) != 0);
            Date nextRunMax = DateUtils.addSeconds((Date)ClockUtil.getCurrentTime(), (int)3600);
            Assert.assertTrue((boolean)jobEntity.getDuedate().before(nextRunMax));
            Assert.assertEquals((long)1L, (long)configuration.getCountEmptyRuns());
        }
        this.assertResult(0L);
    }

    @Test
    public void testConfiguration() {
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00+0200");
        this.processEngineConfiguration.initHistoryCleanup();
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT+2:00"));
        Date startTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowStartTimeAsDate();
        c.setTime(startTime);
        Assert.assertEquals((long)23L, (long)c.get(11));
        Assert.assertEquals((long)0L, (long)c.get(12));
        Assert.assertEquals((long)0L, (long)c.get(13));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.initHistoryCleanup();
        c = Calendar.getInstance();
        startTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowStartTimeAsDate();
        c.setTime(startTime);
        Assert.assertEquals((long)23L, (long)c.get(11));
        Assert.assertEquals((long)0L, (long)c.get(12));
        Assert.assertEquals((long)0L, (long)c.get(13));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:35-0800");
        this.processEngineConfiguration.initHistoryCleanup();
        c = Calendar.getInstance(TimeZone.getTimeZone("GMT-8:00"));
        Date endTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowEndTimeAsDate();
        c.setTime(endTime);
        Assert.assertEquals((long)1L, (long)c.get(11));
        Assert.assertEquals((long)35L, (long)c.get(12));
        Assert.assertEquals((long)0L, (long)c.get(13));
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:35");
        this.processEngineConfiguration.initHistoryCleanup();
        c = Calendar.getInstance();
        endTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowEndTimeAsDate();
        c.setTime(endTime);
        Assert.assertEquals((long)1L, (long)c.get(11));
        Assert.assertEquals((long)35L, (long)c.get(12));
        Assert.assertEquals((long)0L, (long)c.get(13));
        this.processEngineConfiguration.setHistoryCleanupBatchSize(500);
        this.processEngineConfiguration.initHistoryCleanup();
        Assert.assertEquals((long)this.processEngineConfiguration.getHistoryCleanupBatchSize(), (long)500L);
        this.processEngineConfiguration.setHistoryTimeToLive("5");
        this.processEngineConfiguration.initHistoryCleanup();
        Assert.assertEquals((long)5L, (long)ParseUtil.parseHistoryTimeToLive((String)this.processEngineConfiguration.getHistoryTimeToLive()).intValue());
        this.processEngineConfiguration.setHistoryTimeToLive("P6D");
        this.processEngineConfiguration.initHistoryCleanup();
        Assert.assertEquals((long)6L, (long)ParseUtil.parseHistoryTimeToLive((String)this.processEngineConfiguration.getHistoryTimeToLive()).intValue());
    }

    @Test
    public void testHistoryCleanupHelper() throws ParseException {
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("22:00+0100");
        this.processEngineConfiguration.initHistoryCleanup();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        Date date = sdf.parse("2017-09-06T22:15:00+0100");
        Assert.assertTrue((boolean)HistoryCleanupHelper.isWithinBatchWindow((Date)date, (ProcessEngineConfigurationImpl)this.processEngineConfiguration));
        date = sdf.parse("2017-09-06T22:15:00+0200");
        Assert.assertFalse((boolean)HistoryCleanupHelper.isWithinBatchWindow((Date)date, (ProcessEngineConfigurationImpl)this.processEngineConfiguration));
    }

    @Test
    public void testConfigurationFailureWrongStartTime() {
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("01:00");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngineConfiguration.initHistoryCleanup()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("historyCleanupBatchWindowStartTime");
    }

    @Test
    public void testConfigurationFailureWrongDayOfTheWeekStartTime() throws ParseException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngineConfiguration.getHistoryCleanupBatchWindows().put(2, new BatchWindowConfiguration("23", "01:00"))).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("startTime");
    }

    @Test
    public void testConfigurationFailureWrongDayOfTheWeekEndTime() throws ParseException {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngineConfiguration.getHistoryCleanupBatchWindows().put(2, new BatchWindowConfiguration("23:00", "01"))).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("endTime");
    }

    @Test
    public void testConfigurationFailureWrongDegreeOfParallelism() {
        this.processEngineConfiguration.setHistoryCleanupDegreeOfParallelism(0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngineConfiguration.initHistoryCleanup()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("historyCleanupDegreeOfParallelism");
        this.processEngineConfiguration.setHistoryCleanupDegreeOfParallelism(9);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngineConfiguration.initHistoryCleanup()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("historyCleanupDegreeOfParallelism");
    }

    @Test
    public void testConfigurationFailureWrongEndTime() {
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("23:00");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime("wrongValue");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngineConfiguration.initHistoryCleanup()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("historyCleanupBatchWindowEndTime");
    }

    @Test
    public void testConfigurationFailureWrongBatchSize() {
        this.processEngineConfiguration.setHistoryCleanupBatchSize(501);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngineConfiguration.initHistoryCleanup()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("historyCleanupBatchSize");
    }

    @Test
    public void testConfigurationFailureWrongBatchSize2() {
        this.processEngineConfiguration.setHistoryCleanupBatchSize(-5);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngineConfiguration.initHistoryCleanup()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("historyCleanupBatchSize");
    }

    @Test
    public void testConfigurationFailureWrongBatchThreshold() {
        this.processEngineConfiguration.setHistoryCleanupBatchThreshold(-1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngineConfiguration.initHistoryCleanup()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("historyCleanupBatchThreshold");
    }

    @Test
    public void testConfigurationFailureMalformedHistoryTimeToLive() {
        this.processEngineConfiguration.setHistoryTimeToLive("PP5555DDDD");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngineConfiguration.initHistoryCleanup()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("historyTimeToLive");
    }

    @Test
    public void testConfigurationFailureInvalidHistoryTimeToLive() {
        this.processEngineConfiguration.setHistoryTimeToLive("invalidValue");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngineConfiguration.initHistoryCleanup()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("historyTimeToLive");
    }

    @Test
    public void testConfigurationFailureNegativeHistoryTimeToLive() {
        this.processEngineConfiguration.setHistoryTimeToLive("-6");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.processEngineConfiguration.initHistoryCleanup()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("historyTimeToLive");
    }

    @Test
    public void shouldApplyGlobalJobRetries() {
        this.engineRule.getProcessEngineConfiguration().setDefaultNumberOfRetries(7);
        Job cleanupJob = this.historyService.cleanUpHistoryAsync(true);
        Assertions.assertThat((int)cleanupJob.getRetries()).isEqualTo(7);
    }

    @Test
    public void shouldApplyLocalJobRetries() {
        this.engineRule.getProcessEngineConfiguration().setDefaultNumberOfRetries(7);
        this.engineRule.getProcessEngineConfiguration().setHistoryCleanupDefaultNumberOfRetries(Integer.valueOf(1));
        Job cleanupJob = this.historyService.cleanUpHistoryAsync(true);
        Assertions.assertThat((int)cleanupJob.getRetries()).isEqualTo(1);
    }

    @Test
    public void shouldApplyCleanupJobRetries() {
        this.engineRule.getProcessEngineConfiguration().setHistoryCleanupDefaultNumberOfRetries(Integer.valueOf(22));
        Job cleanupJob = this.historyService.cleanUpHistoryAsync(true);
        Assertions.assertThat((int)cleanupJob.getRetries()).isEqualTo(22);
    }

    @Test
    public void shouldDisableRetriesOnCleanupJob() {
        ProcessEngineConfigurationImpl configuration = this.engineRule.getProcessEngineConfiguration();
        configuration.setHistoryCleanupDefaultNumberOfRetries(Integer.valueOf(0));
        Job cleanupJob = this.historyService.cleanUpHistoryAsync(true);
        Assertions.assertThat((int)cleanupJob.getRetries()).isEqualTo(0);
    }

    private Date getNextRunWithinBatchWindow(Date currentTime) {
        return this.processEngineConfiguration.getBatchWindowManager().getNextBatchWindow(currentTime, this.processEngineConfiguration).getStart();
    }

    private HistoryCleanupJobHandlerConfiguration getConfiguration(JobEntity jobEntity) {
        String jobHandlerConfigurationRaw = jobEntity.getJobHandlerConfigurationRaw();
        return HistoryCleanupJobHandlerConfiguration.fromJson((JsonObject)JsonUtil.asObject((String)jobHandlerConfigurationRaw));
    }

    private void prepareData(int instanceCount) {
        int createdInstances = instanceCount / 3;
        this.prepareBPMNData(createdInstances, ONE_TASK_PROCESS);
        this.prepareDMNData(createdInstances);
        this.prepareCMMNData(instanceCount - 2 * createdInstances);
    }

    private void prepareBPMNData(int instanceCount, String definitionKey) {
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)-6));
        List<String> ids = this.prepareHistoricProcesses(definitionKey, this.getVariables(), instanceCount);
        this.deleteProcessInstances(ids);
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    private void deleteProcessInstances(List<String> ids) {
        Date currentTime = ClockUtil.getCurrentTime();
        for (String id : ids) {
            ClockUtil.setCurrentTime((Date)DateUtils.setMinutes((Date)currentTime, (int)this.random.nextInt(60)));
            this.runtimeService.deleteProcessInstance(id, null, true, true);
        }
    }

    private void prepareDMNData(int instanceCount) {
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)-6));
        for (int i = 0; i < instanceCount; ++i) {
            ClockUtil.setCurrentTime((Date)DateUtils.setMinutes((Date)ClockUtil.getCurrentTime(), (int)this.random.nextInt(60)));
            this.engineRule.getDecisionService().evaluateDecisionByKey(DECISION).variables((Map)this.getDMNVariables()).evaluate();
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    private void prepareCMMNData(int instanceCount) {
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)-6));
        for (int i = 0; i < instanceCount; ++i) {
            CaseInstance caseInstance = this.caseService.createCaseInstanceByKey(ONE_TASK_CASE);
            ClockUtil.setCurrentTime((Date)DateUtils.setMinutes((Date)ClockUtil.getCurrentTime(), (int)this.random.nextInt(60)));
            this.caseService.terminateCaseExecution(caseInstance.getId());
            this.caseService.closeCaseInstance(caseInstance.getId());
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    private List<String> prepareHistoricProcesses(String definitionKey, VariableMap variables, Integer processInstanceCount) {
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < processInstanceCount; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(definitionKey, (Map)variables);
            processInstanceIds.add(processInstance.getId());
        }
        return processInstanceIds;
    }

    private VariableMap getVariables() {
        return Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue").putValue("anotherVariableName", (Object)"anotherVariableValue");
    }

    protected VariableMap getDMNVariables() {
        return Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
    }

    private void assertResult(long expectedInstanceCount) {
        long count = this.historyService.createHistoricProcessInstanceQuery().count() + this.historyService.createHistoricDecisionInstanceQuery().count() + this.historyService.createHistoricCaseInstanceQuery().count();
        Assert.assertEquals((long)expectedInstanceCount, (long)count);
    }

    private void assertResultNotLess(long expectedInstanceCount) {
        long count = this.historyService.createHistoricProcessInstanceQuery().count() + this.historyService.createHistoricDecisionInstanceQuery().count() + this.historyService.createHistoricCaseInstanceQuery().count();
        Assert.assertTrue((expectedInstanceCount <= count ? 1 : 0) != 0);
    }

    protected static Date addDays(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }
}

