/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Collection;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ModificationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.api.runtime.BatchModificationHelper;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BatchModificationAuthorizationTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchModificationHelper helper = new BatchModificationHelper(this.engineRule);
    protected ProcessDefinition processDefinition;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance1", "userId", new Permission[]{Permissions.READ, Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.READ, Permissions.UPDATE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_MODIFY_PROCESS_INSTANCES}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance1", "userId", new Permission[]{Permissions.READ, Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.READ, Permissions.UPDATE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance1", "userId", new Permission[]{Permissions.READ, Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.READ})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinition", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_MODIFY_PROCESS_INSTANCES}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance1", "userId", new Permission[]{Permissions.READ, Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.READ})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinition", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})).succeeds());
    }

    @Before
    public void deployProcess() {
        this.processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @After
    public void cleanBatch() {
        HistoricBatch historicBatch;
        Batch batch = (Batch)this.engineRule.getManagementService().createBatchQuery().singleResult();
        if (batch != null) {
            this.engineRule.getManagementService().deleteBatch(batch.getId(), true);
        }
        if ((historicBatch = (HistoricBatch)this.engineRule.getHistoryService().createHistoricBatchQuery().singleResult()) != null) {
            this.engineRule.getHistoryService().deleteHistoricBatch(historicBatch.getId());
        }
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void executeAsyncModification() {
        ProcessInstance processInstance1 = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process");
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstance1", processInstance1.getId()).bindResource("processInstance2", processInstance2.getId()).bindResource("processDefinition", "Process").bindResource("batchId", "*").start();
        Batch batch = ((ModificationBuilder)this.engineRule.getRuntimeService().createModification(this.processDefinition.getId()).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).startAfterActivity("userTask2")).executeAsync();
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().jobDefinitionId(batch.getSeedJobDefinitionId()).singleResult();
        this.engineRule.getManagementService().executeJob(job.getId());
        for (Job pending : this.engineRule.getManagementService().createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list()) {
            this.engineRule.getManagementService().executeJob(pending.getId());
        }
        this.authRule.assertScenario(this.scenario);
    }

    @Test
    public void executeModification() {
        ProcessInstance processInstance1 = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process");
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstance1", processInstance1.getId()).bindResource("processInstance2", processInstance2.getId()).bindResource("processDefinition", "Process").bindResource("batchId", "*").start();
        ((ModificationBuilder)this.engineRule.getRuntimeService().createModification(this.processDefinition.getId()).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).startAfterActivity("userTask2")).execute();
        this.authRule.assertScenario(this.scenario);
    }
}

