/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class ExternalTaskUserOperationLogTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testRule);
    private static String PROCESS_DEFINITION_KEY = "oneExternalTaskProcess";
    private static String PROCESS_DEFINITION_KEY_2 = "twoExternalTaskWithPriorityProcess";
    protected RuntimeService runtimeService;
    protected ExternalTaskService externalTaskService;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
        this.externalTaskService = this.rule.getExternalTaskService();
    }

    @After
    public void removeAllRunningAndHistoricBatches() {
        HistoryService historyService = this.rule.getHistoryService();
        ManagementService managementService = this.rule.getManagementService();
        for (Batch batch : managementService.createBatchQuery().list()) {
            managementService.deleteBatch(batch.getId(), true);
        }
        for (HistoricBatch historicBatch : historyService.createHistoricBatchQuery().list()) {
            historyService.deleteHistoricBatch(historicBatch.getId());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSetRetriesLogCreationForOneExternalTaskId() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        this.rule.getIdentityService().setAuthenticatedUserId("userId");
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        this.externalTaskService.setRetries(externalTask.getId(), 5);
        this.rule.getIdentityService().clearAuthentication();
        List opLogEntries = this.rule.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)1L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry retriesEntry = entries.get("retries");
        Assert.assertNotNull((Object)retriesEntry);
        Assert.assertEquals((Object)"ExternalTask", (Object)retriesEntry.getEntityType());
        Assert.assertEquals((Object)"SetExternalTaskRetries", (Object)retriesEntry.getOperationType());
        Assert.assertEquals((Object)externalTask.getId(), (Object)retriesEntry.getExternalTaskId());
        Assert.assertEquals((Object)externalTask.getProcessInstanceId(), (Object)retriesEntry.getProcessInstanceId());
        Assert.assertEquals((Object)externalTask.getProcessDefinitionId(), (Object)retriesEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)externalTask.getProcessDefinitionKey(), (Object)retriesEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)retriesEntry.getOrgValue());
        Assert.assertEquals((Object)"5", (Object)retriesEntry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)retriesEntry.getCategory());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSetRetriesLogCreationSync() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        List list = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : list) {
            externalTaskIds.add(task.getId());
        }
        this.rule.getIdentityService().setAuthenticatedUserId("userId");
        this.externalTaskService.setRetries(externalTaskIds, 5);
        this.rule.getIdentityService().clearAuthentication();
        List opLogEntries = this.rule.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)3L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry asyncEntry = entries.get("async");
        Assert.assertNotNull((Object)asyncEntry);
        Assert.assertEquals((Object)"ExternalTask", (Object)asyncEntry.getEntityType());
        Assert.assertEquals((Object)"SetExternalTaskRetries", (Object)asyncEntry.getOperationType());
        Assert.assertNull((Object)asyncEntry.getExternalTaskId());
        Assert.assertNull((Object)asyncEntry.getProcessDefinitionId());
        Assert.assertNull((Object)asyncEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)asyncEntry.getProcessInstanceId());
        Assert.assertNull((Object)asyncEntry.getOrgValue());
        Assert.assertEquals((Object)"false", (Object)asyncEntry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)asyncEntry.getCategory());
        UserOperationLogEntry numInstancesEntry = entries.get("nrOfInstances");
        Assert.assertNotNull((Object)numInstancesEntry);
        Assert.assertEquals((Object)"ExternalTask", (Object)numInstancesEntry.getEntityType());
        Assert.assertEquals((Object)"SetExternalTaskRetries", (Object)numInstancesEntry.getOperationType());
        Assert.assertNull((Object)numInstancesEntry.getExternalTaskId());
        Assert.assertNull((Object)numInstancesEntry.getProcessDefinitionId());
        Assert.assertNull((Object)numInstancesEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)numInstancesEntry.getProcessInstanceId());
        Assert.assertNull((Object)numInstancesEntry.getOrgValue());
        Assert.assertEquals((Object)"2", (Object)numInstancesEntry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)numInstancesEntry.getCategory());
        UserOperationLogEntry retriesEntry = entries.get("retries");
        Assert.assertNotNull((Object)retriesEntry);
        Assert.assertEquals((Object)"ExternalTask", (Object)retriesEntry.getEntityType());
        Assert.assertEquals((Object)"SetExternalTaskRetries", (Object)retriesEntry.getOperationType());
        Assert.assertNull((Object)retriesEntry.getExternalTaskId());
        Assert.assertNull((Object)retriesEntry.getProcessDefinitionId());
        Assert.assertNull((Object)retriesEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)retriesEntry.getProcessInstanceId());
        Assert.assertNull((Object)retriesEntry.getOrgValue());
        Assert.assertEquals((Object)"5", (Object)retriesEntry.getNewValue());
        Assert.assertEquals((Object)asyncEntry.getOperationId(), (Object)retriesEntry.getOperationId());
        Assert.assertEquals((Object)"Operator", (Object)retriesEntry.getCategory());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testSetRetriesLogCreationAsync() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        this.rule.getIdentityService().setAuthenticatedUserId("userId");
        this.externalTaskService.setRetriesAsync(null, this.externalTaskService.createExternalTaskQuery(), 5);
        this.rule.getIdentityService().clearAuthentication();
        List opLogEntries = this.rule.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)3L, (long)opLogEntries.size());
        Map<String, UserOperationLogEntry> entries = this.asMap(opLogEntries);
        UserOperationLogEntry asyncEntry = entries.get("async");
        Assert.assertNotNull((Object)asyncEntry);
        Assert.assertEquals((Object)"ExternalTask", (Object)asyncEntry.getEntityType());
        Assert.assertEquals((Object)"SetExternalTaskRetries", (Object)asyncEntry.getOperationType());
        Assert.assertNull((Object)asyncEntry.getExternalTaskId());
        Assert.assertNull((Object)asyncEntry.getProcessDefinitionId());
        Assert.assertNull((Object)asyncEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)asyncEntry.getProcessInstanceId());
        Assert.assertNull((Object)asyncEntry.getOrgValue());
        Assert.assertEquals((Object)"true", (Object)asyncEntry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)asyncEntry.getCategory());
        UserOperationLogEntry numInstancesEntry = entries.get("nrOfInstances");
        Assert.assertNotNull((Object)numInstancesEntry);
        Assert.assertEquals((Object)"ExternalTask", (Object)numInstancesEntry.getEntityType());
        Assert.assertEquals((Object)"SetExternalTaskRetries", (Object)numInstancesEntry.getOperationType());
        Assert.assertNull((Object)numInstancesEntry.getExternalTaskId());
        Assert.assertNull((Object)numInstancesEntry.getProcessDefinitionId());
        Assert.assertNull((Object)numInstancesEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)numInstancesEntry.getProcessInstanceId());
        Assert.assertNull((Object)numInstancesEntry.getOrgValue());
        Assert.assertEquals((Object)"2", (Object)numInstancesEntry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)numInstancesEntry.getCategory());
        UserOperationLogEntry retriesEntry = entries.get("retries");
        Assert.assertNotNull((Object)retriesEntry);
        Assert.assertEquals((Object)"ExternalTask", (Object)retriesEntry.getEntityType());
        Assert.assertEquals((Object)"SetExternalTaskRetries", (Object)retriesEntry.getOperationType());
        Assert.assertNull((Object)retriesEntry.getExternalTaskId());
        Assert.assertNull((Object)retriesEntry.getProcessDefinitionId());
        Assert.assertNull((Object)retriesEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)retriesEntry.getProcessInstanceId());
        Assert.assertNull((Object)retriesEntry.getOrgValue());
        Assert.assertEquals((Object)"5", (Object)retriesEntry.getNewValue());
        Assert.assertEquals((Object)asyncEntry.getOperationId(), (Object)retriesEntry.getOperationId());
        Assert.assertEquals((Object)"Operator", (Object)retriesEntry.getCategory());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml"})
    public void testSetPriorityLogCreation() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY_2, Collections.singletonMap("priority", 14));
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().priorityHigherThanOrEquals(1L).singleResult();
        this.rule.getIdentityService().setAuthenticatedUserId("userId");
        this.externalTaskService.setPriority(externalTask.getId(), 78L);
        this.rule.getIdentityService().clearAuthentication();
        List opLogEntries = this.rule.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)1L, (long)opLogEntries.size());
        UserOperationLogEntry entry = (UserOperationLogEntry)opLogEntries.get(0);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"ExternalTask", (Object)entry.getEntityType());
        Assert.assertEquals((Object)"SetPriority", (Object)entry.getOperationType());
        Assert.assertEquals((Object)externalTask.getId(), (Object)entry.getExternalTaskId());
        Assert.assertEquals((Object)externalTask.getProcessInstanceId(), (Object)entry.getProcessInstanceId());
        Assert.assertEquals((Object)externalTask.getProcessDefinitionId(), (Object)entry.getProcessDefinitionId());
        Assert.assertEquals((Object)externalTask.getProcessDefinitionKey(), (Object)entry.getProcessDefinitionKey());
        Assert.assertEquals((Object)"priority", (Object)entry.getProperty());
        Assert.assertEquals((Object)"14", (Object)entry.getOrgValue());
        Assert.assertEquals((Object)"78", (Object)entry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    public void testUnlockLogCreation() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        this.externalTaskService.fetchAndLock(1, "aWorker").topic(externalTask.getTopicName(), 3000L).execute();
        this.rule.getIdentityService().setAuthenticatedUserId("userId");
        this.externalTaskService.unlock(externalTask.getId());
        this.rule.getIdentityService().clearAuthentication();
        List opLogEntries = this.rule.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)1L, (long)opLogEntries.size());
        UserOperationLogEntry entry = (UserOperationLogEntry)opLogEntries.get(0);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"ExternalTask", (Object)entry.getEntityType());
        Assert.assertEquals((Object)"Unlock", (Object)entry.getOperationType());
        Assert.assertEquals((Object)externalTask.getId(), (Object)entry.getExternalTaskId());
        Assert.assertEquals((Object)externalTask.getProcessInstanceId(), (Object)entry.getProcessInstanceId());
        Assert.assertEquals((Object)externalTask.getProcessDefinitionId(), (Object)entry.getProcessDefinitionId());
        Assert.assertEquals((Object)externalTask.getProcessDefinitionKey(), (Object)entry.getProcessDefinitionKey());
        Assert.assertNull((Object)entry.getProperty());
        Assert.assertNull((Object)entry.getOrgValue());
        Assert.assertNull((Object)entry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
    }

    protected Map<String, UserOperationLogEntry> asMap(List<UserOperationLogEntry> logEntries) {
        HashMap<String, UserOperationLogEntry> map = new HashMap<String, UserOperationLogEntry>();
        for (UserOperationLogEntry entry : logEntries) {
            UserOperationLogEntry previousValue = map.put(entry.getProperty(), entry);
            if (previousValue == null) continue;
            Assert.fail((String)"expected only entry for every property");
        }
        return map;
    }
}

