/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.deployment;

import java.io.InputStream;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.RepositoryServiceImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.DeploymentHandlerFactory;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.Resource;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.deployment.VersionedDeploymentHandlerFactory;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.camunda.commons.testing.WatchLogger;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class BpmnDeploymentTest
extends PluggableProcessEngineTest {
    protected static final String CMD_LOGGER = "org.camunda.bpm.engine.cmd";
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();
    protected DeploymentHandlerFactory defaultDeploymentHandlerFactory;
    protected DeploymentHandlerFactory customDeploymentHandlerFactory;

    @Before
    public void setUp() throws Exception {
        this.defaultDeploymentHandlerFactory = this.processEngineConfiguration.getDeploymentHandlerFactory();
        this.customDeploymentHandlerFactory = new VersionedDeploymentHandlerFactory();
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.setDeploymentHandlerFactory(this.defaultDeploymentHandlerFactory);
    }

    @Deployment
    @Test
    public void testGetBpmnXmlFileThroughService() {
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        List deploymentResources = this.repositoryService.getDeploymentResourceNames(deploymentId);
        Assertions.assertThat((int)deploymentResources.size()).isEqualTo(1);
        String bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml";
        Assertions.assertThat((String)((String)deploymentResources.get(0))).isEqualTo((Object)bpmnResourceName);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assertions.assertThat((String)processDefinition.getResourceName()).isEqualTo((Object)bpmnResourceName);
        Assertions.assertThat((String)processDefinition.getDiagramResourceName()).isNull();
        Assertions.assertThat((boolean)processDefinition.hasStartFormKey()).isFalse();
        ReadOnlyProcessDefinition readOnlyProcessDefinition = ((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinition.getId());
        Assertions.assertThat((String)readOnlyProcessDefinition.getDiagramResourceName()).isNull();
        InputStream deploymentInputStream = this.repositoryService.getResourceAsStream(deploymentId, bpmnResourceName);
        String contentFromDeployment = this.readInputStreamToString(deploymentInputStream);
        Assertions.assertThat((contentFromDeployment.length() > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((boolean)contentFromDeployment.contains("process id=\"emptyProcess\"")).isTrue();
        InputStream fileInputStream = ReflectUtil.getResourceAsStream((String)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml");
        String contentFromFile = this.readInputStreamToString(fileInputStream);
        Assertions.assertThat((String)contentFromDeployment).isEqualTo((Object)contentFromFile);
    }

    private String readInputStreamToString(InputStream inputStream) {
        byte[] bytes = IoUtil.readInputStream((InputStream)inputStream, (String)"input stream");
        return new String(bytes);
    }

    public void FAILING_testViolateProcessDefinitionIdMaximumLength() {
        DeploymentBuilder deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/deployment/processWithLongId.bpmn20.xml");
        Assertions.assertThatThrownBy(() -> this.testRule.deploy(deployment)).hasMessageContaining("id can be maximum 64 characters");
        Assertions.assertThat((long)this.repositoryService.createDeploymentQuery().count()).isEqualTo(0L);
    }

    @Test
    public void testDeploySameFileTwice() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml";
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(false).addClasspathResource(bpmnResourceName).name("twice"));
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        List deploymentResources = this.repositoryService.getDeploymentResourceNames(deploymentId);
        Assertions.assertThat((int)deploymentResources.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)deploymentResources.get(0))).isEqualTo((Object)bpmnResourceName);
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(false).addClasspathResource(bpmnResourceName).name("twice"));
        Assertions.assertThat((long)this.repositoryService.createDeploymentQuery().count()).isEqualTo(1L);
    }

    @Test
    public void shouldNotFilterDuplicateWithSameFileDeployedTwiceWithoutDeploymentName() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml";
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(false).addClasspathResource(bpmnResourceName));
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(false).addClasspathResource(bpmnResourceName));
        List deploymentList = this.repositoryService.createDeploymentQuery().list();
        Assertions.assertThat((int)deploymentList.size()).isEqualTo(2);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.cmd"}, level="WARN")
    public void shouldLogWarningForDuplicateFilteringWithoutName() {
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("model.bpmn", model);
        this.testRule.deploy(deploymentBuilder);
        Assertions.assertThat((int)this.loggingRule.getFilteredLog(CMD_LOGGER, "Deployment name set to null. Filtering duplicates will not work properly.").size()).isEqualTo(1);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.cmd"}, level="WARN")
    public void shouldLogWarningForDuplicateFilteringWithoutPreviousDeploymentName() {
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        Object deployment = this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("model.bpmn", model));
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().enableDuplicateFiltering(true).addDeploymentResources(deployment.getId());
        this.testRule.deploy(deploymentBuilder);
        Assertions.assertThat((int)this.loggingRule.getFilteredLog(CMD_LOGGER, "Deployment name set to null. Filtering duplicates will not work properly.").size()).isEqualTo(1);
    }

    @Test
    public void testDuplicateFilteringDefaultBehavior() {
        BpmnModelInstance oldModel = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"versionedProcess").camundaVersionTag("3")).done();
        BpmnModelInstance newModel = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"versionedProcess").camundaVersionTag("1")).done();
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("model", oldModel).name("defaultDeploymentHandling"));
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("model", newModel).name("defaultDeploymentHandling"));
        long deploymentCount = this.repositoryService.createDeploymentQuery().count();
        Assertions.assertThat((long)deploymentCount).isEqualTo(2L);
    }

    @Test
    public void testDuplicateFilteringCustomBehavior() {
        this.processEngineConfiguration.setDeploymentHandlerFactory(this.customDeploymentHandlerFactory);
        BpmnModelInstance oldModel = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"versionedProcess").camundaVersionTag("1")).startEvent().done();
        BpmnModelInstance newModel = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"versionedProcess").camundaVersionTag("2")).startEvent().done();
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("model.bpmn", oldModel).name("customDeploymentHandling"));
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("model.bpmn", newModel).name("customDeploymentHandling"));
        Object deployment3 = this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("model.bpmn", oldModel).name("customDeploymentHandling"));
        long deploymentCount = this.repositoryService.createDeploymentQuery().count();
        Assertions.assertThat((long)deploymentCount).isEqualTo(2L);
        Assertions.assertThat((String)deployment3.getId()).isEqualTo((Object)deployment1.getId());
    }

    @Test
    public void testPartialChangesDeployAll() {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").startEvent().done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"process2").startEvent().done();
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(false).addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2).name("twice"));
        List deploymentResources = this.repositoryService.getDeploymentResourceNames(deployment1.getId());
        Assertions.assertThat((int)deploymentResources.size()).isEqualTo(2);
        BpmnModelInstance changedModel2 = Bpmn.createExecutableProcess((String)"process2").startEvent().endEvent().done();
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(false).addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", changedModel2).name("twice"));
        List deploymentList = this.repositoryService.createDeploymentQuery().list();
        Assertions.assertThat((int)deploymentList.size()).isEqualTo(2);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").count()).isEqualTo(2L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").count()).isEqualTo(2L);
    }

    @Test
    public void testPartialChangesDeployChangedOnly() {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").startEvent().done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"process2").startEvent().done();
        Object deployment1 = this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2).name("thrice"));
        List deploymentResources = this.repositoryService.getDeploymentResourceNames(deployment1.getId());
        Assertions.assertThat((int)deploymentResources.size()).isEqualTo(2);
        BpmnModelInstance changedModel2 = Bpmn.createExecutableProcess((String)"process2").startEvent().endEvent().done();
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", changedModel2).name("thrice"));
        List deploymentList = this.repositoryService.createDeploymentQuery().list();
        Assertions.assertThat((int)deploymentList.size()).isEqualTo(2);
        ProcessDefinition process1Definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").singleResult();
        Assertions.assertThat((Object)process1Definition).isNotNull();
        Assertions.assertThat((int)process1Definition.getVersion()).isEqualTo(1);
        Assertions.assertThat((String)process1Definition.getDeploymentId()).isEqualTo((Object)deployment1.getId());
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").count()).isEqualTo(2L);
        BpmnModelInstance anotherChangedModel2 = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process2").startEvent().sequenceFlowId("flow")).endEvent().done();
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", anotherChangedModel2).name("thrice"));
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").count()).isEqualTo(1L);
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").count()).isEqualTo(3L);
    }

    @Test
    public void testPartialChangesRedeployOldVersion() {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").startEvent().done();
        this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("process1.bpmn20.xml", model1).name("deployment"));
        BpmnModelInstance changedModel1 = Bpmn.createExecutableProcess((String)"process1").startEvent().endEvent().done();
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("process1.bpmn20.xml", changedModel1).name("deployment"));
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(true).addModelInstance("process1.bpmn20.xml", model1).name("deployment"));
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").count()).isEqualTo(3L);
    }

    @Test
    public void testDeployTwoProcessesWithDuplicateIdAtTheSameTime() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml";
        String bpmnResourceName2 = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService2.bpmn20.xml";
        Assertions.assertThatThrownBy(() -> this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(false).addClasspathResource(bpmnResourceName).addClasspathResource(bpmnResourceName2).name("duplicateAtTheSameTime")));
        Assertions.assertThat((long)this.repositoryService.createDeploymentQuery().count()).isEqualTo(0L);
    }

    @Test
    public void testDeployDifferentFiles() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml";
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(false).addClasspathResource(bpmnResourceName).name("twice"));
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        List deploymentResources = this.repositoryService.getDeploymentResourceNames(deploymentId);
        Assertions.assertThat((int)deploymentResources.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)deploymentResources.get(0))).isEqualTo((Object)bpmnResourceName);
        bpmnResourceName = "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.bpmn20.xml";
        this.testRule.deploy(this.repositoryService.createDeployment().enableDuplicateFiltering(false).addClasspathResource(bpmnResourceName).name("twice"));
        List deploymentList = this.repositoryService.createDeploymentQuery().list();
        Assertions.assertThat((int)deploymentList.size()).isEqualTo(2);
    }

    @Test
    public void testDiagramCreationDisabled() {
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/parse/BpmnParseTest.testParseDiagramInterchangeElements.bpmn20.xml"));
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)commandExecutor.execute((Command)new Command<ProcessDefinitionEntity>(){

            public ProcessDefinitionEntity execute(CommandContext commandContext) {
                return Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedLatestProcessDefinitionByKey("myProcess");
            }
        });
        Assertions.assertThat((Object)processDefinitionEntity).isNotNull();
        Assertions.assertThat((int)processDefinitionEntity.getActivities().size()).isEqualTo(7);
        List resourceNames = this.repositoryService.getDeploymentResourceNames(processDefinitionEntity.getDeploymentId());
        Assertions.assertThat((int)resourceNames.size()).isEqualTo(1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.jpg"})
    @Test
    public void testProcessDiagramResource() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assertions.assertThat((String)processDefinition.getResourceName()).isEqualTo((Object)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.bpmn20.xml");
        Assertions.assertThat((boolean)processDefinition.hasStartFormKey()).isTrue();
        String diagramResourceName = processDefinition.getDiagramResourceName();
        Assertions.assertThat((String)diagramResourceName).isEqualTo((Object)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.jpg");
        InputStream diagramStream = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testProcessDiagramResource.jpg");
        byte[] diagramBytes = IoUtil.readInputStream((InputStream)diagramStream, (String)"diagram stream");
        Assertions.assertThat((int)diagramBytes.length).isEqualTo(33343);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.a.jpg", "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.b.jpg", "org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.c.jpg"})
    @Test
    public void testMultipleDiagramResourcesProvided() {
        ProcessDefinition processA = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("a").singleResult();
        ProcessDefinition processB = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("b").singleResult();
        ProcessDefinition processC = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("c").singleResult();
        Assertions.assertThat((String)processA.getDiagramResourceName()).isEqualTo((Object)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.a.jpg");
        Assertions.assertThat((String)processB.getDiagramResourceName()).isEqualTo((Object)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.b.jpg");
        Assertions.assertThat((String)processC.getDiagramResourceName()).isEqualTo((Object)"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testMultipleDiagramResourcesProvided.c.jpg");
    }

    @Deployment
    @Test
    public void testProcessDefinitionDescription() {
        String id = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ReadOnlyProcessDefinition processDefinition = ((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(id);
        Assertions.assertThat((String)processDefinition.getDescription()).isEqualTo((Object)"This is really good process documentation!");
    }

    @Test
    public void testDeployInvalidExpression() {
        DeploymentBuilder deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testInvalidExpression.bpmn20.xml");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testRule.deploy(deployment)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("ENGINE-01009 Error while parsing process").withFailMessage("Expected exception when deploying process with invalid expression.", new Object[0]);
        Assertions.assertThat((long)this.repositoryService.createDeploymentQuery().count()).isEqualTo(0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/deployment/BpmnDeploymentTest.testGetBpmnXmlFileThroughService.bpmn20.xml"})
    @Test
    public void testDeploymentIdOfResource() {
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        Assertions.assertThat((int)resources.size()).isEqualTo(1);
        Resource resource = (Resource)resources.get(0);
        Assertions.assertThat((String)resource.getDeploymentId()).isEqualTo((Object)deploymentId);
    }

    @Test
    public void testDeployBpmnModelInstance() throws Exception {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"foo").startEvent().userTask().endEvent().done();
        this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("foo.bpmn", modelInstance));
        Assertions.assertThat((Object)((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionResourceName("foo.bpmn").singleResult())).isNotNull();
    }

    @Test
    public void testDeployAndGetProcessDefinition() throws Exception {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"foo").startEvent().userTask().endEvent().done();
        Object deployment = this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("foo.bpmn", modelInstance));
        List deployedProcessDefinitions = deployment.getDeployedProcessDefinitions();
        Assertions.assertThat((int)deployedProcessDefinitions.size()).isEqualTo(1);
        Assertions.assertThat((List)deployment.getDeployedCaseDefinitions()).isNull();
        Assertions.assertThat((List)deployment.getDeployedDecisionDefinitions()).isNull();
        Assertions.assertThat((List)deployment.getDeployedDecisionRequirementsDefinitions()).isNull();
        ProcessDefinition persistedProcDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionResourceName("foo.bpmn").singleResult();
        Assertions.assertThat((String)((ProcessDefinition)deployedProcessDefinitions.get(0)).getId()).isEqualTo((Object)persistedProcDef.getId());
    }

    @Test
    public void testDeployNonExecutableProcess() throws Exception {
        BpmnModelInstance modelInstance = Bpmn.createProcess((String)"foo").startEvent().userTask().endEvent().done();
        Object deployment = this.testRule.deploy(this.repositoryService.createDeployment().addModelInstance("foo.bpmn", modelInstance));
        Assertions.assertThat((List)deployment.getDeployedProcessDefinitions()).isNull();
        Assertions.assertThat((Object)((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionResourceName("foo.bpmn").singleResult())).isNull();
    }
}

