/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import java.util.Date;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.history.useroperationlog.AbstractUserOperationLogTest;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class UserOperationLogTaskTest
extends AbstractUserOperationLogTest {
    protected ProcessDefinition processDefinition;
    protected ProcessInstance process;
    protected Task task;

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testCreateAndCompleteTask() {
        this.startTestProcess();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        this.completeTestProcess();
        query = this.queryOperationDetails("Complete");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry complete = (UserOperationLogEntry)query.singleResult();
        Assert.assertEquals((Object)"delete", (Object)complete.getProperty());
        Assert.assertTrue((boolean)Boolean.parseBoolean(complete.getNewValue()));
        Assert.assertEquals((Object)"TaskWorker", (Object)complete.getCategory());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testAssignTask() {
        this.startTestProcess();
        this.taskService.setAssignee(this.task.getId(), "icke");
        UserOperationLogQuery query = this.queryOperationDetails("Assign");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry assign = (UserOperationLogEntry)query.singleResult();
        Assert.assertEquals((Object)"assignee", (Object)assign.getProperty());
        Assert.assertEquals((Object)"icke", (Object)assign.getNewValue());
        Assert.assertEquals((Object)"TaskWorker", (Object)assign.getCategory());
        this.completeTestProcess();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testChangeTaskOwner() {
        this.startTestProcess();
        this.taskService.setOwner(this.task.getId(), "icke");
        UserOperationLogQuery query = this.queryOperationDetails("SetOwner");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry change = (UserOperationLogEntry)query.singleResult();
        Assert.assertEquals((Object)"owner", (Object)change.getProperty());
        Assert.assertEquals((Object)"icke", (Object)change.getNewValue());
        Assert.assertEquals((Object)"TaskWorker", (Object)change.getCategory());
        this.completeTestProcess();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testSetPriority() {
        this.startTestProcess();
        this.taskService.setPriority(this.task.getId(), 10);
        UserOperationLogQuery query = this.queryOperationDetails("SetPriority");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)query.singleResult();
        Assert.assertEquals((Object)"priority", (Object)userOperationLogEntry.getProperty());
        Assert.assertEquals((long)50L, (long)Integer.parseInt(userOperationLogEntry.getOrgValue()));
        Assert.assertEquals((long)10L, (long)Integer.parseInt(userOperationLogEntry.getNewValue()));
        Assert.assertEquals((Object)"TaskWorker", (Object)userOperationLogEntry.getCategory());
        Date date = DateTimeUtil.now().plusMinutes(5).toDate();
        ClockUtil.setCurrentTime((Date)date);
        this.taskService.setPriority(this.task.getId(), 75);
        query = this.queryOperationDetails("SetPriority");
        Assert.assertEquals((long)2L, (long)query.count());
        userOperationLogEntry = (UserOperationLogEntry)((UserOperationLogQuery)query.orderByTimestamp().asc()).list().get(1);
        Assert.assertEquals((Object)"priority", (Object)userOperationLogEntry.getProperty());
        Assert.assertEquals((long)10L, (long)Integer.parseInt(userOperationLogEntry.getOrgValue()));
        Assert.assertEquals((long)75L, (long)Integer.parseInt(userOperationLogEntry.getNewValue()));
        Assert.assertEquals((Object)"TaskWorker", (Object)userOperationLogEntry.getCategory());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testSetName() {
        this.startTestProcess();
        this.taskService.setName(this.task.getId(), "the-name");
        UserOperationLogQuery query = this.queryOperationDetails("SetName");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry result = (UserOperationLogEntry)query.singleResult();
        Assertions.assertThat((String)result.getOperationType()).isEqualTo((Object)"SetName");
        Assertions.assertThat((String)result.getTaskId()).isEqualTo((Object)this.task.getId());
        Assertions.assertThat((String)result.getProperty()).isEqualTo((Object)"name");
        Assertions.assertThat((String)result.getNewValue()).isEqualTo((Object)"the-name");
        Assertions.assertThat((String)result.getEntityType()).isEqualTo((Object)"Task");
        Assert.assertEquals((Object)"TaskWorker", (Object)result.getCategory());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testSetDescription() {
        this.startTestProcess();
        this.taskService.setDescription(this.task.getId(), "the-description");
        UserOperationLogQuery query = this.queryOperationDetails("SetDescription");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry result = (UserOperationLogEntry)query.singleResult();
        Assertions.assertThat((String)result.getOperationType()).isEqualTo((Object)"SetDescription");
        Assertions.assertThat((String)result.getTaskId()).isEqualTo((Object)this.task.getId());
        Assertions.assertThat((String)result.getProperty()).isEqualTo((Object)"description");
        Assertions.assertThat((String)result.getNewValue()).isEqualTo((Object)"the-description");
        Assertions.assertThat((String)result.getEntityType()).isEqualTo((Object)"Task");
        Assert.assertEquals((Object)"TaskWorker", (Object)result.getCategory());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testSetDueDate() {
        this.startTestProcess();
        Date newValue = DateTime.now().toDate();
        this.taskService.setDueDate(this.task.getId(), newValue);
        UserOperationLogQuery query = this.queryOperationDetails("SetDueDate");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry result = (UserOperationLogEntry)query.singleResult();
        Assertions.assertThat((String)result.getOperationType()).isEqualTo((Object)"SetDueDate");
        Assertions.assertThat((String)result.getTaskId()).isEqualTo((Object)this.task.getId());
        Assertions.assertThat((String)result.getProperty()).isEqualTo((Object)"dueDate");
        Assertions.assertThat((String)result.getNewValue()).isEqualTo((Object)String.valueOf(newValue.getTime()));
        Assertions.assertThat((String)result.getEntityType()).isEqualTo((Object)"Task");
        Assert.assertEquals((Object)"TaskWorker", (Object)result.getCategory());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void setFollowUpDate() {
        this.startTestProcess();
        Date newValue = DateTime.now().toDate();
        this.taskService.setFollowUpDate(this.task.getId(), newValue);
        UserOperationLogQuery query = this.queryOperationDetails("SetFollowUpDate");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry result = (UserOperationLogEntry)query.singleResult();
        Assertions.assertThat((String)result.getOperationType()).isEqualTo((Object)"SetFollowUpDate");
        Assertions.assertThat((String)result.getTaskId()).isEqualTo((Object)this.task.getId());
        Assertions.assertThat((String)result.getProperty()).isEqualTo((Object)"followUpDate");
        Assertions.assertThat((String)result.getNewValue()).isEqualTo((Object)String.valueOf(newValue.getTime()));
        Assertions.assertThat((String)result.getEntityType()).isEqualTo((Object)"Task");
        Assert.assertEquals((Object)"TaskWorker", (Object)result.getCategory());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testClaimTask() {
        this.startTestProcess();
        this.taskService.claim(this.task.getId(), "icke");
        UserOperationLogQuery query = this.queryOperationDetails("Claim");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry claim = (UserOperationLogEntry)query.singleResult();
        Assert.assertEquals((Object)"assignee", (Object)claim.getProperty());
        Assert.assertEquals((Object)"icke", (Object)claim.getNewValue());
        Assert.assertEquals((Object)"TaskWorker", (Object)claim.getCategory());
        this.completeTestProcess();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testDelegateTask() {
        this.startTestProcess();
        this.taskService.claim(this.task.getId(), "icke");
        this.taskService.delegateTask(this.task.getId(), "er");
        UserOperationLogQuery query = this.queryOperationDetails("Delegate");
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertEquals((Object)"icke", (Object)((UserOperationLogEntry)this.queryOperationDetails("Delegate", "owner").singleResult()).getNewValue());
        Assert.assertEquals((Object)"er", (Object)((UserOperationLogEntry)this.queryOperationDetails("Delegate", "assignee").singleResult()).getNewValue());
        Assert.assertEquals((Object)DelegationState.PENDING.toString(), (Object)((UserOperationLogEntry)this.queryOperationDetails("Delegate", "delegation").singleResult()).getNewValue());
        Assert.assertEquals((Object)"TaskWorker", (Object)((UserOperationLogEntry)this.queryOperationDetails("Delegate", "delegation").singleResult()).getCategory());
        this.completeTestProcess();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testResolveTask() {
        this.startTestProcess();
        this.taskService.resolveTask(this.task.getId());
        UserOperationLogQuery query = this.queryOperationDetails("Resolve");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry log = (UserOperationLogEntry)query.singleResult();
        Assert.assertEquals((Object)DelegationState.RESOLVED.toString(), (Object)log.getNewValue());
        Assert.assertEquals((Object)"TaskWorker", (Object)log.getCategory());
        this.completeTestProcess();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testSubmitTaskForm_Complete() {
        this.startTestProcess();
        this.formService.submitTaskForm(this.task.getId(), new HashMap());
        UserOperationLogQuery query = this.queryOperationDetails("Complete");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry log = (UserOperationLogEntry)query.property("delete").singleResult();
        Assert.assertFalse((boolean)Boolean.parseBoolean(log.getOrgValue()));
        Assert.assertTrue((boolean)Boolean.parseBoolean(log.getNewValue()));
        Assert.assertEquals((Object)"TaskWorker", (Object)log.getCategory());
        this.testRule.assertProcessEnded(this.process.getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testSubmitTaskForm_Resolve() {
        this.startTestProcess();
        this.taskService.delegateTask(this.task.getId(), "demo");
        this.formService.submitTaskForm(this.task.getId(), new HashMap());
        UserOperationLogQuery query = this.queryOperationDetails("Resolve");
        Assert.assertEquals((long)2L, (long)query.count());
        UserOperationLogEntry log = (UserOperationLogEntry)query.property("delegation").singleResult();
        Assert.assertEquals((Object)DelegationState.PENDING.toString(), (Object)log.getOrgValue());
        Assert.assertEquals((Object)DelegationState.RESOLVED.toString(), (Object)log.getNewValue());
        Assert.assertEquals((Object)"TaskWorker", (Object)log.getCategory());
        log = (UserOperationLogEntry)query.property("assignee").singleResult();
        Assert.assertEquals((Object)"demo", (Object)log.getOrgValue());
        Assert.assertEquals(null, (Object)log.getNewValue());
        Assert.assertEquals((Object)"TaskWorker", (Object)log.getCategory());
        this.completeTestProcess();
    }

    @Test
    public void testDeleteTask() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.deleteTask(task.getId());
        UserOperationLogQuery query = this.queryOperationDetails("Delete");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry log = (UserOperationLogEntry)query.singleResult();
        Assertions.assertThat((String)log.getProperty()).isEqualTo((Object)"delete");
        Assertions.assertThat((String)log.getOrgValue()).isEqualTo((Object)"false");
        Assertions.assertThat((String)log.getNewValue()).isEqualTo((Object)"true");
        Assertions.assertThat((String)log.getCategory()).isEqualTo((Object)"TaskWorker");
        this.historyService.deleteHistoricTaskInstance(task.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testCompleteTask() {
        this.startTestProcess();
        this.taskService.complete(this.task.getId());
        UserOperationLogQuery query = this.queryOperationDetails("Complete");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry log = (UserOperationLogEntry)query.singleResult();
        Assertions.assertThat((String)log.getProperty()).isEqualTo((Object)"delete");
        Assertions.assertThat((String)log.getOrgValue()).isEqualTo((Object)"false");
        Assertions.assertThat((String)log.getNewValue()).isEqualTo((Object)"true");
        Assertions.assertThat((String)log.getCategory()).isEqualTo((Object)"TaskWorker");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCompleteCaseExecution() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinition.getId()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        UserOperationLogQuery query = this.queryOperationDetails("Complete");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.singleResult();
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)caseDefinition.getId(), (Object)entry.getCaseDefinitionId());
        Assert.assertEquals((Object)caseInstanceId, (Object)entry.getCaseInstanceId());
        Assert.assertEquals((Object)humanTaskId, (Object)entry.getCaseExecutionId());
        Assert.assertEquals((Object)caseDefinition.getDeploymentId(), (Object)entry.getDeploymentId());
        Assert.assertFalse((boolean)Boolean.valueOf(entry.getOrgValue()));
        Assert.assertTrue((boolean)Boolean.valueOf(entry.getNewValue()));
        Assert.assertEquals((Object)"delete", (Object)entry.getProperty());
        Assert.assertEquals((Object)"TaskWorker", (Object)entry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testKeepOpLogEntriesOnUndeployment() {
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        this.startTestProcess();
        this.taskService.resolveTask(this.task.getId());
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(this.processDefinition.getId());
        this.repositoryService.deleteDeployment(deploymentId, true);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assert.assertEquals((long)4L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.operationType("Create").count());
        Assert.assertEquals((long)1L, (long)query.operationType("Suspend").count());
        Assert.assertEquals((long)1L, (long)query.operationType("Resolve").count());
        Assert.assertEquals((long)1L, (long)query.operationType("Delete").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteOpLogEntry() {
        this.startTestProcess();
        this.taskService.resolveTask(this.task.getId());
        UserOperationLogEntry opLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.historyService.deleteUserOperationLogEntry(opLogEntry.getId());
        Assert.assertEquals((long)0L, (long)this.historyService.createUserOperationLogQuery().entityType("Task").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteOpLogEntryWithNullArgument() {
        this.startTestProcess();
        this.taskService.resolveTask(this.task.getId());
        try {
            this.historyService.deleteUserOperationLogEntry(null);
            Assert.fail((String)"exeception expected");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteOpLogNonExstingEntry() {
        this.startTestProcess();
        this.taskService.resolveTask(this.task.getId());
        Assert.assertEquals((long)2L, (long)this.historyService.createUserOperationLogQuery().count());
        this.historyService.deleteUserOperationLogEntry("a non existing id");
        Assert.assertEquals((long)2L, (long)this.historyService.createUserOperationLogQuery().count());
    }

    @Deployment
    @Test
    public void testOnlyTaskCompletionIsLogged() {
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstanceId, "taskListenerCalled")));
        Assert.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(processInstanceId, "serviceTaskCalled")));
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().entityType("Task");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry log = (UserOperationLogEntry)query.singleResult();
        Assert.assertEquals((Object)"process", (Object)log.getProcessDefinitionKey());
        Assert.assertEquals((Object)processInstanceId, (Object)log.getProcessInstanceId());
        Assert.assertEquals((Object)deploymentId, (Object)log.getDeploymentId());
        Assert.assertEquals((Object)taskId, (Object)log.getTaskId());
        Assert.assertEquals((Object)"Complete", (Object)log.getOperationType());
        Assert.assertEquals((Object)"TaskWorker", (Object)log.getCategory());
    }

    protected void startTestProcess() {
        this.processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").singleResult();
        this.process = this.runtimeService.startProcessInstanceById(this.processDefinition.getId());
        this.task = (Task)this.taskService.createTaskQuery().singleResult();
    }

    protected UserOperationLogQuery queryOperationDetails(String type) {
        return this.historyService.createUserOperationLogQuery().operationType(type);
    }

    protected UserOperationLogQuery queryOperationDetails(String type, String property) {
        return this.historyService.createUserOperationLogQuery().operationType(type).property(property);
    }

    protected void completeTestProcess() {
        this.taskService.complete(this.task.getId());
        this.testRule.assertProcessEnded(this.process.getId());
    }
}

