/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.db;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.management.SchemaLogEntry;
import org.camunda.bpm.engine.management.SchemaLogQuery;
import org.camunda.bpm.engine.test.standalone.db.SchemaLogTestCase;
import org.camunda.bpm.engine.test.util.TestconfigProperties;
import org.junit.Before;
import org.junit.Test;

public class SchemaLogEnsureSqlScriptTest
extends SchemaLogTestCase {
    protected String currentSchemaVersion;
    protected String dataBaseType;

    @Override
    @Before
    public void init() {
        super.init();
        SchemaLogEntry latestEntry = (SchemaLogEntry)((SchemaLogQuery)this.processEngine.getManagementService().createSchemaLogQuery().orderByTimestamp().desc()).listPage(0, 1).get(0);
        this.currentSchemaVersion = latestEntry.getVersion();
        this.dataBaseType = this.processEngine.getProcessEngineConfiguration().getDatabaseType();
    }

    @Test
    public void ensureUpgradeScriptsUpdateSchemaLogVersion() {
        ArrayList<String> scriptsForDB = new ArrayList<String>();
        for (String file : (List)this.folderContents.get("org/camunda/bpm/engine/db/upgrade")) {
            if (!file.startsWith(this.dataBaseType)) continue;
            scriptsForDB.add(file);
        }
        if (!scriptsForDB.isEmpty()) {
            Assertions.assertThat((String)this.getLatestTargetVersion(scriptsForDB)).isEqualTo((Object)this.currentSchemaVersion);
        } else {
            Assertions.assertThat((String)this.getCurrentMinorVersion()).isEqualTo((Object)this.currentSchemaVersion);
        }
    }

    @Test
    public void ensureOnlyScriptsForValidDatabaseTypes() {
        for (String file : (List)this.folderContents.get("org/camunda/bpm/engine/db/upgrade")) {
            Assertions.assertThat((String)file.split("_")[0]).isIn((Object[])DATABASES);
        }
    }

    protected String getTargetVersionForScript(String file) {
        String targetVersion = file.substring(file.indexOf("to_") + 3).replace(".sql", "");
        if (this.isMinorLevel(targetVersion)) {
            targetVersion = targetVersion + ".0";
        }
        return targetVersion;
    }

    protected String getLatestTargetVersion(List<String> scriptFiles) {
        String latestVersion = null;
        for (String file : scriptFiles) {
            if (latestVersion == null) {
                latestVersion = this.getTargetVersionForScript(file);
                continue;
            }
            String targetVersion = this.getTargetVersionForScript(file);
            if (!this.isLaterVersionThan(targetVersion, latestVersion)) continue;
            latestVersion = targetVersion;
        }
        return latestVersion;
    }

    protected boolean isLaterVersionThan(String v1, String v2) {
        String[] v1_ = v1.split("\\.|_");
        String[] v2_ = v2.split("\\.|_");
        int length = Math.max(v1_.length, v2_.length);
        for (int i = 0; i < length; ++i) {
            int v2Part;
            int v1Part = i < v1_.length ? Integer.parseInt(v1_[i]) : 0;
            int n = v2Part = i < v2_.length ? Integer.parseInt(v2_[i]) : 0;
            if (v1Part == v2Part) continue;
            return v1Part > v2Part;
        }
        return false;
    }

    protected String getCurrentMinorVersion() {
        String version = TestconfigProperties.getEngineVersion();
        int lastPos = version.lastIndexOf(".");
        version = version.substring(0, lastPos);
        return version + ".0";
    }
}

