/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.transformer;

import org.camunda.bpm.dmn.engine.impl.DmnDecisionImpl;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnElementTransformContext;
import org.camunda.bpm.dmn.engine.impl.transform.DmnDecisionTransformHandler;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.util.ParseUtil;
import org.camunda.bpm.model.dmn.instance.Decision;

public class DecisionDefinitionHandler
extends DmnDecisionTransformHandler {
    protected DmnDecisionImpl createDmnElement() {
        return new DecisionDefinitionEntity();
    }

    protected DmnDecisionImpl createFromDecision(DmnElementTransformContext context, Decision decision) {
        DecisionDefinitionEntity decisionDefinition = (DecisionDefinitionEntity)super.createFromDecision(context, decision);
        String category = context.getModelInstance().getDefinitions().getNamespace();
        decisionDefinition.setCategory(category);
        decisionDefinition.setVersionTag(decision.getVersionTag());
        this.setHistoryTTL(decision, decisionDefinition);
        return decisionDefinition;
    }

    private void setHistoryTTL(Decision decision, DecisionDefinitionEntity decisionDefinition) {
        Integer localHistoryTimeToLive = ParseUtil.parseHistoryTimeToLive(decision.getCamundaHistoryTimeToLiveString());
        if (localHistoryTimeToLive != null) {
            decisionDefinition.setHistoryTimeToLive(localHistoryTimeToLive);
        } else {
            Integer configuredHistoryTTL = ParseUtil.parseHistoryTimeToLive(Context.getProcessEngineConfiguration().getHistoryTimeToLive());
            decisionDefinition.setHistoryTimeToLive(configuredHistoryTTL);
        }
    }
}

