/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.ProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.RepositoryServiceImpl;
import org.camunda.bpm.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DiagramLayout;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessDefinitionAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_TASK_PROCESS_KEY = "oneTaskProcess";
    protected static final String TWO_TASKS_PROCESS_KEY = "twoTasksProcess";

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml");
        super.setUp();
    }

    @Test
    public void testQueryWithoutAuthorization() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithReadPermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void testQueryWithMultiple() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void testQueryWithReadPermissionOnOneTaskProcess() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        ProcessDefinition definition = (ProcessDefinition)query.singleResult();
        Assert.assertNotNull((Object)definition);
        Assert.assertEquals((Object)ONE_TASK_PROCESS_KEY, (Object)definition.getKey());
    }

    @Test
    public void testQueryWithRevokedReadPermission() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.ALL});
        Authorization authorization = this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY);
        authorization.setUserId(this.userId);
        authorization.removePermission((Permission)Permissions.READ);
        this.saveAuthorization(authorization);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        ProcessDefinition definition = (ProcessDefinition)query.singleResult();
        Assert.assertNotNull((Object)definition);
        Assert.assertEquals((Object)TWO_TASKS_PROCESS_KEY, (Object)definition.getKey());
    }

    @Test
    public void testQueryWithGroupAuthorizationRevokedReadPermission() {
        Authorization authorization = this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*");
        authorization.setGroupId(this.groupId);
        authorization.addPermission((Permission)Permissions.ALL);
        this.saveAuthorization(authorization);
        authorization = this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY);
        authorization.setGroupId(this.groupId);
        authorization.removePermission((Permission)Permissions.READ);
        this.saveAuthorization(authorization);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        ProcessDefinition definition = (ProcessDefinition)query.singleResult();
        Assert.assertNotNull((Object)definition);
        Assert.assertEquals((Object)TWO_TASKS_PROCESS_KEY, (Object)definition.getKey());
    }

    @Test
    public void testGetProcessDefinitionWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.getProcessDefinition(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to get the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ProcessDefinition definition = this.repositoryService.getProcessDefinition(processDefinitionId);
        Assert.assertNotNull((Object)definition);
    }

    @Test
    public void testGetDeployedProcessDefinitionWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            ((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to get the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetDeployedProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ReadOnlyProcessDefinition definition = ((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
        Assert.assertNotNull((Object)definition);
    }

    @Test
    public void testGetProcessDiagramWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.getProcessDiagram(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to get the process diagram");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetProcessDiagram() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        InputStream stream = this.repositoryService.getProcessDiagram(processDefinitionId);
        Assert.assertNull((Object)stream);
    }

    @Test
    public void testGetProcessModelWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.getProcessModel(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to get the process model");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetProcessModel() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        InputStream stream = this.repositoryService.getProcessModel(processDefinitionId);
        Assert.assertNotNull((Object)stream);
    }

    @Test
    public void testGetBpmnModelInstanceWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.getBpmnModelInstance(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to get the bpmn model instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetBpmnModelInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        BpmnModelInstance modelInstance = this.repositoryService.getBpmnModelInstance(processDefinitionId);
        Assert.assertNotNull((Object)modelInstance);
    }

    @Test
    public void testGetProcessDiagramLayoutWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.getProcessDiagramLayout(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to get the process diagram layout");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetProcessDiagramLayout() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        DiagramLayout diagramLayout = this.repositoryService.getProcessDiagramLayout(processDefinitionId);
        Assert.assertNull((Object)diagramLayout);
    }

    @Test
    public void testSuspendProcessDefinitionByIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to suspend the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendProcessDefinitionById() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertTrue((boolean)definition.isSuspended());
    }

    @Test
    public void testSuspendProcessDefinitionByIdWithSuspendPermission() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND});
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertTrue((boolean)definition.isSuspended());
    }

    @Test
    public void testActivateProcessDefinitionByIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        try {
            this.repositoryService.activateProcessDefinitionById(processDefinitionId);
            Assert.fail((String)"Exception expected: It should not be possible to activate the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateProcessDefinitionById() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.activateProcessDefinitionById(processDefinitionId);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertFalse((boolean)definition.isSuspended());
    }

    @Test
    public void testActivateProcessDefinitionByIdWithSuspendPermission() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND});
        this.repositoryService.activateProcessDefinitionById(processDefinitionId);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertFalse((boolean)definition.isSuspended());
    }

    @Test
    public void testSuspendProcessDefinitionByIdIncludingInstancesWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
            Assert.fail((String)"Exception expected: It should not be possible to suspend the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendProcessDefinitionByIdIncludingInstancesWithUpdatePermissionOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, ProcessDefinitionPermissions.SUSPEND});
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE, ProcessInstancePermissions.SUSPEND});
        try {
            this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
            Assert.fail((String)"Exception expected: It should not be possible to suspend the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendProcessDefinitionByIdIncludingInstancesWithUpdatePermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertTrue((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessDefinitionByIdIncludingInstancesWithSuspendPermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
        this.verifyProcessDefinitionSuspendedByKeyIncludingInstances();
    }

    @Test
    public void testSuspendProcessDefinitionByIdIncludingInstancesWithUpdateInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertTrue((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessDefinitionByIdIncludingInstancesWithUpdateAndSuspendInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
        this.verifyProcessDefinitionSuspendedByKeyIncludingInstances();
    }

    @Test
    public void testSuspendProcessDefinitionByIdIncludingInstancesWithSuspendAndSuspendInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
        this.verifyProcessDefinitionSuspendedByKeyIncludingInstances();
    }

    @Test
    public void testSuspendProcessDefinitionByIdIncludingInstancesWithSuspendAndUpdateInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND, Permissions.UPDATE_INSTANCE});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
        this.verifyProcessDefinitionSuspendedByKeyIncludingInstances();
    }

    @Test
    public void testActivateProcessDefinitionByIdIncludingInstancesWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, ProcessDefinitionPermissions.SUSPEND});
        try {
            this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
            Assert.fail((String)"Exception expected: It should not be possible to activate the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateProcessDefinitionByIdIncludingInstancesWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
            Assert.fail((String)"Exception expected: It should not be possible to activate the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateProcessDefinitionByIdIncludingInstancesWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertFalse((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessDefinitionByIdIncludingInstancesWithSuspendPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND});
        this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
        this.verifyProcessDefinitionActivatedByKeyIncludingInstances();
    }

    @Test
    public void testActivateProcessDefinitionByIdIncludingInstancesWithUpdateInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertFalse((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessDefinitionByIdIncludingInstancesWithSuspendAndSuspendInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
        this.verifyProcessDefinitionActivatedByKeyIncludingInstances();
    }

    @Test
    public void testActivateProcessDefinitionByIdIncludingInstancesWithSuspendAndUpdateInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND, Permissions.UPDATE_INSTANCE});
        this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
        this.verifyProcessDefinitionActivatedByKeyIncludingInstances();
    }

    @Test
    public void testActivateProcessDefinitionByIdIncludingInstancesWithUpdateAndSuspendInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.suspendProcessDefinitionById(processDefinitionId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
        this.verifyProcessDefinitionActivatedByKeyIncludingInstances();
    }

    @Test
    public void testSuspendProcessDefinitionByKeyWithoutAuthorization() {
        try {
            this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
            Assert.fail((String)"Exception expected: It should not be possible to suspend the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendProcessDefinitionByKey() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertTrue((boolean)definition.isSuspended());
    }

    @Test
    public void testSuspendProcessDefinitionByKeyWithSuspendPermission() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND});
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertTrue((boolean)definition.isSuspended());
    }

    @Test
    public void testActivateProcessDefinitionByKeyWithoutAuthorization() {
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        try {
            this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
            Assert.fail((String)"Exception expected: It should not be possible to activate the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateProcessDefinitionByKey() {
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertFalse((boolean)definition.isSuspended());
    }

    @Test
    public void testActivateProcessDefinitionByKeyWithSuspendPermission() {
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND});
        this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertFalse((boolean)definition.isSuspended());
    }

    @Test
    public void testSuspendProcessDefinitionByKeyIncludingInstancesWithoutAuthorization() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, ProcessDefinitionPermissions.SUSPEND});
        try {
            this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
            Assert.fail((String)"Exception expected: It should not be possible to suspend the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendProcessDefinitionByKeyIncludingInstancesWithUpdatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, ProcessDefinitionPermissions.SUSPEND});
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE, ProcessInstancePermissions.SUSPEND});
        try {
            this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
            Assert.fail((String)"Exception expected: It should not be possible to suspend the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSuspendProcessDefinitionByKeyIncludingInstancesWithUpdatePermissionOnAnyProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertTrue((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessDefinitionByKeyIncludingInstancesWithSuspendPermissionOnAnyProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        this.verifyProcessDefinitionSuspendedByKeyIncludingInstances();
    }

    @Test
    public void testSuspendProcessDefinitionByKeyIncludingInstancesWithUpdateInstancePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertTrue((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    @Test
    public void testSuspendProcessDefinitionByKeyIncludingInstancesWithSuspendAndSuspendInstancePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        this.verifyProcessDefinitionSuspendedByKeyIncludingInstances();
    }

    @Test
    public void testSuspendProcessDefinitionByKeyIncludingInstancesWithSuspendAndUpdateInstancePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND, Permissions.UPDATE_INSTANCE});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        this.verifyProcessDefinitionSuspendedByKeyIncludingInstances();
    }

    @Test
    public void testSuspendProcessDefinitionByKeyIncludingInstancesWithUpdateAndSuspendInstancePermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.repositoryService.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        this.verifyProcessDefinitionSuspendedByKeyIncludingInstances();
    }

    @Test
    public void testActivateProcessDefinitionByKeyIncludingInstancesWithoutAuthorization() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
            Assert.fail((String)"Exception expected: It should not be possible to activate the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateProcessDefinitionByKeyIncludingInstancesWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE, ProcessInstancePermissions.SUSPEND});
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, ProcessDefinitionPermissions.SUSPEND});
        try {
            this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
            Assert.fail((String)"Exception expected: It should not be possible to activate the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testActivateProcessDefinitionByKeyIncludingInstancesWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertFalse((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessDefinitionByKeyIncludingInstancesWithSuspendPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND});
        this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        this.verifyProcessDefinitionActivatedByKeyIncludingInstances();
    }

    @Test
    public void testActivateProcessDefinitionByKeyIncludingInstancesWithUpdateInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, Permissions.UPDATE_INSTANCE});
        this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertFalse((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }

    @Test
    public void testActivateProcessDefinitionByKeyIncludingInstancesWithSuspendAndSuspendInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        this.verifyProcessDefinitionActivatedByKeyIncludingInstances();
    }

    @Test
    public void testActivateProcessDefinitionByKeyIncludingInstancesWithSuspendAndUpdateInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND, Permissions.UPDATE_INSTANCE});
        this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        this.verifyProcessDefinitionActivatedByKeyIncludingInstances();
    }

    @Test
    public void testActivateProcessDefinitionByKeyIncludingInstancesWithUpdateAndSuspendInstancePermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.suspendProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.repositoryService.activateProcessDefinitionByKey(ONE_TASK_PROCESS_KEY, true, null);
        this.verifyProcessDefinitionActivatedByKeyIncludingInstances();
    }

    @Test
    public void testProcessDefinitionUpdateTimeToLive() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(definition.getId(), Integer.valueOf(6));
        definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertEquals((long)6L, (long)definition.getHistoryTimeToLive().intValue());
    }

    @Test
    public void testDecisionDefinitionUpdateTimeToLiveWithoutAuthorizations() {
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        try {
            this.repositoryService.updateProcessDefinitionHistoryTimeToLive(definition.getId(), Integer.valueOf(6));
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testStartableInTasklist() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().list();
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().count());
        Assert.assertEquals((Object)definition.getId(), (Object)((ProcessDefinition)processDefinitions.get(0)).getId());
        Assert.assertTrue((boolean)((ProcessDefinition)processDefinitions.get(0)).isStartableInTasklist());
    }

    @Test
    public void testStartableInTasklistReadAllProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().list();
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().count());
        Assert.assertEquals((Object)definition.getId(), (Object)((ProcessDefinition)processDefinitions.get(0)).getId());
        Assert.assertTrue((boolean)((ProcessDefinition)processDefinitions.get(0)).isStartableInTasklist());
    }

    @Test
    public void testStartableInTasklistWithoutCreateInstancePerm() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().list();
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)0L, (long)processDefinitions.size());
    }

    @Test
    public void testStartableInTasklistWithoutReadDefPerm() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().list();
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)0L, (long)processDefinitions.size());
    }

    @Test
    public void testStartableInTasklistWithoutCreatePerm() {
        this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().startablePermissionCheck().startableInTasklist().list();
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)0L, (long)processDefinitions.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotResolveUnauthorizedCalledProcessDefinitions() {
        Deployment deployment = this.createDeployment("test", "org/camunda/bpm/engine/test/api/repository/call-activities-with-references.bpmn", "org/camunda/bpm/engine/test/api/repository/first-process.bpmn20.xml");
        try {
            String parentKey = "TestCallActivitiesWithReferences";
            this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, parentKey, this.userId, new Permission[]{Permissions.READ});
            ProcessDefinition parentDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(parentKey).singleResult();
            Collection mappings = this.repositoryService.getStaticCalledProcessDefinitions(parentDefinition.getId());
            Assert.assertTrue((boolean)mappings.isEmpty());
        }
        finally {
            this.deleteDeployment(deployment.getId());
        }
    }

    protected void verifyProcessDefinitionSuspendedByKeyIncludingInstances() {
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertTrue((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertTrue((boolean)instance.isSuspended());
    }

    protected void verifyProcessDefinitionActivatedByKeyIncludingInstances() {
        ProcessDefinition definition = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY);
        Assert.assertFalse((boolean)definition.isSuspended());
        ProcessInstance instance = this.selectSingleProcessInstance();
        Assert.assertFalse((boolean)instance.isSuspended());
    }
}

