/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.util;

import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.slf4j.Logger;

public class AuthorizationExceptionInterceptor
extends CommandInterceptor {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    protected boolean isActive;
    protected AuthorizationException lastException;
    protected int count = 0;

    public <T> T execute(Command<T> command) {
        try {
            ++this.count;
            Object result = this.next.execute(command);
            --this.count;
            return (T)result;
        }
        catch (AuthorizationException e) {
            --this.count;
            if (this.count != 0 || !this.isActive) {
                throw e;
            }
            this.lastException = e;
            LOG.info("Caught authorization exception; storing for assertion in test", (Throwable)e);
            return null;
        }
    }

    public void reset() {
        this.lastException = null;
        this.count = 0;
    }

    public AuthorizationException getLastException() {
        return this.lastException;
    }

    public void activate() {
        this.isActive = true;
    }

    public void deactivate() {
        this.isActive = false;
    }
}

