/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.telemetry;

import camundajar.impl.com.google.gson.GsonBuilder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.ManagementServiceImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.metrics.util.MetricsUtil;
import org.camunda.bpm.engine.impl.telemetry.PlatformTelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.dto.ApplicationServerImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.CommandImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.DatabaseImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.InternalsImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.JdkImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.LicenseKeyDataImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.ProductImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.TelemetryDataImpl;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetryReporter;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.bpm.engine.impl.util.ParseUtil;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.telemetry.Command;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.BusinessRuleTask;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.camunda.commons.testing.WatchLogger;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TelemetryReporterTest {
    protected static final String DEPLOY_CMD = "DeployCmd";
    protected static final String GET_NEXT_ID_BLOCK_CMD = "GetNextIdBlockCmd";
    protected static final String BOOTSTRAP_ENGINE_CMD = "BootstrapEngineCommand";
    protected static final String START_PROCESS_INSTANCE_CMD = "StartProcessInstanceCmd";
    protected static final String GET_LICENSE_KEY_CMD = "GetLicenseKeyCmd";
    protected static final String GET_HISTORY_LEVEL_CMD = "GetHistoryLevelCmd";
    protected static final String IS_TELEMETRY_ENABLED_CMD = "IsTelemetryEnabledCmd";
    protected static final String TELEMETRY_CONFIGURE_CMD = "TelemetryConfigureCmd";
    protected static final String GET_TELEMETRY_DATA_CMD = "GetTelemetryDataCmd";
    protected static final String TELEMETRY_ENDPOINT = "http://localhost:8084/pings";
    protected static final String TELEMETRY_ENDPOINT_PATH = "/pings";
    protected static final String VALID_UUID_V4 = "cb07ce31-c8e3-4f5f-94c2-1b28175c2022";
    public static String DMN_FILE = "org/camunda/bpm/engine/test/api/mgmt/metrics/ExecutedDecisionElementsTest.dmn11.xml";
    public static VariableMap VARIABLES = Variables.createVariables().putValue("status", (Object)"").putValue("sum", (Object)100);
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setTelemetryEndpoint(TELEMETRY_ENDPOINT).setTelemetryReporterActivate(true));
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();
    @ClassRule
    public static WireMockRule wireMockRule = new WireMockRule(8084);
    protected ProcessEngine standaloneProcessEngine;
    protected ProcessEngineConfigurationImpl configuration;
    protected ManagementService managementService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected IdentityService identityService;
    protected TelemetryReporter standaloneReporter;
    protected TelemetryDataImpl defaultTelemetryData;

    @Before
    public void init() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = this.configuration.getManagementService();
        this.runtimeService = this.configuration.getRuntimeService();
        this.taskService = this.configuration.getTaskService();
        this.identityService = this.configuration.getIdentityService();
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.configuration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
        this.clearMetrics();
        this.configuration.getTelemetryRegistry().clear();
        this.defaultTelemetryData = new TelemetryDataImpl(this.configuration.getTelemetryData());
    }

    @After
    public void tearDown() {
        this.identityService.clearAuthentication();
        ClockUtil.resetClock();
        if (Boolean.TRUE.equals(this.managementService.isTelemetryEnabled())) {
            this.managementService.toggleTelemetry(false);
        }
        this.clearMetrics();
        if (this.standaloneReporter != null) {
            this.standaloneReporter.stop(false);
            this.standaloneReporter = null;
        }
        if (this.standaloneProcessEngine != null) {
            if (Boolean.TRUE.equals(this.standaloneProcessEngine.getManagementService().isTelemetryEnabled())) {
                this.standaloneProcessEngine.getManagementService().toggleTelemetry(false);
            }
            this.standaloneProcessEngine.close();
        }
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.configuration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
        WireMock.resetAllRequests();
        this.configuration.setTelemetryData(this.defaultTelemetryData);
    }

    protected void clearMetrics() {
        Collection meters = this.configuration.getMetricsRegistry().getDbMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
        this.managementService.deleteMetrics(null);
    }

    @Test
    public void shouldSendTelemetry() {
        this.managementService.toggleTelemetry(true);
        TelemetryDataImpl data = this.createDataToSend();
        String requestBody = this.toJson(data);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.standaloneReporter = new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), TELEMETRY_ENDPOINT, 0, 1000L, data, this.configuration.getTelemetryHttpConnector(), this.configuration.getTelemetryRegistry(), this.configuration.getMetricsRegistry(), this.configuration.getTelemetryRequestTimeout());
        this.standaloneReporter.reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldReportDataWhenTelemetryInitialized() {
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        processEngineConfiguration.setTelemetryEndpoint(TELEMETRY_ENDPOINT).setInitializeTelemetry(true).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.standaloneProcessEngine = processEngineConfiguration.buildProcessEngine();
        processEngineConfiguration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldNotReportWhenProductNameIsNull() {
        this.executeDataValidationTest(null, "7.15.0", "community", VALID_UUID_V4);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldNotReportWhenProductNameIsEmpty() {
        this.executeDataValidationTest("", "7.15.0", "community", VALID_UUID_V4);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldNotReportWhenProductVersionIsNull() {
        this.executeDataValidationTest("Runtime", null, "community", VALID_UUID_V4);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldNotReportWhenProductVersionIsEmpty() {
        this.executeDataValidationTest("Runtime", "", "community", VALID_UUID_V4);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldNotReportWhenProductEditionIsNull() {
        this.executeDataValidationTest("Runtime", "7.15.0", null, VALID_UUID_V4);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldNotReportWhenProductEditionIsEmpty() {
        this.executeDataValidationTest("Runtime", "7.15.0", "", VALID_UUID_V4);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldNotReportWhenInstallationIdIsNull() {
        this.executeDataValidationTest("Runtime", "7.15.0", "community", null);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldNotReportWhenInstallationIdIsEmpty() {
        this.executeDataValidationTest("Runtime", "7.15.0", "community", "");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldNotReportWhenInstallationIdIsInvalid() {
        String invalidUUID = "f5b19e2e-b49a-11ea-b3de-0242ac130004";
        this.executeDataValidationTest("Runtime", "7.15.0", "community", invalidUUID);
    }

    @Test
    public void shouldNotReportWhenReporterDeactivated() {
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        processEngineConfiguration.setTelemetryEndpoint(TELEMETRY_ENDPOINT).setTelemetryReporterActivate(false).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.standaloneProcessEngine = processEngineConfiguration.buildProcessEngine();
        processEngineConfiguration.getTelemetryReporter().reportNow();
        WireMock.verify((int)0, (RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)));
    }

    @Test
    public void shouldSendCompleteTelemetryData() {
        String applicationServerVersion = "Tomcat 10";
        PlatformTelemetryRegistry.setApplicationServer((String)applicationServerVersion);
        LicenseKeyDataImpl licenseKey = new LicenseKeyDataImpl("customer a", "UNIFIED", "2029-09-01", Boolean.valueOf(false), Collections.singletonMap("camundaBPM", "true"), "raw license");
        ProcessEngineConfigurationImpl configuration = this.createEngine(true);
        configuration.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy();
        configuration.getTelemetryRegistry().setLicenseKey(licenseKey);
        configuration.getTelemetryData().getProduct().getInternals().getCamundaIntegration().add("spring-boot-starter");
        ((ManagementServiceImpl)configuration.getManagementService()).addWebappToTelemetry("cockpit");
        ((ManagementServiceImpl)configuration.getManagementService()).addWebappToTelemetry("admin");
        configuration.getManagementService().toggleTelemetry(true);
        configuration.getRuntimeService().startProcessInstanceByKey("oneTaskProcess");
        TelemetryDataImpl initialTelemetryData = (TelemetryDataImpl)configuration.getManagementService().getTelemetryData();
        TelemetryDataImpl expectedData = this.simpleData(b -> {
            b.installation(initialTelemetryData.getInstallation());
            ProductImpl product = initialTelemetryData.getProduct();
            b.productName("Camunda BPM Runtime");
            b.productVersion(product.getVersion());
            b.productEdition("community");
            InternalsImpl internals = product.getInternals();
            b.database(internals.getDatabase().getVendor(), internals.getDatabase().getVersion());
            b.applicationServer(applicationServerVersion);
            b.licenseKey(licenseKey);
            b.addIntegration("spring-boot-starter");
            b.dataCollectionStartDate(internals.getDataCollectionStartDate());
            b.countCommand(IS_TELEMETRY_ENABLED_CMD, 2);
            b.countCommand(TELEMETRY_CONFIGURE_CMD, 1);
            b.countCommand(GET_TELEMETRY_DATA_CMD, 1);
            b.countCommand(GET_NEXT_ID_BLOCK_CMD, 1);
            b.countCommand(START_PROCESS_INSTANCE_CMD, 1);
            b.countCommand(DEPLOY_CMD, 1);
            b.countCommand(GET_LICENSE_KEY_CMD, 1);
            b.countCommand(BOOTSTRAP_ENGINE_CMD, 1);
            b.countMetric("root-process-instance-start", 1);
            b.countMetric("activity-instance-start", 2);
            b.countMetric("executed-decision-elements", 0);
            b.countMetric("flow-node-instances", 2);
            b.countMetric("executed-decision-instances", 0);
            b.countMetric("decision-instances", 0);
            b.countMetric("process-instances", 1);
            b.webapps("cockpit", "admin");
            b.jdk(internals.getJdk());
            b.telemetryEnabled(true);
        });
        String requestBody = JsonUtil.asString((Object)expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)false)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendTelemetryWithApplicationServerInfo() {
        this.managementService.toggleTelemetry(true);
        String applicationServerVersion = "Tomcat 10";
        PlatformTelemetryRegistry.setApplicationServer((String)applicationServerVersion);
        TelemetryDataImpl expectedData = this.simpleData(b -> b.applicationServer(applicationServerVersion));
        String requestBody = this.toJson(expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendTelemetryWithApplicationServerInfoWhenSentBeforeInitialization() {
        String applicationServerVersion = "Tomcat 10";
        PlatformTelemetryRegistry.setApplicationServer((String)applicationServerVersion);
        ProcessEngineConfigurationImpl configuration = this.createEngine(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        TelemetryDataImpl expectedData = this.simpleData(b -> b.applicationServer(applicationServerVersion));
        String requestBody = this.toJson(expectedData);
        configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendTelemetryWithLicenseInfo() {
        this.managementService.toggleTelemetry(true);
        LicenseKeyDataImpl licenseKey = new LicenseKeyDataImpl("customer a", "UNIFIED", "2029-09-01", Boolean.valueOf(false), Collections.singletonMap("camundaBPM", "true"), "raw license");
        this.configuration.getTelemetryRegistry().setLicenseKey(licenseKey);
        TelemetryDataImpl expectedData = this.simpleData(b -> b.licenseKey(licenseKey));
        String requestBody = this.toJson(expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendTelemetryWithOverriddenLicenseInfo() {
        this.managementService.toggleTelemetry(true);
        LicenseKeyDataImpl firstLicenseKey = new LicenseKeyDataImpl("customer a", "UNIFIED", "2029-09-01", Boolean.valueOf(false), Collections.singletonMap("camundaBPM", "true"), "raw license");
        this.configuration.getTelemetryRegistry().setLicenseKey(firstLicenseKey);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        this.configuration.getTelemetryRegistry().getCommands().clear();
        LicenseKeyDataImpl secondLicenseKey = new LicenseKeyDataImpl("customer b", "UNIFIED", "2029-08-01", Boolean.valueOf(false), Collections.singletonMap("cawemo", "true"), "new raw license");
        this.configuration.getTelemetryRegistry().setLicenseKey(secondLicenseKey);
        TelemetryDataImpl expectedData = this.simpleData(b -> b.licenseKey(secondLicenseKey));
        String requestBody = this.toJson(expectedData);
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendTelemetryWithRawLicenseInfoOnly() {
        this.managementService.toggleTelemetry(true);
        String licenseKeyRaw = "raw license";
        this.managementService.setLicenseKey(licenseKeyRaw);
        TelemetryDataImpl expectedData = this.simpleData(b -> b.licenseKeyRaw(licenseKeyRaw));
        String requestBody = this.toJson(expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
        this.managementService.deleteLicenseKey();
    }

    @Test
    public void shouldSendTelemetryWithCommandCounts() {
        this.managementService.toggleTelemetry(true);
        this.managementService.getHistoryLevel();
        this.managementService.getLicenseKey();
        TelemetryDataImpl expectedData = this.simpleData(b -> b.countCommand(GET_HISTORY_LEVEL_CMD, 1).countCommand(GET_LICENSE_KEY_CMD, 1));
        String requestBody = this.toJson(expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldSendTelemetryWithRooProcessInstanceMetrics() {
        this.managementService.toggleTelemetry(true);
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        }
        this.configuration.getDbMetricsReporter().reportNow();
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        TelemetryDataImpl expectedData = this.simpleData(b -> b.countMetric("root-process-instance-start", 3).countMetric("executed-decision-elements", 0).countMetric("executed-decision-instances", 0).countMetric("activity-instance-start", 6));
        String requestBody = this.toJson(expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldNotSendMetricsTwice() {
        this.managementService.toggleTelemetry(true);
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        }
        this.configuration.getDbMetricsReporter().reportNow();
        TelemetryDataImpl expectedData = this.simpleData(b -> b.countMetric("root-process-instance-start", 0).countMetric("executed-decision-elements", 0).countMetric("executed-decision-instances", 0).countMetric("activity-instance-start", 0));
        String requestBody = this.toJson(expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    public void shouldSendTelemetryWithExecutedDecisionInstanceMetrics() {
        this.managementService.toggleTelemetry(true);
        for (int i = 0; i < 2; ++i) {
            this.runtimeService.startProcessInstanceByKey("testProcess");
        }
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        TelemetryDataImpl expectedData = this.simpleData(b -> b.countMetric("root-process-instance-start", 2).countMetric("executed-decision-elements", 2).countMetric("executed-decision-instances", 2).countMetric("activity-instance-start", 4));
        String requestBody = this.toJson(expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/metrics/ExecutedDecisionElementsTest.dmn11.xml"})
    public void shouldSendTelemetryWithExecutedDecisionElementMetrics() {
        BpmnModelInstance modelInstance = this.createProcessWithBusinessRuleTask("testProcess", "decision");
        this.testRule.deploy(this.configuration.getRepositoryService().createDeployment().addModelInstance("process.bpmn", modelInstance).addClasspathResource(DMN_FILE));
        this.managementService.toggleTelemetry(true);
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)VARIABLES);
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        TelemetryDataImpl expectedData = this.simpleData(b -> b.countMetric("root-process-instance-start", 1).countMetric("executed-decision-elements", 16).countMetric("executed-decision-instances", 1).countMetric("activity-instance-start", 3));
        String requestBody = this.toJson(expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldSendTelemetryWithActivityInstanceMetrics() {
        this.managementService.toggleTelemetry(true);
        for (int i = 0; i < 4; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)this.addHour(ClockUtil.getCurrentTime()));
        TelemetryDataImpl expectedData = this.simpleData(b -> b.countMetric("root-process-instance-start", 4).countMetric("executed-decision-elements", 0).countMetric("executed-decision-instances", 0).countMetric("activity-instance-start", 12));
        String requestBody = this.toJson(expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldAddJdkInfoToTelemetryData() {
        TelemetryDataImpl telemetryData = this.configuration.getTelemetryData();
        JdkImpl jdkInfo = telemetryData.getProduct().getInternals().getJdk();
        Assertions.assertThat((Object)jdkInfo).isNotNull();
        JdkImpl expectedJdkInfo = ParseUtil.parseJdkDetails();
        Assertions.assertThat((String)jdkInfo.getVersion()).isEqualTo((Object)expectedJdkInfo.getVersion());
        Assertions.assertThat((String)jdkInfo.getVendor()).isEqualTo((Object)expectedJdkInfo.getVendor());
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogTelemetrySent() {
        this.managementService.toggleTelemetry(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Start telemetry sending task").size()).isOne();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Sending telemetry data").size()).isOne();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Telemetry request was successful.").size()).isOne();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogUnexpectedResponse() {
        this.managementService.toggleTelemetry(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(406)));
        this.configuration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Unexpected response code 406 when sending telemetry data").size()).isEqualTo(3);
    }

    @Test
    public void shouldNotSendTelemetryWhenDisabled() {
        this.managementService.toggleTelemetry(false);
        TelemetryReporter telemetryReporter = this.configuration.getTelemetryReporter();
        telemetryReporter.reportNow();
        WireMock.verify((int)0, (RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldNotSendTelemetryDataCollectedBeforeTelemetryEnabled() {
        TelemetryReporter telemetryReporter = this.configuration.getTelemetryReporter();
        this.managementService.isTelemetryEnabled();
        this.managementService.getHistoryLevel();
        this.managementService.getHistoryLevel();
        this.managementService.getHistoryLevel();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.managementService.toggleTelemetry(true);
        this.managementService.getHistoryLevel();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        telemetryReporter.reportNow();
        TelemetryDataImpl expectedData = this.simpleData(b -> b.countCommand(GET_HISTORY_LEVEL_CMD, 1).countMetric("root-process-instance-start", 1));
        String expectedBody = this.toJson(expectedData);
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)expectedBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogTelemetryDisabled() {
        this.managementService.toggleTelemetry(false);
        this.configuration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Sending telemetry is disabled").size()).isOne();
    }

    @Test
    public void shouldKeepReporterRunningAfterTelemetryIsDisabled() {
        this.managementService.toggleTelemetry(false);
        TelemetryReporter telemetryReporter = this.configuration.getTelemetryReporter();
        Assertions.assertThat((boolean)telemetryReporter.isScheduled()).isTrue();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogErrorOnDebugWhenHttpConnectorNotInitialized() {
        this.managementService.toggleTelemetry(true);
        TelemetryDataImpl data = this.createDataToSend();
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.standaloneReporter = new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), TELEMETRY_ENDPOINT, 0, 1000L, data, null, this.configuration.getTelemetryRegistry(), this.configuration.getMetricsRegistry(), this.configuration.getTelemetryRequestTimeout());
        this.standaloneReporter.reportNow();
        List warningLog = this.loggingRule.getFilteredLog("Could not send telemetry data. ");
        Assertions.assertThat((int)warningLog.size()).isOne();
        Assertions.assertThat((String)((ILoggingEvent)warningLog.get(0)).toString()).contains(new CharSequence[]{"Set this logger to DEBUG/FINE for the full stacktrace."});
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("java.lang.NullPointerException occurred while sending telemetry data.").size()).isOne();
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldRecordUserOperationLog() {
        this.configuration.getIdentityService().setAuthenticatedUserId("admin");
        this.managementService.toggleTelemetry(true);
        UserOperationLogEntry entry = (UserOperationLogEntry)this.configuration.getHistoryService().createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)entry.getEntityType()).isEqualTo((Object)"Property");
        Assertions.assertThat((String)entry.getCategory()).isEqualTo((Object)"Admin");
        Assertions.assertThat((String)entry.getOperationType()).isEqualTo((Object)"Update");
        Assertions.assertThat((String)entry.getProperty()).isEqualTo((Object)"name");
        Assertions.assertThat((String)entry.getOrgValue()).isNull();
        Assertions.assertThat((String)entry.getNewValue()).isEqualTo((Object)"camunda.telemetry.enabled");
    }

    @Test
    public void shouldMakeRetriesOnNonSuccessStatus() {
        this.managementService.toggleTelemetry(true);
        this.managementService.getHistoryLevel();
        this.managementService.getLicenseKey();
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(500)));
        TelemetryDataImpl expectedData = this.simpleData(b -> b.countCommand(GET_HISTORY_LEVEL_CMD, 1).countCommand(GET_LICENSE_KEY_CMD, 1));
        String expectedRequestBody = this.toJson(expectedData);
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((int)3, (RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)expectedRequestBody, (boolean)true, (boolean)true)));
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldNotMakeRetriesOnUnexpectedSuccessStatus() {
        this.managementService.toggleTelemetry(true);
        this.managementService.getHistoryLevel();
        this.managementService.getLicenseKey();
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(204)));
        TelemetryDataImpl expectedData = this.simpleData(b -> b.countCommand(GET_HISTORY_LEVEL_CMD, 1).countCommand(GET_LICENSE_KEY_CMD, 1));
        String expectedRequestBody = this.toJson(expectedData);
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)expectedRequestBody, (boolean)true, (boolean)true)));
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Telemetry request was sent, but received an unexpected response success code: 204").size()).isOne();
    }

    @Test
    public void shouldMakeRetriesOnRequestFailure() {
        this.managementService.toggleTelemetry(true);
        this.managementService.getHistoryLevel();
        this.managementService.getLicenseKey();
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withFault(Fault.MALFORMED_RESPONSE_CHUNK)));
        TelemetryDataImpl expectedData = this.simpleData(b -> b.countCommand(GET_HISTORY_LEVEL_CMD, 1).countCommand(GET_LICENSE_KEY_CMD, 1));
        String expectedRequestBody = this.toJson(expectedData);
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((int)3, (RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)expectedRequestBody, (boolean)true, (boolean)true)));
    }

    @Test
    public void shouldSendTelemetryWhenDbMetricsDisabled() {
        boolean telemetryInitialized = true;
        StandaloneInMemProcessEngineConfiguration inMemoryConfiguration = new StandaloneInMemProcessEngineConfiguration();
        inMemoryConfiguration.setInitializeTelemetry(telemetryInitialized).setTelemetryEndpoint(TELEMETRY_ENDPOINT).setMetricsEnabled(false).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        this.standaloneProcessEngine = inMemoryConfiguration.buildProcessEngine();
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(204)));
        inMemoryConfiguration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendDataWithCamundaIntegration() {
        TelemetryDataImpl expectedData = this.simpleData(b -> b.addIntegration("wildfly-integration"));
        TelemetryDataImpl givenData = this.extendData(this.getTelemetryDataIgnoreCollectionTimeFrame(), b -> b.addIntegration("wildfly-integration"));
        this.managementService.toggleTelemetry(true);
        String requestBody = this.toJson(expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), this.configuration.getTelemetryEndpoint(), 0, this.configuration.getTelemetryReportingPeriod(), givenData, this.configuration.getTelemetryHttpConnector(), this.configuration.getTelemetryRegistry(), this.configuration.getMetricsRegistry(), this.configuration.getTelemetryRequestTimeout()).reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendDataWithWebapps() {
        this.managementService.toggleTelemetry(true);
        HashSet<String> webapps = new HashSet<String>(Arrays.asList("cockpit", "admin"));
        this.configuration.getTelemetryRegistry().setWebapps(webapps);
        TelemetryDataImpl expectedData = this.simpleData(b -> b.webapps("cockpit", "admin"));
        String requestBody = this.toJson(expectedData);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.equalToJson((String)requestBody, (boolean)true, (boolean)true)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendDataWithDataCollectionTimeFrame() {
        this.managementService.toggleTelemetry(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.product.internals.data-collection-start-date")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldResetDataCollectionTimeFrameAfterSending() {
        this.managementService.toggleTelemetry(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        Date telemetryDataTimeFrameBeforeReported = this.configuration.getTelemetryData().getProduct().getInternals().getDataCollectionStartDate();
        this.configuration.getTelemetryReporter().reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
        Assertions.assertThat((Date)this.managementService.getTelemetryData().getProduct().getInternals().getDataCollectionStartDate()).isAfter(telemetryDataTimeFrameBeforeReported);
    }

    protected ProcessEngineConfigurationImpl createEngine(Boolean initTelemetry) {
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        this.buildEngine((ProcessEngineConfigurationImpl)processEngineConfiguration, initTelemetry);
        return processEngineConfiguration;
    }

    protected void buildEngine(ProcessEngineConfigurationImpl processEngineConfiguration, Boolean initTelemetry) {
        processEngineConfiguration.setProcessEngineName("standalone").setTelemetryEndpoint(TELEMETRY_ENDPOINT).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        if (initTelemetry != null) {
            processEngineConfiguration.setInitializeTelemetry(initTelemetry.booleanValue());
        }
        this.standaloneProcessEngine = processEngineConfiguration.buildProcessEngine();
    }

    protected TelemetryDataImpl createDataToSend() {
        return this.createDataToSendWithCustomValues("Runtime", "7.14.0", "special", VALID_UUID_V4);
    }

    protected TelemetryDataImpl createDataToSendWithCustomValues(String name, String version, String edition, String installationId) {
        DatabaseImpl database = new DatabaseImpl("mySpecialDb", "v.1.2.3");
        JdkImpl jdk = ParseUtil.parseJdkDetails();
        InternalsImpl internals = new InternalsImpl(database, new ApplicationServerImpl("Apache Tomcat/10.0.1"), null, jdk);
        internals.setTelemetryEnabled(Boolean.valueOf(true));
        Map<String, Command> commands = this.getDefaultCommandCounts();
        internals.setCommands(commands);
        HashMap metrics = new HashMap();
        internals.setMetrics(metrics);
        ProductImpl product = new ProductImpl(name, version, edition, internals);
        TelemetryDataImpl data = new TelemetryDataImpl(installationId, product);
        return data;
    }

    protected TelemetryDataImpl extendData(TelemetryDataImpl telemetryData, Consumer<TelemetryDataBuilder> configuration) {
        TelemetryDataBuilder builder = new TelemetryDataBuilder(telemetryData);
        configuration.accept(builder);
        return builder.data;
    }

    protected TelemetryDataImpl simpleData(Consumer<TelemetryDataBuilder> configuration) {
        TelemetryDataBuilder builder = new TelemetryDataBuilder();
        configuration.accept(builder);
        return builder.data;
    }

    protected Map<String, Command> getDefaultCommandCounts() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put(TELEMETRY_CONFIGURE_CMD, (Command)new CommandImpl(1L));
        commands.put(IS_TELEMETRY_ENABLED_CMD, (Command)new CommandImpl(1L));
        return commands;
    }

    protected TelemetryDataImpl initData(TelemetryDataImpl telemetryData) {
        TelemetryDataImpl data = new TelemetryDataImpl(telemetryData.getInstallation(), new ProductImpl(telemetryData.getProduct()));
        data.getProduct().getInternals().setTelemetryEnabled(Boolean.valueOf(true));
        return data;
    }

    protected Date addHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, 1);
        Date newDate = calendar.getTime();
        return newDate;
    }

    protected BpmnModelInstance createProcessWithBusinessRuleTask(String processId, String decisionRef) {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)processId).startEvent().businessRuleTask("task").endEvent().done();
        BusinessRuleTask task = (BusinessRuleTask)modelInstance.getModelElementById("task");
        task.setCamundaDecisionRef(decisionRef);
        return modelInstance;
    }

    protected void executeDataValidationTest(String name, String version, String edition, String installationId) {
        this.managementService.toggleTelemetry(true);
        TelemetryDataImpl invalidData = this.createDataToSendWithCustomValues(name, version, edition, installationId);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)).willReturn(WireMock.aResponse().withStatus(202)));
        this.standaloneReporter = new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), TELEMETRY_ENDPOINT, 0, 1000L, invalidData, this.configuration.getTelemetryHttpConnector(), this.configuration.getTelemetryRegistry(), this.configuration.getMetricsRegistry(), this.configuration.getTelemetryRequestTimeout());
        this.standaloneReporter.reportNow();
        WireMock.verify((int)0, (RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT_PATH)));
        String warnLogMessage = "Cannot send the telemetry data. Some of the data is invalid. Set this logger to DEBUG/FINE to see more details.";
        String debugLogMessage = String.format("Cannot send the telemetry task data. The following values must be non-empty Strings: '%s' (name), '%s' (version), '%s' (edition), '%s' (UUIDv4 installation id).", name, version, edition, installationId);
        Assertions.assertThat((List)this.loggingRule.getFilteredLog(warnLogMessage)).hasSize(1);
        Assertions.assertThat((List)this.loggingRule.getFilteredLog(debugLogMessage)).hasSize(1);
    }

    protected TelemetryDataImpl getTelemetryDataIgnoreCollectionTimeFrame() {
        TelemetryDataImpl telemetryData = new TelemetryDataImpl(this.configuration.getTelemetryData());
        telemetryData.getProduct().getInternals().setDataCollectionStartDate(null);
        return telemetryData;
    }

    protected String toJson(TelemetryDataImpl expectedData) {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create().toJson((Object)expectedData);
    }

    protected static class TelemetryDataBuilder {
        protected TelemetryDataImpl data;

        public TelemetryDataBuilder() {
            this.data = new TelemetryDataImpl(null, new ProductImpl(null, null, null, new InternalsImpl(null, null, null, null)));
        }

        public TelemetryDataBuilder(TelemetryDataImpl initialValues) {
            this.data = new TelemetryDataImpl(initialValues.getInstallation(), new ProductImpl(initialValues.getProduct()));
            this.data.getProduct().getInternals().setTelemetryEnabled(Boolean.valueOf(true));
        }

        public TelemetryDataBuilder installation(String installation) {
            this.data.setInstallation(installation);
            return this;
        }

        public TelemetryDataBuilder productName(String name) {
            this.data.getProduct().setName(name);
            return this;
        }

        public TelemetryDataBuilder productVersion(String version) {
            this.data.getProduct().setVersion(version);
            return this;
        }

        public TelemetryDataBuilder productEdition(String edition) {
            this.data.getProduct().setEdition(edition);
            return this;
        }

        public TelemetryDataBuilder database(String vendor, String version) {
            DatabaseImpl database = new DatabaseImpl(vendor, version);
            this.data.getProduct().getInternals().setDatabase(database);
            return this;
        }

        public TelemetryDataBuilder applicationServer(String serverVersion) {
            this.data.getProduct().getInternals().setApplicationServer(new ApplicationServerImpl(serverVersion));
            return this;
        }

        public TelemetryDataBuilder licenseKey(LicenseKeyDataImpl key) {
            this.data.getProduct().getInternals().setLicenseKey(key);
            return this;
        }

        public TelemetryDataBuilder licenseKeyRaw(String rawKey) {
            LicenseKeyDataImpl key = new LicenseKeyDataImpl(null, null, null, null, null, rawKey);
            this.data.getProduct().getInternals().setLicenseKey(key);
            return this;
        }

        public TelemetryDataBuilder addIntegration(String integration) {
            if (this.data.getProduct().getInternals().getCamundaIntegration() == null) {
                this.data.getProduct().getInternals().setCamundaIntegration(new HashSet());
            }
            this.data.getProduct().getInternals().getCamundaIntegration().add(integration);
            return this;
        }

        public TelemetryDataBuilder dataCollectionStartDate(Date date) {
            this.data.getProduct().getInternals().setDataCollectionStartDate(date);
            return this;
        }

        public TelemetryDataBuilder countCommand(String name, int count) {
            this.data.getProduct().getInternals().putCommand(name, count);
            return this;
        }

        public TelemetryDataBuilder countMetric(String name, int count) {
            this.data.getProduct().getInternals().putMetric(name, count);
            String publicName = MetricsUtil.resolvePublicName((String)name);
            this.data.getProduct().getInternals().putMetric(publicName, count);
            return this;
        }

        public TelemetryDataBuilder webapps(String ... webapps) {
            HashSet<String> webappSet = new HashSet<String>();
            for (String webapp : webapps) {
                webappSet.add(webapp);
            }
            this.data.getProduct().getInternals().setWebapps(webappSet);
            return this;
        }

        public TelemetryDataBuilder jdk(JdkImpl jdk) {
            this.data.getProduct().getInternals().setJdk(jdk);
            return this;
        }

        public TelemetryDataBuilder telemetryEnabled(boolean enabled) {
            this.data.getProduct().getInternals().setTelemetryEnabled(Boolean.valueOf(enabled));
            return this;
        }
    }
}

