/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public abstract class AbstractDefinitionQueryTest {
    protected static final String FIRST_DEPLOYMENT_NAME = "firstDeployment";
    protected static final String SECOND_DEPLOYMENT_NAME = "secondDeployment";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected String deploymentOneId;
    protected String deploymentTwoId;

    @Before
    public void before() throws Exception {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.deploymentOneId = this.repositoryService.createDeployment().name(FIRST_DEPLOYMENT_NAME).addClasspathResource(this.getResourceOnePath()).addClasspathResource(this.getResourceTwoPath()).deploy().getId();
        this.deploymentTwoId = this.repositoryService.createDeployment().name(SECOND_DEPLOYMENT_NAME).addClasspathResource(this.getResourceOnePath()).deploy().getId();
    }

    protected abstract String getResourceOnePath();

    protected abstract String getResourceTwoPath();

    @After
    public void after() throws Exception {
        this.repositoryService.deleteDeployment(this.deploymentOneId, true);
        this.repositoryService.deleteDeployment(this.deploymentTwoId, true);
    }

    protected void verifyQueryResults(Query query, int countExpected) {
        Assertions.assertThat((List)query.list()).hasSize(countExpected);
        Assertions.assertThat((long)query.count()).isEqualTo((Object)new Long(countExpected));
        if (countExpected == 1) {
            Assertions.assertThat((Object)query.singleResult()).isNotNull();
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            Assertions.assertThat((Object)query.singleResult()).isNull();
        }
    }

    private void verifySingleResultFails(Query query) {
        Assertions.assertThatThrownBy(() -> query.singleResult()).isInstanceOf(ProcessEngineException.class);
    }
}

